/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.documents.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.warehouse.documents.client.OutDeliveryNoteRowsGridPanel;
import org.jallinone.warehouse.documents.client.SerialNumberDialog;
import org.jallinone.warehouse.documents.java.GridOutDeliveryNoteRowVO;
import org.jallinone.warehouse.documents.java.OutDeliveryNoteRowPK;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class OutDeliveryNoteRowsController
extends CompanyGridController {
    private OutDeliveryNoteRowsGridPanel panel = null;

    public OutDeliveryNoteRowsController(OutDeliveryNoteRowsGridPanel panel) {
        this.panel = panel;
    }

    public void afterEditGrid(GridControl grid) {
        this.panel.getGrid().reloadData();
        this.panel.getHeaderPanel().setMode(0);
        this.panel.getHeaderPanel().executeReload();
        this.panel.getOrders().reloadData();
    }

    public void afterInsertGrid(GridControl grid) {
        this.panel.getHeaderPanel().setMode(0);
        this.panel.getHeaderPanel().executeReload();
        this.panel.getOrders().reloadData();
        this.panel.getFrame().enabledConfirmButton();
    }

    public boolean beforeDeleteGrid(GridControl grid) {
        if (!super.beforeDeleteGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC08().equals("D");
    }

    public boolean beforeEditGrid(GridControl grid) {
        if (!super.beforeEditGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC08().equals("D");
    }

    public boolean beforeInsertGrid(GridControl grid) {
        if (!super.beforeInsertGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC08().equals("D");
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        GridOutDeliveryNoteRowVO vo = (GridOutDeliveryNoteRowVO)valueObject;
        vo.setCompanyCodeSys01DOC10(this.panel.getParentVO().getCompanyCodeSys01DOC08());
        vo.setDocTypeDOC10(this.panel.getParentVO().getDocTypeDOC08());
        vo.setDocYearDOC10(this.panel.getParentVO().getDocYearDOC08());
        vo.setDocNumberDOC10(this.panel.getParentVO().getDocNumberDOC08());
        vo.setDocTypeDoc01DOC10("P");
        vo.setWarehouseCodeWar01DOC08(this.panel.getParentVO().getWarehouseCodeWar01DOC08());
        vo.setQtyDOC10(new BigDecimal(1.0));
        Response res = ClientUtils.getData((String)"getRootLevel", (Object)this.panel.getParentVO().getProgressiveHie02WAR01());
        if (!res.isError()) {
            HierarchyLevelVO posVO = (HierarchyLevelVO)((Object)((VOResponse)res).getVo());
            vo.setProgressiveHie01DOC10(posVO.getProgressiveHIE01());
            vo.setLocationDescriptionSYS10(posVO.getDescriptionSYS10());
        }
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        ArrayList<OutDeliveryNoteRowPK> pks = new ArrayList<OutDeliveryNoteRowPK>();
        OutDeliveryNoteRowPK pk = null;
        GridOutDeliveryNoteRowVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (GridOutDeliveryNoteRowVO)((Object)persistentObjects.get(i));
            pk = new OutDeliveryNoteRowPK(vo.getCompanyCodeSys01DOC10(), vo.getDocTypeDOC10(), vo.getDocYearDOC10(), vo.getDocNumberDOC10(), vo.getDocTypeDoc01DOC10(), vo.getDocYearDoc01DOC10(), vo.getDocNumberDoc01DOC10(), vo.getRowNumberDOC10(), vo.getItemCodeItm01DOC10());
            pks.add(pk);
            ++i;
        }
        Response res = ClientUtils.getData((String)"deleteOutDeliveryNoteRows", pks);
        if (!res.isError()) {
            this.panel.getGrid().reloadData();
            this.panel.getHeaderPanel().setMode(0);
            this.panel.getHeaderPanel().executeReload();
            this.panel.getOrders().reloadData();
        }
        return res;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        ValueObject newValueObject = (ValueObject)newValueObjects.get(0);
        if (this.panel.isSerialNumberRequired() && !this.promptSerialNumbers((GridOutDeliveryNoteRowVO)newValueObject)) {
            return new ErrorResponse("insert not allowed until serial numbers are not defined");
        }
        Response res = ClientUtils.getData((String)"insertOutDeliveryNoteRow", (Object)newValueObject);
        if (res.isError()) {
            return res;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((VOResponse)res).getVo());
        return new VOListResponse(list, false, list.size());
    }

    private boolean promptSerialNumbers(GridOutDeliveryNoteRowVO vo) {
        ArrayList list = vo.getSerialNumbers();
        if (list == null) {
            list = new ArrayList(vo.getQtyDOC10().intValue());
            vo.setSerialNumbers(list);
            list = new ArrayList(vo.getQtyDOC10().intValue());
            vo.setBarCodes(list);
        } else if (vo.getSerialNumbers().size() < vo.getQtyDOC10().intValue()) {
            int i = vo.getSerialNumbers().size();
            while (i < vo.getQtyDOC10().intValue()) {
                vo.getSerialNumbers().add(null);
                vo.getBarCodes().add(null);
                ++i;
            }
        } else if (vo.getSerialNumbers().size() > vo.getQtyDOC10().intValue()) {
            while (vo.getSerialNumbers().size() > vo.getQtyDOC10().intValue()) {
                vo.getSerialNumbers().remove(vo.getSerialNumbers().size() - 1);
                vo.getBarCodes().remove(vo.getBarCodes().size() - 1);
            }
        }
        new SerialNumberDialog(vo.getSerialNumbers(), vo.getBarCodes(), vo.getItemCodeItm01DOC10() + " - " + vo.getDescriptionSYS10());
        return true;
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        int i = 0;
        while (i < persistentObjects.size()) {
            GridOutDeliveryNoteRowVO vo = (GridOutDeliveryNoteRowVO)((Object)persistentObjects.get(i));
            if (this.panel.isSerialNumberRequired() && !this.promptSerialNumbers(vo)) {
                return new ErrorResponse("update not allowed until serial numbers are not defined");
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateOutDeliveryNoteRows", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        return true;
    }
}

