/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.util.ExceptionUtil;
import com.rp.util.Loggable;
import com.rp.util.pool.ObjectManager;
import com.rp.util.pool.PoolException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractConnectionManager
implements ObjectManager {
    protected String url = null;
    protected String user = null;
    protected String password = null;
    protected String driver = null;
    protected String checkQuery = null;
    protected boolean autoCommit = false;
    protected String logKey = null;
    protected Loggable log = null;
    protected String CLASS_NAME = "AbstractConnectionManager";

    protected AbstractConnectionManager(String url, String user, String password, String driver, String checkQuery, boolean autoCommit, String logKey, Loggable log) throws SQLException, ClassNotFoundException {
        this.logKey = logKey;
        this.log = log;
        String method = "constructor";
        this.info(method, "entering constructor()");
        this.info(method, "setting member variables");
        this.url = url;
        this.user = user;
        this.password = password;
        this.driver = driver;
        this.checkQuery = checkQuery;
        this.autoCommit = autoCommit;
        this.info(method, "leaving . . .");
    }

    protected final void init() throws SQLException {
        String method = "init()";
        this.info(method, "entering  . . .");
        try {
            this.debug(method, "attempting to load driver");
            Class.forName(this.driver);
            this.debug(method, "done loading driver");
        }
        catch (ClassNotFoundException c) {
            this.error(method, "COULD NOT LOAD DRIVER: Class Not Found: " + this.driver);
            this.error(method, "EXCEPTION MESSAGE: " + c.toString());
            throw new SQLException(this.CLASS_NAME + ":" + method + "::ClassNotFoundException--" + c.toString());
        }
        this.info(method, "leaving  . . .");
    }

    protected void setClassName(String name) {
        this.CLASS_NAME = name;
    }

    public abstract Object create() throws PoolException;

    public abstract void destroy(Object var1) throws PoolException;

    public abstract Object performEmpty(Object var1) throws PoolException;

    public Object performGet(Object obj) throws PoolException {
        Connection con;
        String method;
        block6: {
            method = "performGet()";
            this.info(method, "entering  . . .");
            con = null;
            try {
                this.debug(method, "casting object to Connection . . .");
                con = (Connection)obj;
                this.debug(method, "done with cast.");
                this.debug(method, "checking if connection is closed . . .");
                if (this.checkClosed(con)) {
                    this.debug(method, "connection is closed or not available");
                    try {
                        this.debug(method, "attempting to destroy closed connection . . .");
                        this.destroy(con);
                        this.debug(method, "closed connection destroyed.");
                    }
                    catch (PoolException e) {
                        this.error(method, "exception while trying to destroy closed connection: " + e.toString());
                    }
                    this.debug(method, "connection is closed.  attempting to create new connection . . .");
                    con = (Connection)this.create();
                    this.debug(method, "new connection created.");
                    break block6;
                }
                this.debug(method, "connection is not closed.  checking connection. . .");
                con = this.checkConnection(con);
                this.debug(method, "done checking connection.");
            }
            catch (PoolException p) {
                this.error(method, "PoolException:: " + p.toString());
                throw p;
            }
            catch (SQLException e) {
                this.error(method, "SQLException:: " + e.toString());
                throw new PoolException(e.toString(), e);
            }
        }
        this.info(method, "leaving  . . .");
        return con;
    }

    public Object performFree(Object obj) throws PoolException {
        String method = "performFree()";
        Connection con = null;
        this.info(method, "entering  . . .");
        try {
            this.debug(method, "casting object to Connection . . .");
            con = (Connection)obj;
            this.debug(method, "cast complete");
            this.debug(method, "returning connection to previous state . . .");
            this.resetConnection(con);
            this.debug(method, "done resetting connection.");
        }
        catch (SQLException e) {
            this.error(method, "SQLException:: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.debug(method, "leaving  . . .");
        return con;
    }

    protected Connection createConnection() throws SQLException {
        String method = "createConnection()";
        this.info(method, "entering  . . .");
        Connection con = null;
        try {
            this.debug(method, "attempting to create connection: user = " + this.user + " url = " + this.url);
            con = DriverManager.getConnection(this.url, this.user, this.password);
            this.debug(method, "connection created");
            this.debug(method, "setting autocommit . . .");
            con.setAutoCommit(this.autoCommit);
            this.debug(method, "autocommit set to " + this.autoCommit);
        }
        catch (SQLException e) {
            this.error(method, "SQL Exception occurred while creating connection . . . MESSAGE: " + e.toString());
            throw e;
        }
        this.info(method, "leaving " + method + " . . .");
        return con;
    }

    protected void resetConnection(Connection con) throws SQLException {
        String method = "resetConnection";
        this.info(method, "entering . . .");
        if (con != null) {
            try {
                this.debug(method, "setting autocommit . . .");
                con.setAutoCommit(this.autoCommit);
                this.debug(method, "autocommit set to " + this.autoCommit);
            }
            catch (SQLException e) {
                this.error(method, "Exception thrown on set of autoCommit");
                throw e;
            }
            try {
                this.debug(method, "clearing warnings . . .");
                con.clearWarnings();
                this.debug(method, "warnings cleared.");
            }
            catch (SQLException e) {
                this.error(method, "Exception thrown on clearWarnings");
                throw e;
            }
        }
        this.info(method, "leaving " + method + " . . .");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Connection checkConnection(Connection con) throws SQLException {
        String method;
        block16: {
            method = "checkConnection()";
            this.info(method, "entering . . .");
            this.debug(method, "checking checkQuery value . . .");
            if (!this.isNull(this.checkQuery)) {
                this.debug(method, "checkQuery has a value.  preparing to execute checkQuery.");
                Statement st = null;
                this.debug(method, "preparing statement with query = " + this.checkQuery + ". . .");
                st = con.prepareStatement(this.checkQuery);
                this.debug(method, "statement prepared.");
                this.debug(method, "executing preparedStatement . . .");
                boolean val = st.execute();
                this.debug(method, "preparedStatement executed");
                Object var7_6 = null;
                this.debug(method, "closing up checkQuery resources . . .");
                try {
                    if (st != null) {
                        st.close();
                    }
                    break block16;
                }
                catch (Exception ex) {}
                break block16;
                {
                    catch (SQLException sqle) {
                        this.error(method, "An exception occurred while attempting to run checkQuery: " + sqle.toString());
                        this.error(method, "STACK TRACE: " + ExceptionUtil.getStackTrace(sqle));
                        try {
                            this.debug(method, "attempting to destroy bad connection . . .");
                            this.destroy(con);
                            this.debug(method, "bad connection destroyed");
                        }
                        catch (PoolException e) {
                            this.error(method, "Exception while trying to close bad connection:: " + e.toString());
                        }
                        try {
                            this.debug(method, "replacing connection with new connection . . .");
                            con = (Connection)this.create();
                            this.debug(method, "connection replaced.");
                        }
                        catch (PoolException e) {
                            this.error(method, "An exception occurred while creating a new Connection.  MESSAGE: " + e.toString());
                            this.error(method, "STACK TRACE: " + ExceptionUtil.getStackTrace(e));
                            throw new SQLException(e.toString());
                        }
                        Object var7_7 = null;
                        this.debug(method, "closing up checkQuery resources . . .");
                        try {
                            if (st != null) {
                                st.close();
                            }
                            break block16;
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.debug(method, "closing up checkQuery resources . . .");
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        this.info(method, "leaving " + method + " . . .");
        return con;
    }

    protected boolean checkClosed(Connection con) {
        boolean closed = false;
        String method = "checkClosed(Connection)";
        this.info(method, "entering . . .");
        try {
            if (con == null || con.isClosed()) {
                closed = true;
            }
        }
        catch (Exception e) {
            this.warn(method, "Exception checking if connection is closed: " + e.toString());
            closed = true;
        }
        this.info(method, "leaving . . .");
        return closed;
    }

    protected void fatal(String method, String s) {
        if (this.log != null) {
            this.log.fatal(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void error(String method, String s) {
        if (this.log != null) {
            this.log.error(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void warn(String method, String s) {
        if (this.log != null) {
            this.log.warn(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void info(String method, String s) {
        if (this.log != null) {
            this.log.info(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void debug(String method, String s) {
        if (this.log != null) {
            this.log.debug(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected boolean isNull(String s) {
        return s == null || s.trim().length() == 0;
    }
}

