/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.database.CSConnectionManager;
import com.rp.database.StatementCache;
import com.rp.log.ObjectLogger;
import com.rp.log.RpLogger;
import com.rp.util.DateTime;
import com.rp.util.ExceptionUtil;
import com.rp.util.LogUtil;
import com.rp.util.pool.ObjectPool;
import com.rp.util.pool.ObjectPoolImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class RPDataSource
implements DataSource,
Serializable {
    protected String CLASS_NAME = "RPDataSource";
    protected ObjectPool pool = null;
    protected CSConnectionManager connectionManager = null;
    protected DateTime dateTime = null;
    protected int loginTimeout = 0;
    protected int holdTimeout = 0;
    protected long waitTimeout = 0L;
    protected String checkQuery = null;
    protected boolean autoCommit = true;
    protected String description = null;
    protected String driverClass = null;
    protected int maxCount;
    protected int minCount;
    protected String password = null;
    protected String user = null;
    protected String url = null;
    protected int statementCacheSize = 0;
    protected int logLevel = 3;
    protected ObjectLogger logger = null;
    protected LogUtil logUtil = null;
    protected PrintWriter logWriter = null;
    protected static final String LOG_KEY = "RpDataSource";

    public RPDataSource(Properties props) throws SQLException {
        this(null, props, null);
    }

    public RPDataSource(Properties props, PrintWriter writer) throws SQLException {
        this(null, props, writer);
    }

    public RPDataSource(Properties props, ObjectLogger logger) throws SQLException {
        this(logger, props, null);
    }

    protected RPDataSource(ObjectLogger logger, Properties props, PrintWriter writer) throws SQLException {
        String method = "constructor";
        try {
            this.dateTime = new DateTime();
            String tempDebugLevel = props.getProperty("logLevel");
            boolean gotLogLevel = true;
            if (!this.isNull(tempDebugLevel)) {
                try {
                    this.logLevel = new Integer(tempDebugLevel);
                }
                catch (Exception e) {
                    gotLogLevel = false;
                    this.logLevel = 3;
                }
            }
            if (writer != null) {
                this.setLogWriter(writer, this.logLevel);
            } else if (logger != null) {
                this.setLogger(logger, this.logLevel);
            }
            this.info(method, "entering " + method + " . . .");
            this.debug(method, "attempting to get values from Properties object");
            if (!gotLogLevel) {
                this.debug(method, "could not get log level.  using default of INFO");
            }
            this.debug(method, "debugLevel = " + this.logLevel);
            String tempAuto = props.getProperty("autoCommit");
            if (!this.isNull(tempAuto)) {
                this.debug(method, "autoCommit (" + tempAuto + ")");
                if (!tempAuto.equalsIgnoreCase("true") && !tempAuto.equalsIgnoreCase("false")) {
                    this.fatal(method, "invalid value for autoCommit:" + tempAuto + ":");
                    throw new SQLException(this.CLASS_NAME + ":" + method + "::invalid value for autoCommit");
                }
            } else {
                this.debug(method, "autoCommit is null.  using default of true");
                tempAuto = "true";
            }
            String tempDescription = props.getProperty("description");
            this.debug(method, "description (" + tempDescription + ")");
            String tempDriverClass = props.getProperty("driverClass");
            if (this.isNull(tempDriverClass)) {
                this.fatal(method, "NULL value for driverClass");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "NULL value for driverClass");
            }
            this.debug(method, "driverClass (" + tempDriverClass + ")");
            String tempMax = props.getProperty("maxCount");
            if (this.isNull(tempMax)) {
                this.fatal(method, "NULL value for maxCount");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "NULL value for maxCount");
            }
            this.debug(method, "maxCount (" + tempMax + ")");
            String tempMin = props.getProperty("minCount");
            if (this.isNull(tempMin)) {
                this.fatal(method, "NULL value for minCount");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "NULL value for minCount");
            }
            this.debug(method, "minCount (" + tempMin + ")");
            String tempPassword = props.getProperty("password");
            String tempUser = props.getProperty("user");
            this.debug(method, "user (" + tempUser + ")");
            String tempUrl = props.getProperty("url");
            if (this.isNull(tempUrl)) {
                this.fatal(method, "NULL value for user");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "NULL value for user");
            }
            this.debug(method, "url (" + tempUrl + ")");
            String tempTimeout = props.getProperty("loginTimeout");
            if (this.isNull(tempTimeout)) {
                this.debug(method, "loginTimeout not set");
                tempTimeout = "0";
            } else {
                this.debug(method, "logintimeout (" + tempTimeout + ")");
            }
            String tempHoldTimeout = props.getProperty("holdTimeout");
            if (this.isNull(tempHoldTimeout)) {
                this.debug(method, "holdTimeOut not set");
                tempHoldTimeout = "0";
            } else {
                this.debug(method, "holdTimeOut (" + tempHoldTimeout + ")");
            }
            String tempWaitTimeout = props.getProperty("waitTimeout");
            if (this.isNull(tempWaitTimeout)) {
                this.debug(method, "waitTimeOut not set");
                tempWaitTimeout = "0";
            } else {
                this.debug(method, "waitTimeOut (" + tempWaitTimeout + ")");
            }
            String tempCheckQuery = props.getProperty("checkQuery");
            if (!this.isNull(tempCheckQuery)) {
                this.debug(method, "checkQuery (" + tempCheckQuery + ")");
            } else {
                this.debug(method, "checkQuery not set");
                tempCheckQuery = null;
            }
            String tempCacheSize = props.getProperty("statementCacheSize");
            if (this.isNull(tempCacheSize)) {
                this.debug(method, "statementCacheSize not set");
                tempCacheSize = "0";
            } else {
                this.debug(method, "statementCacheSize (" + tempCacheSize + ")");
            }
            this.debug(method, "converting autocommit to boolean");
            try {
                tempAuto = tempAuto.toLowerCase();
                this.debug(method, "autocommit toLowerCase (" + tempAuto + ")");
                this.autoCommit = new Boolean(tempAuto);
                this.debug(method, "autocommit boolean value (" + this.autoCommit + ")");
            }
            catch (Exception e) {
                this.fatal(method, "could not convert autocommit to boolean");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert autocommit to boolean: " + e.toString());
            }
            this.debug(method, "setting description = " + tempDescription);
            this.description = tempDescription;
            this.debug(method, "setting driverClass = " + tempDriverClass);
            this.driverClass = tempDriverClass;
            try {
                this.debug(method, "converting maxCount to int");
                this.maxCount = new Integer(tempMax);
                this.debug(method, "maxCount (" + this.maxCount + ")");
            }
            catch (Exception e) {
                this.fatal(method, "could not convert maxCount to int");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert maxCount to int: " + e.toString());
            }
            try {
                this.debug(method, "converting minCount to int");
                this.minCount = new Integer(tempMin);
                this.debug(method, "minCount (" + this.minCount + ")");
            }
            catch (Exception e) {
                this.fatal(method, "could not convert minCount to int");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert minCount to int: " + e.toString());
            }
            this.debug(method, "setting password = ");
            this.password = tempPassword;
            this.debug(method, "setting user = " + tempUser);
            this.user = tempUser;
            this.debug(method, "setting url = " + tempUrl);
            this.url = tempUrl;
            try {
                this.debug(method, "converting login timeout to int");
                this.setLoginTimeout(new Integer(tempTimeout));
                this.debug(method, "loginTimeout (" + this.getLoginTimeout() + ")");
                if (this.getLoginTimeout() > 0) {
                    DriverManager.setLoginTimeout(this.getLoginTimeout());
                }
            }
            catch (Exception e) {
                this.fatal(method, "could not convert login timeout to int");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert login timeout to int: " + e.toString());
            }
            try {
                this.debug(method, "converting hold timeout to long");
                this.holdTimeout = new Integer(tempHoldTimeout);
                this.debug(method, "holdTimeout (" + this.holdTimeout + ")");
            }
            catch (Exception e) {
                this.fatal(method, "could not convert hold timeout to long");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert hold timeout to long: " + e.toString());
            }
            try {
                this.debug(method, "converting wait timeout to int");
                this.waitTimeout = new Long(tempWaitTimeout);
                this.debug(method, "waitTimeout (" + this.waitTimeout + ")");
            }
            catch (Exception e) {
                this.fatal(method, "could not convert wait timeout to int");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert wait timeout to int: " + e.toString());
            }
            this.debug(method, "setting checkQuery = " + tempCheckQuery);
            this.checkQuery = tempCheckQuery;
            try {
                this.debug(method, "converting statementCacheSize to int");
                this.statementCacheSize = new Integer(tempCacheSize);
                this.debug(method, "statementCacheSize (" + this.statementCacheSize + ")");
            }
            catch (Exception e) {
                this.fatal(method, "could not convert statementCacheSize to int");
                throw new SQLException(this.CLASS_NAME + ":" + method + "::" + "Could not convert statementCacheSize to int: " + e.toString());
            }
            this.info(method, "attempting to create ConnectionPool with the following parameters:");
            this.info(method, "url: " + this.url);
            this.info(method, "user: " + this.user);
            this.debug(method, "password: " + this.password);
            this.info(method, "driverClass: " + this.driverClass);
            this.info(method, "maxCount: " + this.maxCount);
            this.info(method, "minCount: " + this.minCount);
            this.info(method, "checkQuery: " + this.checkQuery);
            this.info(method, "loginTimeout: " + this.getLoginTimeout());
            this.info(method, "holdTimeout: " + this.holdTimeout);
            this.info(method, "waitTimeout: " + this.waitTimeout);
            this.info(method, "autoCommit: " + this.autoCommit);
            this.info(method, "logWriter: " + this.getLogWriter());
            this.info(method, "logLevel: " + this.logLevel);
            this.info(method, "statementCacheSize: " + this.statementCacheSize);
        }
        catch (Exception e) {
            this.error(method, "EXCEPTION: " + e.toString());
            this.error(method, "STACK TRACE: " + ExceptionUtil.getStackTrace(e));
            SQLException s = new SQLException(this.CLASS_NAME + ":" + method + "::" + e.toString());
            throw s;
        }
        this.info(method, "leaving constructor . . .");
    }

    public Connection getConnection() throws SQLException {
        String method = "getConnection()";
        this.info(method, "entering " + method + ". . .");
        Connection c = null;
        try {
            if (this.pool == null) {
                this.debug(method, "ConnectionPool is null, creating new pool");
                boolean cacheable = false;
                if (this.statementCacheSize > 0) {
                    cacheable = true;
                }
                StatementCache sCache = new StatementCache(this.statementCacheSize);
                this.connectionManager = (CSConnectionManager)CSConnectionManager.getInstance(this.url, this.user, this.password, this.driverClass, this.checkQuery, this.holdTimeout, this.autoCommit, LOG_KEY, this.logUtil, cacheable, sCache);
                this.connectionManager.init();
                this.pool = ObjectPoolImpl.getInstance(this.connectionManager, this.maxCount, this.minCount, this.waitTimeout, false, this.logUtil, LOG_KEY);
                this.connectionManager.init(this.pool);
                this.pool.init();
                this.debug(method, "ConnectionPool created");
            }
            this.debug(method, "attempting to get connection");
            c = (Connection)this.pool.getObject();
            this.debug(method, "connection obtained.  returning. . .");
        }
        catch (Exception se) {
            this.error(method, "EXCEPTION: " + se.toString());
            this.error(method, "STACK TRACE: " + ExceptionUtil.getStackTrace(se));
            throw new SQLException(se.toString());
        }
        this.info(method, "leaving getConnection(). . .");
        return c;
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        String method = "getConnection(userName, password)";
        this.info(method, "entering " + method + ". . .");
        Connection con = null;
        try {
            this.debug(method, "attempting to load driver");
            Class.forName(this.driverClass);
            this.debug(method, "done loading driver");
        }
        catch (ClassNotFoundException c) {
            this.error(method, "COULD NOT LOAD DRIVER: Class Not Found: " + this.driverClass);
            this.error(method, "EXCEPTION MESSAGE: " + c.toString());
            this.error(method, "STACK TRACE: " + ExceptionUtil.getStackTrace(c));
            throw new SQLException(this.CLASS_NAME + ":" + method + "::ClassNotFoundException--" + c.toString());
        }
        try {
            this.debug(method, "checking loginTime . . .");
            if (this.loginTimeout > 0) {
                this.debug(method, "loginTime > 0.  attempting to set loginTimeout . . .");
                DriverManager.setLoginTimeout(this.loginTimeout);
                this.debug(method, "loginTime set to " + this.loginTimeout);
            }
            this.debug(method, "attempting to create connection: user = " + this.user + " url = " + this.url);
            con = DriverManager.getConnection(this.url, this.user, password);
            this.debug(method, "connection created");
            this.debug(method, "setting autocommit . . .");
            con.setAutoCommit(this.autoCommit);
            this.debug(method, "autocommit set to " + this.autoCommit);
        }
        catch (SQLException e) {
            this.error(method, "SQL Exception occurred while creating connection . . . MESSAGE: " + e.toString());
            this.error(method, "STACK TRACE: " + ExceptionUtil.getStackTrace(e));
            throw e;
        }
        return con;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds > 0) {
            DriverManager.setLoginTimeout(this.loginTimeout);
        }
        this.loginTimeout = seconds;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.setLogWriter(out, 3);
    }

    public void setLogWriter(PrintWriter out, int logLevel) throws SQLException {
        this.logWriter = out;
        RpLogger temp = null;
        int level = 3;
        try {
            switch (logLevel) {
                case 4: {
                    level = 4;
                    break;
                }
                case 3: {
                    level = 3;
                    break;
                }
                case 2: {
                    level = 2;
                    break;
                }
                case 1: {
                    level = 1;
                    break;
                }
                case 0: {
                    level = 0;
                }
            }
            temp = new RpLogger((Writer)out, level);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLogger(temp, logLevel);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogger(ObjectLogger inLogger, int inLogLevel) throws SQLException {
        this.logger = inLogger;
        this.logLevel = inLogLevel;
        this.logUtil = LogUtil.createInstance(this.logger, this.logLevel, LOG_KEY);
    }

    public void setLogger(ObjectLogger inLogger) throws SQLException {
        this.setLogger(inLogger, this.logLevel);
    }

    public ObjectLogger getLogger() throws SQLException {
        return this.logger;
    }

    protected void fatal(String method, String s) {
        if (this.logUtil != null) {
            this.logUtil.fatal(this.CLASS_NAME, method, s);
        }
    }

    protected void error(String method, String s) {
        if (this.logUtil != null) {
            this.logUtil.error(this.CLASS_NAME, method, s);
        }
    }

    protected void warn(String method, String s) {
        if (this.logUtil != null) {
            this.logUtil.warn(this.CLASS_NAME, method, s);
        }
    }

    protected void info(String method, String s) {
        if (this.logUtil != null) {
            this.logUtil.info(this.CLASS_NAME, method, s);
        }
    }

    protected void debug(String method, String s) {
        if (this.logUtil != null) {
            this.logUtil.debug(this.CLASS_NAME, method, s);
        }
    }

    protected boolean isNull(String s) {
        return s == null || s.trim().length() <= 0;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void destroy() {
        String method = "destroy";
        this.debug(method, "trying to destroy pool");
        if (this.pool != null) {
            this.debug(method, "pool is not null");
            try {
                this.pool.destroy(false);
                this.debug(method, "pool destroyed");
            }
            catch (Exception e) {
                this.debug(method, "problem destroying pool: " + e.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.dateTime);
        out.writeInt(this.loginTimeout);
        out.writeInt(this.holdTimeout);
        out.writeLong(this.waitTimeout);
        out.writeObject(this.checkQuery);
        out.writeBoolean(this.autoCommit);
        out.writeObject(this.description);
        out.writeObject(this.driverClass);
        out.writeInt(this.maxCount);
        out.writeInt(this.minCount);
        out.writeObject(this.password);
        out.writeObject(this.user);
        out.writeObject(this.url);
        out.writeInt(this.statementCacheSize);
        out.writeInt(this.logLevel);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.dateTime = (DateTime)in.readObject();
        this.loginTimeout = in.readInt();
        this.holdTimeout = in.readInt();
        this.waitTimeout = in.readLong();
        this.checkQuery = (String)in.readObject();
        this.autoCommit = in.readBoolean();
        this.description = (String)in.readObject();
        this.driverClass = (String)in.readObject();
        this.maxCount = in.readInt();
        this.minCount = in.readInt();
        this.password = (String)in.readObject();
        this.user = (String)in.readObject();
        this.url = (String)in.readObject();
        this.statementCacheSize = in.readInt();
        this.logLevel = in.readInt();
    }
}

