/*
 * Decompiled with CFR 0.152.
 */
package com.rp.log;

import com.rp.log.GenericFileWriter;
import com.rp.util.DateTime;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;

public class LogWriter
extends GenericFileWriter {
    private DateTime dateTime = new DateTime();
    private boolean error = true;

    public LogWriter(String fileName) throws IOException {
        super(fileName);
    }

    public LogWriter(Writer writer) throws IOException {
        super(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.checkOpen();
                this.dateTime.refresh();
                String dt = this.dateTime.getFullDate("/") + " " + this.dateTime.getFullTime(":");
                this.out.write(dt + " " + s, off, dt.length() + 1 + len);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.error = true;
        }
    }

    public void write(String s) {
        if (s != null) {
            this.write(s, 0, s.length());
        } else {
            this.write("null", 0, 4);
        }
    }

    public void write(int c) {
        this.write(String.valueOf(c), 0, 1);
    }

    public void write(char[] buf) {
        if (buf != null) {
            this.write(buf, 0, buf.length);
        } else {
            this.write("null", 0, 4);
        }
    }

    public void write(char[] buf, int off, int len) {
        if (buf != null) {
            StringBuffer sb = new StringBuffer(len);
            for (int i = off; i < len; ++i) {
                sb.append(buf[i]);
            }
            this.write(sb.toString());
        } else {
            this.write("null", 0, 4);
        }
    }

    public boolean checkError() {
        return this.error;
    }

    private void checkOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    protected void finalize() {
        super.finalize();
    }
}

