/*
 * Decompiled with CFR 0.152.
 */
package com.rp.log;

import com.rp.log.RpLogger;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MTRpLogger
extends RpLogger
implements Runnable {
    private int BUFFER_LIMIT = 1000;
    private List buffer = Collections.synchronizedList(new ArrayList(10));
    private Thread logThread = null;
    private boolean check = true;
    private final String newLine = System.getProperty("line.separator");
    private int bufferIndex = 0;

    public MTRpLogger(String fileName) throws IOException {
        this(fileName, 4, 1);
    }

    public MTRpLogger(String fileName, int loggingLevel) throws IOException {
        this(fileName, loggingLevel, 1);
    }

    public MTRpLogger(String fileName, int loggingLevel, int frequency) throws IOException {
        super(fileName, loggingLevel, frequency);
        this.setLogThread(new Thread((Runnable)this, "logThread"));
        this.getLogThread().start();
    }

    public MTRpLogger(Writer writer) throws IOException {
        this(writer, 4);
    }

    public MTRpLogger(Writer writer, int loggingLevel) throws IOException {
        super(writer, loggingLevel);
        this.setLogThread(new Thread((Runnable)this, "logThread"));
        this.getLogThread().start();
    }

    protected Thread getLogThread() {
        return this.logThread;
    }

    protected void setLogThread(Thread t) {
        this.logThread = t;
    }

    protected void stop() throws Exception {
        this.check = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.dumpBuffer();
        }
        catch (Exception exception) {
        }
        finally {
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList logBuffer = new ArrayList(10);
        boolean lbSize = false;
        boolean bufferSize = false;
        while (this.check) {
            try {
                while (this.buffer.size() == 0) {
                    this.wait();
                }
                int size = this.buffer.size();
                for (int i = 0; i < size; ++i) {
                    this.print(this.buffer.get(i));
                    ++this.bufferIndex;
                }
                if (this.bufferIndex <= this.BUFFER_LIMIT) continue;
                List list = this.buffer;
                synchronized (list) {
                    this.remove(this.buffer, this.bufferIndex);
                    this.bufferIndex = 0;
                }
            }
            catch (Exception e) {
            }
        }
    }

    protected void removeAll(List b) {
        b.clear();
    }

    protected void remove(List b, int size) {
        for (int i = 0; i < size; ++i) {
            b.remove(i);
        }
    }

    protected void dumpBuffer() {
        Iterator iter = this.buffer.iterator();
        while (iter.hasNext()) {
            this.print(iter.next());
        }
    }

    protected void print(Object o) {
        super.write(o);
    }

    protected void update(Object o) {
        try {
            this.buffer.add(o);
            this.notify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void write(String s) {
        this.update(s);
    }

    protected void write(boolean b) {
        this.update(String.valueOf(b));
    }

    protected void write(char c) {
        this.update(String.valueOf(c));
    }

    protected void write(double d) {
        this.update(String.valueOf(d));
    }

    protected void write(float f) {
        this.update(String.valueOf(f));
    }

    protected void write(int i) {
        this.update(String.valueOf(i));
    }

    protected void write(byte b) {
        this.update(String.valueOf(b));
    }

    protected void write(short s) {
        this.update(String.valueOf(s));
    }

    protected void write(long l) {
        this.update(String.valueOf(l));
    }

    protected void write(Object o) {
        this.update(o);
    }

    protected void write(char[] buf) {
        int len = buf.length;
        StringBuffer charBuffer = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            charBuffer.append(buf[i]);
        }
        this.update(charBuffer);
    }
}

