/*
 * Decompiled with CFR 0.152.
 */
package com.rp.log;

import com.rp.log.Logger;
import java.io.PrintWriter;

public class StandardLogger
implements Logger {
    public static final int DEBUG = 4;
    public static final int INFO = 3;
    public static final int WARN = 2;
    public static final int ERROR = 1;
    public static final int FATAL = 0;
    protected PrintWriter writer = null;
    protected boolean loggerError = false;
    protected int level = 4;

    public StandardLogger(PrintWriter writer) {
        this(writer, 4);
    }

    public StandardLogger(PrintWriter writer, int level) {
        this.setWriter(writer);
        this.setLevel(level);
    }

    public StandardLogger() {
    }

    public boolean checkError() {
        return this.writer != null && (this.writer.checkError() || this.loggerError);
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    protected int getLevel() {
        return this.level;
    }

    protected void setLevel(int level) {
        this.level = level;
    }

    protected boolean checkLevel(int i) {
        return i <= this.level;
    }

    protected void write(String s) {
        this.writer.println(s);
    }

    protected void write(boolean b) {
        this.writer.println(b);
    }

    protected void write(char c) {
        this.writer.println(c);
    }

    protected void write(byte b) {
        this.writer.println(b);
    }

    protected void write(double d) {
        this.writer.println(d);
    }

    protected void write(float f) {
        this.writer.println(f);
    }

    protected void write(int i) {
        this.writer.println(i);
    }

    protected void write(long l) {
        this.writer.println(l);
    }

    protected void write(Object o) {
        this.writer.println(o);
    }

    protected void write(char[] buf) {
        this.writer.println(buf);
    }

    public void fatal(String s) {
        if (this.checkLevel(0)) {
            this.write(s);
        }
    }

    public void fatal(boolean b) {
        if (this.checkLevel(0)) {
            this.write(b);
        }
    }

    public void fatal(char c) {
        if (this.checkLevel(0)) {
            this.write(c);
        }
    }

    public void fatal(double d) {
        if (this.checkLevel(0)) {
            this.write(d);
        }
    }

    public void fatal(short s) {
        if (this.checkLevel(0)) {
            this.write(s);
        }
    }

    public void fatal(byte b) {
        if (this.checkLevel(0)) {
            this.write(b);
        }
    }

    public void fatal(float f) {
        if (this.checkLevel(0)) {
            this.write(f);
        }
    }

    public void fatal(int i) {
        if (this.checkLevel(0)) {
            this.write(i);
        }
    }

    public void fatal(long l) {
        if (this.checkLevel(0)) {
            this.write(l);
        }
    }

    public void fatal(Object o) {
        if (this.checkLevel(0)) {
            this.write(o);
        }
    }

    public void fatal(char[] buf) {
        if (this.checkLevel(0)) {
            this.write(buf);
        }
    }

    public void error(String s) {
        if (this.checkLevel(1)) {
            this.write(s);
        }
    }

    public void error(boolean b) {
        if (this.checkLevel(1)) {
            this.write(b);
        }
    }

    public void error(char c) {
        if (this.checkLevel(1)) {
            this.write(c);
        }
    }

    public void error(double d) {
        if (this.checkLevel(1)) {
            this.write(d);
        }
    }

    public void error(byte b) {
        if (this.checkLevel(1)) {
            this.write(b);
        }
    }

    public void error(short s) {
        if (this.checkLevel(1)) {
            this.write(s);
        }
    }

    public void error(float f) {
        if (this.checkLevel(1)) {
            this.write(f);
        }
    }

    public void error(int i) {
        if (this.checkLevel(1)) {
            this.write(i);
        }
    }

    public void error(long l) {
        if (this.checkLevel(1)) {
            this.write(l);
        }
    }

    public void error(Object o) {
        if (this.checkLevel(1)) {
            this.write(o);
        }
    }

    public void error(char[] buf) {
        if (this.checkLevel(1)) {
            this.write(buf);
        }
    }

    public void warn(String s) {
        if (this.checkLevel(4)) {
            this.write(s);
        }
    }

    public void warn(boolean b) {
        if (this.checkLevel(4)) {
            this.write(b);
        }
    }

    public void warn(char c) {
        if (this.checkLevel(4)) {
            this.write(c);
        }
    }

    public void warn(double d) {
        if (this.checkLevel(4)) {
            this.write(d);
        }
    }

    public void warn(byte b) {
        if (this.checkLevel(4)) {
            this.write(b);
        }
    }

    public void warn(short s) {
        if (this.checkLevel(4)) {
            this.write(s);
        }
    }

    public void warn(float f) {
        if (this.checkLevel(4)) {
            this.write(f);
        }
    }

    public void warn(int i) {
        if (this.checkLevel(4)) {
            this.write(i);
        }
    }

    public void warn(long l) {
        if (this.checkLevel(4)) {
            this.write(l);
        }
    }

    public void warn(Object o) {
        if (this.checkLevel(4)) {
            this.write(o);
        }
    }

    public void warn(char[] buf) {
        if (this.checkLevel(4)) {
            this.write(buf);
        }
    }

    public void info(String s) {
        if (this.checkLevel(3)) {
            this.write(s);
        }
    }

    public void info(boolean b) {
        if (this.checkLevel(3)) {
            this.write(b);
        }
    }

    public void info(char c) {
        if (this.checkLevel(3)) {
            this.write(c);
        }
    }

    public void info(double d) {
        if (this.checkLevel(3)) {
            this.write(d);
        }
    }

    public void info(byte b) {
        if (this.checkLevel(3)) {
            this.write(b);
        }
    }

    public void info(short s) {
        if (this.checkLevel(3)) {
            this.write(s);
        }
    }

    public void info(float f) {
        if (this.checkLevel(3)) {
            this.write(f);
        }
    }

    public void info(int i) {
        if (this.checkLevel(3)) {
            this.write(i);
        }
    }

    public void info(long l) {
        if (this.checkLevel(3)) {
            this.write(l);
        }
    }

    public void info(Object o) {
        if (this.checkLevel(3)) {
            this.write(o);
        }
    }

    public void info(char[] buf) {
        if (this.checkLevel(3)) {
            this.write(buf);
        }
    }

    public void debug(String s) {
        if (this.checkLevel(4)) {
            this.write(s);
        }
    }

    public void debug(boolean b) {
        if (this.checkLevel(4)) {
            this.write(b);
        }
    }

    public void debug(char c) {
        if (this.checkLevel(4)) {
            this.write(c);
        }
    }

    public void debug(double d) {
        if (this.checkLevel(4)) {
            this.write(d);
        }
    }

    public void debug(byte b) {
        if (this.checkLevel(4)) {
            this.write(b);
        }
    }

    public void debug(short s) {
        if (this.checkLevel(4)) {
            this.write(s);
        }
    }

    public void debug(float f) {
        if (this.checkLevel(4)) {
            this.write(f);
        }
    }

    public void debug(int i) {
        if (this.checkLevel(4)) {
            this.write(i);
        }
    }

    public void debug(long l) {
        if (this.checkLevel(4)) {
            this.write(l);
        }
    }

    public void debug(Object o) {
        if (this.checkLevel(4)) {
            this.write(o);
        }
    }

    public void debug(char[] buf) {
        if (this.checkLevel(4)) {
            this.write(buf);
        }
    }

    protected boolean verifyLevel(int level) {
        return level >= 0 && level <= 4;
    }

    protected void finalize() {
        this.destroy();
    }

    protected void setError(boolean val) {
        this.loggerError = val;
    }

    public void destroy() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            this.setError(true);
        }
    }
}

