/*
 * Decompiled with CFR 0.152.
 */
package com.rp.util;

import com.rp.log.ObjectLogger;
import com.rp.log.RpLogger;
import com.rp.util.Loggable;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class LogUtil
implements Loggable {
    public static final int DEBUG = 4;
    public static final int INFO = 3;
    public static final int WARN = 2;
    public static final int ERROR = 1;
    public static final int FATAL = 0;
    private ObjectLogger logger = null;
    private int logLevel = 4;
    private static Map keyMap = new HashMap();
    static PrintWriter writer = null;
    static RpLogger log = null;

    public static void load(PrintWriter inWriter) {
        writer = inWriter;
        try {
            log = new RpLogger((Writer)writer, 3);
        }
        catch (Exception e) {
            writer.println("Error loading log in LogUtil: " + e.toString());
        }
    }

    public static void log(Object obj) {
        if (log != null) {
            log.info(obj);
        }
    }

    public static void close() {
        if (log != null) {
            log.destroy();
        }
    }

    private LogUtil(ObjectLogger inLogger, int inLevel) {
        this.logger = inLogger;
        this.logLevel = inLevel;
    }

    public static LogUtil getInstance(String key) {
        return (LogUtil)keyMap.get(key);
    }

    public static LogUtil createInstance(ObjectLogger logger, int logLevel, String key) {
        LogUtil logUtil = new LogUtil(logger, logLevel);
        keyMap.put(key, logUtil);
        return logUtil;
    }

    public void fatal(String className, String method, String message, String key) {
        LogUtil logUtil = (LogUtil)keyMap.get(key);
        if (logUtil != null) {
            logUtil.fatal(className, method, message);
        }
    }

    public void error(String className, String method, String message, String key) {
        LogUtil logUtil = (LogUtil)keyMap.get(key);
        if (logUtil != null) {
            logUtil.error(className, method, message);
        }
    }

    public void warn(String className, String method, String message, String key) {
        LogUtil logUtil = (LogUtil)keyMap.get(key);
        if (logUtil != null) {
            logUtil.warn(className, method, message);
        }
    }

    public void info(String className, String method, String message, String key) {
        LogUtil logUtil = (LogUtil)keyMap.get(key);
        if (logUtil != null) {
            logUtil.info(className, method, message);
        }
    }

    public void debug(String className, String method, String message, String key) {
        LogUtil logUtil = (LogUtil)keyMap.get(key);
        if (logUtil != null) {
            logUtil.debug(className, method, message);
        }
    }

    public void fatal(String className, String method, String message) {
        if (this.logger != null) {
            this.logger.fatal(className + "::" + method + "::" + message);
        }
    }

    public void error(String className, String method, String message) {
        if (this.logLevel >= 1 && this.logger != null) {
            this.logger.error(className + "::" + method + "::" + message);
        }
    }

    public void warn(String className, String method, String message) {
        if (this.logLevel >= 2 && this.logger != null) {
            this.logger.warn(className + "::" + method + "::" + message);
        }
    }

    public void info(String className, String method, String message) {
        if (this.logLevel >= 3 && this.logger != null) {
            this.logger.info(className + "::" + method + "::" + message);
        }
    }

    public void debug(String className, String method, String message) {
        if (this.logLevel >= 4 && this.logger != null) {
            this.logger.debug(className + "::" + method + "::" + message);
        }
    }
}

