/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openswing.swing.client.AutoCompletitionDataLocator;
import org.openswing.swing.client.AutoCompletitionInputControl;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.table.editors.client.CodLookupCellEditor;

public final class AutoCompletitionListener
extends KeyAdapter {
    private AutoCompletitionDataLocator dataLocator = null;
    private AutoCompletitionInputControl inputControl = null;
    private JList list;
    private JScrollPane scrollPane;
    private long time = 0L;
    private WaitTimer timer = null;
    private long waitTime;
    private JWindow window = new JWindow();

    public AutoCompletitionListener(AutoCompletitionInputControl inputControl, AutoCompletitionDataLocator dataLocator, long waitTime) {
        this.list = new JList();
        this.scrollPane = new JScrollPane(this.list);
        this.inputControl = inputControl;
        this.dataLocator = dataLocator;
        this.waitTime = waitTime;
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setOpaque(false);
        this.list.setOpaque(false);
        this.list.setBackground(new Color(250, 250, 200));
        this.window.getContentPane().setBackground(new Color(250, 250, 200));
        this.scrollPane.getVerticalScrollBar().setFocusable(true);
        int i = 0;
        while (i < this.scrollPane.getVerticalScrollBar().getComponents().length) {
            if (this.scrollPane.getVerticalScrollBar().getComponents()[i] instanceof JButton) {
                this.scrollPane.getVerticalScrollBar().getComponents()[i].addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        e.consume();
                    }

                    public void mousePressed(MouseEvent e) {
                        AutoCompletitionListener.this.window.setVisible(true);
                    }

                    public void mouseReleased(MouseEvent e) {
                        e.consume();
                    }
                });
            }
            ++i;
        }
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            public void mousePressed(MouseEvent e) {
                AutoCompletitionListener.this.window.setVisible(true);
            }

            public void mouseReleased(MouseEvent e) {
                e.consume();
            }
        });
        this.window.setBackground(new Color(250, 250, 200));
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)this.scrollPane, "Center");
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AutoCompletitionListener.this.list.setSelectedIndex(AutoCompletitionListener.this.list.locationToIndex(e.getPoint()));
                e.consume();
                AutoCompletitionListener.this.inputControl.setValue(AutoCompletitionListener.this.list.getSelectedValue());
                AutoCompletitionListener.this.window.setVisible(false);
                if (AutoCompletitionListener.this.inputControl instanceof CodLookupControl) {
                    ((CodLookupControl)AutoCompletitionListener.this.inputControl).getCodBox().forceValidate();
                }
                if (AutoCompletitionListener.this.inputControl instanceof CodLookupCellEditor) {
                    ((CodLookupCellEditor)((Object)AutoCompletitionListener.this.inputControl)).forceValidate();
                }
                try {
                    if (AutoCompletitionListener.this.timer != null) {
                        AutoCompletitionListener.this.timer.interrupt();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                AutoCompletitionListener.this.time = 0L;
            }
        });
        inputControl.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
                try {
                    if (AutoCompletitionListener.this.timer != null) {
                        AutoCompletitionListener.this.timer.interrupt();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                AutoCompletitionListener.this.window.setVisible(false);
                AutoCompletitionListener.this.window.dispose();
            }
        });
        inputControl.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AutoCompletitionListener.this.window.setVisible(false);
                try {
                    if (AutoCompletitionListener.this.timer != null) {
                        AutoCompletitionListener.this.timer.interrupt();
                    }
                }
                catch (Exception ex) {
                }
            }
        });
    }

    static /* synthetic */ void access$700(AutoCompletitionListener x0) {
        x0.checkInputControlValue();
    }

    private void checkInputControlValue() {
        if (this.inputControl.getValue() == null || "".equals(this.inputControl.getValue().toString())) {
            this.window.setVisible(false);
            try {
                if (this.timer != null) {
                    this.timer.interrupt();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.time = 0L;
        } else if (!this.window.isVisible()) {
            this.window.setLocation(this.inputControl.getLocationOnScreen().x, this.inputControl.getLocationOnScreen().y + this.inputControl.getHeight() + 1);
            if (this.reload()) {
                this.window.setSize(this.inputControl.getWidth(), 200);
                this.window.setVisible(true);
            }
        } else if (!this.reload()) {
            this.window.setVisible(false);
            try {
                if (this.timer != null) {
                    this.timer.interrupt();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.time = 0L;
        }
    }

    public final boolean isWindowVisible() {
        return this.window.isVisible();
    }

    public final void keyPressed(KeyEvent e) {
        block18: {
            block21: {
                block20: {
                    block19: {
                        block17: {
                            if (e.getKeyCode() != 10 || !this.window.isVisible() || this.list.getSelectedIndex() == -1) break block17;
                            e.consume();
                            this.inputControl.setValue(this.list.getSelectedValue());
                            this.window.setVisible(false);
                            if (this.inputControl instanceof CodLookupControl) {
                                ((CodLookupControl)this.inputControl).getCodBox().forceValidate();
                            }
                            if (this.inputControl instanceof CodLookupCellEditor) {
                                ((CodLookupCellEditor)((Object)this.inputControl)).forceValidate();
                            }
                            try {
                                if (this.timer != null) {
                                    this.timer.interrupt();
                                }
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            this.time = 0L;
                            break block18;
                        }
                        if (e.getKeyCode() != 38 || !this.window.isVisible()) break block19;
                        if (this.list.getSelectedIndex() == -1) {
                            this.list.setSelectedIndex(0);
                        } else if (this.list.getSelectedIndex() == 0) {
                            this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
                        } else {
                            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
                        }
                        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                        break block18;
                    }
                    if (e.getKeyCode() != 40 || !this.window.isVisible()) break block20;
                    if (this.list.getSelectedIndex() == -1) {
                        this.list.setSelectedIndex(0);
                    } else if (this.list.getSelectedIndex() < this.list.getModel().getSize() - 1) {
                        this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
                    } else {
                        this.list.setSelectedIndex(0);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    break block18;
                }
                if (e.getKeyCode() == 27) break block21;
                if (e.getKeyCode() != 9) break block18;
            }
            this.window.setVisible(false);
            try {
                if (this.timer != null) {
                    this.timer.interrupt();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.time = 0L;
        }
    }

    public final void keyReleased(KeyEvent e) {
        block19: {
            block18: {
                if (e.getKeyCode() == 10) break block18;
                if (e.getKeyCode() == 38) break block18;
                if (e.getKeyCode() == 40) break block18;
                if (e.getKeyCode() != 27) break block19;
            }
            return;
        }
        if (this.time == 0L) {
            this.time = System.currentTimeMillis();
            this.timer = new WaitTimer();
            this.timer.start();
        } else if (System.currentTimeMillis() - this.time < this.waitTime) {
            try {
                if (this.timer != null) {
                    this.timer.interrupt();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.timer = new WaitTimer();
            this.timer.start();
            this.time = System.currentTimeMillis();
            if (this.inputControl.getValue() == null || "".equals(this.inputControl.getValue().toString())) {
                this.window.setVisible(false);
                try {
                    if (this.timer != null) {
                        this.timer.interrupt();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.time = 0L;
            } else if (this.window.isVisible()) {
                this.checkInputControlValue();
            }
        } else {
            this.time = System.currentTimeMillis();
        }
    }

    private boolean reload() {
        ArrayList data = this.dataLocator.getListOfData(this.inputControl.getValue());
        DefaultListModel model = new DefaultListModel();
        int i = 0;
        while (i < data.size()) {
            model.addElement(data.get(i));
            ++i;
        }
        this.list.setModel(model);
        this.list.revalidate();
        this.list.repaint();
        if (data.size() > 0) {
            this.list.setSelectedIndex(0);
        }
        return data.size() > 0;
    }

    class WaitTimer
    extends Thread {
        WaitTimer() {
        }

        static /* synthetic */ AutoCompletitionListener access$600(WaitTimer x0) {
            return x0.AutoCompletitionListener.this;
        }

        public void run() {
            try {
                Thread.sleep(AutoCompletitionListener.this.waitTime);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ WaitTimer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        AutoCompletitionListener.access$700(WaitTimer.access$600(this.this$1));
                    }
                });
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

