/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.InputControlPopupMenu;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.form.model.client.ValueChangeEvent;
import org.openswing.swing.form.model.client.ValueChangeListener;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class BaseInputControl
extends JPanel
implements InputControl {
    private String attributeName = null;
    private boolean canCopy = true;
    private boolean changed = false;
    protected Color defaultBackgroundColor = null;
    private boolean enabledOnEdit = true;
    private boolean enabledOnInsert = true;
    private InputControlPopupMenu inputControlPopupMenu;
    private LabelControl linkedLabel = null;
    protected Object oldValue;
    private boolean required = false;
    private JLabel requiredIcon = new JLabel("*");
    private int textAlignment = 2;
    private String toolTipText = null;
    private ArrayList valueChangedListeners = new ArrayList();

    public BaseInputControl() {
        this.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!BaseInputControl.this.getBindingComponent().hasFocus()) {
                    BaseInputControl.this.getBindingComponent().requestFocus();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        if (Beans.isDesignTime()) {
            this.requiredIcon.setForeground(Color.red);
            this.requiredIcon.setFont(new Font(this.requiredIcon.getFont().getFontName(), 0, 20));
            this.requiredIcon.setPreferredSize(new Dimension(15, 15));
            this.requiredIcon.setFocusable(false);
        } else {
            this.requiredIcon.setText("");
            this.requiredIcon.setIcon(new ImageIcon(ClientUtils.getImage("obl.gif", this.getClass())));
        }
    }

    public final void addValueChangedListener(ValueChangeListener listener) {
        this.valueChangedListeners.add(listener);
    }

    private void controlFocusGained(FocusEvent e) {
        if (this instanceof DateControl) {
            this.maybeFireValueChangedEvent();
        }
        this.oldValue = this.getValue();
        if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && this.isEnabled()) {
            this.getBindingComponent().setBackground(ClientSettings.BACKGROUND_SEL_COLOR);
        }
        if (ClientSettings.SELECT_DATA_IN_EDITABLE_FORM && this.isEnabled() && this.getBindingComponent() instanceof JTextComponent) {
            ((JTextComponent)this.getBindingComponent()).select(0, ((JTextComponent)this.getBindingComponent()).getText().length());
        }
    }

    private void controlFocusLost(FocusEvent e) {
        if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && this.isEnabled()) {
            this.getBindingComponent().setBackground(this.defaultBackgroundColor);
        }
        this.maybeFireValueChangedEvent();
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public JComponent getBindingComponent() {
        Logger.error(this.getClass().getName(), "getBindingComponent", "This method must be overridden in '" + this.getClass().getName() + "'", null);
        return null;
    }

    public final Font getFont() {
        return this.getBindingComponent() == null ? null : this.getBindingComponent().getFont();
    }

    public final LabelControl getLinkLabel() {
        return this.linkedLabel;
    }

    public final int getTextAlignment() {
        return this.textAlignment;
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public Object getValue() {
        Logger.error(this.getClass().getName(), "getValue", "This method must be overridden in '" + this.getClass().getName() + "'", null);
        return null;
    }

    public final ValueChangeListener[] getValueChangeListeners() {
        return this.valueChangedListeners.toArray(new ValueChangeListener[this.valueChangedListeners.size()]);
    }

    protected void initListeners() {
        this.defaultBackgroundColor = this.getBindingComponent().getBackground();
        this.getBindingComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                BaseInputControl.this.controlFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                BaseInputControl.this.controlFocusLost(e);
            }
        });
        if (this.getBindingComponent() instanceof ItemSelectable) {
            ((ItemSelectable)((Object)this.getBindingComponent())).addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && BaseInputControl.this.attributeName != null) {
                        BaseInputControl.this.maybeFireValueChangedEvent();
                    }
                }
            });
        }
        this.inputControlPopupMenu = new InputControlPopupMenu(this);
        ClientUtils.addTabListener(this.getBindingComponent());
    }

    public final boolean isCanCopy() {
        return this.canCopy;
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public boolean isEnabled() {
        try {
            Logger.error(this.getClass().getName(), "isEnabled", "This method must be overridden in '" + this.getClass().getName() + "'", null);
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isEnabledOnEdit() {
        return this.enabledOnEdit;
    }

    public final boolean isEnabledOnInsert() {
        return this.enabledOnInsert;
    }

    public final boolean isRequired() {
        return this.required;
    }

    protected void maybeFireValueChangedEvent() {
        Object newValue = this.getValue();
        if (this.isEnabled() && (this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue))) {
            this.setChanged(true);
            ValueChangeEvent e = new ValueChangeEvent(this, this.attributeName, this.oldValue, newValue);
            int i = 0;
            while (i < this.valueChangedListeners.size()) {
                ((ValueChangeListener)this.valueChangedListeners.get(i)).valueChanged(e);
                ++i;
            }
            this.oldValue = newValue;
        }
    }

    public final void removeValueChangedListener(ValueChangeListener listener) {
        this.valueChangedListeners.remove(listener);
    }

    public void requestFocus() {
        this.getBindingComponent().requestFocus();
    }

    public final void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public final void setCanCopy(boolean canCopy) {
        this.canCopy = canCopy;
    }

    public final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setEnabled(boolean enabled) {
        Logger.error(this.getClass().getName(), "setEnabled", "This method must be overridden in '" + this.getClass().getName() + "'", null);
    }

    public final void setEnabledOnEdit(boolean enabled) {
        this.enabledOnEdit = enabled;
    }

    public final void setEnabledOnInsert(boolean enabled) {
        this.enabledOnInsert = enabled;
    }

    public final void setFont(Font font) {
        if (this.getBindingComponent() != null) {
            this.getBindingComponent().setFont(font);
        }
    }

    public final void setLinkLabel(LabelControl linkedLabel) {
        this.linkedLabel = linkedLabel;
    }

    public final void setRequired(boolean required) {
        if (!this.required && required && ClientSettings.VIEW_MANDATORY_SYMBOL) {
            if (this.getLayout() instanceof FlowLayout) {
                this.add(this.requiredIcon);
            } else if (this.getLayout() instanceof BorderLayout) {
                this.add((Component)this.requiredIcon, "East");
            } else if (this.getLayout() instanceof GridBagLayout) {
                this.add((Component)this.requiredIcon, new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 5, 0));
            }
            this.revalidate();
            this.repaint();
        } else if (this.required && !required && ClientSettings.VIEW_MANDATORY_SYMBOL) {
            this.remove(this.requiredIcon);
        }
        this.required = required;
    }

    public final void setTextAlignment(int alignment) {
        this.textAlignment = alignment;
        if (!Beans.isDesignTime() && this.getBindingComponent() != null && this.getBindingComponent() instanceof JTextField) {
            ((JTextField)this.getBindingComponent()).setHorizontalAlignment(alignment);
        }
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (!Beans.isDesignTime()) {
            this.getBindingComponent().setToolTipText(ClientSettings.getInstance().getResources().getResource(toolTipText));
        }
    }

    public void setValue(Object value) {
        Logger.error(this.getClass().getName(), "setValue", "This method must be overridden in '" + this.getClass().getName() + "'", null);
    }
}

