/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.form.model.client.ValueChangeEvent;
import org.openswing.swing.form.model.client.ValueChangeListener;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class CheckBoxControl
extends JCheckBox
implements InputControl {
    private boolean allowNullValue = false;
    private String attributeName = null;
    private boolean canCopy = false;
    private boolean changed = false;
    private Color defaultBackgroundColor = null;
    private boolean enabledOnEdit = true;
    private boolean enabledOnInsert = true;
    private LabelControl label = null;
    private CheckBoxButtonModel model = null;
    protected Object oldValue;
    private String toolTipText = null;
    private ArrayList valueChangedListeners = new ArrayList();

    public CheckBoxControl() {
        this.setOpaque(false);
        this.initListeners();
    }

    public final void addValueChangedListener(ValueChangeListener listener) {
        this.valueChangedListeners.add(listener);
    }

    private void controlFocusGained(FocusEvent e) {
        this.oldValue = this.getValue();
        if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && this.isEnabled()) {
            UIManager.put("CheckBox.background", ClientSettings.BACKGROUND_SEL_COLOR);
            UIManager.put("CheckBoxMenuItem.selectionBackground", ClientSettings.BACKGROUND_SEL_COLOR);
            this.repaint();
        }
    }

    private void controlFocusLost(FocusEvent e) {
        if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && this.isEnabled()) {
            UIManager.put("CheckBox.background", this.defaultBackgroundColor);
            UIManager.put("CheckBoxMenuItem.selectionBackground", this.defaultBackgroundColor);
            this.repaint();
        }
        this.maybeFireValueChangedEvent();
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final Font getFont() {
        return super.getFont();
    }

    public final LabelControl getLinkLabel() {
        return this.label;
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public final Object getValue() {
        if (this.allowNullValue) {
            return this.model.getCurrentValue();
        }
        return new Boolean(this.isSelected());
    }

    public final ValueChangeListener[] getValueChangeListeners() {
        return this.valueChangedListeners.toArray(new ValueChangeListener[this.valueChangedListeners.size()]);
    }

    protected void initListeners() {
        this.defaultBackgroundColor = this.getBackground();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CheckBoxControl.this.controlFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                CheckBoxControl.this.controlFocusLost(e);
            }
        });
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && CheckBoxControl.this.attributeName != null) {
                    CheckBoxControl.this.maybeFireValueChangedEvent();
                }
            }
        });
        ClientUtils.addTabListener(this);
    }

    public final boolean isAllowNullValue() {
        return this.allowNullValue;
    }

    public final boolean isCanCopy() {
        return this.canCopy;
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public final boolean isEnabledOnEdit() {
        return this.enabledOnEdit;
    }

    public final boolean isEnabledOnInsert() {
        return this.enabledOnInsert;
    }

    public final boolean isRequired() {
        return false;
    }

    protected void maybeFireValueChangedEvent() {
        Object newValue = this.getValue();
        if (this.isEnabled() && (this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue))) {
            this.oldValue = newValue;
            this.setChanged(true);
            ValueChangeEvent e = new ValueChangeEvent(this, this.attributeName, this.oldValue, newValue);
            int i = 0;
            while (i < this.valueChangedListeners.size()) {
                ((ValueChangeListener)this.valueChangedListeners.get(i)).valueChanged(e);
                ++i;
            }
        }
    }

    public final void removeValueChangedListener(ValueChangeListener listener) {
        this.valueChangedListeners.remove(listener);
    }

    public final void setAllowNullValue(boolean allowNullValue) {
        this.allowNullValue = allowNullValue;
        if (allowNullValue) {
            MouseListener[] ll = this.getMouseListeners();
            int i = 0;
            while (i < ll.length) {
                if (ll[i] instanceof BasicButtonListener) {
                    this.removeMouseListener(ll[i]);
                }
                ++i;
            }
            super.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!CheckBoxControl.this.isEnabled()) {
                        return;
                    }
                    CheckBoxControl.this.grabFocus();
                    if (CheckBoxControl.this.model.getCurrentValue() == null) {
                        CheckBoxControl.this.model.setCurrentValue(Boolean.FALSE);
                    } else if (Boolean.TRUE.equals(CheckBoxControl.this.model.getCurrentValue())) {
                        CheckBoxControl.this.model.setCurrentValue(null);
                    } else if (Boolean.FALSE.equals(CheckBoxControl.this.model.getCurrentValue())) {
                        CheckBoxControl.this.model.setCurrentValue(Boolean.TRUE);
                    }
                }
            });
            ActionMapUIResource map = new ActionMapUIResource();
            map.put("pressed", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    CheckBoxControl.this.grabFocus();
                    if (CheckBoxControl.this.model.getCurrentValue() == null) {
                        CheckBoxControl.this.model.setCurrentValue(Boolean.FALSE);
                    } else if (Boolean.TRUE.equals(CheckBoxControl.this.model.getCurrentValue())) {
                        CheckBoxControl.this.model.setCurrentValue(null);
                    } else if (Boolean.FALSE.equals(CheckBoxControl.this.model.getCurrentValue())) {
                        CheckBoxControl.this.model.setCurrentValue(Boolean.TRUE);
                    }
                }
            });
            map.put("released", null);
            SwingUtilities.replaceUIActionMap(this, map);
            this.model = new CheckBoxButtonModel(this.getModel());
            this.setModel(this.model);
        }
    }

    public final void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public final void setCanCopy(boolean canCopy) {
        this.canCopy = canCopy;
    }

    public final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        try {
            UIManager.put("CheckBox.background", UIManager.getColor("TextField.inactiveBackground"));
            UIManager.put("CheckBoxMenuItem.selectionBackground", UIManager.getColor("TextField.inactiveBackground"));
        }
        catch (Exception ex) {
        }
    }

    public final void setEnabledOnEdit(boolean enabled) {
        this.enabledOnEdit = enabled;
    }

    public final void setEnabledOnInsert(boolean enabled) {
        this.enabledOnInsert = enabled;
    }

    public final void setFont(Font font) {
        super.setFont(font);
    }

    public final void setLinkLabel(LabelControl label) {
        this.label = label;
    }

    public final void setSelected(boolean selected) {
        if (this.allowNullValue) {
            this.model.setCurrentValue(new Boolean(selected));
        } else {
            super.setSelected(selected);
        }
    }

    public final void setText(String text) {
        if (Beans.isDesignTime()) {
            super.setText(text);
        } else {
            super.setText(ClientSettings.getInstance().getResources().getResource(text));
        }
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (!Beans.isDesignTime()) {
            super.setToolTipText(ClientSettings.getInstance().getResources().getResource(toolTipText));
        }
    }

    public final void setValue(Object value) {
        if (this.allowNullValue) {
            try {
                this.model.setCurrentValue((Boolean)value);
            }
            catch (ClassCastException ex) {
                Logger.error(this.getClass().getName(), "setValue", "Value is not of type Boolean: " + value.getClass().getName(), null);
            }
        } else if (value == null) {
            this.setSelected(false);
        } else if (value instanceof Boolean) {
            this.setSelected((Boolean)value);
        } else {
            Logger.error(this.getClass().getName(), "setValue", "Value is not of type Boolean: " + value.getClass().getName(), null);
        }
    }

    class CheckBoxButtonModel
    implements ButtonModel {
        private final ButtonModel model;

        public CheckBoxButtonModel(ButtonModel model) {
            this.model = model;
        }

        public void addActionListener(ActionListener listener) {
            this.model.addActionListener(listener);
        }

        public void addChangeListener(ChangeListener listener) {
            this.model.addChangeListener(listener);
        }

        public void addItemListener(ItemListener listener) {
            this.model.addItemListener(listener);
        }

        public String getActionCommand() {
            return this.model.getActionCommand();
        }

        public Boolean getCurrentValue() {
            if (this.isSelected()) {
                return Boolean.TRUE;
            }
            if (!this.isSelected() && this.isArmed()) {
                return null;
            }
            return Boolean.FALSE;
        }

        public int getMnemonic() {
            return this.model.getMnemonic();
        }

        public Object[] getSelectedObjects() {
            return this.model.getSelectedObjects();
        }

        public boolean isArmed() {
            return this.model.isArmed();
        }

        public boolean isEnabled() {
            try {
                return this.model.isEnabled();
            }
            catch (Exception ex) {
                return false;
            }
        }

        public boolean isPressed() {
            return this.model.isPressed();
        }

        public boolean isRollover() {
            return this.model.isRollover();
        }

        public boolean isSelected() {
            return this.model.isSelected();
        }

        public void removeActionListener(ActionListener listener) {
            this.model.removeActionListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.model.removeChangeListener(listener);
        }

        public void removeItemListener(ItemListener listener) {
            this.model.removeItemListener(listener);
        }

        public void setActionCommand(String command) {
            this.model.setActionCommand(command);
        }

        public void setArmed(boolean armed) {
        }

        public void setCurrentValue(Boolean value) {
            if (value == null) {
                this.model.setArmed(true);
                this.setPressed(true);
                this.setSelected(false);
            } else if (Boolean.FALSE.equals(value)) {
                this.model.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (Boolean.TRUE.equals(value)) {
                this.model.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            }
        }

        public final void setEnabled(boolean b) {
            CheckBoxControl.this.setFocusable(b);
            this.model.setEnabled(b);
        }

        public void setGroup(ButtonGroup group) {
            this.model.setGroup(group);
        }

        public void setMnemonic(int mnemonic) {
            this.model.setMnemonic(mnemonic);
        }

        public void setPressed(boolean pressed) {
            this.model.setPressed(pressed);
        }

        public void setRollover(boolean rollover) {
            this.model.setRollover(rollover);
        }

        public void setSelected(boolean selected) {
            this.model.setSelected(selected);
        }
    }
}

