/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class CheckBoxListControl
extends BaseInputControl
implements InputControl,
SearchControl,
MouseListener {
    private Domain domain = null;
    private String domainId = null;
    private boolean firstTime = false;
    private JList list;
    private DefaultListModel model;
    private ArrayList mouseListeners = new ArrayList();
    private boolean nullAsDefaultValue = false;
    private boolean translateItemDescriptions = true;

    public CheckBoxListControl() {
        this.list = new JList(){

            public void addMouseListener(MouseListener listener) {
                try {
                    if (listener.equals(CheckBoxListControl.this)) {
                        super.addMouseListener(listener);
                    } else {
                        CheckBoxListControl.this.mouseListeners.add(listener);
                    }
                }
                catch (Exception ex) {
                }
            }
        };
        this.model = new DefaultListModel();
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setOpaque(false);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 3) break block2;
                        if (e.getKeyCode() == 8) break block2;
                        if (e.getKeyCode() != 127) break block3;
                    }
                    CheckBoxListControl.this.list.setSelectedIndex(-1);
                }
            }
        });
        this.list.setSelectionForeground((Color)UIManager.get("TextField.foreground"));
        this.initListeners();
        this.getBindingComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && CheckBoxListControl.this.isEnabled()) {
                    CheckBoxListControl.this.getBindingComponent().setBackground(CheckBoxListControl.this.defaultBackgroundColor);
                }
            }
        });
        new SearchWindowManager(this);
    }

    public final void addFocusListener(FocusListener l) {
        try {
            this.list.addFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public final void addMouseListener(MouseListener l) {
        try {
            this.list.addMouseListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addNotify() {
        super.addNotify();
        if (!this.firstTime) {
            this.firstTime = true;
            this.list.setCellRenderer(new CheckBoxListControlCellRenderer());
        }
    }

    public final boolean disableListener() {
        return false;
    }

    public JComponent getBindingComponent() {
        return this.list;
    }

    public final JComponent getComponent() {
        return this.list;
    }

    public final Domain getDomain() {
        return this.domain;
    }

    public final String getDomainId() {
        return this.domainId;
    }

    public final int getFixedCellHeight() {
        return this.list.getFixedCellHeight();
    }

    public final int getFixedCellWidth() {
        return this.list.getFixedCellWidth();
    }

    public final int getLayoutOrientation() {
        return this.list.getLayoutOrientation();
    }

    public final int getRowCount() {
        return this.list.getModel().getSize();
    }

    public final int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public final Color getSelectionBackground() {
        return this.list.getSelectionBackground();
    }

    public Color getSelectionForeground() {
        return this.list.getSelectionForeground();
    }

    public final int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public final Object getValue() {
        if (this.list.getSelectionMode() == 0) {
            if (this.domain == null) {
                return null;
            }
            DomainPair[] pairs = this.domain.getDomainPairList();
            if (this.list.getSelectedIndex() == -1) {
                return null;
            }
            return pairs[this.list.getSelectedIndex()].getCode();
        }
        if (this.domain == null) {
            return new ArrayList();
        }
        DomainPair[] pairs = this.domain.getDomainPairList();
        ArrayList<Object> codes = new ArrayList<Object>();
        int[] values = this.list.getSelectedIndices();
        int j = 0;
        while (j < values.length) {
            codes.add(pairs[values[j]].getCode());
            ++j;
        }
        return codes;
    }

    public final String getValueAt(int index) {
        return this.list.getModel().getElementAt(index) == null ? "" : this.list.getModel().getElementAt(index).toString();
    }

    public final boolean getValueIsAdjusting() {
        return this.list.getValueIsAdjusting();
    }

    public final int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    public final boolean isEnabled() {
        try {
            return this.list.isEnabled();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isNullAsDefaultValue() {
        return this.nullAsDefaultValue;
    }

    public final boolean isReadOnly() {
        return !this.isEnabled();
    }

    public final boolean isTranslateItemDescriptions() {
        return this.translateItemDescriptions;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled()) {
            try {
                int row = this.list.locationToIndex(e.getPoint());
                if (row != -1) {
                    if (this.list.getSelectionMode() == 0) {
                        this.list.setSelectedIndex(row);
                    } else {
                        int[] indexes = this.list.getSelectedIndices();
                        int i = 0;
                        while (i < indexes.length) {
                            if (indexes[i] == row) {
                                this.list.getSelectionModel().removeSelectionInterval(row, row);
                                return;
                            }
                            ++i;
                        }
                        this.list.getSelectionModel().addSelectionInterval(row, row);
                    }
                }
            }
            catch (Exception ex) {
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public final void removeFocusListener(FocusListener l) {
        try {
            this.list.removeFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    public final void removeMouseListener(MouseListener l) {
        try {
            this.list.removeMouseListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final int search(String textToSeach) {
        return -1;
    }

    public final void setDomain(Domain domain) {
        this.domain = domain;
        this.model.removeAllElements();
        if (domain != null) {
            DomainPair[] pairs = domain.getDomainPairList();
            int i = 0;
            while (i < pairs.length) {
                if (this.translateItemDescriptions) {
                    this.model.addElement(ClientSettings.getInstance().getResources().getResource(pairs[i].getDescription()));
                } else {
                    this.model.addElement(pairs[i].getDescription());
                }
                ++i;
            }
            this.list.setModel(this.model);
            this.list.revalidate();
            this.list.setSelectedIndex(-1);
        }
    }

    public final void setDomainId(String domainId) {
        this.domainId = domainId;
        if (Beans.isDesignTime()) {
            return;
        }
        Domain domain = ClientSettings.getInstance().getDomain(domainId);
        this.setDomain(domain);
    }

    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
        this.list.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (enabled) {
            this.list.setBackground((Color)UIManager.get("TextField.background"));
            this.list.setSelectionBackground(ClientSettings.BACKGROUND_SEL_COLOR);
        } else {
            this.list.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
            try {
                this.list.setSelectionBackground(new Color(this.list.getBackground().getRed() - 10, this.list.getBackground().getGreen() - 10, this.list.getBackground().getBlue() - 10));
            }
            catch (Exception ex) {
                this.list.setSelectionBackground(Color.lightGray);
            }
        }
    }

    public final void setFixedCellHeight(int height) {
        this.list.setFixedCellHeight(height);
    }

    public final void setFixedCellWidth(int width) {
        this.list.setFixedCellWidth(width);
    }

    public final void setLayoutOrientation(int layoutOrientation) {
        this.list.setLayoutOrientation(layoutOrientation);
    }

    public final void setNullAsDefaultValue(boolean nullAsDefaultValue) {
        this.nullAsDefaultValue = nullAsDefaultValue;
    }

    public final void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
        try {
            this.list.scrollRectToVisible(this.list.getCellBounds(index, index));
        }
        catch (Exception ex) {
        }
    }

    public final void setSelectedIndices(int[] indices) {
        this.list.setSelectedIndices(indices);
        try {
            this.list.scrollRectToVisible(this.list.getCellBounds(indices[0], indices[0]));
        }
        catch (Exception ex) {
        }
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.list.setSelectionBackground(selectionBackground);
    }

    public final void setSelectionForeground(Color selectionForeground) {
        this.list.setSelectionForeground(selectionForeground);
    }

    public final void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public final void setTranslateItemDescriptions(boolean translateItemDescriptions) {
        this.translateItemDescriptions = translateItemDescriptions;
    }

    public final void setValue(Object code) {
        if (this.list.getSelectionMode() == 0) {
            if (code == null) {
                this.list.setSelectedIndex(-1);
            }
            if (this.domain == null) {
                return;
            }
            DomainPair pair = this.domain.getDomainPair(code);
            if (pair != null) {
                if (this.translateItemDescriptions) {
                    this.list.setSelectedValue(ClientSettings.getInstance().getResources().getResource(pair.getDescription()), true);
                } else {
                    this.list.setSelectedValue(pair.getDescription(), true);
                }
            }
        } else {
            if (code == null || code instanceof List && ((List)code).size() == 0) {
                this.list.getSelectionModel().clearSelection();
                return;
            }
            if (this.domain == null) {
                return;
            }
            if (code instanceof List) {
                List codes = (List)code;
                this.list.getSelectionModel().clearSelection();
                int i = 0;
                while (i < codes.size()) {
                    int j = 0;
                    while (j < this.domain.getDomainPairList().length) {
                        if (this.domain.getDomainPairList()[j].getCode().equals(codes.get(i))) {
                            this.list.getSelectionModel().addSelectionInterval(j, j);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                Logger.error(this.getClass().getName(), "setValue", "You must specify a java.util.List argument type", null);
            }
        }
    }

    public final void setValueIsAdjusting(boolean b) {
        this.list.setValueIsAdjusting(b);
    }

    public final void setVisibleRowCount(int visibleRowCount) {
        this.list.setVisibleRowCount(visibleRowCount);
    }

    class CheckBoxLabel
    extends JLabel {
        private boolean sel;

        CheckBoxLabel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.translate(this.getWidth() / 2 - 6, this.getHeight() / 2 - 5);
            BasicGraphicsUtils.drawLoweredBezel(g, 0, 0, 12, 12, Color.darkGray, Color.black, Color.white, Color.gray);
            if (this.sel) {
                if (!this.isEnabled()) {
                    g.setColor(Color.GRAY);
                } else {
                    g.setColor(Color.black);
                }
                g.drawLine(3, 5, 5, 7);
                g.drawLine(3, 6, 5, 8);
                g.drawLine(3, 7, 5, 9);
                g.drawLine(6, 6, 9, 3);
                g.drawLine(6, 7, 9, 4);
                g.drawLine(6, 8, 9, 5);
            }
        }

        public void setSelected(boolean sel) {
            this.sel = sel;
            this.repaint();
        }
    }

    class CheckBoxListControlCellRenderer
    extends DefaultListCellRenderer {
        private CheckBoxLabel checkBox;
        private JPanel panel;

        public CheckBoxListControlCellRenderer() {
            this.checkBox = new CheckBoxLabel();
            this.panel = new JPanel();
            this.checkBox.setOpaque(false);
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout(0, 0));
            this.panel.add((Component)this, "Center");
            this.checkBox.setSize(14, 14);
            this.checkBox.setPreferredSize(new Dimension(14, 14));
            this.panel.add((Component)this.checkBox, "Before");
            if (CheckBoxListControl.this.list.getSelectionMode() == 1) {
                CheckBoxListControl.this.list.setSelectionMode(2);
            }
            CheckBoxListControl.this.list.addMouseListener(CheckBoxListControl.this);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, false, cellHasFocus);
            this.checkBox.setEnabled(CheckBoxListControl.this.isEnabled());
            this.checkBox.setSelected(isSelected);
            return this.panel;
        }
    }
}

