/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.math.BigDecimal;
import javax.swing.FocusManager;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openswing.swing.client.CodBoxContainer;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.lookup.client.RestoreFocusOnInvalidCodeException;
import org.openswing.swing.util.client.ClientSettings;

public class CodBox
extends JTextField {
    private boolean allowOnlyNumbers = false;
    private CodBoxContainer container = null;
    private int maxCharacters = 1;
    private String oldValue = "";

    public CodBox() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9 && ClientSettings.FORCE_FOCUS_ON_LOOKUP_CONTROL) {
                    CodBox.this.transferFocus();
                    if (CodBox.this.getText().trim().length() > 0 && CodBox.this.container instanceof CodLookupControl) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                FocusManager.getCurrentManager().getFocusOwner().transferFocus();
                            }
                        });
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' && (ClientSettings.AS_TAB == null || ClientSettings.AS_TAB.getKeyChar() != 'n')) {
                    if (CodBox.this.isEnabled() && CodBox.this.isEditable()) {
                        CodBox.this.startValidation();
                    }
                } else if (e.getKeyChar() == '\b') {
                    return;
                }
                if (CodBox.this.allowOnlyNumbers && (e.getKeyChar() < '0' || e.getKeyChar() > '9')) {
                    e.consume();
                } else if ((CodBox.this.getSelectedText() == null || CodBox.this.getSelectedText().length() == 0) && CodBox.this.getText().length() >= CodBox.this.maxCharacters) {
                    e.consume();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (CodBox.this.isEnabled() && CodBox.this.isEditable()) {
                    CodBox.this.startValidation();
                }
            }
        });
        StringBuffer s = new StringBuffer(this.getMaxCharacters());
        int i = 0;
        while (i < this.getMaxCharacters()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth(s.toString()), this.getPreferredSize().height));
        if (ClientSettings.FORCE_FOCUS_ON_LOOKUP_CONTROL) {
            this.setFocusTraversalKeysEnabled(false);
        }
    }

    public final void codeValidated(boolean validated) {
        if (!validated) {
            super.setText("");
            this.requestFocus();
        } else if (this.getText().length() > 0) {
            this.oldValue = this.getText();
        }
    }

    public void forceValidate() {
        try {
            this.oldValue = null;
            this.startValidation();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final int getMaxCharacters() {
        return this.maxCharacters;
    }

    public final Object getValue() {
        if (this.getText().length() == 0) {
            return null;
        }
        if (this.allowOnlyNumbers) {
            return new BigDecimal(this.getText());
        }
        return this.getText();
    }

    public final boolean isAllowOnlyNumbers() {
        return this.allowOnlyNumbers;
    }

    public final void setAllowOnlyNumbers(boolean allowOnlyNumbers) {
        this.allowOnlyNumbers = allowOnlyNumbers;
    }

    public final void setContainer(CodBoxContainer container) {
        this.container = container;
    }

    public final void setEditable(boolean enabled) {
        super.setEditable(enabled);
        try {
            if (enabled) {
                this.setForeground(UIManager.getColor("TextField.foreground"));
                this.setBackground(UIManager.getColor("TextField.background"));
            } else {
                this.setForeground(UIManager.getColor("TextField.foreground"));
                this.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            }
        }
        catch (Exception ex) {
        }
    }

    public void setEnabled(boolean enabled) {
        this.setEditable(enabled);
        if (this.container != null) {
            this.container.setEnabled(enabled);
        }
    }

    public final void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
        StringBuffer s = new StringBuffer(this.getMaxCharacters());
        int i = 0;
        while (i < this.getMaxCharacters()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.getFontMetrics(this.getFont()).stringWidth(s.toString()), this.getPreferredSize().height));
    }

    public final void setText(String text) {
        this.setValue(text);
    }

    public final void setValue(Object value) {
        super.setText(value == null ? null : value.toString());
        this.oldValue = value == null ? null : value.toString();
    }

    private void startValidation() {
        super.setText(this.getText().trim().toUpperCase());
        if (this.container != null && (this.oldValue != null && !this.oldValue.equals(this.getText()) || this.oldValue == null && this.getText() != null)) {
            this.oldValue = this.getText();
            try {
                this.container.validateCode(this.getText());
                this.oldValue = this.getText();
            }
            catch (RestoreFocusOnInvalidCodeException ex) {
                this.oldValue = "";
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!CodBox.this.hasFocus()) {
                            CodBox.this.requestFocus();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

