/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.items.client.ItemRenderer;
import org.openswing.swing.items.client.ItemsDataLocator;
import org.openswing.swing.items.client.ItemsMapper;
import org.openswing.swing.items.client.ItemsParent;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DateColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class ComboBoxVOControl
extends BaseInputControl
implements InputControl,
ItemsParent,
SearchControl {
    private int allColumnPreferredWidth = 100;
    private boolean allColumnVisible = false;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    private Column[] colProperties;
    private JComboBox combo = new JComboBox();
    private Color enabledBackColor;
    private String foreignKeyAttributeName;
    private Form form = null;
    private Hashtable getters;
    private ItemsDataLocator itemsDataLocator = null;
    private boolean itemsLoaded = false;
    private ItemsMapper itemsMapper = new ItemsMapper();
    private ValueObject itemsVO = null;
    private DefaultComboBoxModel model;
    private boolean nullAsDefaultValue = false;

    static {
        UIManager.put("ComboBox.disabledForeground", UIManager.get("ComboBox.foreground"));
        UIManager.put("ComboBox.disabledBackground", UIManager.get("TextField.inactiveBackground"));
        UIManager.put("ComboBox.selectionForeground", Color.black);
        UIManager.put("ComboBox.selectionBackground", ClientSettings.BACKGROUND_SEL_COLOR);
    }

    public ComboBoxVOControl() {
        this.colProperties = new Column[0];
        this.model = new DefaultComboBoxModel();
        this.enabledBackColor = this.combo.getBackground();
        this.getters = new Hashtable();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.combo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setOpaque(false);
        this.combo.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 3) break block2;
                        if (e.getKeyCode() == 8) break block2;
                        if (e.getKeyCode() != 127) break block3;
                    }
                    ComboBoxVOControl.this.combo.setSelectedIndex(-1);
                }
            }
        });
        this.initListeners();
        this.combo.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                return -1;
            }
        });
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
        new SearchWindowManager(this);
    }

    public final void addActionListener(ActionListener l) {
        try {
            this.combo.addActionListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addCombo2ParentLink(String parentAttributeName) {
        this.itemsMapper.addItem2ParentLink("", parentAttributeName);
    }

    public final void addCombo2ParentLink(String comboAttributeName, String parentAttributeName) {
        this.itemsMapper.addItem2ParentLink(comboAttributeName, parentAttributeName);
    }

    public final void addFocusListener(FocusListener l) {
        try {
            this.combo.addFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void addItemListener(ItemListener alistener) {
        try {
            this.combo.addItemListener(alistener);
        }
        catch (Exception ex) {
        }
    }

    public final void addNotify() {
        super.addNotify();
        if (!this.itemsLoaded) {
            Response res;
            this.itemsLoaded = true;
            if (this.itemsDataLocator != null && this.itemsVO != null && !(res = this.itemsDataLocator.loadData(this.itemsVO.getClass())).isError()) {
                List items = ((VOListResponse)res).getRows();
                int i = 0;
                while (i < items.size()) {
                    this.model.addElement(items.get(i));
                    ++i;
                }
                this.combo.setModel(this.model);
                this.combo.revalidate();
                this.combo.repaint();
                this.combo.setSelectedIndex(-1);
            }
            ItemRenderer rend = new ItemRenderer();
            rend.init(this.getters, this.colProperties, 1, 0, 0, 0);
            this.combo.setRenderer(rend);
            this.combo.setMinimumSize(new Dimension((int)this.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
            this.combo.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
            this.combo.setSize(new Dimension((int)this.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
            this.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && (ComboBoxVOControl.this.form == null || ComboBoxVOControl.this.form.getMode() != 0)) {
                        ComboBoxVOControl.this.itemsVO = (ValueObject)e.getItem();
                        ComboBoxVOControl.this.updateParentModel(ComboBoxVOControl.this);
                    }
                }
            });
            this.form = ClientUtils.getLinkedForm(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final boolean disableListener() {
        return false;
    }

    public final int getAllColumnPreferredWidth() {
        return this.allColumnPreferredWidth;
    }

    public JComponent getBindingComponent() {
        return this.combo;
    }

    public final JComboBox getComboBox() {
        return this.combo;
    }

    public final ItemsDataLocator getComboDataLocator() {
        return this.itemsDataLocator;
    }

    public final JComponent getComponent() {
        return this.combo;
    }

    private String getFKAttributeName() {
        return this.foreignKeyAttributeName == null || this.foreignKeyAttributeName.equals("") ? this.getAttributeName() : this.foreignKeyAttributeName;
    }

    public final String getForeignKeyAttributeName() {
        return this.foreignKeyAttributeName;
    }

    public final int getRowCount() {
        return this.combo.getItemCount();
    }

    public final int getSelectedIndex() {
        return this.combo.getSelectedIndex();
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.combo.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final Object getValue() {
        try {
            return ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(this.combo.getSelectedIndex()), new Object[0]);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public final String getValueAt(int index) {
        return this.combo.getItemAt(index) == null ? "" : this.combo.getItemAt(index).toString();
    }

    public ValueObject getValueObject() {
        return this.form == null ? null : this.form.getVOModel().getValueObject();
    }

    private void initItemsVO(String itemsValueObjectClassName) {
        try {
            this.itemsVO = (ValueObject)Class.forName(itemsValueObjectClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            Method[] methods = this.itemsVO.getClass().getMethods();
            int count = 0;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes().length == 0 && (methods[i].getReturnType().equals(class$java$lang$String == null ? ComboBoxVOControl.class$("java.lang.String") : class$java$lang$String) || methods[i].getReturnType().equals(class$java$math$BigDecimal == null ? ComboBoxVOControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || methods[i].getReturnType().equals(class$java$util$Date == null ? ComboBoxVOControl.class$("java.util.Date") : class$java$util$Date) || methods[i].getReturnType().equals(class$java$sql$Date == null ? ComboBoxVOControl.class$("java.sql.Date") : class$java$sql$Date) || methods[i].getReturnType().equals(class$java$sql$Timestamp == null ? ComboBoxVOControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || methods[i].getReturnType().equals(class$java$lang$Integer == null ? ComboBoxVOControl.class$("java.lang.Integer") : class$java$lang$Integer) || methods[i].getReturnType().equals(class$java$lang$Long == null ? ComboBoxVOControl.class$("java.lang.Long") : class$java$lang$Long) || methods[i].getReturnType().equals(class$java$lang$Short == null ? ComboBoxVOControl.class$("java.lang.Short") : class$java$lang$Short) || methods[i].getReturnType().equals(class$java$lang$Double == null ? ComboBoxVOControl.class$("java.lang.Double") : class$java$lang$Double) || methods[i].getReturnType().equals(class$java$lang$Float == null ? ComboBoxVOControl.class$("java.lang.Float") : class$java$lang$Float) || methods[i].getReturnType().equals(Integer.TYPE) || methods[i].getReturnType().equals(Long.TYPE) || methods[i].getReturnType().equals(Short.TYPE) || methods[i].getReturnType().equals(Double.TYPE) || methods[i].getReturnType().equals(Float.TYPE) || methods[i].getReturnType().equals(class$java$lang$Boolean == null ? ComboBoxVOControl.class$("java.lang.Boolean") : class$java$lang$Boolean))) {
                    ++count;
                }
                ++i;
            }
            String[] attributeNames = new String[count];
            this.colProperties = new Column[count];
            count = 0;
            Class<?> colType = null;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().startsWith("get") && methods[i2].getParameterTypes().length == 0 && (methods[i2].getReturnType().equals(class$java$lang$String == null ? ComboBoxVOControl.class$("java.lang.String") : class$java$lang$String) || methods[i2].getReturnType().equals(class$java$math$BigDecimal == null ? ComboBoxVOControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || methods[i2].getReturnType().equals(class$java$util$Date == null ? ComboBoxVOControl.class$("java.util.Date") : class$java$util$Date) || methods[i2].getReturnType().equals(class$java$sql$Date == null ? ComboBoxVOControl.class$("java.sql.Date") : class$java$sql$Date) || methods[i2].getReturnType().equals(class$java$sql$Timestamp == null ? ComboBoxVOControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || methods[i2].getReturnType().equals(class$java$lang$Integer == null ? ComboBoxVOControl.class$("java.lang.Integer") : class$java$lang$Integer) || methods[i2].getReturnType().equals(class$java$lang$Long == null ? ComboBoxVOControl.class$("java.lang.Long") : class$java$lang$Long) || methods[i2].getReturnType().equals(class$java$lang$Short == null ? ComboBoxVOControl.class$("java.lang.Short") : class$java$lang$Short) || methods[i2].getReturnType().equals(class$java$lang$Double == null ? ComboBoxVOControl.class$("java.lang.Double") : class$java$lang$Double) || methods[i2].getReturnType().equals(class$java$lang$Float == null ? ComboBoxVOControl.class$("java.lang.Float") : class$java$lang$Float) || methods[i2].getReturnType().equals(Integer.TYPE) || methods[i2].getReturnType().equals(Long.TYPE) || methods[i2].getReturnType().equals(Short.TYPE) || methods[i2].getReturnType().equals(Double.TYPE) || methods[i2].getReturnType().equals(Float.TYPE) || methods[i2].getReturnType().equals(class$java$lang$Boolean == null ? ComboBoxVOControl.class$("java.lang.Boolean") : class$java$lang$Boolean))) {
                    attributeNames[count] = methods[i2].getName().substring(3);
                    if (attributeNames[count].length() > 1) {
                        attributeNames[count] = attributeNames[count].substring(0, 1).toLowerCase() + attributeNames[count].substring(1);
                    }
                    if ((colType = methods[i2].getReturnType()).equals(class$java$lang$String == null ? ComboBoxVOControl.class$("java.lang.String") : class$java$lang$String)) {
                        this.colProperties[count] = new TextColumn();
                    } else if (colType.equals(class$java$lang$Integer == null ? ComboBoxVOControl.class$("java.lang.Integer") : class$java$lang$Integer) || colType.equals(class$java$lang$Long == null ? ComboBoxVOControl.class$("java.lang.Long") : class$java$lang$Long) || colType.equals(class$java$lang$Short == null ? ComboBoxVOControl.class$("java.lang.Short") : class$java$lang$Short) || colType.equals(Integer.TYPE) || colType.equals(Long.TYPE) || colType.equals(Short.TYPE)) {
                        this.colProperties[count] = new IntegerColumn();
                    } else if (colType.equals(class$java$math$BigDecimal == null ? ComboBoxVOControl.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || colType.equals(class$java$lang$Double == null ? ComboBoxVOControl.class$("java.lang.Double") : class$java$lang$Double) || colType.equals(class$java$lang$Float == null ? ComboBoxVOControl.class$("java.lang.Float") : class$java$lang$Float) || colType.equals(Double.TYPE) || colType.equals(Float.TYPE)) {
                        this.colProperties[count] = new DecimalColumn();
                    } else if (colType.equals(class$java$lang$Boolean == null ? ComboBoxVOControl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        this.colProperties[count] = new CheckBoxColumn();
                    } else if (colType.equals(class$java$util$Date == null ? ComboBoxVOControl.class$("java.util.Date") : class$java$util$Date)) {
                        this.colProperties[count] = new DateColumn();
                    } else if (colType.equals(class$java$sql$Date == null ? ComboBoxVOControl.class$("java.sql.Date") : class$java$sql$Date)) {
                        this.colProperties[count] = new DateColumn();
                    } else if (colType.equals(class$java$sql$Timestamp == null ? ComboBoxVOControl.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                        this.colProperties[count] = new DateColumn();
                    }
                    this.colProperties[count].setColumnName(attributeNames[count]);
                    if (this.colProperties[count].getHeaderColumnName().equals("columnname")) {
                        this.colProperties[count].setHeaderColumnName(String.valueOf(attributeNames[count].charAt(0)).toUpperCase() + attributeNames[count].substring(1));
                    }
                    this.colProperties[count].setColumnVisible(this.allColumnVisible);
                    this.colProperties[count].setPreferredWidth(this.allColumnPreferredWidth);
                    this.getters.put(this.colProperties[count].getColumnName(), methods[i2]);
                    ++count;
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.itemsVO = null;
        }
        catch (Error er) {
            er.printStackTrace();
            this.itemsVO = null;
        }
    }

    public final boolean isAllColumnVisible() {
        return this.allColumnVisible;
    }

    public final boolean isEnabled() {
        try {
            return this.combo.isEnabled();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isNullAsDefaultValue() {
        return this.nullAsDefaultValue;
    }

    public final boolean isReadOnly() {
        return this.isEnabled();
    }

    public final void reloadItems() {
        Response res;
        if (this.itemsDataLocator != null && this.itemsVO != null && !(res = this.itemsDataLocator.loadData(this.itemsVO.getClass())).isError()) {
            List items = ((VOListResponse)res).getRows();
            this.model = new DefaultComboBoxModel();
            int i = 0;
            while (i < items.size()) {
                this.model.addElement(items.get(i));
                ++i;
            }
            this.combo.setModel(this.model);
            this.combo.revalidate();
            this.combo.repaint();
            this.combo.setSelectedIndex(-1);
        }
    }

    public final void removeActionListener(ActionListener l) {
        try {
            this.combo.removeActionListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener l) {
        try {
            this.combo.removeFocusListener(l);
        }
        catch (Exception ex) {
        }
    }

    public final void removeItemListener(ItemListener alistener) {
        try {
            this.combo.removeItemListener(alistener);
        }
        catch (Exception ex) {
        }
    }

    public final int search(String textToSeach) {
        return -1;
    }

    public final void setAllColumnPreferredWidth(int preferredWidth) {
        this.allColumnPreferredWidth = preferredWidth;
        int i = 0;
        while (i < this.colProperties.length) {
            this.colProperties[i].setPreferredWidth(preferredWidth);
            ++i;
        }
    }

    public final void setAllColumnVisible(boolean visible) {
        this.allColumnVisible = visible;
        int i = 0;
        while (i < this.colProperties.length) {
            this.colProperties[i].setColumnVisible(visible);
            this.colProperties[i].setColumnSelectable(visible);
            ++i;
        }
    }

    public final void setComboDataLocator(ItemsDataLocator comboDataLocator) {
        this.itemsDataLocator = comboDataLocator;
    }

    public final void setComboValueObjectClassName(String comboValueObjectClassName) {
        this.initItemsVO(comboValueObjectClassName);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
        this.combo.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (!enabled) {
            this.combo.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
        }
    }

    public final void setForeignKeyAttributeName(String foreignKeyAttributeName) {
        this.foreignKeyAttributeName = foreignKeyAttributeName;
    }

    public final void setNullAsDefaultValue(boolean nullAsDefaultValue) {
        this.nullAsDefaultValue = nullAsDefaultValue;
    }

    public final void setPreferredWidthColumn(String itemsAttributeName, int preferredWidth) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(itemsAttributeName)) {
                this.colProperties[i].setPreferredWidth(preferredWidth);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setPreferredWidthColumn", "The attribute '" + (itemsAttributeName == null ? "null" : "'" + itemsAttributeName + "'") + "' does not exist.", null);
    }

    public final void setSelectedIndex(int index) {
        this.combo.setSelectedIndex(index);
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.combo.setComponentOrientation(o);
    }

    public void setValue(String attributeName, Object value) {
        if (this.form != null) {
            this.form.getVOModel().setValue(attributeName, value);
        }
    }

    public final void setValue(Object code) {
        if (code == null) {
            this.combo.setSelectedIndex(-1);
        }
        if (this.getFKAttributeName() == null) {
            return;
        }
        Object obj = null;
        try {
            int i = 0;
            while (i < this.model.getSize()) {
                obj = ((Method)this.getters.get(this.getFKAttributeName())).invoke(this.model.getElementAt(i), new Object[0]);
                if (code.equals(obj)) {
                    this.combo.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
        finally {
            this.combo.setSelectedIndex(-1);
        }
    }

    public final void setVisibleColumn(String comboAttributeName, boolean visible) {
        try {
            int visibleIndex = -1;
            int index = -1;
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.colProperties[i].isVisible()) {
                    visibleIndex = i;
                }
                if (this.colProperties[i].getColumnName().equals(comboAttributeName)) {
                    this.colProperties[i].setColumnVisible(visible);
                    this.colProperties[i].setColumnSelectable(visible);
                    index = i;
                    break;
                }
                ++i;
            }
            if (visible) {
                if (visibleIndex == -1) {
                    visibleIndex = 0;
                } else if (visibleIndex - 1 < this.colProperties.length) {
                    ++visibleIndex;
                }
                if (index > -1 && index != visibleIndex) {
                    Column infoTemp = this.colProperties[index];
                    this.colProperties[index] = this.colProperties[visibleIndex];
                    this.colProperties[visibleIndex] = infoTemp;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateParentModel(ItemsParent itemsParent) {
        if (this.itemsVO != null && this.itemsMapper != null) {
            try {
                Enumeration itemsAttributes = this.itemsMapper.getItemsChangedAttributes();
                String attrName = null;
                while (itemsAttributes.hasMoreElements()) {
                    String itemsAttributeName = (String)itemsAttributes.nextElement();
                    if (itemsAttributeName.length() == 0) {
                        if (!this.itemsMapper.setParentAttribute(itemsParent, itemsAttributeName, this.itemsVO.getClass(), this.itemsVO)) {
                            Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting items container value object.", null);
                            continue;
                        }
                        if (this.form == null || (attrName = this.itemsMapper.getParentAttributeName(itemsAttributeName)) == null || this.form == null) continue;
                        this.form.pull(attrName);
                        continue;
                    }
                    String itemsMethodName = "get" + String.valueOf(Character.toUpperCase(itemsAttributeName.charAt(0))) + itemsAttributeName.substring(1);
                    Method itemsMethod = this.itemsVO.getClass().getMethod(itemsMethodName, new Class[0]);
                    if (!this.itemsMapper.setParentAttribute(itemsParent, itemsAttributeName, itemsMethod.getReturnType(), itemsMethod.invoke((Object)this.itemsVO, new Object[0]))) {
                        Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting items container value object.", null);
                        continue;
                    }
                    if (this.form == null || (attrName = this.itemsMapper.getParentAttributeName(itemsAttributeName)) == null || this.form == null) continue;
                    this.form.pull(attrName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
        } else {
            Logger.error(this.getClass().getName(), "updateParentModel", "You must set 'itemsMapper' property", null);
        }
    }
}

