/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Beans;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.util.client.ClientSettings;

public class CurrencyControl
extends BaseInputControl
implements InputControl {
    private CurrencyBox currencyBox = new CurrencyBox();
    private String currencySymbol;
    private boolean currencySymbolOnLeft;
    private char decimalSymbol;
    private int decimals = 0;
    private DecimalFormat format = null;
    private boolean grouping = false;
    private char groupingSymbol;
    private boolean hideZeroDigits = ClientSettings.HIDE_ZERO_DIGITS;
    private int maxCharacters = 255;
    private double maxValue = 2.147483647E9;
    private double minValue = 0.0;
    private String nullValue = null;

    public CurrencyControl(int columns) {
        this.currencySymbol = ClientSettings.getInstance().getResources().getCurrencySymbol();
        this.decimalSymbol = ClientSettings.getInstance().getResources().getDecimalSymbol();
        this.groupingSymbol = ClientSettings.getInstance().getResources().getGroupingSymbol();
        this.currencySymbolOnLeft = ClientSettings.CURRENCY_SYMBOL_ON_LEFT;
        this.currencyBox.setColumns(columns);
        this.currencyBox.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.currencyBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        StringBuffer s = new StringBuffer(this.currencyBox.getColumns());
        int i = 0;
        while (i < this.currencyBox.getColumns()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.currencyBox.getFontMetrics(this.currencyBox.getFont()).stringWidth(s.toString()), this.currencyBox.getPreferredSize().height));
        this.setFormat();
        this.addKeyListener();
        this.addFocusListener();
        this.initListeners();
        this.setGrouping(true);
    }

    public CurrencyControl() {
        this(10);
    }

    public final void addActionListener(ActionListener listener) {
        try {
            this.currencyBox.addActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            this.currencyBox.addFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addFocusListener() {
        this.currencyBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (CurrencyControl.this.currencyBox.isEnabled() && CurrencyControl.this.currencyBox.isEditable()) {
                    try {
                        Number number = CurrencyControl.this.format.parse(CurrencyControl.this.currencyBox.getText());
                        if (number != null) {
                            if (number.doubleValue() > CurrencyControl.this.maxValue) {
                                CurrencyControl.this.setText(String.valueOf(CurrencyControl.this.maxValue));
                                number = new BigDecimal(CurrencyControl.this.maxValue);
                            } else if (number.doubleValue() < CurrencyControl.this.minValue) {
                                CurrencyControl.this.setText(String.valueOf(CurrencyControl.this.minValue));
                                number = new BigDecimal(CurrencyControl.this.minValue);
                            } else {
                                CurrencyControl.this.setText(String.valueOf(number));
                            }
                            BigDecimal d = new BigDecimal(number.doubleValue());
                            d = d.setScale(CurrencyControl.this.decimals, 4);
                            CurrencyControl.this.setText(d.toString());
                        }
                    }
                    catch (ParseException ex) {
                        CurrencyControl.this.setText(CurrencyControl.this.nullValue);
                    }
                    if (CurrencyControl.this.currencyBox.getText().length() > CurrencyControl.this.maxCharacters) {
                        CurrencyControl.this.setText(CurrencyControl.this.currencyBox.getText().substring(0, CurrencyControl.this.maxCharacters));
                    }
                }
            }
        });
    }

    public final void addKeyListener(KeyListener listener) {
        try {
            this.currencyBox.addKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addKeyListener() {
        this.currencyBox.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block9: {
                    block8: {
                        if (e.getKeyCode() == 127) {
                            if (CurrencyControl.this.currencySymbolOnLeft && CurrencyControl.this.currencyBox.getCaretPosition() < CurrencyControl.this.nullValue.length()) {
                                e.consume();
                                return;
                            }
                            if (!CurrencyControl.this.currencySymbolOnLeft && CurrencyControl.this.currencyBox.getCaretPosition() > CurrencyControl.this.currencyBox.getText().length() - CurrencyControl.this.nullValue.length()) {
                                e.consume();
                                return;
                            }
                        }
                        if (e.getKeyCode() == 37 && CurrencyControl.this.currencySymbolOnLeft && CurrencyControl.this.currencyBox.getCaretPosition() <= CurrencyControl.this.nullValue.length()) {
                            e.consume();
                            return;
                        }
                        if (e.getKeyCode() == 39 && !CurrencyControl.this.currencySymbolOnLeft && CurrencyControl.this.currencyBox.getCaretPosition() >= CurrencyControl.this.currencyBox.getText().length() - CurrencyControl.this.nullValue.length()) {
                            e.consume();
                            return;
                        }
                        if (e.getKeyCode() == 10) break block8;
                        if (e.getKeyCode() == 9) break block8;
                        if (e.getKeyCode() == 127) break block8;
                        if (e.getKeyCode() == 8) break block8;
                        if (e.getKeyCode() == 37) break block8;
                        if (e.getKeyCode() != 39) break block9;
                    }
                    return;
                }
                e.consume();
            }

            public final void keyReleased(KeyEvent e) {
                e.consume();
            }

            public final void keyTyped(KeyEvent e) {
                if (CurrencyControl.this.getText() == null || CurrencyControl.this.getText().length() == 0) {
                    CurrencyControl.this.setText(CurrencyControl.this.nullValue);
                }
                if (e.getKeyChar() == ClientSettings.getInstance().getResources().getDecimalSymbol() && CurrencyControl.this.decimals > 0 && CurrencyControl.this.currencyBox.getText() != null && CurrencyControl.this.currencyBox.getText().indexOf(ClientSettings.getInstance().getResources().getDecimalSymbol()) != -1) {
                    e.consume();
                    return;
                }
                if (e.getKeyChar() == ClientSettings.getInstance().getResources().getDecimalSymbol() && CurrencyControl.this.decimals > 0) {
                    return;
                }
                if (e.getKeyChar() == ClientSettings.getInstance().getResources().getGroupingSymbol() && CurrencyControl.this.grouping) {
                    return;
                }
                if (e.getKeyChar() == '\b') {
                    if (CurrencyControl.this.currencySymbolOnLeft && CurrencyControl.this.currencyBox.getCaretPosition() <= CurrencyControl.this.nullValue.length()) {
                        e.consume();
                    } else if (!CurrencyControl.this.currencySymbolOnLeft && CurrencyControl.this.currencyBox.getCaretPosition() > CurrencyControl.this.currencyBox.getText().length() - CurrencyControl.this.nullValue.length()) {
                        e.consume();
                    }
                    return;
                }
                if (e.getKeyChar() == '-' && CurrencyControl.this.minValue < 0.0 && CurrencyControl.this.currencyBox.getCaretPosition() == 0 && CurrencyControl.this.currencyBox.getText() != null && (CurrencyControl.this.currencyBox.getText().length() == 0 || CurrencyControl.this.currencyBox.getText().charAt(0) != '-')) {
                    return;
                }
                if (e.getKeyChar() < '0' || e.getKeyChar() > '9') {
                    e.consume();
                }
            }
        });
    }

    public final BigDecimal getBigDecimal() {
        if (this.currencyBox.getText().length() == 0 || this.currencyBox.getText().equals(this.nullValue)) {
            return null;
        }
        try {
            BigDecimal num = new BigDecimal(this.format.parse(this.currencyBox.getText()).doubleValue());
            num = num.setScale(this.decimals, 4);
            return num;
        }
        catch (ParseException ex) {
            Logger.error(this.getClass().getName(), "getBigDecimal", "Error while creating BigDecimal object", ex);
            return null;
        }
    }

    public JComponent getBindingComponent() {
        return this.currencyBox;
    }

    public final int getColumns() {
        return this.currencyBox.getColumns();
    }

    public final String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public final char getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public final Double getDouble() {
        if (this.currencyBox.getText().length() == 0 || this.currencyBox.getText().equals(this.nullValue)) {
            return null;
        }
        try {
            return new Double(this.format.parse(this.currencyBox.getText()).doubleValue());
        }
        catch (ParseException ex) {
            Logger.error(this.getClass().getName(), "getDouble", "Error while creating BigDecimal object", ex);
            return null;
        }
    }

    public final char getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public final String getText() {
        BigDecimal value = null;
        try {
            if (this.currencyBox.getText().length() != 0 && !this.currencyBox.getText().trim().equals(this.nullValue.trim()) && !"-".equals(this.currencyBox.getText())) {
                value = new BigDecimal(this.format.parse(this.currencyBox.getText()).doubleValue());
            }
            if ("-".equals(this.currencyBox.getText())) {
                value = new BigDecimal(0.0).negate();
            }
        }
        catch (ParseException ex) {
            Logger.error(this.getClass().getName(), "getText", "Error while creating BigDecimal object", ex);
            return null;
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value.doubleValue());
    }

    public final Object getValue() {
        return this.getBigDecimal();
    }

    public final boolean isCurrencySymbolOnLeft() {
        return this.currencySymbolOnLeft;
    }

    public final boolean isEnabled() {
        try {
            return this.currencyBox.isEditable();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isGrouping() {
        return this.grouping;
    }

    public final boolean isHideZeroDigits() {
        return this.hideZeroDigits;
    }

    public void processKeyEvent(KeyEvent e) {
        this.currencyBox.processKeyEvent(e);
    }

    public final void removeActionListener(ActionListener listener) {
        try {
            this.currencyBox.removeActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            this.currencyBox.removeFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeKeyListener(KeyListener listener) {
        try {
            this.currencyBox.removeKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void select(int selectionStart, int selectionEnd) {
        this.currencyBox.select(selectionStart, selectionEnd);
    }

    public final void setColumns(int columns) {
        this.currencyBox.setColumns(columns);
        StringBuffer s = new StringBuffer(this.currencyBox.getColumns());
        int i = 0;
        while (i < this.currencyBox.getColumns()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.currencyBox.getFontMetrics(this.currencyBox.getFont()).stringWidth(s.toString()), this.currencyBox.getPreferredSize().height));
    }

    public final void setCurrencySymbol(String currencySymbol) {
        Object val = this.getValue();
        this.currencySymbol = currencySymbol;
        if (!Beans.isDesignTime()) {
            this.setFormat();
            this.setValue(val);
        }
    }

    public final void setCurrencySymbolOnLeft(boolean currencySymbolOnLeft) {
        this.currencySymbolOnLeft = currencySymbolOnLeft;
    }

    public final void setDecimalSymbol(char decimalSymbol) {
        Object val = this.getValue();
        this.decimalSymbol = decimalSymbol;
        if (!Beans.isDesignTime()) {
            this.setFormat();
            this.setValue(val);
        }
    }

    public final void setDecimals(int decimals) {
        Object val = this.getValue();
        this.decimals = decimals;
        if (!Beans.isDesignTime()) {
            this.setFormat();
            this.setValue(val);
        }
    }

    public void setEnabled(boolean enabled) {
        this.currencyBox.setEditable(enabled);
        this.currencyBox.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (!enabled) {
            this.currencyBox.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
        }
    }

    protected void setFormat() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(this.groupingSymbol);
        dfs.setDecimalSeparator(this.decimalSymbol);
        String zero = "0";
        if (this.hideZeroDigits) {
            zero = "#";
        }
        if (!this.isGrouping() && this.getDecimals() == 0) {
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "#") : new DecimalFormat("# " + this.currencySymbol);
        } else if (this.isGrouping() && this.getDecimals() == 0) {
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "#,###", dfs) : new DecimalFormat("#,### " + this.currencySymbol, dfs);
        } else if (this.isGrouping() && this.getDecimals() > 0) {
            String dec = "";
            int i = 0;
            while (i < this.getDecimals()) {
                dec = dec + zero;
                ++i;
            }
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "#,##0." + dec, dfs) : new DecimalFormat("#,##0." + dec + " " + this.currencySymbol, dfs);
        } else if (!this.isGrouping() && this.getDecimals() > 0) {
            String dec = "";
            int i = 0;
            while (i < this.getDecimals()) {
                dec = dec + zero;
                ++i;
            }
            this.format = this.currencySymbolOnLeft ? new DecimalFormat(this.currencySymbol + " " + "0." + dec, dfs) : new DecimalFormat("0." + dec + " " + this.currencySymbol, dfs);
        }
        this.format.setGroupingUsed(this.isGrouping());
        this.nullValue = this.currencySymbolOnLeft ? this.currencySymbol + " " : " " + this.currencySymbol;
        this.setText("");
    }

    public final void setGrouping(boolean grouping) {
        this.grouping = grouping;
        this.setFormat();
    }

    public final void setGroupingSymbol(char groupingSymbol) {
        Object val = this.getValue();
        this.groupingSymbol = groupingSymbol;
        if (!Beans.isDesignTime()) {
            this.setFormat();
            this.setValue(val);
        }
    }

    public final void setHideZeroDigits(boolean hideZeroDigits) {
        this.hideZeroDigits = hideZeroDigits;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public final void setText(String text) {
        try {
            BigDecimal number = null;
            if (text != null && text.length() > 0) {
                number = new BigDecimal(text);
            }
            if (number != null) {
                this.currencyBox.setText(this.format.format(number));
            } else {
                this.currencyBox.setText(this.nullValue);
            }
        }
        catch (Exception ex) {
            this.currencyBox.setText(this.nullValue);
        }
    }

    public final void setValue(Object value) {
        try {
            if (value == null) {
                this.currencyBox.setText(this.nullValue);
            } else {
                this.currencyBox.setText(this.format.format(value));
            }
        }
        catch (Exception ex) {
            this.currencyBox.setText(this.nullValue);
        }
    }

    class CurrencyBox
    extends JTextField {
        public CurrencyBox() {
            this.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ CurrencyBox this$1;
                {
                    this.this$1 = this$1;
                }

                static /* synthetic */ CurrencyBox access$1000(3 x0) {
                    return x0.this$1;
                }

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    BigDecimal n;
                    if (!CurrencyControl.access$400(CurrencyBox.access$900(this.this$1)) && this.this$1.getCaretPosition() >= this.this$1.getText().length() - CurrencyControl.access$000(CurrencyBox.access$900(this.this$1)).length()) {
                        try {
                            n = new BigDecimal(this.this$1.getText().substring(0, this.this$1.getText().length() - CurrencyControl.access$000(CurrencyBox.access$900(this.this$1)).length()));
                            SwingUtilities.invokeLater(new Runnable(this, n){
                                private final /* synthetic */ 3 this$2;
                                private final /* synthetic */ BigDecimal val$n;
                                {
                                    this.this$2 = this$2;
                                    this.val$n = val$n;
                                }

                                public void run() {
                                    3.access$1000(this.this$2).setText(this.val$n + CurrencyControl.access$000(CurrencyBox.access$900(3.access$1000(this.this$2))));
                                    3.access$1000(this.this$2).setCaretPosition(3.access$1000(this.this$2).getText().length() - CurrencyControl.access$000(CurrencyBox.access$900(3.access$1000(this.this$2))).length());
                                }
                            });
                        }
                        catch (Exception ex1) {
                        }
                    }
                    if (!CurrencyControl.access$400(CurrencyBox.access$900(this.this$1)) && this.this$1.getText().startsWith(CurrencyControl.access$000(CurrencyBox.access$900(this.this$1)))) {
                        try {
                            n = new BigDecimal(this.this$1.getText().substring(CurrencyControl.access$000(CurrencyBox.access$900(this.this$1)).length()));
                            SwingUtilities.invokeLater(new Runnable(this, n){
                                private final /* synthetic */ 3 this$2;
                                private final /* synthetic */ BigDecimal val$n;
                                {
                                    this.this$2 = this$2;
                                    this.val$n = val$n;
                                }

                                public void run() {
                                    3.access$1000(this.this$2).setText(this.val$n + CurrencyControl.access$000(CurrencyBox.access$900(3.access$1000(this.this$2))));
                                    3.access$1000(this.this$2).setCaretPosition(3.access$1000(this.this$2).getText().length() - CurrencyControl.access$000(CurrencyBox.access$900(3.access$1000(this.this$2))).length());
                                }
                            });
                        }
                        catch (Exception ex1) {
                        }
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                }
            });
        }

        static /* synthetic */ CurrencyControl access$900(CurrencyBox x0) {
            return x0.CurrencyControl.this;
        }

        public String getText() {
            String t = super.getText();
            if (t != null && !CurrencyControl.this.currencySymbolOnLeft && t.indexOf(" ") > 0) {
                t = t.substring(0, t.indexOf(" ")) + CurrencyControl.this.nullValue;
            }
            return t;
        }

        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        public void setCaretPosition(int pos) {
            if (CurrencyControl.this.currencySymbolOnLeft && pos < CurrencyControl.this.nullValue.length()) {
                super.setCaretPosition(CurrencyControl.this.nullValue.length());
            } else if (!CurrencyControl.this.currencySymbolOnLeft && pos >= this.getText().length() - CurrencyControl.this.nullValue.length()) {
                super.setCaretPosition(this.getText().length() - CurrencyControl.this.nullValue.length());
            } else {
                super.setCaretPosition(pos);
            }
        }
    }
}

