/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.DateChangedListener;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class DateControl
extends BaseInputControl
implements KeyListener,
FocusListener,
InputControl {
    private JDateChooser calendar;
    private Calendar currentDate = null;
    private DateBox date;
    private int dateFormat;
    private ArrayList dateListeners;
    private int dateType;
    private Calendar defaultDate = null;
    private boolean eventFiredByCalendar = false;
    private Date lowerLimit = null;
    private SimpleDateFormat sdf = null;
    private char separator = (char)47;
    private boolean showCentury = true;
    private String timeFormat = null;
    private Date upperLimit = null;

    public DateControl(int dateType, int dateFormat, char dateFormatSeparator, boolean showCenturyInDateFormat, String timeFormat) {
        this.date = new DateBox(8);
        this.dateListeners = new ArrayList();
        this.calendar = new JDateChooser((IDateEditor)this.date);
        this.init(dateType, dateFormat, dateFormatSeparator, showCenturyInDateFormat, timeFormat);
    }

    public DateControl() {
        this.date = new DateBox(8);
        this.dateListeners = new ArrayList();
        this.calendar = new JDateChooser((IDateEditor)this.date);
        try {
            this.init(1, ClientSettings.getInstance().getResources().getDateFormat(), ClientSettings.getInstance().getResources().getDateFormatSeparator(), ClientSettings.getInstance().getResources().isShowCenturyInDateFormat(), "HH:mm");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public final void addActionListener(ActionListener listener) {
        try {
            this.date.addActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void addDateChangedListener(DateChangedListener listener) {
        this.dateListeners.add(listener);
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            this.date.addFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void addKeyListener(KeyListener listener) {
        try {
            this.date.addKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private String buildText() {
        String voidYear = "  ";
        if (this.showCentury) {
            voidYear = voidYear + "  ";
        }
        if (this.currentDate == null) {
            String value = null;
            switch (this.dateFormat) {
                case 0: {
                    value = voidYear + this.separator + "  " + this.separator + "  ";
                    break;
                }
                case 1: {
                    value = "  " + this.separator + "  " + this.separator + voidYear;
                    break;
                }
                case 2: {
                    value = "  " + this.separator + "  " + this.separator + voidYear;
                    break;
                }
                case 3: {
                    value = voidYear + this.separator + "  " + this.separator + "  ";
                }
            }
            if (this.dateType == 2) {
                value = this.timeFormat == "HH:mm" ? value + "   :  " : (this.timeFormat == "h:mm aaa" ? value + "   :     " : (this.timeFormat == "HH:mm:ss" ? value + "   :  :  " : value + "   :  :     "));
            } else if (this.dateType == 3) {
                value = this.timeFormat == "HH:mm" ? "  :  " : (this.timeFormat == "h:mm aaa" ? "  :     " : (this.timeFormat == "HH:mm:ss" ? value + "  :  :  " : value + "  :  :     "));
            }
            return value;
        }
        return this.sdf.format(this.currentDate.getTime());
    }

    public final void finalize() {
        try {
            ClientUtils.disposeComponents(this.getComponents());
            if (this.calendar != null) {
                this.calendar.getDateEditor().removePropertyChangeListener((PropertyChangeListener)this.calendar);
                this.calendar.getJCalendar().getDayChooser().removePropertyChangeListener((PropertyChangeListener)this.calendar);
                this.calendar.cleanup();
            }
            this.date = null;
            this.dateListeners = null;
            this.calendar = null;
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.currentDate == null) {
            this.refresh();
        }
        this.date.setCaretPosition(0);
    }

    public void focusLost(FocusEvent e) {
        Calendar oldCurrentDate = this.currentDate;
        try {
            String text = this.date.getText();
            if (this.dateType == 2 && text.endsWith("  :  ") && this.timeFormat.equals("HH:mm")) {
                text = text.substring(0, 9 + (this.showCentury ? 2 : 0)) + "00:00";
            } else if (this.dateType == 2 && text.endsWith("  :  ") && this.timeFormat.equals("h:mm aaa")) {
                text = text.substring(0, 9 + (this.showCentury ? 2 : 0)) + "00:00 AM";
            } else if (this.dateType == 2 && text.endsWith("  :  :  ") && this.timeFormat.equals("HH:mm:ss")) {
                text = text.substring(0, 9 + (this.showCentury ? 2 : 0)) + "00:00:00";
            } else if (this.dateType == 2 && text.endsWith("  :  :  ") && this.timeFormat.equals("h:mm:ss aaa")) {
                text = text.substring(0, 9 + (this.showCentury ? 2 : 0)) + "00:00:00 AM";
            }
            boolean isNull = true;
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) != ' ' && text.charAt(i) != ':' && text.charAt(i) != this.separator) {
                    isNull = false;
                    break;
                }
                ++i;
            }
            if (!isNull) {
                this.setDate(this.sdf.parse(text));
            } else {
                this.setDate(null);
            }
        }
        catch (Exception ex) {
            this.currentDate = oldCurrentDate;
        }
        if (this.currentDate == null) {
            this.date.setText("");
        }
    }

    public JComponent getBindingComponent() {
        return this.date;
    }

    public final Date getDate() {
        if (this.currentDate == null) {
            return null;
        }
        if (this.dateType == 1) {
            this.currentDate.set(10, 0);
            this.currentDate.set(12, 0);
            this.currentDate.set(13, 0);
            this.currentDate.set(14, 0);
        }
        return this.currentDate.getTime();
    }

    public final JTextField getDateField() {
        return this.date;
    }

    public final int getDateType() {
        return this.dateType;
    }

    public final Calendar getDefaultDate() {
        return this.defaultDate;
    }

    public final int getFormat() {
        return this.dateFormat;
    }

    public final Date getLowerLimit() {
        return this.lowerLimit;
    }

    public final char getSeparator() {
        return this.separator;
    }

    public final String getTimeFormat() {
        return this.timeFormat;
    }

    public final Date getUpperLimit() {
        return this.upperLimit;
    }

    public Object getValue() {
        return this.getDate();
    }

    private void init(int dateType, int dateFormat, char dateFormatSeparator, boolean showCenturyInDateFormat, String timeFormat) {
        try {
            this.date.setDisabledTextColor(this.date.getForeground());
            if (dateType == 2) {
                this.date.setColumns(12);
            }
            this.dateType = dateType;
            this.separator = dateFormatSeparator;
            this.showCentury = showCenturyInDateFormat;
            this.timeFormat = timeFormat;
            this.setFormat(dateFormat);
            try {
                String id;
                this.setOpaque(false);
                this.calendar.setDateFormatString(this.sdf.toPattern());
                this.calendar.setIcon(new ImageIcon(ClientUtils.getImage(ClientSettings.CALENDAR)));
                this.calendar.updateUI();
                this.calendar.getJCalendar().setDecorationBordersVisible(true);
                this.calendar.getJCalendar().getDayChooser().setDecorationBordersVisible(true);
                this.calendar.getJCalendar().getDayChooser().setDayBordersVisible(true);
                this.setLayout(new GridBagLayout());
                this.add((Component)this.calendar, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                if (Beans.isDesignTime()) {
                    return;
                }
                this.date.setEnabled(true);
                this.date.addKeyListener(this);
                this.date.addFocusListener(this);
                this.setMinimumSize(new Dimension(this.date.getFontMetrics(this.calendar.getFont()).stringWidth("0000000000"), this.date.getPreferredSize().height));
                String language = id = ClientSettings.getInstance().getResources().getLanguageId();
                String country = "";
                if (id.length() == 5) {
                    language = id.substring(0, 2);
                    country = id.substring(3);
                }
                this.calendar.setLocale(new Locale(language, country));
                this.initListeners();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public final boolean isEnabled() {
        try {
            if (this.date != null) {
                return this.date.isEditable();
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isShowCentury() {
        return this.showCentury;
    }

    public final void keyPressed(KeyEvent e) {
        e.consume();
        if (e.getKeyCode() == 27) {
            this.setDate(null);
            return;
        }
        if (e.getKeyCode() == ClientSettings.CALENDAR_CURRENT_DATE_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.CALENDAR_CURRENT_DATE_KEY.getModifiers()) {
            this.setDate(new Date());
        }
        if (e.getKeyCode() == ClientSettings.CALENDAR_OPEN_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.CALENDAR_OPEN_KEY.getModifiers()) {
            this.focusLost(null);
            if (this.currentDate == null && this.defaultDate != null) {
                this.calendar.getJCalendar().setCalendar(this.defaultDate);
            } else {
                this.calendar.setCalendar(this.currentDate);
            }
            this.calendar.actionPerformed(null);
            this.calendar.getJCalendar().requestFocus();
            this.calendar.getJCalendar().getDayChooser().requestFocus();
            this.calendar.getJCalendar().getDayChooser().setFocus();
        }
        int i = this.date.getCaretPosition();
        if (e.getKeyCode() == 37 && i > 0) {
            this.date.setCaretPosition(i - 1);
        } else if (e.getKeyCode() == 39 && i < this.date.getText().length()) {
            this.date.setCaretPosition(i + 1);
        } else if (e.getKeyCode() == 36) {
            this.date.setCaretPosition(0);
        } else if (e.getKeyCode() == 35) {
            this.date.setCaretPosition(this.date.getText().length());
        }
    }

    public final void keyReleased(KeyEvent e) {
        e.consume();
    }

    public final void keyTyped(KeyEvent e) {
        if (!this.date.isEditable()) {
            e.consume();
            return;
        }
        e.consume();
        int i = this.date.getCaretPosition();
        if (e.getKeyChar() == '\b') {
            if (this.date.getText().length() > 0 && i > 0) {
                if (this.date.getText().charAt(i - 1) != this.separator && this.date.getText().charAt(i - 1) != ':') {
                    this.setChar(i - 1, ' ');
                }
                this.date.setCaretPosition(i - 1);
            }
        } else {
            if ((this.dateType == 2 || this.dateType == 3) && this.timeFormat.equals("h:mm aaa") && this.date.getText().length() > i && (this.dateType == 2 && i > 14 + (this.showCentury ? 2 : 0) || this.dateType == 3 && i > 5)) {
                if (e.getKeyChar() == 'A' || e.getKeyChar() == 'M' || e.getKeyChar() == 'P') {
                    this.setChar(i, e.getKeyChar());
                }
                return;
            }
            if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9') {
                if (this.dateType == 1 || this.dateType == 2) {
                    int len = 0;
                    if (this.showCentury) {
                        len += 2;
                    }
                    switch (this.dateFormat) {
                        case 0: {
                            if (i < 2 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 3 + len && i <= 4 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 6 + len && i <= 7 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (this.date.getText().length() <= i) break;
                            if (this.dateType == 2 && i > 8 + len) {
                                this.setTimeDigits(i, e.getKeyChar(), 9 + len);
                                break;
                            }
                            this.date.setCaretPosition(i + 1);
                            break;
                        }
                        case 1: {
                            if (i < 2) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 3 && i <= 4) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 6 && i <= 7 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (this.date.getText().length() <= i) break;
                            if (this.dateType == 2 && i > 8 + len) {
                                this.setTimeDigits(i, e.getKeyChar(), 9 + len);
                                break;
                            }
                            this.date.setCaretPosition(i + 1);
                            break;
                        }
                        case 2: {
                            if (i < 2) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 3 && i <= 4) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 6 && i <= 7 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (this.date.getText().length() <= i) break;
                            if (this.dateType == 2 && i > 8 + len) {
                                this.setTimeDigits(i, e.getKeyChar(), 9 + len);
                                break;
                            }
                            this.date.setCaretPosition(i + 1);
                            break;
                        }
                        case 3: {
                            if (i < 2 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 3 + len && i <= 4 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (i >= 6 + len && i <= 7 + len) {
                                this.setChar(i, e.getKeyChar());
                                break;
                            }
                            if (this.date.getText().length() <= i) break;
                            if (this.dateType == 2 && i > 8 + len) {
                                this.setTimeDigits(i, e.getKeyChar(), 9 + len);
                                break;
                            }
                            this.date.setCaretPosition(i + 1);
                        }
                    }
                } else {
                    this.setTimeDigits(i, e.getKeyChar(), 0);
                }
            }
        }
    }

    private void limits() {
        if (this.upperLimit != null && this.currentDate != null && this.upperLimit.getTime() < this.currentDate.getTime().getTime()) {
            this.currentDate.setTime(this.upperLimit);
            if (this.dateType == 1) {
                this.currentDate.set(10, 0);
                this.currentDate.set(12, 0);
                this.currentDate.set(13, 0);
                this.currentDate.set(14, 0);
            }
            return;
        }
        if (this.lowerLimit != null && this.currentDate != null && this.lowerLimit.getTime() > this.currentDate.getTime().getTime()) {
            this.currentDate.setTime(this.lowerLimit);
            if (this.dateType == 1) {
                this.currentDate.set(10, 0);
                this.currentDate.set(12, 0);
                this.currentDate.set(13, 0);
                this.currentDate.set(14, 0);
            }
            return;
        }
    }

    public void processKeyEvent(KeyEvent e) {
        this.date.processKeyEvent(e);
    }

    public final void refresh() {
        this.limits();
        this.date.setText(this.buildText());
        this.repaint();
    }

    public final void removeActionListener(ActionListener listener) {
        try {
            this.date.removeActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeDateChangedListener(DateChangedListener listener) {
        this.dateListeners.remove(listener);
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            this.date.removeFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeKeyListener(KeyListener listener) {
        try {
            this.date.removeKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void requestFocus() {
        this.date.requestFocus();
    }

    private void setChar(int pos, char c) {
        StringBuffer text = new StringBuffer(this.date.getText());
        text.replace(pos, pos + 1, String.valueOf(c));
        this.date.setText(text.toString());
        this.date.setCaretPosition(pos + 1);
        if (this.date.getText().length() > this.date.getCaretPosition() && this.date.getText().charAt(this.date.getCaretPosition()) == this.separator) {
            this.date.setCaretPosition(pos + 2);
        }
    }

    public final void setDate(Date date) {
        Date oldDate = null;
        if (this.currentDate != null) {
            oldDate = (Date)this.currentDate.getTime().clone();
        }
        if (date == null) {
            this.currentDate = null;
        } else {
            this.currentDate = Calendar.getInstance();
            this.currentDate.setTime(date);
            if (this.dateType == 1) {
                this.currentDate.set(10, 0);
                this.currentDate.set(12, 0);
                this.currentDate.set(13, 0);
                this.currentDate.set(14, 0);
            }
            if (!this.eventFiredByCalendar) {
                this.calendar.setCalendar(this.currentDate);
            }
        }
        this.date.setText(this.buildText());
        int i = 0;
        while (i < this.dateListeners.size()) {
            ((DateChangedListener)this.dateListeners.get(i)).dateChanged(oldDate, this.getDate());
            ++i;
        }
    }

    public final void setDateType(int dateType) {
        this.dateType = dateType;
        if (dateType == 2) {
            this.date.setColumns(12);
        } else {
            this.date.setColumns(8);
        }
        this.setFormat(this.dateFormat);
    }

    public final void setDefaultDate(Calendar defaultDate) {
        this.defaultDate = defaultDate;
    }

    public void setEnabled(boolean enabled) {
        if (this.date == null) {
            return;
        }
        this.date.setEnabled(true);
        this.date.setEditable(enabled);
        this.calendar.setEnabled(enabled);
        this.date.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        this.calendar.setFocusable(enabled);
        if (!enabled) {
            this.getBindingComponent().setBackground((Color)UIManager.get("TextField.inactiveBackground"));
        }
    }

    public final void setFormat(int dateFormat) {
        if (dateFormat < 0 || dateFormat > 3) {
            dateFormat = 0;
        }
        this.dateFormat = dateFormat;
        String mask = ClientSettings.getInstance().getResources().getDateMask(this.dateType, dateFormat, this.separator, this.showCentury, this.timeFormat);
        this.sdf = new SimpleDateFormat(mask);
        this.date.setText(this.buildText());
    }

    public final void setLowerLimit(Date lowerLimit) {
        this.lowerLimit = lowerLimit;
        if (!this.eventFiredByCalendar) {
            this.calendar.setMinSelectableDate(lowerLimit);
        }
        if (this.currentDate != null) {
            this.refresh();
        }
    }

    public final void setSeparator(char separator) {
        if (Character.isLetterOrDigit(separator) || separator == ' ') {
            return;
        }
        this.separator = separator;
        this.setFormat(this.dateFormat);
        this.date.setText(this.buildText());
    }

    public final void setShowCentury(boolean showCentury) {
        this.showCentury = showCentury;
        this.setFormat(this.dateFormat);
    }

    private void setTimeDigits(int i, char c, int len) {
        if (i < 2 + len) {
            this.setChar(i, c);
        } else if (i >= 3 + len && i <= 4 + len) {
            this.setChar(i, c);
        } else if (i >= 6 + len && i <= 7 + len && this.timeFormat.equals("h:mm aaa")) {
            this.setChar(i, c);
        } else if (this.date.getText().length() > i) {
            this.date.setCaretPosition(i + 1);
        }
    }

    public final void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.setFormat(this.dateFormat);
    }

    public final void setUpperLimit(Date upperLimit) {
        this.upperLimit = upperLimit;
        if (!this.eventFiredByCalendar) {
            this.calendar.setMaxSelectableDate(upperLimit);
        }
        if (this.currentDate != null) {
            this.refresh();
        }
    }

    public void setValue(Object value) {
        this.setDate((Date)value);
    }

    public final void transferFocus() {
        this.date.transferFocus();
    }

    class DateBox
    extends JTextField
    implements IDateEditor {
        public DateBox(int cols) {
            super(cols);
        }

        public Date getDate() {
            Date dateToReturn = DateControl.this.getDate();
            if (dateToReturn == null && DateControl.this.defaultDate != null) {
                dateToReturn = DateControl.this.defaultDate.getTime();
            }
            return dateToReturn;
        }

        public String getDateFormatString() {
            return DateControl.this.sdf.toPattern();
        }

        public Date getMaxSelectableDate() {
            return DateControl.this.getUpperLimit();
        }

        public Date getMinSelectableDate() {
            return DateControl.this.getLowerLimit();
        }

        public JComponent getUiComponent() {
            return this;
        }

        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        public void setDate(Date date) {
            DateControl.this.eventFiredByCalendar = true;
            DateControl.this.setDate(date);
            DateControl.this.eventFiredByCalendar = false;
        }

        public void setDateFormatString(String dateFormatString) {
            if (dateFormatString != null) {
                DateControl.this.sdf = new SimpleDateFormat(dateFormatString);
            }
        }

        public void setMaxSelectableDate(Date max) {
            DateControl.this.eventFiredByCalendar = true;
            DateControl.this.setUpperLimit(max);
            DateControl.this.eventFiredByCalendar = false;
        }

        public void setMinSelectableDate(Date min) {
            DateControl.this.eventFiredByCalendar = true;
            DateControl.this.setLowerLimit(min);
            DateControl.this.eventFiredByCalendar = false;
        }

        public void setSelectableDateRange(Date min, Date max) {
            DateControl.this.eventFiredByCalendar = true;
            DateControl.this.setLowerLimit(min);
            DateControl.this.setUpperLimit(max);
            DateControl.this.eventFiredByCalendar = false;
        }
    }
}

