/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.FormatterController;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.util.client.ClientSettings;

public class FormattedTextControl
extends BaseInputControl
implements InputControl {
    private FormatterController controller;
    private FormattedTextBox textBox = new FormattedTextBox();

    public FormattedTextControl(int columns) {
        try {
            this.textBox.setColumns(columns);
            this.textBox.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.textBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.addFocusListener();
            this.initListeners();
        }
        catch (Exception ex) {
        }
    }

    public FormattedTextControl() {
        this(10);
    }

    public final void addActionListener(ActionListener listener) {
        try {
            if (this.textBox != null) {
                this.textBox.addActionListener(listener);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            if (this.textBox != null) {
                this.textBox.addFocusListener(listener);
            }
        }
        catch (Exception ex) {
        }
    }

    private void addFocusListener() {
        if (this.textBox != null) {
            this.textBox.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (FormattedTextControl.this.textBox.isEnabled() && FormattedTextControl.this.textBox.isEditable()) {
                        FormattedTextControl.this.setText(FormattedTextControl.this.textBox.getText());
                    }
                }
            });
        }
    }

    public final void commitEdit() throws ParseException {
        try {
            if (this.textBox != null) {
                this.textBox.commitEdit();
            }
        }
        catch (Exception ex) {
        }
    }

    public final Action[] getActions() {
        try {
            if (this.textBox != null) {
                return this.textBox.getActions();
            }
            return new Action[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final JComponent getBindingComponent() {
        return this.textBox;
    }

    public final int getColumns() {
        return this.textBox.getColumns();
    }

    public final FormatterController getController() {
        return this.controller;
    }

    public final int getFocusLostBehavior() {
        try {
            if (this.textBox != null) {
                return this.textBox.getFocusLostBehavior();
            }
            return 1;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public final JFormattedTextField.AbstractFormatter getFormatter() {
        try {
            if (this.textBox != null) {
                return this.textBox.getFormatter();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final JFormattedTextField.AbstractFormatterFactory getFormatterFactory() {
        try {
            if (this.textBox != null) {
                return this.textBox.getFormatterFactory();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String getText() {
        return this.textBox.getText();
    }

    public final Object getValue() {
        return this.textBox.getValue();
    }

    public final void invalidEdit() {
        try {
            if (this.textBox != null) {
                this.textBox.invalidEdit();
            }
        }
        catch (Exception ex) {
        }
    }

    public final boolean isEditValid() {
        try {
            if (this.textBox != null) {
                return this.textBox.isEditValid() || "".equals(this.textBox.getValue());
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isEnabled() {
        try {
            return this.textBox.isEditable();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void processKeyEvent(KeyEvent e) {
        try {
            if (this.textBox != null) {
                this.textBox.processKeyEvent(e);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void removeActionListener(ActionListener listener) {
        try {
            if (this.textBox != null) {
                this.textBox.removeActionListener(listener);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            if (this.textBox != null) {
                this.textBox.removeFocusListener(listener);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setColumns(int columns) {
        this.textBox.setColumns(columns);
    }

    public final void setController(FormatterController controller) {
        this.controller = controller;
    }

    public final void setDocument(Document doc) {
        try {
            if (this.textBox != null) {
                this.textBox.setDocument(doc);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setEnabled(boolean enabled) {
        if (this.textBox != null) {
            this.textBox.setEditable(enabled);
            this.textBox.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
            if (!enabled) {
                this.getBindingComponent().setBackground((Color)UIManager.get("TextField.inactiveBackground"));
            }
        }
    }

    public void setFocusLostBehavior(int behavior) {
        try {
            if (this.textBox != null) {
                this.textBox.setFocusLostBehavior(behavior);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setFormatter(JFormattedTextField.AbstractFormatter format) {
        try {
            if (this.textBox != null) {
                this.textBox.setFormatter(format);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory tf) {
        try {
            if (this.textBox != null) {
                this.textBox.setFormatterFactory(tf);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setInputVerifier(InputVerifier verifier) {
        try {
            if (this.textBox != null) {
                this.textBox.setInputVerifier(verifier);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setText(String text) {
        try {
            if (text == null) {
                text = "";
            }
            this.textBox.setText(text);
        }
        catch (Exception ex) {
        }
    }

    public final void setValue(Object value) {
        if (value == null || value != null && value instanceof String) {
            this.setText((String)value);
        } else {
            this.textBox.setValue(value);
        }
    }

    class FormattedTextBox
    extends JFormattedTextField
    implements FormatterController {
        FormattedTextBox() {
        }

        public void invalidEdit() {
            try {
                if (FormattedTextControl.this.controller == null) {
                    super.invalidEdit();
                } else {
                    FormattedTextControl.this.controller.invalidEdit();
                }
            }
            catch (Exception ex) {
            }
        }

        public void processKeyEvent(KeyEvent e) {
            try {
                super.processKeyEvent(e);
            }
            catch (Exception ex) {
            }
        }

        public void setFormatter(JFormattedTextField.AbstractFormatter format) {
            try {
                if (FormattedTextControl.this.controller == null) {
                    if (this.getFormatterFactory() == null) {
                        super.setFormatterFactory(new DefaultFormatterFactory(format));
                    } else {
                        super.setFormatter(format);
                    }
                } else {
                    FormattedTextControl.this.controller.setFormatter(format);
                }
            }
            catch (Exception ex) {
            }
        }
    }
}

