/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableColumnModel;
import org.openswing.swing.client.AttributeNameEditor;
import org.openswing.swing.client.CopyButton;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExpandableRowController;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.FilterButton;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.GenericButtonController;
import org.openswing.swing.client.ImportButton;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.form.client.FormShortcutsListener;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.GridStatusPanel;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.client.ListFilterController;
import org.openswing.swing.table.client.OrderPolicy;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.filter.client.FilterPanel;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.model.client.VOListTableModel;
import org.openswing.swing.table.permissions.java.GridPermissions;
import org.openswing.swing.table.profiles.java.GridProfile;
import org.openswing.swing.table.profiles.java.GridProfileDescription;
import org.openswing.swing.util.client.ApplicationEventQueue;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;
import org.openswing.swing.util.java.Utils;

public class GridControl
extends JPanel {
    private boolean allowColumnsSortingInEdit = false;
    private boolean allowInsertInEdit = false;
    private boolean anchorLastColumn = false;
    private boolean anchorLockedColumnsToLeft = true;
    private boolean autoLoadData = true;
    private BorderLayout borderLayout1;
    private BorderLayout borderLayout2;
    private GridController bottomGridController;
    private GridDataLocator bottomGridDataLocator = null;
    private Grids bottomTable = null;
    private ArrayList bottomTableMergedCells;
    private ArrayList buttonsNotEnabled;
    private boolean colorsInReadOnlyMode = true;
    private Column[] columnProperties = null;
    private ArrayList components;
    private GridController controller;
    private CopyButton copyButton = null;
    private boolean createInnerVO = true;
    private GridProfile defaultProfile = null;
    private int defaultQuickFilterCriteria;
    private DeleteButton deleteButton = null;
    private JScrollPane designScrollPane;
    private EditButton editButton = null;
    private boolean editOnSingleRow = false;
    private int expandableColumn = 0;
    private ExpandableRowController expandableRowController = null;
    private ExportButton exportButton = null;
    private FilterButton filterButton = null;
    private FilterPanel filterPanel = null;
    private int filterPanelOnGridPolicy;
    private FlowLayout flowLayout1;
    private String functionId = null;
    private ArrayList genericButtons;
    private GridDataLocator gridDataLocator = null;
    private String gridId = null;
    private JPanel gridStatusPanel;
    private int headerHeight;
    private ImportButton importButton = null;
    private InsertButton insertButton = null;
    private boolean insertRowsOnTop;
    private ColumnContainer itsColumnContainer = new ColumnContainer();
    private GridStatusPanel labelPanel;
    private HashMap listFilters;
    private ArrayList loadDataCompletedListeners;
    private int lockedColumns = 0;
    private int lockedRowsOnBottom = 0;
    private int lockedRowsOnTop = 0;
    private int maxNumberOfRowsOnInsert = 1;
    private int maxSortedColumns = 1;
    private ArrayList mergedCells;
    private int mode = 0;
    private NavigatorBar navBar = null;
    private OrderPolicy orderPolicy;
    private boolean orderWithLoadData = true;
    private Map otherGridParams;
    private boolean overwriteRowWhenExpanding = false;
    private JInternalFrame parentFrame = null;
    private GridPermissions permissions = null;
    private ArrayList popupCommands;
    private GridProfile profile = null;
    private JMenu profileMenu;
    private JMenu profilesMenu;
    private ReloadButton reloadButton = null;
    private boolean reorderingAllowed = true;
    private boolean resizingAllowed = true;
    private int rowHeight;
    private boolean rowHeightFixed = true;
    private int rowMargin;
    private SaveButton saveButton = null;
    public boolean searchAdditionalRows;
    private int selectionMode = 0;
    private boolean showFilterPanelOnGrid;
    public boolean showPageNumber;
    private boolean showWarnMessageBeforeReloading = true;
    private boolean singleExpandableRow = false;
    private Dimension spacing;
    private JSplitPane split;
    private Grids table = null;
    private JPanel tmpPanel;
    private GridController topGridController;
    private GridDataLocator topGridDataLocator = null;
    private Grids topTable = null;
    private ArrayList topTableMergedCells;
    private String valueObjectClassName = null;
    private boolean visibleStatusPanel = true;

    public GridControl() {
        this.designScrollPane = new JScrollPane();
        this.flowLayout1 = new FlowLayout();
        this.borderLayout1 = new BorderLayout(0, 0);
        this.controller = new GridController();
        this.labelPanel = new GridStatusPanel();
        this.gridStatusPanel = new JPanel();
        this.borderLayout2 = new BorderLayout(0, 0);
        this.otherGridParams = new HashMap();
        this.buttonsNotEnabled = new ArrayList();
        this.genericButtons = new ArrayList();
        this.components = new ArrayList();
        this.rowHeight = ClientSettings.CELL_HEIGHT;
        this.orderPolicy = new OrderPolicy();
        this.showFilterPanelOnGrid = ClientSettings.FILTER_PANEL_ON_GRID;
        this.filterPanelOnGridPolicy = ClientSettings.FILTER_PANEL_ON_GRID_POLICY;
        this.split = new JSplitPane();
        this.topGridController = new GridController();
        this.bottomGridController = new GridController();
        this.tmpPanel = new JPanel();
        this.defaultQuickFilterCriteria = ClientSettings.DEFAULT_QUICK_FILTER_CRITERIA;
        this.spacing = ClientSettings.INTERCELL_SPACING;
        this.rowMargin = ClientSettings.ROW_MARGIN;
        this.mergedCells = new ArrayList();
        this.loadDataCompletedListeners = new ArrayList();
        this.popupCommands = new ArrayList();
        this.profileMenu = new JMenu(ClientSettings.getInstance().getResources().getResource("grid profile management"));
        this.profilesMenu = new JMenu(ClientSettings.getInstance().getResources().getResource("select grid profile"));
        this.insertRowsOnTop = ClientSettings.INSERT_ROWS_ON_TOP;
        this.headerHeight = ClientSettings.HEADER_HEIGHT;
        this.topTableMergedCells = new ArrayList();
        this.bottomTableMergedCells = new ArrayList();
        this.listFilters = new HashMap();
        this.showPageNumber = ClientSettings.SHOW_PAGE_NUMBER_IN_GRID;
        this.searchAdditionalRows = ClientSettings.SEARCH_ADDITIONAL_ROWS;
        try {
            this.jbInit();
            this.setVisibleStatusPanel(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final Component add(Component comp) {
        this.itsColumnContainer.add(comp, null);
        return comp;
    }

    public final void add(Component comp, Object constraint) {
        this.itsColumnContainer.add(comp, constraint);
    }

    public final void addButtonsNotEnabled(HashSet buttons, GenericButtonController buttonController) {
        if (this.table != null) {
            this.table.addButtonsNotEnabled(buttons, buttonController);
        } else {
            this.buttonsNotEnabled.add(new Object[]{buttons, buttonController});
        }
    }

    public final void addGenericButton(GenericButton button) {
        if (button != null) {
            if (this.table == null) {
                this.genericButtons.add(button);
            } else {
                this.table.getGenericButtons().add(button);
                button.addDataController(this.table);
            }
        }
    }

    public final void addListFilter(String attributeName, ListFilterController filter) {
        this.listFilters.put(attributeName, filter);
    }

    public final void addLoadDataCompletedListener(ActionListener listener) {
        this.loadDataCompletedListeners.add(listener);
        if (this.table != null) {
            this.table.addLoadDataCompletedListener(listener);
        }
    }

    public final void addNotify() {
        super.addNotify();
        this.commitColumnContainer();
    }

    public final void addPopupCommand(String command, ActionListener listener, boolean enabled, int mnemonic, KeyStroke accelerator) {
        JMenuItem menu = new JMenuItem(ClientSettings.getInstance().getResources().getResource(command), mnemonic);
        menu.setAccelerator(accelerator);
        menu.setEnabled(enabled);
        menu.addActionListener(listener);
        this.popupCommands.add(menu);
    }

    public final void addPopupCommand(String command, ActionListener listener, boolean enabled, int mnemonic) {
        JMenuItem menu = new JMenuItem(ClientSettings.getInstance().getResources().getResource(command), mnemonic);
        menu.setEnabled(enabled);
        menu.addActionListener(listener);
        this.popupCommands.add(menu);
    }

    public final void addPopupCommand(String command, ActionListener listener, boolean enabled, Icon icon) {
        JMenuItem menu = new JMenuItem(ClientSettings.getInstance().getResources().getResource(command), icon);
        menu.setEnabled(enabled);
        menu.addActionListener(listener);
        this.popupCommands.add(menu);
    }

    public final void addPopupCommand(String command, ActionListener listener, boolean enabled) {
        JMenuItem menu = new JMenuItem(ClientSettings.getInstance().getResources().getResource(command));
        menu.setEnabled(enabled);
        menu.addActionListener(listener);
        this.popupCommands.add(menu);
    }

    public final void addPopupCommand(JMenuItem command) {
        this.popupCommands.add(command);
    }

    public final void addSortedColumn(String attributeName, String sortingVersus, boolean reloadGrid) {
        if (!sortingVersus.equals("ASC") && !sortingVersus.equals("DESC")) {
            Logger.error(this.getClass().getName(), "addSortedColumn", "Invalid sorting versus. Allowed values: Consts.ASC_SORTED,Consts.DESC_SORTED", null);
            return;
        }
        if (this.topTable != null) {
            int colIndex = this.topTable.getCurrentSortedColumns().indexOf(attributeName);
            if (colIndex != -1) {
                this.topTable.getCurrentSortedColumns().remove(colIndex);
                this.topTable.getCurrentSortedVersusColumns().remove(colIndex);
            }
            this.topTable.getCurrentSortedColumns().add(attributeName);
            this.topTable.getCurrentSortedVersusColumns().add(sortingVersus);
            this.topTable.repaint();
            if (reloadGrid) {
                this.reloadData();
            } else if (!this.orderWithLoadData && this.table != null) {
                this.table.getGrid().internalSorting();
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().internalSorting();
                }
            }
        } else if (this.table != null) {
            int colIndex = this.table.getCurrentSortedColumns().indexOf(attributeName);
            if (colIndex != -1) {
                this.table.getCurrentSortedColumns().remove(colIndex);
                this.table.getCurrentSortedVersusColumns().remove(colIndex);
            }
            this.table.getCurrentSortedColumns().add(attributeName);
            this.table.getCurrentSortedVersusColumns().add(sortingVersus);
            this.table.repaint();
            if (reloadGrid) {
                this.reloadData();
            } else if (!this.orderWithLoadData && this.table != null) {
                this.table.getGrid().internalSorting();
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().internalSorting();
                }
            }
        }
    }

    private void applyGridPermissions(String[] columnsAttribute, boolean[] columnsVisibility, boolean[] columnsEditableInIns, boolean[] columnsEditableInEdit, boolean[] columnsMandatory) throws Throwable {
        if (this.permissions == null) {
            this.permissions = (GridPermissions)ClientSettings.getInstance().getGridPermissions().get(this.functionId);
            if (this.permissions == null) {
                ClientSettings.getInstance();
                ClientSettings.getInstance();
                this.permissions = ClientSettings.GRID_PERMISSION_MANAGER.getUserGridPermissions(this.functionId, ClientSettings.GRID_PERMISSION_MANAGER.getUserRoles(), columnsAttribute, columnsVisibility, columnsEditableInIns, columnsEditableInEdit, columnsMandatory);
                if (this.permissions != null) {
                    ClientSettings.getInstance().getGridPermissions().put(this.functionId, this.permissions);
                }
            }
        }
        int i = 0;
        while (i < this.permissions.getColumnsAttribute().length) {
            this.columnProperties[i].setColumnVisible(this.permissions.getColumnsVisibility()[i]);
            if (!this.permissions.getColumnsVisibility()[i]) {
                this.columnProperties[i].setColumnSelectable(false);
            }
            this.columnProperties[i].setEditableOnInsert(this.permissions.getColumnsEditabilityInInsert()[i]);
            this.columnProperties[i].setEditableOnEdit(this.permissions.getColumnsEditabilityInEdit()[i]);
            this.columnProperties[i].setColumnRequired(this.permissions.getColumnsMandatory()[i]);
            ++i;
        }
    }

    private void applyProfile(Column[] columnProperties, GridProfile profile, boolean reloadGrid) {
        this.profile = profile;
        this.labelPanel.setProfile(profile.getDescription());
        int i = 0;
        while (i < profile.getColumnsAttribute().length) {
            if (this.permissions == null || this.permissions != null && this.permissions.getColumnsVisibility()[i]) {
                columnProperties[i].setColumnVisible(profile.getColumnsVisibility()[i]);
            }
            columnProperties[i].setPreferredWidth(profile.getColumnsWidth()[i]);
            ++i;
        }
        Grid g = null;
        if (this.table.getLockedGrid() != null) {
            g = this.table.getLockedGrid();
            g.resetColumns(profile);
        }
        g = this.table.getGrid();
        g.resetColumns(profile);
        if (this.table != null) {
            this.table.getCurrentSortedColumns().clear();
            this.table.getCurrentSortedColumns().addAll(profile.getCurrentSortedColumns());
            this.table.getCurrentSortedVersusColumns().clear();
            this.table.getCurrentSortedVersusColumns().addAll(profile.getCurrentSortedVersusColumns());
            this.table.getQuickFilterValues().clear();
            this.table.getQuickFilterValues().putAll(profile.getQuickFilterValues());
        }
        if (this.topTable != null) {
            g = this.topTable.getGrid();
            g.resetColumns(profile);
            this.topTable.getCurrentSortedColumns().clear();
            this.topTable.getCurrentSortedColumns().addAll(profile.getCurrentSortedColumns());
            this.topTable.getCurrentSortedVersusColumns().clear();
            this.topTable.getCurrentSortedVersusColumns().addAll(profile.getCurrentSortedVersusColumns());
            this.topTable.getQuickFilterValues().clear();
            this.topTable.getQuickFilterValues().putAll(profile.getQuickFilterValues());
        }
        if (this.bottomTable != null) {
            g = this.bottomTable.getGrid();
            g.resetColumns(profile);
            this.bottomTable.getCurrentSortedColumns().clear();
            this.bottomTable.getCurrentSortedColumns().addAll(profile.getCurrentSortedColumns());
            this.bottomTable.getCurrentSortedVersusColumns().clear();
            this.bottomTable.getCurrentSortedVersusColumns().addAll(profile.getCurrentSortedVersusColumns());
            this.bottomTable.getQuickFilterValues().clear();
            this.bottomTable.getQuickFilterValues().putAll(profile.getQuickFilterValues());
        }
        if (reloadGrid) {
            this.table.reload();
        }
    }

    public final void clearData() {
        if (this.table != null) {
            this.table.clearData();
        }
    }

    public final void commitColumnContainer() {
        try {
            long time = System.currentTimeMillis();
            if (Beans.isDesignTime()) {
                return;
            }
            if (this.itsColumnContainer == null) {
                return;
            }
            this.gridStatusPanel.remove(this.designScrollPane);
            Component[] c = this.components.toArray(new Component[this.components.size()]);
            this.columnProperties = new Column[c.length];
            int i = 0;
            while (i < c.length) {
                this.columnProperties[i] = (Column)c[i];
                if (this.columnProperties[i].getListFilter() != null) {
                    this.listFilters.put(this.columnProperties[i].getColumnName(), this.columnProperties[i].getListFilter());
                }
                ++i;
            }
            this.table = new Grids(this, this.lockedColumns, this.anchorLockedColumnsToLeft, this.valueObjectClassName, this.columnProperties, this.controller, this.labelPanel, this.gridDataLocator, this.otherGridParams, this.colorsInReadOnlyMode, this.popupCommands, this.anchorLastColumn, this.expandableColumn, this.singleExpandableRow, this.overwriteRowWhenExpanding, this.expandableRowController, this.listFilters, this.headerHeight, this.searchAdditionalRows, this.allowColumnsSortingInEdit, 0);
            this.table.setEditOnSingleRow(this.editOnSingleRow);
            int i2 = 0;
            while (i2 < this.columnProperties.length) {
                this.columnProperties[i2].setTable(this.table);
                ++i2;
            }
            ClientSettings.getInstance();
            if (ClientSettings.GRID_PERMISSION_MANAGER != null && this.functionId != null) {
                try {
                    String[] columnsAttribute = new String[this.columnProperties.length];
                    boolean[] columnsVisibility = new boolean[this.columnProperties.length];
                    boolean[] columnsEditableInIns = new boolean[this.columnProperties.length];
                    boolean[] columnsEditableInEdit = new boolean[this.columnProperties.length];
                    boolean[] columnsMandatory = new boolean[this.columnProperties.length];
                    int i3 = 0;
                    while (i3 < this.columnProperties.length) {
                        columnsAttribute[i3] = this.columnProperties[i3].getColumnName();
                        columnsVisibility[i3] = this.columnProperties[i3].isColumnVisible();
                        columnsEditableInIns[i3] = this.columnProperties[i3].isEditableOnInsert();
                        columnsEditableInEdit[i3] = this.columnProperties[i3].isEditableOnEdit();
                        columnsMandatory[i3] = this.columnProperties[i3].isColumnRequired();
                        ++i3;
                    }
                    String lastDigest = (String)ClientSettings.getInstance().getLastGridPermissionsDigests().get(this.functionId);
                    if (lastDigest == null) {
                        ClientSettings.getInstance();
                        lastDigest = ClientSettings.GRID_PERMISSION_MANAGER.getLastGridDigest(this.functionId);
                        if (lastDigest != null) {
                            ClientSettings.getInstance().getLastGridPermissionsDigests().put(this.functionId, lastDigest);
                        }
                    }
                    ClientSettings.getInstance();
                    String currentDigest = ClientSettings.GRID_PERMISSION_MANAGER.getCurrentGridDigest(columnsAttribute, this.functionId);
                    if (!currentDigest.equals(lastDigest)) {
                        ClientSettings.getInstance();
                        ClientSettings.GRID_PERMISSION_MANAGER.storeGridDigest(this.functionId, currentDigest);
                        ClientSettings.getInstance();
                        ClientSettings.GRID_PERMISSION_MANAGER.deleteAllGridPermissionsPerFunctionId(this.functionId);
                        ClientSettings.getInstance();
                        ClientSettings.GRID_PERMISSION_MANAGER.storeGridPermissionsDefaults(this.functionId, columnsAttribute, columnsVisibility, columnsEditableInIns, columnsEditableInEdit, columnsMandatory);
                        ClientSettings.getInstance().getLastGridPermissionsDigests().put(this.functionId, currentDigest);
                        ClientSettings.getInstance().getGridPermissions().remove(this.functionId);
                    }
                    this.applyGridPermissions(columnsAttribute, columnsVisibility, columnsEditableInIns, columnsEditableInEdit, columnsMandatory);
                }
                catch (Throwable ex) {
                    Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while fetching grid permissions:\n" + ex.getMessage(), ex);
                }
            }
            ClientSettings.getInstance();
            if (ClientSettings.GRID_PROFILE_MANAGER != null && this.functionId != null) {
                try {
                    block86: {
                        String lastDigest = (String)ClientSettings.getInstance().getLastUserGridDigests().get(this.functionId);
                        if (lastDigest == null) {
                            ClientSettings.getInstance();
                            lastDigest = ClientSettings.GRID_PROFILE_MANAGER.getLastGridDigest(this.functionId);
                            if (lastDigest != null) {
                                ClientSettings.getInstance().getLastUserGridDigests().put(this.functionId, lastDigest);
                            }
                        }
                        String[] columnNames = new String[this.columnProperties.length];
                        int i4 = 0;
                        while (i4 < this.columnProperties.length) {
                            columnNames[i4] = this.columnProperties[i4].getColumnName();
                            ++i4;
                        }
                        ClientSettings.getInstance();
                        String currentDigest = ClientSettings.GRID_PROFILE_MANAGER.getCurrentGridDigest(columnNames, this.functionId);
                        if (!currentDigest.equals(lastDigest)) {
                            ClientSettings.getInstance();
                            ClientSettings.GRID_PROFILE_MANAGER.storeGridDigest(this.functionId, currentDigest);
                            ClientSettings.getInstance();
                            ClientSettings.GRID_PROFILE_MANAGER.deleteAllGridProfiles(this.functionId);
                            ClientSettings.getInstance();
                            ClientSettings.GRID_PROFILE_MANAGER.deleteAllGridProfileIds(this.functionId);
                            ClientSettings.getInstance().getLastUserGridDigests().put(this.functionId, currentDigest);
                            ClientSettings.getInstance().getLastUserGridProfileIds().remove(this.functionId);
                            ClientSettings.getInstance().getUserGridProfiles().remove(this.functionId);
                            ClientSettings.getInstance().getGridProfileDescriptions().remove(this.functionId);
                        }
                        this.addPopupCommand(this.profileMenu);
                        this.setDefaultProfile(this.columnProperties);
                        Object id = ClientSettings.getInstance().getLastUserGridProfileIds().get(this.functionId);
                        if (id == null) {
                            ClientSettings.getInstance();
                            id = ClientSettings.GRID_PROFILE_MANAGER.getLastGridProfileId(this.functionId);
                            if (id != null) {
                                ClientSettings.getInstance().getLastUserGridProfileIds().put(this.functionId, id);
                            }
                        }
                        if (id != null) {
                            try {
                                this.profile = (GridProfile)ClientSettings.getInstance().getUserGridProfiles(this.functionId).get(id);
                                if (this.profile != null) break block86;
                                ClientSettings.getInstance();
                                this.profile = ClientSettings.GRID_PROFILE_MANAGER.getUserProfile(this.functionId, id);
                                if (this.profile != null) {
                                    ClientSettings.getInstance().getUserGridProfiles(this.functionId).put(id, this.profile);
                                }
                                break block86;
                            }
                            catch (IOException ex1) {
                                Logger.error(this.getClass().getName(), "commitColumnContainer", ex1.getMessage() + ": " + id, ex1);
                                this.profile = (GridProfile)this.defaultProfile.clone();
                                ClientSettings.getInstance();
                                id = ClientSettings.GRID_PROFILE_MANAGER.storeUserProfile(this.profile);
                                this.profile.setId(id);
                                ClientSettings.getInstance();
                                ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(this.functionId, this.profile.getId());
                                if (this.profile != null) {
                                    ClientSettings.getInstance().getUserGridProfiles(this.functionId).put(this.profile.getId(), this.profile);
                                    ClientSettings.getInstance().getLastUserGridProfileIds().put(this.functionId, this.profile.getId());
                                }
                                break block86;
                            }
                        }
                        this.profile = (GridProfile)this.defaultProfile.clone();
                        ClientSettings.getInstance();
                        id = ClientSettings.GRID_PROFILE_MANAGER.storeUserProfile(this.profile);
                        this.profile.setId(id);
                        ClientSettings.getInstance();
                        ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(this.functionId, this.profile.getId());
                        if (this.profile != null) {
                            ClientSettings.getInstance().getUserGridProfiles(this.functionId).put(this.profile.getId(), this.profile);
                            ClientSettings.getInstance().getLastUserGridProfileIds().put(this.functionId, this.profile.getId());
                            ClientSettings.getInstance().getGridProfileDescriptions(this.functionId).add(new GridProfileDescription(this.profile.getId(), this.profile.getDescription(), this.profile.isDefaultProfile()));
                        }
                    }
                    JMenuItem restoreMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("restore default grid profile"));
                    restoreMenu.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                int i = 0;
                                while (i < GridControl.this.profilesMenu.getMenuComponentCount()) {
                                    ((JCheckBoxMenuItem)GridControl.this.profilesMenu.getMenuComponent(i)).setSelected(false);
                                    ++i;
                                }
                                ClientSettings.getInstance();
                                GridControl.this.profile = ClientSettings.GRID_PROFILE_MANAGER.getDefaultProfile(GridControl.this.functionId);
                                if (GridControl.this.profile != null) {
                                    ClientSettings.getInstance();
                                    ClientSettings.GRID_PROFILE_MANAGER.deleteUserProfile(GridControl.this.functionId, GridControl.this.profile.getId());
                                    ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).remove(GridControl.this.profile.getId());
                                }
                                GridControl.this.profile = (GridProfile)GridControl.this.defaultProfile.clone();
                                ClientSettings.getInstance();
                                Object id = ClientSettings.GRID_PROFILE_MANAGER.storeUserProfile(GridControl.this.profile);
                                GridControl.this.profile.setId(id);
                                ClientSettings.getInstance();
                                ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(GridControl.this.functionId, GridControl.this.profile.getId());
                                GridControl.this.applyProfile(GridControl.this.columnProperties, GridControl.this.profile, true);
                                if (GridControl.this.profile != null) {
                                    ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).put(GridControl.this.profile.getId(), GridControl.this.profile);
                                    ClientSettings.getInstance().getLastUserGridProfileIds().put(GridControl.this.functionId, GridControl.this.profile.getId());
                                }
                            }
                            catch (Throwable ex) {
                                Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while storing grid profile: " + ex.getMessage(), ex);
                                return;
                            }
                        }
                    });
                    this.profileMenu.add(restoreMenu);
                    JMenuItem newMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("create new grid profile"));
                    newMenu.addActionListener(new ActionListener(){

                        static /* synthetic */ GridControl access$600(2 x0) {
                            return x0.GridControl.this;
                        }

                        public void actionPerformed(ActionEvent e) {
                            Object id;
                            String desc = OptionPane.showInputDialog(ClientUtils.getParentFrame(GridControl.this), "profile description", "create new grid profile", 3);
                            if (desc == null) {
                                return;
                            }
                            GridProfile profile = (GridProfile)GridControl.this.defaultProfile.clone();
                            profile.setId(null);
                            profile.setDefaultProfile(false);
                            profile.setDescription(desc);
                            try {
                                ClientSettings.getInstance();
                                id = ClientSettings.GRID_PROFILE_MANAGER.storeUserProfile(profile);
                                profile.setId(id);
                                ClientSettings.getInstance();
                                ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(GridControl.this.functionId, profile.getId());
                                GridControl.this.applyProfile(GridControl.this.columnProperties, profile, true);
                                ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).put(profile.getId(), profile);
                                ClientSettings.getInstance().getLastUserGridProfileIds().put(GridControl.this.functionId, profile.getId());
                                ClientSettings.getInstance().getGridProfileDescriptions(GridControl.this.functionId).add(new GridProfileDescription(profile.getId(), profile.getDescription(), profile.isDefaultProfile()));
                            }
                            catch (Throwable ex) {
                                Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while storing grid profile: " + ex.getMessage(), ex);
                                return;
                            }
                            id = profile.getId();
                            int i = 0;
                            while (i < GridControl.this.profilesMenu.getMenuComponentCount()) {
                                ((JCheckBoxMenuItem)GridControl.this.profilesMenu.getMenuComponent(i)).setSelected(false);
                                ++i;
                            }
                            JCheckBoxMenuItem item = new JCheckBoxMenuItem(profile.getDescription(), true);
                            item.addActionListener(new ActionListener(this, item, id){
                                private final /* synthetic */ 2 this$1;
                                private final /* synthetic */ Object val$id;
                                private final /* synthetic */ JCheckBoxMenuItem val$item;
                                {
                                    this.this$1 = this$1;
                                    this.val$item = val$item;
                                    this.val$id = val$id;
                                }

                                public void actionPerformed(ActionEvent e) {
                                    try {
                                        int i = 0;
                                        while (i < GridControl.access$000(2.access$600(this.this$1)).getMenuComponentCount()) {
                                            ((JCheckBoxMenuItem)GridControl.access$000(2.access$600(this.this$1)).getMenuComponent(i)).setSelected(false);
                                            ++i;
                                        }
                                        this.val$item.setSelected(true);
                                        GridControl.access$700(2.access$600(this.this$1), GridControl.access$400(2.access$600(this.this$1)));
                                        GridControl.access$102(2.access$600(this.this$1), (GridProfile)ClientSettings.getInstance().getUserGridProfiles(GridControl.access$200(2.access$600(this.this$1))).get(this.val$id));
                                        if (GridControl.access$100(2.access$600(this.this$1)) == null) {
                                            GridControl gridControl = 2.access$600(this.this$1);
                                            ClientSettings.getInstance();
                                            GridControl.access$102(gridControl, ClientSettings.GRID_PROFILE_MANAGER.getUserProfile(GridControl.access$200(2.access$600(this.this$1)), this.val$id));
                                            if (GridControl.access$100(2.access$600(this.this$1)) != null) {
                                                ClientSettings.getInstance().getUserGridProfiles(GridControl.access$200(2.access$600(this.this$1))).put(this.val$id, GridControl.access$100(2.access$600(this.this$1)));
                                            }
                                        }
                                        GridControl.access$500(2.access$600(this.this$1), GridControl.access$400(2.access$600(this.this$1)), GridControl.access$100(2.access$600(this.this$1)), true);
                                        ClientSettings.getInstance().getLastUserGridProfileIds().put(GridControl.access$200(2.access$600(this.this$1)), GridControl.access$100(2.access$600(this.this$1)).getId());
                                    }
                                    catch (Throwable ex) {
                                        Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while fetching grid profile: " + ex.getMessage(), ex);
                                    }
                                }
                            });
                            if (GridControl.this.profilesMenu.getComponentCount() == 0) {
                                GridControl.this.profileMenu.add(GridControl.this.profilesMenu);
                                GridControl.this.profileMenu.revalidate();
                            }
                            GridControl.this.profilesMenu.add(item);
                        }
                    });
                    this.profileMenu.add(newMenu);
                    JMenuItem removeMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("remove current grid profile"));
                    removeMenu.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                if (GridControl.this.profile.getId().equals(GridControl.this.defaultProfile.getId())) {
                                    return;
                                }
                                int i = 0;
                                while (i < GridControl.this.profilesMenu.getMenuComponentCount()) {
                                    ((JCheckBoxMenuItem)GridControl.this.profilesMenu.getMenuComponent(i)).setSelected(false);
                                    ++i;
                                }
                                String descriptionToRemove = GridControl.this.profile.getDescription();
                                ClientSettings.getInstance();
                                ClientSettings.GRID_PROFILE_MANAGER.deleteUserProfile(GridControl.this.functionId, GridControl.this.profile.getId());
                                ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).remove(GridControl.this.profile.getId());
                                ClientSettings.getInstance().getGridProfileDescriptions(GridControl.this.functionId).remove(new GridProfileDescription(GridControl.this.profile.getId(), GridControl.this.profile.getDescription(), GridControl.this.profile.isDefaultProfile()));
                                ClientSettings.getInstance();
                                GridControl.this.profile = ClientSettings.GRID_PROFILE_MANAGER.getDefaultProfile(GridControl.this.functionId);
                                if (GridControl.this.profile == null) {
                                    GridControl.this.profile = (GridProfile)GridControl.this.defaultProfile.clone();
                                    ClientSettings.getInstance();
                                    Object id = ClientSettings.GRID_PROFILE_MANAGER.storeUserProfile(GridControl.this.profile);
                                    GridControl.this.profile.setId(id);
                                    ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).put(GridControl.this.profile.getId(), GridControl.this.profile);
                                    ClientSettings.getInstance().getGridProfileDescriptions(GridControl.this.functionId).add(new GridProfileDescription(GridControl.this.profile.getId(), GridControl.this.profile.getDescription(), GridControl.this.profile.isDefaultProfile()));
                                }
                                ClientSettings.getInstance();
                                ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(GridControl.this.functionId, GridControl.this.profile.getId());
                                ClientSettings.getInstance().getLastUserGridProfileIds().put(GridControl.this.functionId, GridControl.this.profile.getId());
                                GridControl.this.applyProfile(GridControl.this.columnProperties, GridControl.this.profile, true);
                                int i2 = 0;
                                while (i2 < GridControl.this.profilesMenu.getMenuComponentCount()) {
                                    if (((JMenuItem)GridControl.this.profilesMenu.getMenuComponent(i2)).getText().equals(descriptionToRemove)) {
                                        GridControl.this.profilesMenu.remove(i2);
                                        GridControl.this.profilesMenu.revalidate();
                                        if (GridControl.this.profileMenu.getComponentCount() == 0) {
                                            GridControl.this.profileMenu.getParent().remove(GridControl.this.profileMenu);
                                        }
                                        break;
                                    }
                                    ++i2;
                                }
                            }
                            catch (Throwable ex) {
                                Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while removing grid profile: " + ex.getMessage(), ex);
                            }
                        }
                    });
                    this.profileMenu.add(removeMenu);
                    this.profileMenu.addSeparator();
                    try {
                        ArrayList list = ClientSettings.getInstance().getGridProfileDescriptions(this.functionId);
                        if (list.size() == 0) {
                            ClientSettings.getInstance();
                            list = ClientSettings.GRID_PROFILE_MANAGER.getUserProfiles(this.functionId);
                            ClientSettings.getInstance().getGridProfileDescriptions(this.functionId).addAll(list);
                        }
                        int i5 = 0;
                        while (i5 < list.size()) {
                            final GridProfileDescription desc = (GridProfileDescription)list.get(i5);
                            if (!((GridProfileDescription)list.get(i5)).isDefaultProfile()) {
                                final JCheckBoxMenuItem item = new JCheckBoxMenuItem(desc.getDescription());
                                item.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        int i = 0;
                                        while (i < GridControl.this.profilesMenu.getMenuComponentCount()) {
                                            ((JCheckBoxMenuItem)GridControl.this.profilesMenu.getMenuComponent(i)).setSelected(false);
                                            ++i;
                                        }
                                        item.setSelected(true);
                                        Object id = desc.getId();
                                        try {
                                            GridControl.this.maybeStoreProfile(GridControl.this.columnProperties);
                                            GridControl.this.profile = (GridProfile)ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).get(id);
                                            if (GridControl.this.profile == null) {
                                                ClientSettings.getInstance();
                                                GridControl.this.profile = ClientSettings.GRID_PROFILE_MANAGER.getUserProfile(GridControl.this.functionId, id);
                                                ClientSettings.getInstance().getUserGridProfiles(GridControl.this.functionId).put(id, GridControl.this.profile);
                                            }
                                            ClientSettings.getInstance();
                                            ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(GridControl.this.functionId, id);
                                            ClientSettings.getInstance().getLastUserGridProfileIds().put(GridControl.this.functionId, id);
                                            GridControl.this.applyProfile(GridControl.this.columnProperties, GridControl.this.profile, true);
                                        }
                                        catch (Throwable ex) {
                                            Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while fetching grid profile: " + ex.getMessage(), ex);
                                        }
                                    }
                                });
                                if (this.profile.getId().equals(desc.getId())) {
                                    item.setSelected(true);
                                }
                                this.profilesMenu.add(item);
                            }
                            ++i5;
                        }
                        if (this.profilesMenu.getMenuComponentCount() > 0) {
                            this.profileMenu.add(this.profilesMenu);
                        }
                    }
                    catch (Throwable ex) {
                        Logger.error(this.getClass().getName(), "commitColumnContainer", "Error while fetching grid profiles: " + ex.getMessage(), ex);
                    }
                    this.addAncestorListener(new AncestorListener(){

                        public void ancestorAdded(AncestorEvent event) {
                        }

                        public void ancestorMoved(AncestorEvent event) {
                        }

                        public void ancestorRemoved(AncestorEvent event) {
                            GridControl.this.maybeStoreProfile(GridControl.this.columnProperties);
                        }
                    });
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    this.profile = null;
                }
            } else {
                ClientSettings.getInstance();
                if (ClientSettings.GRID_PROFILE_MANAGER != null && this.functionId == null) {
                    Logger.warn(this.getClass().getName(), "commitColumnContainer", "Grid profile not enabled because no 'functionId' property setted on GridControl");
                }
            }
            this.table.setReorderingAllowed(this.reorderingAllowed);
            this.table.setSelectionMode(this.selectionMode);
            this.table.setMaxSortedColumns(this.maxSortedColumns);
            if (this.insertButton != null) {
                this.table.setInsertButton(this.insertButton);
            }
            if (this.exportButton != null) {
                this.table.setExportButton(this.exportButton);
            }
            if (this.importButton != null) {
                this.table.setImportButton(this.importButton);
            }
            if (this.filterButton != null) {
                this.table.setFilterButton(this.filterButton);
            }
            if (this.copyButton != null) {
                this.table.setCopyButton(this.copyButton);
            }
            if (this.editButton != null) {
                this.table.setEditButton(this.editButton);
            }
            if (this.reloadButton != null) {
                this.table.setReloadButton(this.reloadButton);
            }
            if (this.deleteButton != null) {
                this.table.setDeleteButton(this.deleteButton);
            }
            if (this.saveButton != null) {
                this.table.setSaveButton(this.saveButton);
            }
            if (this.navBar != null) {
                this.table.setNavBar(this.navBar);
            }
            GenericButton button = null;
            int i6 = 0;
            while (i6 < this.genericButtons.size()) {
                button = (GenericButton)this.genericButtons.get(i6);
                this.table.getGenericButtons().add(button);
                button.addDataController(this.table);
                ++i6;
            }
            this.table.setFunctionId(this.functionId);
            Object[] policy = null;
            int i7 = 0;
            while (i7 < this.buttonsNotEnabled.size()) {
                policy = (Object[])this.buttonsNotEnabled.get(i7);
                this.table.addButtonsNotEnabled((HashSet)policy[0], (GenericButtonController)policy[1]);
                ++i7;
            }
            if (this.gridId != null) {
                this.table.enableDrag(this.gridId);
            }
            if (this.spacing != null) {
                this.table.setIntercellSpacing(this.spacing);
            }
            if (this.rowMargin != -1) {
                this.table.setRowMargin(this.rowMargin);
            }
            if (this.lockedRowsOnTop > 0) {
                this.topTable = new Grids(this, this.lockedColumns, this.anchorLockedColumnsToLeft, this.valueObjectClassName, this.columnProperties, this.topGridController, this.labelPanel, this.topGridDataLocator, this.otherGridParams, this.colorsInReadOnlyMode, new ArrayList(), this.anchorLastColumn, 0, false, false, null, this.listFilters, this.headerHeight, this.searchAdditionalRows, this.allowColumnsSortingInEdit, 1);
                this.topTable.setEditOnSingleRow(this.editOnSingleRow);
                this.topTable.setReorderingAllowed(this.reorderingAllowed);
                this.topTable.setResizingAllowed(this.resizingAllowed);
                this.topTable.setSelectionMode(this.selectionMode);
                this.topTable.setMaxSortedColumns(this.maxSortedColumns);
                this.topTable.getVOListTableModel().setMode(0);
                this.topTable.getGrid().addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (GridControl.this.parentFrame == null) {
                            GridControl.this.parentFrame = ClientUtils.getParentInternalFrame(GridControl.this);
                        }
                        if (GridControl.this.parentFrame != null && !GridControl.this.parentFrame.isSelected()) {
                            if (GridControl.this.parentFrame.getDesktopPane().getSelectedFrame() != null) {
                                GridControl.this.parentFrame.getDesktopPane().getSelectedFrame().requestFocus();
                            }
                            return;
                        }
                        GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 1));
                        GridControl.this.dropFocusFromAllForms();
                    }

                    public void focusLost(FocusEvent e) {
                        GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
                    }
                });
                if (this.lockedColumns > 0) {
                    this.topTable.getLockedGrid().addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            if (GridControl.this.parentFrame == null) {
                                GridControl.this.parentFrame = ClientUtils.getParentInternalFrame(GridControl.this);
                            }
                            if (GridControl.this.parentFrame != null && !GridControl.this.parentFrame.isSelected()) {
                                if (GridControl.this.parentFrame.getDesktopPane().getSelectedFrame() != null) {
                                    GridControl.this.parentFrame.getDesktopPane().getSelectedFrame().requestFocus();
                                }
                                return;
                            }
                            GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 1));
                            GridControl.this.dropFocusFromAllForms();
                        }

                        public void focusLost(FocusEvent e) {
                            GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
                        }
                    });
                }
                if (this.spacing != null) {
                    this.topTable.setIntercellSpacing(this.spacing);
                }
                if (this.rowMargin != -1) {
                    this.topTable.setRowMargin(this.rowMargin);
                }
            }
            if (this.lockedRowsOnBottom > 0) {
                this.bottomTable = new Grids(this, this.lockedColumns, this.anchorLockedColumnsToLeft, this.valueObjectClassName, this.columnProperties, this.bottomGridController, this.labelPanel, this.bottomGridDataLocator, this.otherGridParams, this.colorsInReadOnlyMode, new ArrayList(), this.anchorLastColumn, 0, false, false, null, new HashMap(), this.headerHeight, this.searchAdditionalRows, this.allowColumnsSortingInEdit, 2);
                this.bottomTable.setEditOnSingleRow(this.editOnSingleRow);
                this.bottomTable.setReorderingAllowed(this.reorderingAllowed);
                this.bottomTable.setResizingAllowed(this.resizingAllowed);
                this.bottomTable.setSelectionMode(this.selectionMode);
                this.bottomTable.setMaxSortedColumns(this.maxSortedColumns);
                this.bottomTable.getVOListTableModel().setMode(0);
                this.bottomTable.getGrid().addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (GridControl.this.parentFrame == null) {
                            GridControl.this.parentFrame = ClientUtils.getParentInternalFrame(GridControl.this);
                        }
                        if (GridControl.this.parentFrame != null && !GridControl.this.parentFrame.isSelected()) {
                            if (GridControl.this.parentFrame.getDesktopPane().getSelectedFrame() != null) {
                                GridControl.this.parentFrame.getDesktopPane().getSelectedFrame().requestFocus();
                            }
                            return;
                        }
                        GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 1));
                        GridControl.this.dropFocusFromAllForms();
                    }

                    public void focusLost(FocusEvent e) {
                        GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
                    }
                });
                if (this.lockedColumns > 0) {
                    this.bottomTable.getLockedGrid().addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            if (GridControl.this.parentFrame == null) {
                                GridControl.this.parentFrame = ClientUtils.getParentInternalFrame(GridControl.this);
                            }
                            if (GridControl.this.parentFrame != null && !GridControl.this.parentFrame.isSelected()) {
                                if (GridControl.this.parentFrame.getDesktopPane().getSelectedFrame() != null) {
                                    GridControl.this.parentFrame.getDesktopPane().getSelectedFrame().requestFocus();
                                }
                                return;
                            }
                            GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 1));
                            GridControl.this.dropFocusFromAllForms();
                        }

                        public void focusLost(FocusEvent e) {
                            GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
                        }
                    });
                }
                if (this.spacing != null) {
                    this.bottomTable.setIntercellSpacing(this.spacing);
                }
                if (this.rowMargin != -1) {
                    this.bottomTable.setRowMargin(this.rowMargin);
                }
            }
            this.tmpPanel.setLayout(new GridBagLayout());
            if (this.topTable != null) {
                this.tmpPanel.add((Component)this.topTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, this.lockedRowsOnTop * this.rowHeight));
            }
            this.tmpPanel.add((Component)this.table, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (this.bottomTable != null) {
                this.tmpPanel.add((Component)this.bottomTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, this.lockedRowsOnBottom * this.rowHeight));
            }
            this.table.getGrid().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (GridControl.this.parentFrame == null) {
                        GridControl.this.parentFrame = ClientUtils.getParentInternalFrame(GridControl.this);
                    }
                    if (GridControl.this.parentFrame != null && !GridControl.this.parentFrame.isSelected()) {
                        if (GridControl.this.parentFrame.getDesktopPane().getSelectedFrame() != null) {
                            GridControl.this.parentFrame.getDesktopPane().getSelectedFrame().requestFocus();
                        }
                        return;
                    }
                    if (GridControl.this.table.getCurrentNestedComponent() != null) {
                        Container cont = (Container)GridControl.this.table.getCurrentNestedComponent();
                        while (cont != null && !(cont instanceof Form) && !cont.equals(GridControl.this.table.getGrid())) {
                            cont = cont.getParent();
                        }
                        if (cont != null && cont instanceof Form) {
                            ((Form)cont).setFocusOnForm();
                            return;
                        }
                    }
                    GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 1));
                    GridControl.this.dropFocusFromAllForms();
                }

                public void focusLost(FocusEvent e) {
                    GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
                }
            });
            if (this.lockedColumns > 0) {
                this.table.getLockedGrid().addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        if (GridControl.this.parentFrame == null) {
                            GridControl.this.parentFrame = ClientUtils.getParentInternalFrame(GridControl.this);
                        }
                        if (GridControl.this.parentFrame != null && !GridControl.this.parentFrame.isSelected()) {
                            if (GridControl.this.parentFrame.getDesktopPane().getSelectedFrame() != null) {
                                GridControl.this.parentFrame.getDesktopPane().getSelectedFrame().requestFocus();
                            }
                            return;
                        }
                        GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 1));
                        GridControl.this.dropFocusFromAllForms();
                    }

                    public void focusLost(FocusEvent e) {
                        GridControl.this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
                    }
                });
            }
            this.gridStatusPanel.add((Component)this.tmpPanel, "Center");
            if (this.visibleStatusPanel) {
                this.gridStatusPanel.add((Component)this.labelPanel, "South");
            }
            if (this.showFilterPanelOnGrid) {
                this.filterPanel = new FilterPanel(this.columnProperties, this.table, this.filterPanelOnGridPolicy);
                this.split.setOrientation(1);
                this.split.setDividerSize(1);
                this.split.add((Component)this.gridStatusPanel, "left");
                this.split.add((Component)this.filterPanel, "right");
                super.add((Component)this.split, "Center");
                this.split.setDividerLocation(2048);
                this.table.getGrid().addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent e) {
                        if (GridControl.this.filterPanelOnGridPolicy == 0 || GridControl.this.filterPanelOnGridPolicy == 2 && !GridControl.this.filterPanel.isLocked() || GridControl.this.filterPanelOnGridPolicy == 3 && !GridControl.this.filterPanel.isLocked()) {
                            GridControl.this.split.setDividerLocation(GridControl.this.split.getWidth() - 10);
                        }
                    }
                });
                if (this.filterPanelOnGridPolicy == 1) {
                    this.filterPanel.getClosePanel().addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            GridControl.this.split.setDividerLocation(GridControl.this.split.getWidth() - 10);
                        }
                    });
                }
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().addMouseListener(new MouseAdapter(){

                        public void mouseEntered(MouseEvent e) {
                            GridControl.this.split.setDividerLocation(GridControl.this.split.getWidth() - 10);
                        }
                    });
                }
                this.filterPanel.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent e) {
                        if (GridControl.this.split.getDividerLocation() <= GridControl.this.split.getWidth() - (int)GridControl.this.filterPanel.getPreferredSize().getWidth() - 20) {
                            return;
                        }
                        if (!(GridControl.this.filterPanelOnGridPolicy == 2 && GridControl.this.filterPanel.isLocked() || GridControl.this.filterPanelOnGridPolicy == 3 && GridControl.this.filterPanel.isLocked())) {
                            GridControl.this.filterPanel.init();
                        }
                        if (GridControl.this.split.getLastDividerLocation() > 0 && (double)GridControl.this.split.getLastDividerLocation() < GridControl.this.filterPanel.getPreferredSize().getWidth() && GridControl.this.filterPanel.getPreferredSize().getWidth() < 300.0) {
                            GridControl.this.split.setDividerLocation(GridControl.this.split.getLastDividerLocation());
                        } else {
                            GridControl.this.split.setDividerLocation(GridControl.this.split.getWidth() - (int)GridControl.this.filterPanel.getPreferredSize().getWidth() - 20);
                        }
                    }

                    public void mouseExited(MouseEvent e) {
                        if ((GridControl.this.filterPanelOnGridPolicy == 0 || GridControl.this.filterPanelOnGridPolicy == 2 && !GridControl.this.filterPanel.isLocked() || GridControl.this.filterPanelOnGridPolicy == 3 && !GridControl.this.filterPanel.isLocked()) && (e.getX() <= 0 || e.getY() <= 0 || e.getX() >= GridControl.this.filterPanel.getWidth() || e.getY() >= GridControl.this.filterPanel.getHeight())) {
                            GridControl.this.split.setDividerLocation(GridControl.this.split.getWidth() - 10);
                        }
                    }
                });
            }
            this.gridStatusPanel.revalidate();
            this.gridStatusPanel.repaint();
            this.itsColumnContainer = null;
            this.tmpPanel.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_NO_FOCUS_BORDER, 1));
            this.table.getVOListTableModel().setMode(this.mode);
            this.table.setMaxNumberOfRowsOnInsert(this.maxNumberOfRowsOnInsert);
            this.table.setAllowInsertInEdit(this.allowInsertInEdit);
            this.table.setInsertRowsOnTop(this.insertRowsOnTop);
            if (this.mode == 0 && this.autoLoadData) {
                this.table.reload();
            }
            int i8 = 0;
            while (i8 < this.loadDataCompletedListeners.size()) {
                this.table.addLoadDataCompletedListener((ActionListener)this.loadDataCompletedListeners.get(i8));
                ++i8;
            }
            this.table.addLoadDataCompletedListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < GridControl.this.mergedCells.size()) {
                        GridControl.this.table.mergeCells((int[])((Object[])GridControl.this.mergedCells.get(i))[0], (int[])((Object[])GridControl.this.mergedCells.get(i))[1]);
                        ++i;
                    }
                }
            });
            if (this.topTable != null) {
                this.topTable.addLoadDataCompletedListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int i = 0;
                        while (i < GridControl.this.topTableMergedCells.size()) {
                            GridControl.this.topTable.mergeCells((int[])((Object[])GridControl.this.topTableMergedCells.get(i))[0], (int[])((Object[])GridControl.this.topTableMergedCells.get(i))[1]);
                            ++i;
                        }
                    }
                });
            }
            if (this.bottomTable != null) {
                this.bottomTable.addLoadDataCompletedListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int i = 0;
                        while (i < GridControl.this.bottomTableMergedCells.size()) {
                            GridControl.this.bottomTable.mergeCells((int[])((Object[])GridControl.this.bottomTableMergedCells.get(i))[0], (int[])((Object[])GridControl.this.bottomTableMergedCells.get(i))[1]);
                            ++i;
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                }
            });
            if (this.rowHeightFixed) {
                this.table.getGrid().setRowHeight(this.rowHeight);
                if (this.topTable != null) {
                    this.topTable.getGrid().setRowHeight(this.rowHeight);
                }
                if (this.bottomTable != null) {
                    this.bottomTable.getGrid().setRowHeight(this.rowHeight);
                }
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().setRowHeight(this.rowHeight);
                }
                if (this.topTable != null && this.topTable.getLockedGrid() != null) {
                    this.topTable.getLockedGrid().setRowHeight(this.rowHeight);
                }
                if (this.bottomTable != null && this.bottomTable.getLockedGrid() != null) {
                    this.bottomTable.getLockedGrid().setRowHeight(this.rowHeight);
                }
            } else {
                this.table.getGrid().setRowHeightFixed(false);
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().setRowHeightFixed(false);
                }
                if (this.topTable != null) {
                    this.topTable.getGrid().setRowHeightFixed(false);
                    if (this.topTable.getLockedGrid() != null) {
                        this.topTable.getLockedGrid().setRowHeightFixed(false);
                    }
                }
                if (this.bottomTable != null) {
                    this.bottomTable.getGrid().setRowHeightFixed(false);
                    if (this.bottomTable.getLockedGrid() != null) {
                        this.bottomTable.getLockedGrid().setRowHeightFixed(false);
                    }
                }
            }
            this.table.getGrid().setOrderWithLoadData(this.orderWithLoadData, this.orderPolicy);
            if (this.table.getLockedGrid() != null) {
                this.table.getLockedGrid().setOrderWithLoadData(this.orderWithLoadData, this.orderPolicy);
            }
            ClientSettings.getInstance();
            if (ClientSettings.GRID_PROFILE_MANAGER != null && this.functionId != null && this.profile != null) {
                this.applyProfile(this.columnProperties, this.profile, false);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void dropFocusFromAllForms() {
        try {
            KeyListener[] ll = ApplicationEventQueue.getInstance().getKeyListeners();
            int i = 0;
            while (i < ll.length) {
                if (ll[i] instanceof FormShortcutsListener) {
                    ((FormShortcutsListener)ll[i]).getForm().dropFocusFromForm();
                }
                ++i;
            }
        }
        catch (Exception ex1) {
        }
    }

    private void editCellAt(final int row, final int colIndex) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GridControl.this.setRowSelectionInterval(row, row);
                GridControl.this.table.getGrid().editCellAt(row, colIndex);
            }
        });
    }

    public final void editCellAt(int row, String attributeName) {
        try {
            if (this.getMode() == 0) {
                return;
            }
            int colIndex = this.table.getVOListTableModel().findColumn(attributeName);
            if (colIndex == -1) {
                Logger.error(this.getClass().getName(), "editCellAt", "The specified attribute '" + attributeName + "' does not exist.", null);
            } else {
                colIndex = this.table.getGrid().convertColumnIndexToView(colIndex);
                if (colIndex == -1) {
                    if (this.table.getLockedGrid() != null) {
                        colIndex = this.table.getLockedGrid().convertColumnIndexToView(colIndex);
                        if (colIndex != -1) {
                            this.editCellAt(row, colIndex);
                        } else {
                            Logger.error(this.getClass().getName(), "editCellAt", "The specified attribute '" + attributeName + "' has not a visible column associated.", null);
                        }
                    } else {
                        Logger.error(this.getClass().getName(), "editCellAt", "The specified attribute '" + attributeName + "' has not a visible column associated.", null);
                    }
                } else {
                    this.editCellAt(row, colIndex);
                }
            }
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "editCellAt", "Error while setting cell editing", ex);
        }
    }

    public final void enableDrag(String gridId) {
        if (this.table != null) {
            this.table.enableDrag(gridId);
        } else {
            this.gridId = gridId;
        }
    }

    public final void finalize() {
        try {
            if (this.table == null) {
                return;
            }
            ClientSettings.getInstance();
            if (ClientSettings.GRID_PROFILE_MANAGER != null && this.functionId != null) {
                this.maybeStoreProfile(this.columnProperties);
            }
            this.table.finalize();
            this.table = null;
            if (this.topTable != null) {
                this.topTable.finalize();
            }
            this.topTable = null;
            if (this.bottomTable != null) {
                this.bottomTable.finalize();
            }
            this.bottomTable = null;
            FocusListener[] fl = this.getFocusListeners();
            int i = 0;
            while (i < fl.length) {
                this.removeFocusListener(fl[i]);
                ++i;
            }
            MouseListener[] ml = this.getMouseListeners();
            int i2 = 0;
            while (i2 < ml.length) {
                this.removeMouseListener(ml[i2]);
                ++i2;
            }
            KeyListener[] ll = this.getKeyListeners();
            int i3 = 0;
            while (i3 < ll.length) {
                this.removeKeyListener(ll[i3]);
                ++i3;
            }
            this.controller = null;
            this.gridDataLocator = null;
            if (this.getParent() != null) {
                this.getParent().remove(this);
            }
            if (this.itsColumnContainer != null) {
                ClientUtils.disposeComponents(this.itsColumnContainer.getComponents());
            }
            ClientUtils.disposeComponents(this.getComponents());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.insertButton = null;
        this.exportButton = null;
        this.importButton = null;
        this.filterButton = null;
        this.copyButton = null;
        this.editButton = null;
        this.reloadButton = null;
        this.deleteButton = null;
        this.saveButton = null;
        this.navBar = null;
        this.buttonsNotEnabled = null;
        this.genericButtons = null;
        this.components = null;
        this.filterPanel = null;
        this.topGridController = null;
        this.bottomGridController = null;
        this.topGridDataLocator = null;
        this.bottomGridDataLocator = null;
        this.tmpPanel = null;
        this.mergedCells = null;
        this.topTableMergedCells = null;
        this.bottomTableMergedCells = null;
        this.loadDataCompletedListeners = null;
        this.popupCommands = null;
        this.profile = null;
        this.defaultProfile = null;
        this.profileMenu = null;
        this.profilesMenu = null;
        this.expandableRowController = null;
        this.itsColumnContainer = null;
    }

    public final GridController getBottomGridController() {
        return this.bottomGridController;
    }

    public final GridDataLocator getBottomGridDataLocator() {
        return this.bottomGridDataLocator;
    }

    public final Grids getBottomTable() {
        return this.bottomTable;
    }

    public final ColumnContainer getColumnContainer() {
        return this.itsColumnContainer;
    }

    public final GridController getController() {
        return this.controller;
    }

    public final CopyButton getCopyButton() {
        return this.copyButton;
    }

    public final ArrayList getCurrentSortedColumns() {
        if (this.topTable != null) {
            return this.topTable.getCurrentSortedColumns();
        }
        if (this.table != null) {
            return this.table.getCurrentSortedColumns();
        }
        return null;
    }

    public final ArrayList getCurrentSortedVersusColumns() {
        if (this.topTable != null) {
            return this.topTable.getCurrentSortedVersusColumns();
        }
        if (this.table != null) {
            return this.table.getCurrentSortedVersusColumns();
        }
        return null;
    }

    public final GridExportOptions getDefaultGridExportOptions(HashSet attributesToExport) {
        if (this.table != null) {
            return this.table.getDefaultGridExportOptions(attributesToExport);
        }
        return null;
    }

    public final GridExportOptions getDefaultGridExportOptions() {
        if (this.table != null) {
            return this.table.getDefaultGridExportOptions();
        }
        return null;
    }

    public final int getDefaultQuickFilterCriteria() {
        return this.defaultQuickFilterCriteria;
    }

    public final DeleteButton getDeleteButton() {
        return this.deleteButton;
    }

    public final EditButton getEditButton() {
        return this.editButton;
    }

    public final int getExpandableColumn() {
        return this.expandableColumn;
    }

    public final ExpandableRowController getExpandableRowController() {
        return this.expandableRowController;
    }

    public final ExportButton getExportButton() {
        return this.exportButton;
    }

    public final FilterButton getFilterButton() {
        return this.filterButton;
    }

    public final int getFilterPanelOnGridPolicy() {
        return this.filterPanelOnGridPolicy;
    }

    public final String getFunctionId() {
        return this.functionId;
    }

    public final GridDataLocator getGridDataLocator() {
        return this.gridDataLocator;
    }

    public final int getHeaderHeight() {
        return this.headerHeight;
    }

    public final ImportButton getImportButton() {
        return this.importButton;
    }

    public final InsertButton getInsertButton() {
        return this.insertButton;
    }

    public final Dimension getIntercellSpacing() {
        return this.spacing;
    }

    public LayoutManager getLayout() {
        return this.flowLayout1;
    }

    public final int getLockedColumns() {
        return this.lockedColumns;
    }

    public final int getLockedRowsOnBottom() {
        return this.lockedRowsOnBottom;
    }

    public final int getLockedRowsOnTop() {
        return this.lockedRowsOnTop;
    }

    public final int getMaxNumberOfRowsOnInsert() {
        if (this.table == null) {
            return this.maxNumberOfRowsOnInsert;
        }
        return this.table.getMaxNumberOfRowsOnInsert();
    }

    public final int getMaxSortedColumns() {
        return this.maxSortedColumns;
    }

    public final int getMode() {
        if (this.table == null) {
            return this.mode;
        }
        return this.table.getMode();
    }

    public final NavigatorBar getNavBar() {
        return this.navBar;
    }

    public final Map getOtherGridParams() {
        if (this.table != null) {
            return this.table.getOtherGridParams();
        }
        return this.otherGridParams;
    }

    public final GridProfile getProfile() {
        return this.profile;
    }

    public final Map getQuickFilterValues() {
        if (this.table == null) {
            return new HashMap();
        }
        return this.table.getQuickFilterValues();
    }

    public final ReloadButton getReloadButton() {
        return this.reloadButton;
    }

    public final int getRowHeight() {
        return this.rowHeight;
    }

    public final int getRowMargin() {
        return this.rowMargin;
    }

    public final SaveButton getSaveButton() {
        return this.saveButton;
    }

    public int getSelectedRow() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        if (this.table == null) {
            return new int[0];
        }
        return this.table.getSelectedRows();
    }

    public final int getSelectionMode() {
        return this.selectionMode;
    }

    public final int getStatusPanelHeight() {
        return this.labelPanel.getSize().height;
    }

    public final Grids getTable() {
        return this.table;
    }

    public final GridController getTopGridController() {
        return this.topGridController;
    }

    public final GridDataLocator getTopGridDataLocator() {
        return this.topGridDataLocator;
    }

    public final Grids getTopTable() {
        return this.topTable;
    }

    public final VOListTableModel getVOListTableModel() {
        if (this.table != null) {
            return this.table.getVOListTableModel();
        }
        return null;
    }

    public final String getValueObjectClassName() {
        try {
            AttributeNameEditor.setDesignVOClass(Class.forName(this.valueObjectClassName));
        }
        catch (Throwable ex) {}
        return this.valueObjectClassName;
    }

    public final boolean isAllowColumnsSortingInEdit() {
        return this.allowColumnsSortingInEdit;
    }

    public final boolean isAllowInsertInEdit() {
        if (this.table == null) {
            return this.allowInsertInEdit;
        }
        return this.table.isAllowInsertInEdit();
    }

    public boolean isAnchorLastColumn() {
        return this.anchorLastColumn;
    }

    public final boolean isAnchorLockedColumnsToLeft() {
        return this.anchorLockedColumnsToLeft;
    }

    public final boolean isAutoLoadData() {
        return this.autoLoadData;
    }

    public final boolean isButtonDisabled(GenericButton button) {
        if (this.table != null) {
            return this.table.isButtonDisabled(button);
        }
        return false;
    }

    public final boolean isColorsInReadOnlyMode() {
        return this.colorsInReadOnlyMode;
    }

    public final boolean isCreateInnerVO() {
        return this.createInnerVO;
    }

    public final boolean isEditOnSingleRow() {
        return this.editOnSingleRow;
    }

    public final boolean isFieldEditable(int rowNumber, String attributeName) {
        return this.table.isFieldEditable(rowNumber, attributeName);
    }

    public final boolean isInsertRowsOnTop() {
        if (this.table == null) {
            return this.insertRowsOnTop;
        }
        return this.table.isInsertRowsOnTop();
    }

    public final boolean isOrderWithLoadData() {
        return this.orderWithLoadData;
    }

    public final boolean isOverwriteRowWhenExpanding() {
        return this.overwriteRowWhenExpanding;
    }

    public final boolean isReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public final boolean isResizingAllowed() {
        return this.resizingAllowed;
    }

    public final boolean isRowHeightFixed() {
        return this.rowHeightFixed;
    }

    public final boolean isSearchAdditionalRows() {
        return this.searchAdditionalRows;
    }

    public final boolean isShowFilterPanelOnGrid() {
        return this.showFilterPanelOnGrid;
    }

    public final boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public final boolean isShowWarnMessageBeforeReloading() {
        return this.showWarnMessageBeforeReloading;
    }

    public final boolean isSingleExpandableRow() {
        return this.singleExpandableRow;
    }

    public final boolean isVisibleStatusPanel() {
        return this.visibleStatusPanel;
    }

    protected final void jbInit() throws Exception {
        this.gridStatusPanel.setLayout(this.borderLayout2);
        this.gridStatusPanel.add((Component)this.designScrollPane, "Center");
        this.setLayout(this.borderLayout1);
        super.add((Component)this.gridStatusPanel, "Center");
        this.designScrollPane.getViewport().add(this.itsColumnContainer);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.itsColumnContainer.setLayout(this.flowLayout1);
        try {
            this.labelPanel.setPreferredSize(new Dimension(this.getPreferredSize().width, 22));
        }
        catch (Exception ex) {
        }
    }

    private void maybeStoreProfile(Column[] columnProperties) {
        if (this.table == null) {
            return;
        }
        try {
            int i;
            TableColumnModel model;
            boolean changed = false;
            String[] attributesName = new String[this.profile.getColumnsAttribute().length];
            boolean[] visibility = new boolean[this.profile.getColumnsVisibility().length];
            int[] width = new int[this.profile.getColumnsWidth().length];
            ArrayList<String> sortedCols = new ArrayList<String>();
            ArrayList<String> sortedColVersus = new ArrayList<String>();
            HashMap filters = new HashMap();
            Grid g = this.table.getLockedGrid();
            if (g != null) {
                model = g.getColumnModel();
                i = 0;
                while (i < model.getColumnCount()) {
                    attributesName[i] = columnProperties[g.convertColumnIndexToModel(i)].getColumnName();
                    visibility[g.convertColumnIndexToModel((int)i)] = columnProperties[g.convertColumnIndexToModel(i)].isColumnVisible();
                    width[g.convertColumnIndexToModel((int)i)] = model.getColumn(i).getWidth();
                    ++i;
                }
            }
            g = this.table.getGrid();
            model = g.getColumnModel();
            i = 0;
            while (i < model.getColumnCount()) {
                attributesName[i + this.lockedColumns] = columnProperties[g.convertColumnIndexToModel(i)].getColumnName();
                visibility[g.convertColumnIndexToModel((int)i)] = columnProperties[g.convertColumnIndexToModel(i)].isColumnVisible();
                width[g.convertColumnIndexToModel((int)i)] = model.getColumn(i).getWidth();
                ++i;
            }
            int k = attributesName.length - 1;
            Hashtable<Integer, Integer> sortingVersus = new Hashtable<Integer, Integer>(columnProperties.length);
            int i2 = 0;
            while (i2 < columnProperties.length) {
                if (!columnProperties[i2].isColumnVisible()) {
                    attributesName[k--] = columnProperties[i2].getColumnName();
                }
                if (!columnProperties[i2].getSortVersus().equals("NO_SORT")) {
                    sortingVersus.put(new Integer(columnProperties[i2].getSortingOrder()), new Integer(i2));
                }
                ++i2;
            }
            Integer index = null;
            int i3 = 0;
            while (i3 < columnProperties.length) {
                index = (Integer)sortingVersus.get(new Integer(i3));
                if (index != null) {
                    sortedCols.add(columnProperties[index].getColumnName());
                    sortedColVersus.add(columnProperties[index].getSortVersus());
                }
                ++i3;
            }
            if (this.table != null) {
                filters.putAll(this.table.getQuickFilterValues());
            }
            if (this.topTable != null) {
                filters.putAll(this.topTable.getQuickFilterValues());
            }
            if (this.bottomTable != null) {
                filters.putAll(this.bottomTable.getQuickFilterValues());
            }
            if (!Utils.equals(attributesName, this.profile.getColumnsAttribute())) {
                this.profile.setColumnsAttribute(attributesName);
                changed = true;
            }
            if (!Utils.equals(visibility, this.profile.getColumnsVisibility())) {
                this.profile.setColumnsVisibility(visibility);
                changed = true;
            }
            if (!Utils.equals(width, this.profile.getColumnsWidth())) {
                this.profile.setColumnsWidth(width);
                changed = true;
            }
            if (!Utils.equals(sortedCols, this.profile.getCurrentSortedColumns())) {
                this.profile.setCurrentSortedColumns(sortedCols);
                changed = true;
            }
            if (!Utils.equals(sortedColVersus, this.profile.getCurrentSortedVersusColumns())) {
                this.profile.setCurrentSortedVersusColumns(sortedColVersus);
                changed = true;
            }
            if (!Utils.equals(filters, this.profile.getQuickFilterValues())) {
                this.profile.setQuickFilterValues(filters);
                changed = true;
            }
            if (changed) {
                ClientSettings.getInstance();
                Object id = ClientSettings.GRID_PROFILE_MANAGER.storeUserProfile(this.profile);
                this.profile.setId(id);
                ClientSettings.getInstance();
                ClientSettings.GRID_PROFILE_MANAGER.storeGridProfileId(this.functionId, this.profile.getId());
                ClientSettings.getInstance().getLastUserGridProfileIds().put(this.functionId, this.profile.getId());
            }
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "maybeStoreProfile", "Error while saving grid profile: " + ex.getMessage(), ex);
        }
    }

    public final boolean mergeCells(int[] rows, int[] columns) {
        if (this.table != null) {
            return this.table.mergeCells(rows, columns);
        }
        this.mergedCells.add(new Object[]{rows, columns});
        return true;
    }

    public final boolean mergeCellsOnBottom(int[] rows, int[] columns) {
        if (this.bottomTable != null) {
            return this.bottomTable.mergeCells(rows, columns);
        }
        this.bottomTableMergedCells.add(new Object[]{rows, columns});
        return true;
    }

    public final boolean mergeCellsOnTop(int[] rows, int[] columns) {
        if (this.topTable != null) {
            return this.topTable.mergeCells(rows, columns);
        }
        this.topTableMergedCells.add(new Object[]{rows, columns});
        return true;
    }

    public final void paint(Graphics g) {
        if (Beans.isDesignTime()) {
            if (this.getColumnContainer().getComponents().length > 0) {
                super.paint(g);
            } else {
                Component[] comps = this.itsColumnContainer.getComponents();
                ArrayList<Component> tmp = new ArrayList<Component>(Arrays.asList(comps));
                tmp.addAll(this.components);
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.GRAY);
                Column comp = null;
                int width = 0;
                boolean b = false;
                int i = 0;
                while (i < tmp.size()) {
                    comp = (Column)tmp.get(i);
                    b = true;
                    if (width < this.getWidth()) {
                        g.setColor(Color.GRAY);
                        g.drawRect(width, 0, comp.getPreferredSize().width, 19);
                        g.setColor(Color.WHITE);
                        g.drawLine(width + 1, 1, width + comp.getPreferredSize().width - 1, 1);
                        g.drawLine(width + 1, 1, width + 1, 19);
                        g.setColor(new Color(100, 100, 100));
                        g.drawLine(width + 1, 19, width + comp.getPreferredSize().width - 1, 19);
                        g.drawLine(width + comp.getPreferredSize().width - 1, 1, width + comp.getPreferredSize().width - 1, 18);
                        g.setColor(Color.BLACK);
                        g.drawString(comp.getHeaderColumnName(), width + 3, 15);
                        g.setColor(Color.WHITE);
                        g.fillRect(width + 1, 21, comp.getPreferredSize().width - 1, 18);
                    }
                    width += comp.getPreferredSize().width;
                    ++i;
                }
                if (b) {
                    g.drawRect(0, this.getHeight() - 20, this.getWidth() - 1, 19);
                    g.setColor(new Color(100, 100, 100));
                    g.drawLine(1, this.getHeight() - 19, this.getWidth() - 2, this.getHeight() - 19);
                    g.drawLine(1, this.getHeight() - 19, 1, this.getHeight() - 1);
                    g.setColor(Color.WHITE);
                    g.drawLine(1, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
                    g.drawLine(this.getWidth() - 1, this.getHeight() - 19, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        } else {
            super.paint(g);
        }
    }

    public final void reloadCurrentBlockOfData() {
        if (this.table != null) {
            this.table.reload();
        }
    }

    public final void reloadData() {
        if (this.table != null) {
            this.table.reloadDataFromStart();
        }
    }

    public final void removeComboFilter(String attributeName) {
        this.listFilters.remove(attributeName);
    }

    public final void removeGenericButton(GenericButton button) {
        if (button != null) {
            if (this.table == null) {
                this.genericButtons.remove(button);
            } else {
                this.table.getGenericButtons().remove(button);
            }
        }
    }

    public final void removeLoadDataCompletedListener(ActionListener listener) {
        this.loadDataCompletedListeners.remove(listener);
        if (this.table != null) {
            this.table.removeLoadDataCompletedListener(listener);
        }
    }

    public final void removeSortedColumn(String attributeName, boolean reloadGrid) {
        if (this.topTable != null) {
            int colIndex = this.topTable.getCurrentSortedColumns().indexOf(attributeName);
            if (colIndex == -1) {
                Logger.error(this.getClass().getName(), "removeSortedColumn", "The specified attribute name '" + attributeName + "' does not exists", null);
                return;
            }
            this.topTable.getCurrentSortedColumns().remove(colIndex);
            this.topTable.getCurrentSortedVersusColumns().remove(colIndex);
            this.topTable.repaint();
            if (reloadGrid) {
                this.reloadData();
            } else if (!this.orderWithLoadData && this.table != null) {
                this.table.getGrid().internalSorting();
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().internalSorting();
                }
            }
        } else if (this.table != null) {
            int colIndex = this.table.getCurrentSortedColumns().indexOf(attributeName);
            if (colIndex == -1) {
                Logger.error(this.getClass().getName(), "removeSortedColumn", "The specified attribute name '" + attributeName + "' does not exists", null);
                return;
            }
            this.table.getCurrentSortedColumns().remove(colIndex);
            this.table.getCurrentSortedVersusColumns().remove(colIndex);
            this.table.repaint();
            if (reloadGrid) {
                this.reloadData();
            } else if (!this.orderWithLoadData && this.table != null) {
                this.table.getGrid().internalSorting();
                if (this.table.getLockedGrid() != null) {
                    this.table.getLockedGrid().internalSorting();
                }
            }
        }
    }

    public final void renamePopupCommand(String oldCommand, String newCommand) {
        if (this.table != null) {
            ArrayList list = this.table.getPopupCommands();
            String text = ClientSettings.getInstance().getResources().getResource(oldCommand);
            JMenuItem menu = null;
            int i = 0;
            while (i < list.size()) {
                menu = (JMenuItem)list.get(i);
                if (menu.getText().equals(text)) {
                    menu.setText(ClientSettings.getInstance().getResources().getResource(newCommand));
                    return;
                }
                ++i;
            }
        }
    }

    public final void requestFocus() {
        if (this.table != null) {
            this.table.getGrid().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public final void resetButtonsState() {
        if (this.table != null) {
            this.table.resetButtonsState();
        }
    }

    public final boolean save() {
        if (this.table != null) {
            return this.table.save();
        }
        return false;
    }

    public final void setAllowColumnsSortingInEdit(boolean allowColumnsSortingInEdit) {
        this.allowColumnsSortingInEdit = allowColumnsSortingInEdit;
    }

    public final void setAllowInsertInEdit(boolean allowInsertInEdit) {
        if (this.table == null) {
            this.allowInsertInEdit = allowInsertInEdit;
        } else {
            this.table.setAllowInsertInEdit(allowInsertInEdit);
        }
    }

    public void setAnchorLastColumn(boolean anchorLastColumn) {
        this.anchorLastColumn = anchorLastColumn;
    }

    public final void setAnchorLockedColumnsToLeft(boolean anchorLockedColumnsToLeft) {
        this.anchorLockedColumnsToLeft = anchorLockedColumnsToLeft;
    }

    public final void setAutoLoadData(boolean autoLoadData) {
        this.autoLoadData = autoLoadData;
    }

    public final void setBottomGridController(GridController bottomGridController) {
        this.bottomGridController = bottomGridController;
    }

    public final void setBottomGridDataLocator(GridDataLocator bottomGridDataLocator) {
        this.bottomGridDataLocator = bottomGridDataLocator;
    }

    public final void setColorsInReadOnlyMode(boolean colorsInReadOnlyMode) {
        this.colorsInReadOnlyMode = colorsInReadOnlyMode;
        if (this.table != null) {
            this.table.setColorsInReadOnlyMode(colorsInReadOnlyMode);
        }
        if (this.topTable != null) {
            this.topTable.setColorsInReadOnlyMode(colorsInReadOnlyMode);
        }
        if (this.bottomTable != null) {
            this.bottomTable.setColorsInReadOnlyMode(colorsInReadOnlyMode);
        }
    }

    public final void setController(GridController controller) {
        this.controller = controller;
    }

    public final void setCopyButton(CopyButton copyButton) {
        if (copyButton != null) {
            copyButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Copy record (CTRL+C)"));
        }
        this.copyButton = copyButton;
        if (this.table != null) {
            this.table.setCopyButton(copyButton);
        }
    }

    public final void setCreateInnerVO(boolean createInnerVO) {
        this.createInnerVO = createInnerVO;
    }

    private void setDefaultProfile(Column[] columnProperties) {
        String[] columnsAttribute = new String[columnProperties.length];
        boolean[] columnsVisibility = new boolean[columnProperties.length];
        int[] columnsWidth = new int[columnProperties.length];
        ArrayList<String> currentSortedColumns = new ArrayList<String>();
        ArrayList<String> currentSortedVersusColumns = new ArrayList<String>();
        int[] aux = new int[columnProperties.length + 1];
        int i = 0;
        while (i < aux.length) {
            aux[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < columnProperties.length) {
            columnsAttribute[i2] = columnProperties[i2].getColumnName();
            columnsVisibility[i2] = columnProperties[i2].isColumnVisible();
            columnsWidth[i2] = columnProperties[i2].getPreferredWidth();
            if (!columnProperties[i2].getSortVersus().equals("NO_SORT")) {
                aux[columnProperties[i2].getSortingOrder()] = i2;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < aux.length) {
            if (aux[i3] >= 0) {
                currentSortedColumns.add(columnProperties[aux[i3]].getColumnName());
                currentSortedVersusColumns.add(columnProperties[aux[i3]].getSortVersus());
            }
            ++i3;
        }
        String string = ClientSettings.getInstance().getResources().getResource("default profile");
        ClientSettings.getInstance();
        this.defaultProfile = new GridProfile(string, this.functionId, ClientSettings.GRID_PROFILE_MANAGER.getUsername(), currentSortedColumns, currentSortedVersusColumns, new HashMap(), columnsAttribute, columnsVisibility, columnsWidth, true);
    }

    public final void setDefaultQuickFilterCriteria(int defaultQuickFilterCriteria) {
        this.defaultQuickFilterCriteria = defaultQuickFilterCriteria;
    }

    public final void setDeleteButton(DeleteButton deleteButton) {
        if (deleteButton != null) {
            deleteButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Delete record (CTRL+D)"));
        }
        this.deleteButton = deleteButton;
        if (this.table != null) {
            this.table.setDeleteButton(deleteButton);
        }
    }

    public final void setEditButton(EditButton editButton) {
        if (editButton != null) {
            editButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Edit record (CTRL+E)"));
        }
        this.editButton = editButton;
        if (this.table != null) {
            this.table.setEditButton(editButton);
        }
    }

    public final void setEditOnSingleRow(boolean editOnSingleRow) {
        this.editOnSingleRow = editOnSingleRow;
    }

    public final void setEnablePopupCommand(String command, boolean enabled) {
        if (this.table != null) {
            ArrayList list = this.table.getPopupCommands();
            String text = ClientSettings.getInstance().getResources().getResource(command);
            JMenuItem menu = null;
            int i = 0;
            while (i < list.size()) {
                menu = (JMenuItem)list.get(i);
                if (menu.getText().equals(text)) {
                    menu.setEnabled(enabled);
                    return;
                }
                ++i;
            }
        }
    }

    public final void setExpandableColumn(int expandableColumn) {
        this.expandableColumn = expandableColumn;
    }

    public final void setExpandableRowController(ExpandableRowController expandableRowController) {
        this.expandableRowController = expandableRowController;
    }

    public final void setExportButton(ExportButton exportButton) {
        if (exportButton != null) {
            exportButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Export record (CTRL+X)"));
        }
        this.exportButton = exportButton;
        if (this.table != null) {
            this.table.setExportButton(exportButton);
        }
    }

    public final void setFilterButton(FilterButton filterButton) {
        if (filterButton != null) {
            filterButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Filtering/Sorting data (CTRL+F)"));
        }
        this.filterButton = filterButton;
        if (this.table != null) {
            this.table.setFilterButton(filterButton);
        }
    }

    public final void setFilterPanelOnGridPolicy(int filterPanelOnGridPolicy) {
        this.filterPanelOnGridPolicy = filterPanelOnGridPolicy;
    }

    public final void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public final void setGridDataLocator(GridDataLocator gridDataLocator) {
        this.gridDataLocator = gridDataLocator;
    }

    public final void setHeaderHeight(int headerHeight) {
        if (this.table == null) {
            this.headerHeight = headerHeight;
        }
    }

    public final void setImportButton(ImportButton importButton) {
        if (importButton != null) {
            importButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Import records (CTRL+M)"));
        }
        this.importButton = importButton;
        if (this.table != null) {
            this.table.setImportButton(importButton);
        }
    }

    public final void setInsertButton(InsertButton insertButton) {
        if (insertButton != null) {
            insertButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("New record (CTRL+I)"));
        }
        this.insertButton = insertButton;
        if (this.table != null) {
            this.table.setInsertButton(insertButton);
        }
    }

    public final void setInsertRowsOnTop(boolean insertRowsOnTop) {
        if (this.table == null) {
            this.insertRowsOnTop = insertRowsOnTop;
        } else {
            this.table.setInsertRowsOnTop(insertRowsOnTop);
        }
    }

    public final void setIntercellSpacing(Dimension spacing) {
        this.spacing = spacing;
        if (this.table != null) {
            this.table.setIntercellSpacing(spacing);
        }
    }

    public final void setLockedColumns(int lockedColumns) {
        this.lockedColumns = lockedColumns;
    }

    public final void setLockedRowsOnBottom(int lockedRowsOnBottom) {
        this.lockedRowsOnBottom = lockedRowsOnBottom;
    }

    public final void setLockedRowsOnTop(int lockedRowsOnTop) {
        this.lockedRowsOnTop = lockedRowsOnTop;
    }

    public final void setMaxNumberOfRowsOnInsert(int maxNumberOfRowsOnInsert) {
        if (this.table == null) {
            this.maxNumberOfRowsOnInsert = maxNumberOfRowsOnInsert;
        } else {
            this.table.setMaxNumberOfRowsOnInsert(maxNumberOfRowsOnInsert);
        }
    }

    public final void setMaxSortedColumns(int maxSortedColumns) {
        this.maxSortedColumns = maxSortedColumns;
    }

    public final void setMode(int mode) {
        this.mode = mode;
        if (this.table != null) {
            this.table.getVOListTableModel().setMode(mode);
        }
    }

    public final void setNavBar(NavigatorBar navBar) {
        this.navBar = navBar;
        if (this.table != null) {
            this.table.setNavBar(navBar);
        }
    }

    public final void setOrderPolicy(OrderPolicy orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public final void setOrderWithLoadData(boolean orderWithLoadData) {
        this.orderWithLoadData = orderWithLoadData;
    }

    public final void setOtherGridParams(Map otherGridParams) {
        this.otherGridParams = otherGridParams;
        if (this.table != null) {
            this.table.setOtherGridParams(otherGridParams);
        }
    }

    public final void setOverwriteRowWhenExpanding(boolean overwriteRowWhenExpanding) {
        this.overwriteRowWhenExpanding = overwriteRowWhenExpanding;
    }

    public final void setReloadButton(ReloadButton reloadButton) {
        if (reloadButton != null) {
            reloadButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Reload record/Cancel current operation (CTRL+Z)"));
        }
        this.reloadButton = reloadButton;
        if (this.table != null) {
            this.table.setReloadButton(reloadButton);
        }
    }

    public final void setReorderingAllowed(boolean reorderingAllowed) {
        this.reorderingAllowed = reorderingAllowed;
    }

    public final void setResizingAllowed(boolean resizingAllowed) {
        this.resizingAllowed = resizingAllowed;
    }

    public final void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public final void setRowHeightFixed(boolean rowHeightFixed) {
        this.rowHeightFixed = rowHeightFixed;
    }

    public final void setRowMargin(int rowMargin) {
        this.rowMargin = rowMargin;
        if (this.table != null) {
            this.table.setRowMargin(rowMargin);
        }
    }

    public final void setRowSelectionInterval(int startRow, int endRow) {
        if (this.table != null) {
            this.table.setRowSelectionInterval(startRow, endRow);
        }
    }

    public final void setSaveButton(SaveButton saveButton) {
        if (saveButton != null) {
            saveButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Save record (CTRL+S)"));
        }
        this.saveButton = saveButton;
        if (this.table != null) {
            this.table.setSaveButton(saveButton);
        }
    }

    public final void setSearchAdditionalRows(boolean searchAdditionalRows) {
        this.searchAdditionalRows = searchAdditionalRows;
    }

    public final void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public final void setShowFilterPanelOnGrid(boolean showFilterPanelOnGrid) {
        this.showFilterPanelOnGrid = showFilterPanelOnGrid;
    }

    public final void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public final void setShowWarnMessageBeforeReloading(boolean showWarnMessageBeforeReloading) {
        this.showWarnMessageBeforeReloading = showWarnMessageBeforeReloading;
    }

    public final void setSingleExpandableRow(boolean singleExpandableRow) {
        this.singleExpandableRow = singleExpandableRow;
    }

    public final void setTopGridController(GridController topGridController) {
        this.topGridController = topGridController;
    }

    public final void setTopGridDataLocator(GridDataLocator topGridDataLocator) {
        this.topGridDataLocator = topGridDataLocator;
    }

    public final void setValueObjectClassName(String valueObjectClassName) {
        this.valueObjectClassName = valueObjectClassName;
        try {
            AttributeNameEditor.setDesignVOClass(Class.forName(valueObjectClassName));
        }
        catch (Throwable ex) {
        }
    }

    public final void setVisibleColumn(String attributeName, boolean visible) {
        if (this.table != null) {
            this.table.setVisibleColumn(attributeName, visible);
        }
    }

    public final void setVisibleStatusPanel(boolean visibleStatusPanel) {
        this.visibleStatusPanel = visibleStatusPanel;
        if (visibleStatusPanel) {
            this.gridStatusPanel.add((Component)this.labelPanel, "South");
        } else {
            this.gridStatusPanel.remove(this.labelPanel);
        }
    }

    public final void transferFocus() {
        try {
            if (this.table != null) {
                this.table.transferFocus();
            }
        }
        catch (Exception ex) {
        }
    }

    public class ColumnContainer
    extends JPanel {
        public final void add(Component comp, Object constraint) {
            super.add(comp, constraint);
            GridControl.this.components.add(comp);
        }

        public final Component add(Component comp) {
            super.add(comp, null);
            GridControl.this.components.add(comp);
            return comp;
        }
    }
}

