/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CheckBoxControl;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.ComboBoxVOControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.FormattedTextControl;
import org.openswing.swing.client.ImageControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.ListControl;
import org.openswing.swing.client.ListVOControl;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.client.ProgressBarControl;
import org.openswing.swing.client.RadioButtonControl;
import org.openswing.swing.client.TextAreaControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.form.model.client.ValueChangeEvent;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.util.client.ClientSettings;

public class InputControlPopupMenu
extends JPopupMenu
implements MouseListener {
    private boolean copyAndPasteEnabled = false;
    private InputControl inputControl = null;

    public InputControlPopupMenu(InputControl inputControl) {
        this.inputControl = inputControl;
        if (inputControl instanceof BaseInputControl) {
            ((BaseInputControl)inputControl).getBindingComponent().addMouseListener(this);
        } else {
            ((JComponent)((Object)inputControl)).addMouseListener(this);
        }
        this.copyAndPasteEnabled = !(inputControl instanceof CheckBoxControl) && !(inputControl instanceof RadioButtonControl) && !(inputControl instanceof ComboBoxControl) && !(inputControl instanceof ComboBoxVOControl) && !(inputControl instanceof ListControl) && !(inputControl instanceof ListVOControl) && !(inputControl instanceof ProgressBarControl) && !(inputControl instanceof ImageControl);
    }

    private boolean copyToClipboard(Object value) {
        StringSelection contents = null;
        if (value instanceof String) {
            contents = new StringSelection(value.toString());
        } else if (value instanceof Date) {
            SimpleDateFormat sdfdatetime = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(2));
            contents = new StringSelection(sdfdatetime.format((Date)value));
        } else if (value instanceof Number) {
            contents = new StringSelection(value.toString());
        }
        if (contents != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
            return true;
        }
        return false;
    }

    private void maybeFireValueChangedEvent(Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
            this.inputControl.setChanged(true);
            ValueChangeEvent e = new ValueChangeEvent(this.inputControl, this.inputControl.getAttributeName(), oldValue, newValue);
            int i = 0;
            while (i < this.inputControl.getValueChangeListeners().length) {
                this.inputControl.getValueChangeListeners()[i].valueChanged(e);
                ++i;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.showPopupMenu(e.getX(), e.getY());
        } else if (this.inputControl.isEnabled()) {
            ((JComponent)((Object)this.inputControl)).requestFocus();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public final void setVisible(boolean v) {
        super.setVisible(v);
        if (!v && this.inputControl != null && ((JComponent)((Object)this.inputControl)).isVisible()) {
            if (this.inputControl instanceof BaseInputControl && !((BaseInputControl)this.inputControl).getBindingComponent().hasFocus()) {
                ((BaseInputControl)this.inputControl).getBindingComponent().requestFocus();
            } else if (!(this.inputControl instanceof BaseInputControl) && !((JComponent)((Object)this.inputControl)).hasFocus()) {
                ((JComponent)((Object)this.inputControl)).requestFocus();
            }
        }
    }

    private void showPopupMenu(int x, int y) {
        try {
            Point tablexy = ((JComponent)((Object)this.inputControl)).getLocationOnScreen();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.removeAll();
            final Object value = this.inputControl.getValue();
            if (value != null && this.copyAndPasteEnabled) {
                JMenuItem copyMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("copy"), ClientSettings.getInstance().getResources().getResource("copymnemonic").charAt(0));
                copyMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        InputControlPopupMenu.this.copyToClipboard(value);
                    }
                });
                this.add(copyMenu);
            }
            if (this.inputControl.isEnabled() && this.copyAndPasteEnabled) {
                JMenuItem cutMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("cut"), ClientSettings.getInstance().getResources().getResource("cutmnemonic").charAt(0));
                cutMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (InputControlPopupMenu.this.copyToClipboard(value)) {
                            Object oldValue = InputControlPopupMenu.this.inputControl.getValue();
                            InputControlPopupMenu.this.inputControl.setValue(null);
                            InputControlPopupMenu.this.maybeFireValueChangedEvent(oldValue, null);
                        }
                    }
                });
                this.add(cutMenu);
                JMenuItem pasteMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("paste"), ClientSettings.getInstance().getResources().getResource("pastemnemonic").charAt(0));
                pasteMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                        if (content != null) {
                            try {
                                String data = (String)content.getTransferData(DataFlavor.stringFlavor);
                                if (data != null && !data.equals("")) {
                                    Object value = null;
                                    if (InputControlPopupMenu.this.inputControl instanceof CodLookupControl) {
                                        value = ((CodLookupControl)InputControlPopupMenu.this.inputControl).isAllowOnlyNumbers() ? new Double(data) : data;
                                    } else if (InputControlPopupMenu.this.inputControl instanceof NumericControl) {
                                        value = new Double(data);
                                    } else if (InputControlPopupMenu.this.inputControl instanceof DateControl) {
                                        SimpleDateFormat sdfdatetime = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(2));
                                        value = sdfdatetime.parse(data);
                                    } else if (InputControlPopupMenu.this.inputControl instanceof FormattedTextControl) {
                                        value = data;
                                    } else if (InputControlPopupMenu.this.inputControl instanceof TextControl) {
                                        value = data;
                                    } else if (InputControlPopupMenu.this.inputControl instanceof TextAreaControl) {
                                        int pos = ((TextAreaControl)InputControlPopupMenu.this.inputControl).getTextArea().getCaretPosition();
                                        if (pos < 0) {
                                            pos = 0;
                                        }
                                        value = ((TextAreaControl)InputControlPopupMenu.this.inputControl).getTextArea().getText();
                                        value = pos == 0 ? data + value : (pos == value.toString().length() - 1 ? value.toString().substring(0, pos) + data : value.toString().substring(0, pos) + data + value.toString().substring(pos));
                                    }
                                    if (value != null) {
                                        Object oldValue = InputControlPopupMenu.this.inputControl.getValue();
                                        InputControlPopupMenu.this.inputControl.setValue(value);
                                        InputControlPopupMenu.this.maybeFireValueChangedEvent(oldValue, value);
                                    }
                                }
                            }
                            catch (Throwable ex) {
                                System.out.println("Couldn't get contents in format: " + DataFlavor.stringFlavor.getHumanPresentableName());
                            }
                        }
                    }
                });
                this.add(pasteMenu);
            }
            if (this.getComponentCount() > 0) {
                int xOverflow = x + (int)tablexy.getX() + this.getWidth() - (int)screenSize.getWidth();
                int yOverflow = y + (int)tablexy.getY() + this.getHeight() - (int)screenSize.getHeight();
                int popupX = xOverflow > 0 ? x - xOverflow - 20 : x;
                int popupY = yOverflow > 0 ? y - yOverflow - 20 : y;
                this.show((JComponent)((Object)this.inputControl), popupX, popupY);
            }
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "showPopupMenu", "Error while constructing this menu.", ex);
            ex.printStackTrace();
        }
    }
}

