/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class LinkButton
extends JPanel {
    private boolean enabled = true;
    private Color foregroundColorWhenEntered = Color.blue;
    private Color foregroundColorWhenExited = null;
    private String label = null;
    public String labelAttributeName = null;
    private JLabel linkButton;
    private ArrayList listeners = new ArrayList();
    private boolean oldValue = true;
    private boolean showUnderline = true;
    private String toolTipText = null;
    public String tooltipAttributeName = null;
    private String uri = null;
    public String uriAttributeName = null;

    public LinkButton() {
        this.linkButton = new JLabel(){

            public final void paint(Graphics g) {
                super.paint(g);
                if (LinkButton.this.showUnderline) {
                    g.setColor(LinkButton.this.linkButton.getForeground());
                    g.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
                }
            }
        };
        this.setTextAlignment(2);
        this.linkButton.setOpaque(false);
        this.linkButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LinkButton.this.linkClicked();
            }

            public void mouseEntered(MouseEvent e) {
                if (!LinkButton.this.enabled) {
                    return;
                }
                LinkButton.this.foregroundColorWhenExited = LinkButton.this.linkButton.getForeground();
                LinkButton.this.linkButton.setForeground(LinkButton.this.foregroundColorWhenEntered);
            }

            public void mouseExited(MouseEvent e) {
                if (!LinkButton.this.enabled) {
                    return;
                }
                LinkButton.this.linkButton.setForeground(LinkButton.this.foregroundColorWhenExited);
            }
        });
        this.setLabel("text to translate");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.linkButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setEnabled(true);
    }

    public final void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public final ActionListener[] getActionListeners() {
        return this.listeners.toArray(new ActionListener[this.listeners.size()]);
    }

    public final Font getFont() {
        try {
            return this.linkButton.getFont();
        }
        catch (Exception ex) {
            return super.getFont();
        }
    }

    public final Color getForegroundColorWhenEntered() {
        return this.foregroundColorWhenEntered;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getLabelAttributeName() {
        return this.labelAttributeName;
    }

    public JLabel getLinkButton() {
        return this.linkButton;
    }

    public final boolean getOldValue() {
        return this.oldValue;
    }

    public final int getTextAlignment() {
        return this.linkButton.getHorizontalAlignment();
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public final String getTooltipAttributeName() {
        return this.tooltipAttributeName;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getUriAttributeName() {
        return this.uriAttributeName;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isShowUnderline() {
        return this.showUnderline;
    }

    public final void linkClicked() {
        if (!this.enabled) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((ActionListener)this.listeners.get(i)).actionPerformed(new ActionEvent(this, 1001, ""));
            ++i;
        }
        if (this.uri != null && !this.uri.equals("")) {
            ClientUtils.displayURL(this.uri);
        }
    }

    public final void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public final void setEnabled(boolean enabled) {
        if (this.enabled && !enabled) {
            this.foregroundColorWhenExited = this.linkButton.getForeground();
            this.linkButton.setForeground(Color.gray);
        } else if (!this.enabled && enabled) {
            this.linkButton.setForeground(this.foregroundColorWhenExited);
        }
        if (this.enabled == enabled) {
            return;
        }
        this.oldValue = this.enabled || enabled;
        this.enabled = enabled;
    }

    public final void setFont(Font font) {
        try {
            this.linkButton.setFont(font);
        }
        catch (Exception ex) {
        }
    }

    public final void setForegroundColorWhenEntered(Color foregroundColorWhenEntered) {
        this.foregroundColorWhenEntered = foregroundColorWhenEntered;
    }

    public final void setLabel(String label) {
        this.setText(label);
    }

    public final void setLabelAttributeName(String labelAttributeName) {
        this.labelAttributeName = labelAttributeName;
    }

    public final void setShowUnderline(boolean showUnderline) {
        this.showUnderline = showUnderline;
    }

    public final void setText(String label) {
        this.label = label;
        this.linkButton.setText(ClientSettings.getInstance().getResources().getResource(label));
    }

    public final void setTextAlignment(int alignment) {
        this.linkButton.setHorizontalAlignment(alignment);
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (!Beans.isDesignTime()) {
            this.linkButton.setToolTipText(ClientSettings.getInstance().getResources().getResource(toolTipText));
        }
    }

    public final void setTooltipAttributeName(String tooltipAttributeName) {
        this.tooltipAttributeName = tooltipAttributeName;
    }

    public final void setUri(String uri) {
        this.uri = uri;
    }

    public final void setUriAttributeName(String uriAttributeName) {
        this.uriAttributeName = uriAttributeName;
    }
}

