/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.MultiCodLookupControl_clearButton_actionAdapter;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class MultiCodLookupControl
extends JPanel {
    private JButton clearButton;
    private JList codesList;
    private LookupController controller = null;
    private GridBagLayout gridBagLayout1;
    private String[] lookupAttributeNames = null;
    private CodLookupControl lookupControl = new CodLookupControl();
    private DefaultListModel model;
    private JScrollPane scrollPaneList;
    private ArrayList selectedVOs = new ArrayList();
    private String sep = null;

    public MultiCodLookupControl(LookupController controller, String[] lookupAttributeNames, String sep) {
        this.clearButton = new JButton(){

            public void paint(Graphics g) {
                super.paint(g);
                int width = g.getFontMetrics().stringWidth("C");
                g.drawString("C", (this.getWidth() - width + 1) / 2, this.getHeight() / 2 + 4);
            }
        };
        this.model = new DefaultListModel();
        this.codesList = new JList(this.model);
        this.scrollPaneList = new JScrollPane();
        this.gridBagLayout1 = new GridBagLayout();
        this.lookupAttributeNames = lookupAttributeNames;
        this.sep = sep;
        try {
            this.jbInit();
            this.setController(controller);
            if (ClientSettings.TEXT_ORIENTATION != null) {
                this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MultiCodLookupControl(LookupController controller, String lookupAttributeName) {
        this(controller, new String[]{lookupAttributeName}, " - ");
    }

    public MultiCodLookupControl() {
        this(new LookupController(), new String[]{""}, " - ");
    }

    void clearButton_actionPerformed(ActionEvent e) {
        this.selectedVOs.clear();
        this.model.removeAllElements();
        this.codesList.revalidate();
        this.codesList.repaint();
    }

    public final LookupController getController() {
        return this.controller;
    }

    public final int getListHeight() {
        return this.scrollPaneList.getPreferredSize().height;
    }

    public final CodLookupControl getLookupControl() {
        return this.lookupControl;
    }

    public ArrayList getSelectedVOs() {
        return this.selectedVOs;
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.lookupControl.getTextOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.clearButton.setPreferredSize(new Dimension(20, 20));
        this.clearButton.setMnemonic('C');
        this.clearButton.setText("");
        this.clearButton.addActionListener(new MultiCodLookupControl_clearButton_actionAdapter(this));
        this.scrollPaneList.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.lookupControl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.scrollPaneList, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPaneList.getViewport().add((Component)this.codesList, null);
    }

    public final void setController(final LookupController controller) {
        this.lookupControl.setLookupController(controller);
        this.controller = controller;
        this.controller.setDisableFrameClosing(true);
        this.controller.addLookupListener(new LookupListener(){

            public void beforeLookupAction(ValueObject parentVO) {
            }

            public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                try {
                    StringBuffer sb = new StringBuffer();
                    Object value = null;
                    int i = 0;
                    while (i < MultiCodLookupControl.this.lookupAttributeNames.length) {
                        value = ClientUtils.getValue(controller.getLookupVO(), MultiCodLookupControl.this.lookupAttributeNames[i]);
                        sb.append(value).append(MultiCodLookupControl.this.sep);
                        ++i;
                    }
                    sb.delete(sb.length() - MultiCodLookupControl.this.sep.length(), sb.length());
                    MultiCodLookupControl.this.model.addElement(sb.toString());
                    MultiCodLookupControl.this.selectedVOs.add(controller.getLookupVO());
                    MultiCodLookupControl.this.codesList.revalidate();
                    MultiCodLookupControl.this.codesList.repaint();
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "codeChanged", ex.getMessage(), ex);
                }
            }

            public void codeValidated(boolean validated) {
            }

            public void forceValidate() {
            }
        });
    }

    public final void setListHeight(int height) {
        this.scrollPaneList.setPreferredSize(new Dimension(100, height));
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.lookupControl.setComponentOrientation(o);
    }
}

