/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.NavigatorBarController;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class NavigatorBar
extends JPanel {
    public static final String DOWN_KEY = "DOWN_KEY";
    public static final String FIRST_BUTTON = "FIRST_BUTTON";
    public static final String LAST_BUTTON = "LAST_BUTTON";
    public static final String LEFT_MOUSE_BUTTON = "LEFT_MOUSE_BUTTON";
    public static final String NEXT_BUTTON = "NEXT_BUTTON";
    public static final String NEXT_PG_BUTTON = "NEXT_PG_BUTTON";
    public static final String PREV_BUTTON = "PREV_BUTTON";
    public static final String PREV_PG_BUTTON = "PREV_PG_BUTTON";
    public static final String UP_KEY = "UP_KEY";
    private ArrayList afterActionListeners;
    private ArrayList beforeActionListeners;
    private NumericControl controlPageNr;
    private int currentPageNr = -1;
    private JButton firstButton = new GenericButton(new ImageIcon(ClientUtils.getImage("first.gif")));
    private JButton lastButton;
    private JButton nextButton;
    private JButton nextPgButton;
    private JPanel pageNrPanel;
    private JButton prevButton = new GenericButton(new ImageIcon(ClientUtils.getImage("prev.gif")));
    private JButton prevPgButton;
    private NavigatorBarController resultSetController = null;
    private boolean showPageNumber = true;
    private boolean showPaginationButtons;

    public NavigatorBar() {
        this.nextButton = new GenericButton(new ImageIcon(ClientUtils.getImage("next.gif")));
        this.lastButton = new GenericButton(new ImageIcon(ClientUtils.getImage("last.gif")));
        this.nextPgButton = new GenericButton(new ImageIcon(ClientUtils.getImage("nextpg.gif")));
        this.prevPgButton = new GenericButton(new ImageIcon(ClientUtils.getImage("prevpg.gif")));
        this.afterActionListeners = new ArrayList();
        this.beforeActionListeners = new ArrayList();
        this.controlPageNr = new NumericControl();
        this.pageNrPanel = new JPanel();
        this.showPaginationButtons = ClientSettings.SHOW_PAGINATION_BUTTONS_ON_NAVBAR;
        try {
            this.jbInit();
            this.controlPageNr.setColumns(3);
            this.controlPageNr.setValue(new Integer(1));
            this.controlPageNr.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (NavigatorBar.this.controlPageNr.getDouble() == null) {
                        NavigatorBar.this.controlPageNr.setValue(new Integer(1));
                    }
                    if (!NavigatorBar.this.checkValidPage()) {
                        return;
                    }
                    NavigatorBar.this.currentPageNr = NavigatorBar.this.controlPageNr.getDouble().intValue();
                    NavigatorBar.this.gotoPage();
                }
            });
            this.controlPageNr.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (NavigatorBar.this.controlPageNr.getDouble() == null) {
                        NavigatorBar.this.controlPageNr.setValue(new Integer(1));
                    }
                    NavigatorBar.this.currentPageNr = NavigatorBar.this.controlPageNr.getDouble().intValue();
                }

                public void focusLost(FocusEvent e) {
                    if (NavigatorBar.this.controlPageNr.getDouble() == null) {
                        NavigatorBar.this.controlPageNr.setValue(new Integer(1));
                    }
                    if (!NavigatorBar.this.checkValidPage()) {
                        return;
                    }
                    int lastValue = NavigatorBar.this.currentPageNr;
                    NavigatorBar.this.currentPageNr = NavigatorBar.this.controlPageNr.getDouble().intValue();
                    if (lastValue != NavigatorBar.this.currentPageNr) {
                        NavigatorBar.this.gotoPage();
                    }
                }
            });
            this.firstButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Load the first block of records"));
            this.firstButton.setPreferredSize(new Dimension(32, 32));
            this.prevPgButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Load the previous block of records"));
            this.prevPgButton.setPreferredSize(new Dimension(32, 32));
            this.prevButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Select the previous row in grid"));
            this.prevButton.setPreferredSize(new Dimension(32, 32));
            this.nextButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Select the next row in grid"));
            this.nextButton.setPreferredSize(new Dimension(32, 32));
            this.nextPgButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Load the next block of records"));
            this.nextPgButton.setPreferredSize(new Dimension(32, 32));
            this.lastButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Load the last block of records"));
            this.lastButton.setPreferredSize(new Dimension(32, 32));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void addAfterActionListener(ActionListener listener) {
        this.afterActionListeners.add(listener);
    }

    public final void addBeforeActionListener(ActionListener listener) {
        this.beforeActionListeners.add(listener);
    }

    private boolean checkValidPage() {
        if (this.resultSetController != null && this.resultSetController.getTotalResultSetLength() != -1 && this.resultSetController.getBlockSize() != -1 && this.controlPageNr.getDouble().intValue() > this.resultSetController.getTotalResultSetLength() / this.resultSetController.getBlockSize()) {
            this.controlPageNr.setValue(new Integer(this.currentPageNr));
            return false;
        }
        return true;
    }

    public final void fireButtonPressedEvent(String buttonType) {
        int i = 0;
        while (i < this.afterActionListeners.size()) {
            ((ActionListener)this.afterActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, buttonType));
            ++i;
        }
    }

    public void firstButton_actionPerformed(ActionEvent e) {
        if (this.resultSetController != null) {
            int i = 0;
            while (i < this.beforeActionListeners.size()) {
                ((ActionListener)this.beforeActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, FIRST_BUTTON));
                ++i;
            }
            this.resultSetController.firstRow(this);
        }
    }

    private void gotoPage() {
        if (this.currentPageNr > 0 && this.resultSetController != null) {
            this.resultSetController.loadPage(this.currentPageNr);
        }
    }

    public void initNavigator(NavigatorBarController resultSetController) {
        this.resultSetController = resultSetController;
    }

    public boolean isFirstButtonEnabled() {
        return this.firstButton.isEnabled();
    }

    public boolean isLastButtonEnabled() {
        return this.lastButton.isEnabled();
    }

    public boolean isNextButtonEnabled() {
        return this.nextButton.isEnabled();
    }

    public boolean isPrevButtonEnabled() {
        return this.prevButton.isEnabled();
    }

    public final boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public final boolean isShowPaginationButtons() {
        return this.showPaginationButtons;
    }

    private void jbInit() throws Exception {
        this.pageNrPanel.setLayout(new FlowLayout(0, 0, 0));
        this.firstButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorBar.this.firstButton_actionPerformed(e);
            }
        });
        this.prevButton.setActionCommand(PREV_BUTTON);
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorBar.this.prevButton_actionPerformed(e);
            }
        });
        this.prevPgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorBar.this.prevPgButton_actionPerformed(e);
            }
        });
        this.nextPgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorBar.this.nextPgButton_actionPerformed(e);
            }
        });
        this.nextButton.setActionCommand(NEXT_BUTTON);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorBar.this.nextButton_actionPerformed(e);
            }
        });
        this.lastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorBar.this.lastButton_actionPerformed(e);
            }
        });
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)this.firstButton, null);
        if (this.showPaginationButtons) {
            this.add((Component)this.prevPgButton, null);
        }
        this.add((Component)this.prevButton, null);
        this.add((Component)this.pageNrPanel, null);
        this.add((Component)this.nextButton, null);
        if (this.showPaginationButtons) {
            this.add((Component)this.nextPgButton, null);
        }
        this.add((Component)this.lastButton, null);
    }

    public void lastButton_actionPerformed(ActionEvent e) {
        if (this.resultSetController != null) {
            int i = 0;
            while (i < this.beforeActionListeners.size()) {
                ((ActionListener)this.beforeActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, LAST_BUTTON));
                ++i;
            }
            this.resultSetController.lastRow(this);
        }
    }

    public void nextButton_actionPerformed(ActionEvent e) {
        if (this.resultSetController != null) {
            int i = 0;
            while (i < this.beforeActionListeners.size()) {
                ((ActionListener)this.beforeActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, e.getActionCommand()));
                ++i;
            }
            this.resultSetController.nextRow(this, e);
        }
    }

    public void nextPgButton_actionPerformed(ActionEvent e) {
        if (this.resultSetController != null) {
            int i = 0;
            while (i < this.beforeActionListeners.size()) {
                ((ActionListener)this.beforeActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, NEXT_PG_BUTTON));
                ++i;
            }
            this.resultSetController.nextPage(this);
        }
    }

    public void prevButton_actionPerformed(ActionEvent e) {
        if (this.resultSetController != null) {
            int i = 0;
            while (i < this.beforeActionListeners.size()) {
                ((ActionListener)this.beforeActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, e.getActionCommand()));
                ++i;
            }
            this.resultSetController.previousRow(this, e);
        }
    }

    public void prevPgButton_actionPerformed(ActionEvent e) {
        if (this.resultSetController != null) {
            int i = 0;
            while (i < this.beforeActionListeners.size()) {
                ((ActionListener)this.beforeActionListeners.get(i)).actionPerformed(new ActionEvent(this, 1001, PREV_PG_BUTTON));
                ++i;
            }
            this.resultSetController.previousPage(this);
        }
    }

    public final void removeAfterActionListener(ActionListener listener) {
        this.afterActionListeners.remove(listener);
    }

    public final void removeBeforerActionListener(ActionListener listener) {
        this.beforeActionListeners.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        this.controlPageNr.setEnabled(enabled);
        this.firstButton.setEnabled(enabled);
        this.prevPgButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.nextPgButton.setEnabled(enabled);
        this.lastButton.setEnabled(enabled);
    }

    public void setFirstRow(boolean isFirstRecord) {
        this.firstButton.setEnabled(!isFirstRecord);
        this.prevPgButton.setEnabled(!isFirstRecord);
        this.prevButton.setEnabled(!isFirstRecord);
        this.controlPageNr.setEnabled(true);
    }

    public void setLastRow(boolean isLastRecord) {
        this.lastButton.setEnabled(!isLastRecord);
        this.nextButton.setEnabled(!isLastRecord);
        this.nextPgButton.setEnabled(!isLastRecord);
        this.controlPageNr.setEnabled(true);
    }

    public final void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public final void setShowPaginationButtons(boolean showPaginationButtons) {
        if (!this.showPaginationButtons && showPaginationButtons) {
            this.add((Component)this.prevPgButton, null);
            this.add((Component)this.nextPgButton, null);
            this.revalidate();
            this.repaint();
        } else if (this.showPaginationButtons && !showPaginationButtons) {
            this.remove(this.prevPgButton);
            this.remove(this.nextPgButton);
            this.revalidate();
            this.repaint();
        }
        this.showPaginationButtons = showPaginationButtons;
    }

    public final void updatePageNumber(int pageNr) {
        this.controlPageNr.setValue(new Integer(pageNr));
        this.pageNrPanel.removeAll();
        if (pageNr > 0 && this.showPageNumber) {
            this.pageNrPanel.add(this.controlPageNr);
        }
        this.pageNrPanel.revalidate();
        this.repaint();
    }
}

