/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.NumBox;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.util.client.ClientSettings;

public class NumericControl
extends BaseInputControl
implements InputControl {
    private int decimals = 0;
    private DecimalFormat format = null;
    private boolean grouping = false;
    private boolean hideZeroDigits;
    private int maxCharacters = 255;
    private double maxValue = 2.147483647E9;
    private double minValue = 0.0;
    private String nullValue = null;
    private NumBox numBox = new NumBox();

    public NumericControl(int columns) {
        this.hideZeroDigits = ClientSettings.HIDE_ZERO_DIGITS;
        this.numBox.setColumns(columns);
        this.numBox.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.numBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        StringBuffer s = new StringBuffer(this.numBox.getColumns());
        int i = 0;
        while (i < this.numBox.getColumns()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.numBox.getFontMetrics(this.numBox.getFont()).stringWidth(s.toString()), this.numBox.getPreferredSize().height));
        this.setFormat();
        this.addKeyListener();
        this.addFocusListener();
        this.initListeners();
    }

    public NumericControl() {
        this(10);
    }

    public final void addActionListener(ActionListener listener) {
        try {
            this.numBox.addActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            this.numBox.addFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addFocusListener() {
        this.numBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (NumericControl.this.numBox.isEnabled() && NumericControl.this.numBox.isEditable()) {
                    try {
                        Number number = NumericControl.this.format.parse(NumericControl.this.numBox.getText());
                        if (number != null) {
                            if (number.doubleValue() > NumericControl.this.maxValue) {
                                NumericControl.this.setText(String.valueOf(NumericControl.this.maxValue));
                                number = new BigDecimal(NumericControl.this.maxValue);
                            } else if (number.doubleValue() < NumericControl.this.minValue) {
                                NumericControl.this.setText(String.valueOf(NumericControl.this.minValue));
                                number = new BigDecimal(NumericControl.this.minValue);
                            } else {
                                NumericControl.this.setText(String.valueOf(number));
                            }
                            BigDecimal d = new BigDecimal(number.doubleValue());
                            d = d.setScale(NumericControl.this.decimals, 4);
                            NumericControl.this.setText(d.toString());
                        }
                    }
                    catch (ParseException ex) {
                        NumericControl.this.setText(NumericControl.this.nullValue);
                    }
                    if (NumericControl.this.numBox.getText().length() > NumericControl.this.maxCharacters) {
                        NumericControl.this.setText(NumericControl.this.numBox.getText().substring(0, NumericControl.this.maxCharacters));
                    }
                }
            }
        });
    }

    public final void addKeyListener(KeyListener listener) {
        try {
            this.numBox.addKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addKeyListener() {
        this.numBox.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block3: {
                    block2: {
                        if (e.getKeyCode() == 10) break block2;
                        if (e.getKeyCode() == 9) break block2;
                        if (e.getKeyCode() == 127) break block2;
                        if (e.getKeyCode() == 8) break block2;
                        if (e.getKeyCode() == 37) break block2;
                        if (e.getKeyCode() != 39) break block3;
                    }
                    return;
                }
                e.consume();
            }

            public final void keyReleased(KeyEvent e) {
                e.consume();
            }

            public final void keyTyped(KeyEvent e) {
                if (NumericControl.this.getText() == null || NumericControl.this.getText().length() == 0) {
                    NumericControl.this.setText(NumericControl.this.nullValue);
                }
                if (e.getKeyChar() == ClientSettings.getInstance().getResources().getDecimalSymbol() && NumericControl.this.decimals > 0 && NumericControl.this.numBox.getText() != null && NumericControl.this.numBox.getText().indexOf(ClientSettings.getInstance().getResources().getDecimalSymbol()) != -1) {
                    e.consume();
                    return;
                }
                if (e.getKeyChar() == ClientSettings.getInstance().getResources().getDecimalSymbol() && NumericControl.this.decimals > 0) {
                    return;
                }
                if (e.getKeyChar() == ClientSettings.getInstance().getResources().getGroupingSymbol() && NumericControl.this.grouping) {
                    return;
                }
                if (e.getKeyChar() == '\b') {
                    return;
                }
                if (e.getKeyChar() == '-' && NumericControl.this.minValue < 0.0 && NumericControl.this.numBox.getCaretPosition() == 0 && NumericControl.this.numBox.getText() != null && (NumericControl.this.numBox.getText().length() == 0 || NumericControl.this.numBox.getText().charAt(0) != '-')) {
                    return;
                }
                if (e.getKeyChar() < '0' || e.getKeyChar() > '9') {
                    e.consume();
                }
                if (NumericControl.this.numBox.getText() != null && NumericControl.this.numBox.getText().length() >= NumericControl.this.maxCharacters) {
                    e.consume();
                }
            }
        });
    }

    public final BigDecimal getBigDecimal() {
        if (this.numBox.getText().length() == 0 || this.numBox.getText().equals(this.nullValue)) {
            return null;
        }
        try {
            BigDecimal num = new BigDecimal(this.format.parse(this.numBox.getText()).doubleValue());
            num = num.setScale(this.decimals, 4);
            return num;
        }
        catch (ParseException ex) {
            Logger.error(this.getClass().getName(), "getBigDecimal", "Error while creating BigDecimal object", ex);
            return null;
        }
    }

    public JComponent getBindingComponent() {
        return this.numBox;
    }

    public final int getColumns() {
        return this.numBox.getColumns();
    }

    public int getDecimals() {
        return this.decimals;
    }

    public final Double getDouble() {
        if (this.numBox.getText().length() == 0 || this.numBox.getText().equals(this.nullValue)) {
            return null;
        }
        try {
            return new Double(this.format.parse(this.numBox.getText()).doubleValue());
        }
        catch (ParseException ex) {
            Logger.error(this.getClass().getName(), "getDouble", "Error while creating BigDecimal object", ex);
            return null;
        }
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public final String getText() {
        BigDecimal value = null;
        try {
            if (this.numBox.getText().length() != 0 && !this.numBox.getText().equals(this.nullValue) && !"-".equals(this.numBox.getText())) {
                value = new BigDecimal(this.format.parse(this.numBox.getText()).doubleValue());
            }
            if ("-".equals(this.numBox.getText())) {
                value = new BigDecimal(0.0).negate();
            }
        }
        catch (ParseException ex) {
            Logger.error(this.getClass().getName(), "getText", "Error while creating BigDecimal object", ex);
            return null;
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value.doubleValue());
    }

    public final Object getValue() {
        return this.getBigDecimal();
    }

    public final boolean isEnabled() {
        try {
            return this.numBox.isEditable();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean isGrouping() {
        return this.grouping;
    }

    public final boolean isHideZeroDigits() {
        return this.hideZeroDigits;
    }

    public void processKeyEvent(KeyEvent e) {
        this.numBox.processKeyEvent(e);
    }

    public final void removeActionListener(ActionListener listener) {
        try {
            this.numBox.removeActionListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            this.numBox.removeFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void removeKeyListener(KeyListener listener) {
        try {
            this.numBox.removeKeyListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void select(int selectionStart, int selectionEnd) {
        this.numBox.select(selectionStart, selectionEnd);
    }

    public final void setColumns(int columns) {
        this.numBox.setColumns(columns);
        StringBuffer s = new StringBuffer(this.numBox.getColumns());
        int i = 0;
        while (i < this.numBox.getColumns()) {
            s.append("0");
            ++i;
        }
        this.setMinimumSize(new Dimension(this.numBox.getFontMetrics(this.numBox.getFont()).stringWidth(s.toString()), this.numBox.getPreferredSize().height));
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
        this.setFormat();
    }

    public void setEnabled(boolean enabled) {
        this.numBox.setEditable(enabled);
        this.numBox.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (!enabled) {
            this.numBox.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
        }
    }

    private void setFormat() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(ClientSettings.getInstance().getResources().getGroupingSymbol());
        dfs.setDecimalSeparator(ClientSettings.getInstance().getResources().getDecimalSymbol());
        String zero = "0";
        if (this.hideZeroDigits) {
            zero = "#";
        }
        if (!this.grouping && this.decimals == 0) {
            this.format = new DecimalFormat("#");
        } else if (this.grouping && this.decimals == 0) {
            this.format = new DecimalFormat("#,###", dfs);
        } else if (this.grouping && this.decimals > 0) {
            String dec = "";
            int i = 0;
            while (i < this.decimals) {
                dec = dec + zero;
                ++i;
            }
            this.format = new DecimalFormat("#,##0." + dec, dfs);
        } else if (!this.grouping && this.decimals > 0) {
            String dec = "";
            int i = 0;
            while (i < this.decimals) {
                dec = dec + zero;
                ++i;
            }
            this.format = new DecimalFormat("0." + dec, dfs);
        }
        this.format.setGroupingUsed(this.grouping);
        this.nullValue = "";
    }

    public final void setGrouping(boolean grouping) {
        this.grouping = grouping;
        this.setFormat();
    }

    public final void setHideZeroDigits(boolean hideZeroDigits) {
        this.hideZeroDigits = hideZeroDigits;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public final void setText(String text) {
        try {
            BigDecimal number = null;
            if (text != null && text.length() > 0) {
                number = new BigDecimal(text);
            }
            if (number != null) {
                this.numBox.setText(this.format.format(number));
            } else {
                this.numBox.setText(this.nullValue);
            }
        }
        catch (Exception ex) {
            this.numBox.setText(this.nullValue);
        }
    }

    public final void setValue(Object value) {
        try {
            if (value == null) {
                this.numBox.setText(this.nullValue);
            } else {
                this.numBox.setText(this.format.format(value));
            }
        }
        catch (Exception ex) {
            this.numBox.setText(this.nullValue);
        }
    }
}

