/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class OptionPane {
    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return OptionPane.getWindowForComponent(parentComponent.getParent());
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return OptionPane.showConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return OptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, String imageName) throws HeadlessException {
        return OptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, imageName, null, null);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return (String)OptionPane.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, String imageName, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        if (message != null && message instanceof String) {
            message = ClientSettings.getInstance().getResources().getResource(message.toString());
        }
        title = ClientSettings.getInstance().getResources().getResource(title);
        if (selectionValues != null) {
            int i = 0;
            while (i < selectionValues.length) {
                if (selectionValues[i] != null && selectionValues[i] instanceof String) {
                    selectionValues[i] = ClientSettings.getInstance().getResources().getResource(selectionValues[i].toString());
                }
                ++i;
            }
        }
        if (initialSelectionValue != null && initialSelectionValue instanceof String) {
            initialSelectionValue = ClientSettings.getInstance().getResources().getResource(initialSelectionValue.toString());
        }
        return OptionPane.showInputDialog2(parentComponent, message, title, messageType, imageName == null ? null : new ImageIcon(ClientUtils.getImage(imageName)), selectionValues, initialSelectionValue);
    }

    public static Object showInputDialog2(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        boolean supportsWindowDecorations;
        Object[] options = new String[]{ClientSettings.getInstance().getResources().getResource("ok"), ClientSettings.getInstance().getResources().getResource("cancel")};
        final JOptionPane pane = new JOptionPane(message, messageType, 2, icon, options, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        int style = OptionPane.styleFromMessageType(messageType);
        Window window = OptionPane.getWindowForComponent(parentComponent);
        final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        dialog.setResizable(true);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            dialog.getRootPane().setWindowDecorationStyle(style);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent we) {
                pane.setValue(null);
            }

            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    pane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        JPanel p = (JPanel)pane.getComponents()[1];
        JButton okB = (JButton)p.getComponent(0);
        JButton cancelB = (JButton)p.getComponent(1);
        okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.hide();
                dialog.dispose();
            }
        });
        cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pane.setInitialValue(JOptionPane.UNINITIALIZED_VALUE);
                pane.setInputValue(JOptionPane.UNINITIALIZED_VALUE);
                pane.setInitialSelectionValue(JOptionPane.UNINITIALIZED_VALUE);
                dialog.hide();
                dialog.dispose();
            }
        });
        pane.selectInitialValue();
        dialog.show();
        dialog.dispose();
        Object value = pane.getInputValue();
        if (JOptionPane.UNINITIALIZED_VALUE.equals(value)) {
            return null;
        }
        return value;
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return OptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, 3);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return OptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, String imageName) {
        return OptionPane.showInternalOptionDialog(parentComponent, message, title, optionType, messageType, imageName, null, null);
    }

    public static String showInternalInputDialog(Component parentComponent, Object message, String title, int messageType) {
        return (String)OptionPane.showInternalInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static Object showInternalInputDialog(Component parentComponent, Object message, String title, int messageType, String imageName, Object[] selectionValues, Object initialSelectionValue) {
        if (message != null && message instanceof String) {
            message = ClientSettings.getInstance().getResources().getResource(message.toString());
        }
        title = ClientSettings.getInstance().getResources().getResource(title);
        if (selectionValues != null) {
            int i = 0;
            while (i < selectionValues.length) {
                if (selectionValues[i] != null && selectionValues[i] instanceof String) {
                    selectionValues[i] = ClientSettings.getInstance().getResources().getResource(selectionValues[i].toString());
                }
                ++i;
            }
        }
        if (initialSelectionValue != null && initialSelectionValue instanceof String) {
            initialSelectionValue = ClientSettings.getInstance().getResources().getResource(initialSelectionValue.toString());
        }
        return JOptionPane.showInternalInputDialog(parentComponent, message, title, messageType, imageName == null ? null : new ImageIcon(ClientUtils.getImage(imageName)), selectionValues, initialSelectionValue);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType, String imageName) {
        OptionPane.showInternalOptionDialog(parentComponent, message, title, -1, messageType, imageName, null, null);
    }

    public static int showInternalOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, String imageName, Object[] options, Object initialValue) {
        if (message != null && message instanceof String) {
            message = ClientSettings.getInstance().getResources().getResource(message.toString());
        }
        title = ClientSettings.getInstance().getResources().getResource(title);
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                if (options[i] != null && options[i] instanceof String) {
                    options[i] = ClientSettings.getInstance().getResources().getResource(options[i].toString());
                }
                ++i;
            }
        }
        if (initialValue != null && initialValue instanceof String) {
            initialValue = ClientSettings.getInstance().getResources().getResource(initialValue.toString());
        }
        return JOptionPane.showInternalOptionDialog(parentComponent, message, title, optionType, messageType, imageName == null ? null : new ImageIcon(ClientUtils.getImage(imageName)), options, initialValue);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        OptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, null, null, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, String imageName) throws HeadlessException {
        OptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, imageName, null, null);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, String imageName, Object[] options, Object initialValue) throws HeadlessException {
        if (message != null && message instanceof String) {
            message = ClientSettings.getInstance().getResources().getResource(message.toString());
        }
        title = ClientSettings.getInstance().getResources().getResource(title);
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                if (options[i] != null && options[i] instanceof String) {
                    options[i] = ClientSettings.getInstance().getResources().getResource(options[i].toString());
                }
                ++i;
            }
        } else if (optionType == 1) {
            options = new String[]{ClientSettings.getInstance().getResources().getResource("yes"), ClientSettings.getInstance().getResources().getResource("no"), ClientSettings.getInstance().getResources().getResource("cancel")};
        } else if (optionType == 0) {
            options = new String[]{ClientSettings.getInstance().getResources().getResource("yes"), ClientSettings.getInstance().getResources().getResource("no")};
        } else if (optionType == 2) {
            options = new String[]{ClientSettings.getInstance().getResources().getResource("ok"), ClientSettings.getInstance().getResources().getResource("cancel")};
        } else if (optionType == -1) {
            options = new String[]{ClientSettings.getInstance().getResources().getResource("ok")};
        }
        return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, imageName == null ? null : new ImageIcon(ClientUtils.getImage(imageName)), options, initialValue);
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }
}

