/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.form.model.client.ValueChangeEvent;
import org.openswing.swing.form.model.client.ValueChangeListener;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class RadioButtonControl
extends JRadioButton
implements InputControl {
    private String attributeName = null;
    private ButtonGroup buttonGroup = null;
    private boolean canCopy = false;
    private boolean changed = false;
    private Color defaultBackgroundColor = null;
    private boolean enabledOnEdit = true;
    private boolean enabledOnInsert = true;
    private LabelControl label = null;
    protected Object oldValue;
    private boolean required = false;
    private Object selectedValue = null;
    private String toolTipText = null;
    private ArrayList valueChangedListeners = new ArrayList();

    public RadioButtonControl() {
        this.setOpaque(false);
        this.initListeners();
    }

    public final void addValueChangedListener(ValueChangeListener listener) {
        this.valueChangedListeners.add(listener);
    }

    private void controlFocusGained(FocusEvent e) {
        this.oldValue = this.getValue();
        if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && this.isEnabled()) {
            UIManager.put("CheckBox.background", ClientSettings.BACKGROUND_SEL_COLOR);
            UIManager.put("CheckBoxMenuItem.selectionBackground", ClientSettings.BACKGROUND_SEL_COLOR);
            this.repaint();
        }
    }

    private void controlFocusLost(FocusEvent e) {
        if (ClientSettings.VIEW_BACKGROUND_SEL_COLOR && this.isEnabled()) {
            UIManager.put("CheckBox.background", this.defaultBackgroundColor);
            UIManager.put("CheckBoxMenuItem.selectionBackground", this.defaultBackgroundColor);
            this.repaint();
        }
        this.maybeFireValueChangedEvent();
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public final Font getFont() {
        return super.getFont();
    }

    public LabelControl getLinkLabel() {
        return this.label;
    }

    public final Object getSelectedValue() {
        return this.selectedValue;
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public final Object getValue() {
        if (this.isSelected()) {
            return this.selectedValue;
        }
        Enumeration<AbstractButton> en = this.buttonGroup.getElements();
        RadioButtonControl comp = null;
        while (en.hasMoreElements()) {
            comp = (RadioButtonControl)en.nextElement();
            if (!comp.isSelected()) continue;
            return comp.getSelectedValue();
        }
        return null;
    }

    public final ValueChangeListener[] getValueChangeListeners() {
        return this.valueChangedListeners.toArray(new ValueChangeListener[this.valueChangedListeners.size()]);
    }

    protected void initListeners() {
        this.defaultBackgroundColor = this.getBackground();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RadioButtonControl.this.controlFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                RadioButtonControl.this.controlFocusLost(e);
            }
        });
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RadioButtonControl.this.maybeFireValueChangedEvent();
            }
        });
        ClientUtils.addTabListener(this);
    }

    public final boolean isCanCopy() {
        return this.canCopy;
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public final boolean isEnabledOnEdit() {
        return this.enabledOnEdit;
    }

    public final boolean isEnabledOnInsert() {
        return this.enabledOnInsert;
    }

    public final boolean isRequired() {
        return false;
    }

    protected void maybeFireValueChangedEvent() {
        Object newValue = this.getValue();
        if (this.isEnabled() && (this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue))) {
            this.oldValue = newValue;
            this.setChanged(true);
            ValueChangeEvent e = new ValueChangeEvent(this, this.attributeName, this.oldValue, newValue);
            int i = 0;
            while (i < this.valueChangedListeners.size()) {
                ((ValueChangeListener)this.valueChangedListeners.get(i)).valueChanged(e);
                ++i;
            }
        }
    }

    public final void removeValueChangedListener(ValueChangeListener listener) {
        this.valueChangedListeners.remove(listener);
    }

    public final void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public final void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add(this);
    }

    public final void setCanCopy(boolean canCopy) {
        this.canCopy = canCopy;
    }

    public final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
    }

    public final void setEnabledOnEdit(boolean enabled) {
        this.enabledOnEdit = enabled;
    }

    public final void setEnabledOnInsert(boolean enabled) {
        this.enabledOnInsert = enabled;
    }

    public final void setFont(Font font) {
        super.setFont(font);
    }

    public void setLinkLabel(LabelControl label) {
        this.label = label;
    }

    public final void setSelectedValue(Object selectedValue) {
        this.selectedValue = selectedValue;
    }

    public final void setText(String text) {
        if (Beans.isDesignTime()) {
            super.setText(text);
        } else {
            super.setText(ClientSettings.getInstance().getResources().getResource(text));
        }
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        if (!Beans.isDesignTime()) {
            super.setToolTipText(ClientSettings.getInstance().getResources().getResource(toolTipText));
        }
    }

    public final void setValue(Object value) {
        if (value == null) {
            this.setSelected(false);
        } else if (value.equals(this.selectedValue)) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }
}

