/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JFrame;
import javax.swing.JWindow;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.util.client.ClientUtils;

public class SplashScreen
extends JWindow {
    private int delayTime;
    private Image image;
    private JFrame parentFrame;
    private String text;

    public SplashScreen(JFrame parentFrame, String imageName, String text, int delayTime) {
        super(parentFrame == null ? MDIFrame.getInstance() : parentFrame);
        this.parentFrame = parentFrame == null ? MDIFrame.getInstance() : parentFrame;
        this.image = ClientUtils.getImage(imageName);
        this.text = text;
        this.delayTime = delayTime;
        this.pack();
        ClientUtils.centerWindow(parentFrame, this);
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            Dimension dim = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2);
            if (this.text != null) {
                FontMetrics fm = this.getGraphics().getFontMetrics();
                dim.height += fm.getHeight() + 2;
            }
            return dim;
        }
        return new Dimension(0, 0);
    }

    public final void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
        g.drawImage(this.image, 1, 1, this.image.getWidth(this), this.image.getHeight(this), this);
        if (this.text != null) {
            FontMetrics fm = g.getFontMetrics();
            int y = this.image.getHeight(this) + 2 + fm.getAscent();
            int x = (size.width - fm.stringWidth(this.text)) / 2;
            g.setColor(this.getForeground());
            g.drawString(this.text, x, y);
        }
    }

    public final void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.delayTime > 0) {
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep((long)SplashScreen.this.delayTime * 1000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    SplashScreen.this.dispose();
                }
            }.start();
        }
    }
}

