/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.util.client.ClientSettings;

public class TextAreaControl
extends BaseInputControl
implements InputControl {
    private int maxCharacters = 255;
    private JScrollPane scrollPane = new JScrollPane();
    private TextArea textArea = new TextArea();

    public TextAreaControl() {
        this.scrollPane.getViewport().add((Component)this.textArea, null);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.scrollPane, "Center");
        this.textArea.setFont(UIManager.getFont("TextField.font"));
        if (ClientSettings.TEXT_ORIENTATION != null) {
            this.setComponentOrientation(ClientSettings.TEXT_ORIENTATION);
        }
        this.addFocusListener();
        this.addKeyListener();
        this.initListeners();
    }

    public final void addFocusListener(FocusListener listener) {
        try {
            this.textArea.addFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    private void addFocusListener() {
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TextAreaControl.this.textArea.isEnabled() && TextAreaControl.this.textArea.isEditable()) {
                    TextAreaControl.this.textArea.setText(TextAreaControl.this.textArea.getText());
                }
            }
        });
    }

    private void addKeyListener() {
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    e.consume();
                    TextAreaControl.this.textArea.transferFocus();
                }
            }

            public final void keyReleased(KeyEvent e) {
                e.consume();
            }

            public final void keyTyped(KeyEvent e) {
                if (TextAreaControl.this.textArea.getText() != null && TextAreaControl.this.textArea.getText().length() >= TextAreaControl.this.maxCharacters && e.getKeyChar() != '\b') {
                    TextAreaControl.this.textArea.setText(TextAreaControl.this.textArea.getText().substring(0, TextAreaControl.this.maxCharacters));
                    e.consume();
                }
            }
        });
    }

    public JComponent getBindingComponent() {
        return this.textArea;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public final JTextArea getTextArea() {
        return this.textArea;
    }

    public final ComponentOrientation getTextOrientation() {
        try {
            return this.textArea.getComponentOrientation();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getValue() {
        if (this.textArea.getText() != null && this.textArea.getText().length() == 0) {
            return null;
        }
        return this.textArea.getText();
    }

    public final boolean isEnabled() {
        try {
            return this.textArea.isEditable();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void processKeyEvent(KeyEvent e) {
        try {
            this.textArea.processKeyEvent(e);
        }
        catch (Throwable ex) {
        }
    }

    public final void removeFocusListener(FocusListener listener) {
        try {
            this.textArea.removeFocusListener(listener);
        }
        catch (Exception ex) {
        }
    }

    public final void select(int selectionStart, int selectionEnd) {
        this.textArea.select(selectionStart, selectionEnd);
    }

    public void setEnabled(boolean enabled) {
        this.textArea.setEditable(enabled);
        this.textArea.setFocusable(enabled || ClientSettings.DISABLED_INPUT_CONTROLS_FOCUSABLE);
        if (enabled) {
            this.textArea.setBackground((Color)UIManager.get("TextField.background"));
        } else {
            this.textArea.setBackground((Color)UIManager.get("TextField.inactiveBackground"));
        }
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public final void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.length() > this.maxCharacters) {
            text = text.substring(0, this.maxCharacters);
        }
        this.textArea.setText(text);
    }

    public final void setTextOrientation(ComponentOrientation o) {
        this.textArea.setComponentOrientation(o);
    }

    public void setValue(Object value) {
        this.textArea.setText((String)value);
    }

    class TextArea
    extends JTextArea {
        TextArea() {
        }

        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        public void setEnabled(boolean enabled) {
            TextAreaControl.this.setEnabled(enabled);
        }
    }
}

