/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.export.java;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.openswing.swing.export.java.ComponentExportOptions;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.GridExportCallbacks;
import org.openswing.swing.export.java.GridExportOptions;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;

public class ExportToHTML {
    private static final String newline = System.getProperty("line.separator");

    private void appendRow(ExportOptions exportOptions, StringBuffer sb, Object vo, GridExportOptions opt, Hashtable gettersMethods, SimpleDateFormat sdf, SimpleDateFormat sdatf, SimpleDateFormat stf, String newline, int rownum, int tableType) throws Throwable {
        String aName = null;
        Method getter = null;
        Class<?> clazz = null;
        Object obj = null;
        sb.append("<TR>").append(newline);
        int i = 0;
        while (i < opt.getExportColumns().size()) {
            clazz = vo.getClass();
            obj = vo;
            aName = opt.getExportAttrColumns().get(i).toString();
            while (aName.indexOf(".") != -1) {
                try {
                    getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                }
                aName = aName.substring(aName.indexOf(".") + 1);
                clazz = getter.getReturnType();
                obj = getter.invoke(obj, new Object[0]);
                if (obj == null) break;
            }
            try {
                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
            }
            if (obj != null) {
                obj = getter.invoke(obj, new Object[0]);
            }
            if (obj != null && !"".equals(obj)) {
                if (obj instanceof java.sql.Date || obj instanceof Date || obj instanceof Timestamp) {
                    int type = (Integer)opt.getColumnsType().get(opt.getExportAttrColumns().get(i));
                    if (type == 1) {
                        sb.append("\t<TD bgcolor=E8E8E8><FONT face=\"Verdana, Arial, Helvetica, sans-serif\">").append(sdf.format((Date)obj)).append("</FONT></TD>").append(newline);
                    } else if (type == 2) {
                        sb.append("\t<TD bgcolor=E8E8E8><FONT face=\"Verdana, Arial, Helvetica, sans-serif\">").append(sdatf.format((Date)obj)).append("</FONT></TD>").append(newline);
                    } else if (type == 3) {
                        sb.append("\t<TD bgcolor=E8E8E8><FONT face=\"Verdana, Arial, Helvetica, sans-serif\">").append(stf.format((Date)obj)).append("</FONT></TD>").append(newline);
                    }
                } else {
                    sb.append("\t<TD bgcolor=E8E8E8><FONT face=\"Verdana, Arial, Helvetica, sans-serif\">").append(this.encodeText(obj.toString())).append("</FONT></TD>").append(newline);
                }
            } else {
                sb.append("\t<TD bgcolor=E8E8E8>&nbsp;</TD>").append(newline);
            }
            ++i;
        }
        sb.append("</TR>").append(newline);
        if (opt.getCallbacks() != null) {
            if (tableType == 0) {
                this.processComponent(sb, exportOptions, opt.getCallbacks().getComponentPerRowInHeader((ValueObject)vo, rownum));
            } else if (tableType == 1) {
                ComponentExportOptions compOpts = opt.getCallbacks().getComponentPerRow((ValueObject)vo, rownum);
                if (compOpts != null) {
                    sb.append("<TR><TD COLSPAN='").append(opt.getExportColumns().size()).append("'>").append(newline);
                    this.processComponent(sb, exportOptions, compOpts);
                    sb.append("</TD></TR>").append(newline);
                }
            } else if (tableType == 2) {
                this.processComponent(sb, exportOptions, opt.getCallbacks().getComponentPerRowInFooter((ValueObject)vo, rownum));
            }
        }
    }

    private String encodeText(String text) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) >= '.' && text.charAt(i) <= 'Z' || text.charAt(i) >= 'a' && text.charAt(i) <= 'z') {
                sb.append(text.charAt(i));
            } else {
                sb.append("&#").append((int)text.charAt(i)).append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    public byte[] getDocument(ExportOptions opt) throws Throwable {
        StringBuffer sb = new StringBuffer("");
        sb.append("<HTML><HEAD><TITLE></TITLE></HEAD>").append(newline);
        sb.append("<BODY>").append(newline);
        Object obj = null;
        int i = 0;
        while (i < opt.getComponentsExportOptions().size()) {
            obj = opt.getComponentsExportOptions().get(i);
            this.processComponent(sb, opt, obj);
            ++i;
        }
        sb.append("</BODY>").append(newline).append("</HTML>").append(newline);
        byte[] doc = sb.toString().getBytes();
        return doc;
    }

    private void prepareGenericComponent(StringBuffer sb, ExportOptions exportOptions, ComponentExportOptions opt) throws Throwable {
        Object[] row = null;
        Object obj = null;
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        sb.append("<TABLE BORDER=0>").append(newline);
        if (opt.getCellsContent() != null) {
            int i = 0;
            while (i < opt.getCellsContent().length) {
                row = opt.getCellsContent()[i];
                sb.append("<TR>").append(newline);
                int j = 0;
                while (j < row.length) {
                    obj = row[j];
                    sb.append("<TD>").append(newline);
                    if (obj != null) {
                        if (obj instanceof Boolean) {
                            sb.append((Boolean)obj);
                        } else if (obj.getClass().equals(Boolean.TYPE)) {
                            sb.append((Boolean)obj);
                        } else if (obj instanceof java.sql.Date || obj instanceof Date || obj instanceof Timestamp) {
                            sb.append(sdatf.format((Date)obj));
                        } else {
                            sb.append(this.encodeText(obj.toString()));
                        }
                    }
                    sb.append("</TD>").append(newline);
                    ++j;
                }
                sb.append("</TR>").append(newline);
                ++i;
            }
        }
        sb.append("</TABLE>").append(newline);
    }

    private void prepareGrid(StringBuffer sb, ExportOptions exportOptions, GridExportOptions opt) throws Throwable {
        int j;
        int i;
        String[] filters;
        String methodName = null;
        String attributeName = null;
        Hashtable<String, Method> gettersMethods = new Hashtable<String, Method>();
        Method[] voMethods = opt.getValueObjectType().getMethods();
        int i2 = 0;
        while (i2 < voMethods.length) {
            methodName = voMethods[i2].getName();
            if (methodName.startsWith("get")) {
                attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (opt.getExportAttrColumns().contains(attributeName)) {
                    gettersMethods.put(attributeName, voMethods[i2]);
                }
            }
            ++i2;
        }
        Response response = null;
        int start = 0;
        int rownum = 0;
        Object value = null;
        Object vo = null;
        SimpleDateFormat sdf = new SimpleDateFormat(exportOptions.getDateFormat());
        SimpleDateFormat sdatf = new SimpleDateFormat(exportOptions.getDateTimeFormat());
        SimpleDateFormat stf = new SimpleDateFormat(exportOptions.getTimeFormat());
        String newline = System.getProperty("line.separator");
        if (opt.getTitle() != null && !opt.getTitle().equals("")) {
            sb.append("<B>").append(opt.getTitle()).append("</B><BR/><BR/>").append(newline);
        }
        if ((filters = opt.getFilteringConditions()) != null) {
            i = 0;
            while (i < filters.length) {
                sb.append(filters[i] + "<BR/>").append(newline);
                ++i;
            }
            sb.append("<BR/>").append(newline);
        }
        sb.append("<TABLE BORDER=1>").append(newline);
        sb.append("<TR>").append(newline);
        i = 0;
        while (i < opt.getExportColumns().size()) {
            sb.append("\t<TD bgcolor=92C3EE align=CENTER><FONT face=\"Verdana, Arial, Helvetica, sans-serif\">").append(this.encodeText(opt.getExportColumns().get(i).toString())).append("</FONT></TD>").append(newline);
            ++i;
        }
        sb.append("</TR>").append(newline);
        int j2 = 0;
        while (j2 < opt.getTopRows().size()) {
            vo = opt.getTopRows().get(j2);
            this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, newline, j2, 0);
            ++j2;
        }
        do {
            if ((response = opt.getGridDataLocator().loadData(1, start, opt.getFilteredColumns(), opt.getCurrentSortedColumns(), opt.getCurrentSortedVersusColumns(), opt.getValueObjectType(), opt.getOtherGridParams())).isError()) {
                throw new Exception(response.getErrorMessage());
            }
            j = 0;
            while (j < ((VOListResponse)response).getRows().size()) {
                vo = ((VOListResponse)response).getRows().get(j);
                this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, newline, rownum, 1);
                ++rownum;
                ++j;
            }
            start += ((VOListResponse)response).getRows().size();
        } while (((VOListResponse)response).isMoreRows() && rownum < opt.getMaxRows());
        j = 0;
        while (j < opt.getBottomRows().size()) {
            vo = opt.getBottomRows().get(j);
            this.appendRow(exportOptions, sb, vo, opt, gettersMethods, sdf, sdatf, stf, newline, j, 2);
            ++j;
        }
        sb.append("</TABLE>").append(newline);
    }

    private void processComponent(StringBuffer sb, ExportOptions exportOptions, Object obj) throws Throwable {
        if (obj != null) {
            GridExportCallbacks callbacks = null;
            if (obj instanceof GridExportOptions) {
                callbacks = ((GridExportOptions)obj).getCallbacks();
                if (callbacks != null) {
                    this.processComponent(sb, exportOptions, callbacks.getHeaderComponent());
                }
                this.prepareGrid(sb, exportOptions, (GridExportOptions)obj);
                if (callbacks != null) {
                    this.processComponent(sb, exportOptions, callbacks.getFooterComponent());
                }
            } else if (obj instanceof ComponentExportOptions) {
                this.prepareGenericComponent(sb, exportOptions, (ComponentExportOptions)obj);
            } else {
                return;
            }
            sb.append("<br/>" + newline);
            sb.append(newline);
        }
    }
}

