/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.form.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.openswing.swing.client.AttributeNameEditor;
import org.openswing.swing.client.BaseInputControl;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.CopyButton;
import org.openswing.swing.client.DataController;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.FormattedTextControl;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.GenericButtonController;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.LinkButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.client.ProgressBarControl;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.form.client.AttributeCouple;
import org.openswing.swing.form.client.FormController;
import org.openswing.swing.form.client.FormShortcutsListener;
import org.openswing.swing.form.model.client.VOModel;
import org.openswing.swing.form.model.client.ValueChangeEvent;
import org.openswing.swing.form.model.client.ValueChangeListener;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.client.Grid;
import org.openswing.swing.table.renderers.client.ExpandablePanel;
import org.openswing.swing.util.client.ApplicationEventQueue;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class Form
extends JPanel
implements DataController,
ValueChangeListener,
GenericButtonController,
ActionListener {
    private HashSet bindedButtons;
    private Hashtable bindedGenericButtons;
    private Hashtable bindedLinkButtons;
    private Hashtable bindings;
    private Hashtable buttonsToDisable;
    static /* synthetic */ Class class$java$awt$event$FocusEvent;
    static /* synthetic */ Class class$org$openswing$swing$message$receive$java$ValueObject;
    private CopyButton copyButton = null;
    private boolean createInnerVO = true;
    private boolean currentFormHasFocus = false;
    private HashMap currentValueButtons;
    private DeleteButton deleteButton = null;
    private EditButton editButton = null;
    private boolean firstTime = true;
    private FormController formController = null;
    private FormFocusListener formFocusListener;
    private String functionId = null;
    private ArrayList genericButtons;
    private GridControl grid = null;
    private Hashtable inputControlsToDisable;
    private InsertButton insertButton = null;
    private ArrayList linkButtons;
    private ArrayList linkedPanels = new ArrayList();
    private int mode = 0;
    private VOModel model = null;
    private NavigatorBar navBar = null;
    private Border notFocusedBorder = null;
    private HashSet pkAttributes = null;
    private ValueObject previousVO = null;
    private ReloadButton reloadButton = null;
    private boolean reloadModelWhenClickingWithMouse;
    private boolean reloadModelWhenPressingKey;
    private SaveButton saveButton = null;
    private FormShortcutsListener shortcutsListener;
    private String voClassName = null;

    public Form() {
        this.genericButtons = new ArrayList();
        this.linkButtons = new ArrayList();
        this.inputControlsToDisable = new Hashtable();
        this.buttonsToDisable = new Hashtable();
        this.bindings = new Hashtable();
        this.bindedGenericButtons = new Hashtable();
        this.bindedLinkButtons = new Hashtable();
        this.shortcutsListener = new FormShortcutsListener(this);
        this.formFocusListener = new FormFocusListener();
        this.currentValueButtons = new HashMap();
        this.bindedButtons = new HashSet();
    }

    public final void actionPerformed(ActionEvent e) {
        if (e != null && e.getSource() != null && this.navBar != null && e.getSource().equals(this.navBar) || this.grid != null && this.grid.getNavBar() != null && e.getSource().equals(this.grid.getNavBar()) && (this.reloadModelWhenClickingWithMouse || !e.getActionCommand().equals("LEFT_MOUSE_BUTTON")) && (this.reloadModelWhenPressingKey || !e.getActionCommand().equals("UP_KEY")) && (this.reloadModelWhenPressingKey || !e.getActionCommand().equals("DOWN_KEY"))) {
            this.reload();
        }
    }

    public final void addButtonsNotEnabled(HashSet buttons, GenericButtonController buttonController) {
        Iterator it = buttons.iterator();
        GenericButton genericButton = null;
        ArrayList<GenericButtonController> list = null;
        while (it.hasNext()) {
            genericButton = (GenericButton)it.next();
            list = (ArrayList<GenericButtonController>)this.buttonsToDisable.get(genericButton);
            if (list == null) {
                list = new ArrayList<GenericButtonController>();
                this.buttonsToDisable.put(genericButton, list);
            }
            list.add(buttonController);
        }
    }

    public final void addGenericButton(GenericButton b) {
        this.genericButtons.add(b);
    }

    public final void addInputControlAttributesNotEditableOnState(HashSet attributeNames, String stateAttributeName, Object state) {
        AttributeCouple ac = new AttributeCouple(stateAttributeName, state);
        Iterator it = attributeNames.iterator();
        String aName = null;
        ArrayList<AttributeCouple> list = null;
        while (it.hasNext()) {
            aName = it.next().toString();
            list = (ArrayList<AttributeCouple>)this.inputControlsToDisable.get(aName);
            if (list == null) {
                list = new ArrayList<AttributeCouple>();
                this.inputControlsToDisable.put(aName, list);
            }
            list.add(ac);
        }
    }

    public final void addLinkButton(LinkButton b) {
        this.linkButtons.add(b);
    }

    public final void addLinkedPanel(Container c) {
        if (this.linkedPanels.contains(c)) {
            return;
        }
        if (c instanceof Form && ((Form)c).getFormController() == null) {
            ((Form)c).setFormController(this.getFormController());
        }
        this.linkedPanels.add(c);
        if (!this.firstTime) {
            this.linkInputControlsAndButtons(c.getComponents(), false);
        }
    }

    public final void addNotify() {
        try {
            super.addNotify();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!Beans.isDesignTime() && this.firstTime) {
            this.firstTime = false;
            this.maybeCreateVOModel();
            SwingUtilities.invokeLater(new Runnable(){

                static /* synthetic */ Form access$200(1 x0) {
                    return x0.Form.this;
                }

                public void run() {
                    if (Form.this.navBar != null) {
                        Form.this.navBar.initNavigator(Form.this.grid.getTable());
                        Form.this.navBar.addAfterActionListener(Form.this);
                        Form.this.navBar.addBeforeActionListener(new ActionListener(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void actionPerformed(ActionEvent e) {
                                int rowInGrid = 1.access$200(this.this$1).getRowIndexInGrid();
                                if (rowInGrid != -1) {
                                    Form.access$100(1.access$200(this.this$1)).setRowSelectionInterval(rowInGrid, rowInGrid);
                                }
                            }
                        });
                    }
                }
            });
            this.linkInputControlsAndButtons(this.getComponents(), true);
            this.notFocusedBorder = this.getBorder();
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Form.this.setFocusOnForm();
                }
            });
            JInternalFrame parentInternalFrame = this.getParentJInternalFrame(this);
            if (parentInternalFrame != null) {
                parentInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

                    public void internalFrameDeactivated(InternalFrameEvent e) {
                        Form.this.dropFocusFromForm();
                    }
                });
            } else {
                JFrame parentFrame = this.getParentJFrame(this);
                if (parentFrame != null) {
                    parentFrame.addWindowListener(new WindowAdapter(){

                        public void windowDeactivated(WindowEvent e) {
                            Form.this.dropFocusFromForm();
                        }
                    });
                }
            }
        }
    }

    public final void bind(InputControl comp) throws Exception {
        if (comp.getAttributeName() == null) {
            throw new Exception("No attribute name defined for the specified input control");
        }
        ArrayList<InputControl> list = (ArrayList<InputControl>)this.bindings.get(comp.getAttributeName());
        if (list == null) {
            list = new ArrayList<InputControl>();
            this.bindings.put(comp.getAttributeName(), list);
        }
        if (!list.contains(comp)) {
            list.add(comp);
            comp.addValueChangedListener(this);
            comp.addFocusListener(this.formFocusListener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final boolean containsLinkedPanel(Container c) {
        return this.linkedPanels.contains(c);
    }

    public final void copy() {
        this.maybeCreateVOModel();
        if (this.getMode() == 0) {
            try {
                ValueObject vo = (ValueObject)this.model.getValueObject().clone();
                this.setMode(1);
                if (this.insertButton != null) {
                    this.insertButton.setEnabled(false);
                }
                if (this.copyButton != null) {
                    this.copyButton.setEnabled(false);
                }
                if (this.deleteButton != null) {
                    this.deleteButton.setEnabled(false);
                }
                if (this.editButton != null) {
                    this.editButton.setEnabled(false);
                }
                int i = 0;
                while (i < this.genericButtons.size()) {
                    ((GenericButton)this.genericButtons.get(i)).setEnabled(false);
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.linkButtons.size()) {
                    ((LinkButton)this.linkButtons.get(i2)).setEnabled(false);
                    ++i2;
                }
                if (this.reloadButton != null) {
                    this.reloadButton.setEnabled(true);
                }
                if (this.saveButton != null) {
                    this.saveButton.setEnabled(true);
                }
                this.copyInputControlValues(vo, this, this.getComponents(), true);
                this.pull();
                this.resetButtonsState();
            }
            catch (Throwable ex) {
                Logger.error(this.getClass().getName(), "copy", "Error while duplicating the Form content", ex);
            }
        } else {
            Logger.error(this.getClass().getName(), "copy", "The form is not in READONLY mode: operation not allowed.", null);
        }
    }

    private void copyInputControlValues(ValueObject vo, Form form, Component[] c, boolean evalLinkedForm) throws Throwable {
        this.maybeCreateVOModel();
        String attributeName = null;
        Object attributeValue = null;
        int i = 0;
        while (i < c.length) {
            if (c[i] instanceof InputControl) {
                attributeName = ((InputControl)((Object)c[i])).getAttributeName();
                if (attributeName != null && ((InputControl)((Object)c[i])).isCanCopy()) {
                    try {
                        attributeValue = vo.getClass().getMethod("get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]).invoke((Object)vo, new Object[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            attributeValue = vo.getClass().getMethod("is" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]).invoke((Object)vo, new Object[0]);
                        }
                        catch (NoSuchMethodException exx) {
                            attributeValue = this.getVOModel().getValue(attributeName, vo);
                        }
                    }
                    this.model.setValue(attributeName, attributeValue);
                }
            } else if (c[i] instanceof Container) {
                this.copyInputControlValues(vo, form, ((Container)c[i]).getComponents(), false);
            }
            ++i;
        }
        Container container = null;
        if (evalLinkedForm) {
            int i2 = 0;
            while (i2 < this.linkedPanels.size()) {
                container = (Container)this.linkedPanels.get(i2);
                this.copyInputControlValues(vo, form, container.getComponents(), false);
                ++i2;
            }
        }
    }

    public final void delete() {
        block9: {
            if (this.getMode() == 0) {
                if (!this.formController.beforeDeleteData(this)) {
                    return;
                }
                if (OptionPane.showConfirmDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Confirm deliting data?"), ClientSettings.getInstance().getResources().getResource("Attention"), 0) == 0) {
                    try {
                        this.maybeCreateVOModel();
                        Response response = this.formController.deleteRecord(this.model.getValueObject());
                        if (!response.isError()) {
                            int gridRowIndex = -1;
                            if (this.grid != null && this.pkAttributes != null) {
                                gridRowIndex = this.getRowIndexInGrid();
                            }
                            this.insert();
                            this.formController.afterDeleteData();
                            if (this.grid != null && this.pkAttributes != null && gridRowIndex != -1) {
                                this.grid.getVOListTableModel().removeObjectAt(gridRowIndex);
                            }
                            break block9;
                        }
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error on deleting:") + "\n" + ClientSettings.getInstance().getResources().getResource(response.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Deleting Error"), 2);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                Logger.error(this.getClass().getName(), "delete", "The form is not in READONLY mode: operation not allowed.", null);
            }
        }
    }

    public final void dropFocusFromForm() {
        if (Beans.isDesignTime()) {
            return;
        }
        ApplicationEventQueue.getInstance().removeKeyListener(this.shortcutsListener);
        this.currentFormHasFocus = false;
        if (ClientSettings.SHOW_FOCUS_BORDER_ON_FORM) {
            this.setBorder(BorderFactory.createCompoundBorder(this.getNotFocusedBorder(), BorderFactory.createLineBorder(this.getBackground(), 1)));
        }
    }

    public final void edit() {
        if (this.getMode() == 0) {
            if (!this.formController.beforeEditData(this)) {
                return;
            }
            this.setMode(2);
        } else {
            Logger.error(this.getClass().getName(), "edit", "The form is not in READONLY mode: operation not allowed.", null);
        }
    }

    public final void executeReload() {
        try {
            this.setMode(0);
            this.reloadData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void export() {
    }

    public void filterSort() {
    }

    public final void finalize() {
        this.dropFocusFromForm();
        ClientUtils.disposeComponents(this.getComponents());
        try {
            JComponent btn;
            int i;
            ArrayList list;
            Enumeration en = null;
            Object attributeName = null;
            if (this.bindings != null) {
                en = this.bindings.keys();
                InputControl ic = null;
                while (en.hasMoreElements()) {
                    attributeName = en.nextElement();
                    list = (ArrayList)this.bindings.get(attributeName);
                    if (list == null) continue;
                    i = 0;
                    while (i < list.size()) {
                        ic = (InputControl)list.get(i);
                        list.remove(ic);
                        ic.removeFocusListener(this.formFocusListener);
                        ic.removeValueChangedListener(this);
                        if (((Component)((Object)ic)).getParent() != null) {
                            ((Component)((Object)ic)).getParent().remove((Component)((Object)ic));
                        }
                        ++i;
                    }
                }
            }
            if (this.bindedGenericButtons != null) {
                en = this.bindedGenericButtons.keys();
                btn = null;
                while (en.hasMoreElements()) {
                    attributeName = en.nextElement();
                    list = (ArrayList)this.bindings.get(attributeName);
                    if (list == null) continue;
                    i = 0;
                    while (i < list.size()) {
                        btn = (GenericButton)list.get(i);
                        list.remove(btn);
                        if (btn.getParent() != null) {
                            btn.getParent().remove(btn);
                        }
                        ++i;
                    }
                }
            }
            if (this.bindedLinkButtons != null) {
                en = this.bindedLinkButtons.keys();
                btn = null;
                while (en.hasMoreElements()) {
                    attributeName = en.nextElement();
                    list = (ArrayList)this.bindings.get(attributeName);
                    if (list == null) continue;
                    i = 0;
                    while (i < list.size()) {
                        btn = (LinkButton)list.get(i);
                        list.remove(btn);
                        if (btn.getParent() != null) {
                            btn.getParent().remove(btn);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.formController = null;
        this.insertButton = null;
        this.copyButton = null;
        this.editButton = null;
        this.reloadButton = null;
        this.deleteButton = null;
        this.saveButton = null;
        this.model = null;
        this.linkedPanels = null;
        this.previousVO = null;
        this.genericButtons = null;
        this.linkButtons = null;
        this.inputControlsToDisable = null;
        this.buttonsToDisable = null;
        this.bindings = null;
        this.grid = null;
        this.navBar = null;
        this.pkAttributes = null;
        this.bindedGenericButtons = null;
        this.bindedLinkButtons = null;
    }

    public final HashSet getBindedButtons() {
        return this.bindedButtons;
    }

    public final CopyButton getCopyButton() {
        return this.copyButton;
    }

    public final boolean getCurrentValue(GenericButton button) {
        Boolean currentValue = (Boolean)this.currentValueButtons.get(button);
        if (currentValue == null) {
            return true;
        }
        return currentValue;
    }

    public final DeleteButton getDeleteButton() {
        return this.deleteButton;
    }

    public final EditButton getEditButton() {
        return this.editButton;
    }

    public final FormController getFormController() {
        return this.formController;
    }

    public final String getFunctionId() {
        return this.functionId;
    }

    public final ArrayList getInputControlsNotValid() {
        ArrayList<String> inputControlsNotValid = new ArrayList<String>();
        ArrayList list = null;
        String attrName = null;
        InputControl comp = null;
        Enumeration en = this.bindings.keys();
        ArrayList models = new ArrayList();
        Object value = null;
        while (en.hasMoreElements()) {
            attrName = en.nextElement().toString();
            list = (ArrayList)this.bindings.get(attrName);
            if (list == null) continue;
            int i = 0;
            while (i < list.size()) {
                comp = (InputControl)list.get(i);
                if (!(comp instanceof ProgressBarControl)) {
                    if (comp instanceof FormattedTextControl && !((FormattedTextControl)comp).isEditValid()) {
                        if (comp.getLinkLabel() != null) {
                            inputControlsNotValid.add(comp.getLinkLabel().getText());
                        } else {
                            inputControlsNotValid.add(comp.getAttributeName());
                        }
                    } else {
                        try {
                            if (comp instanceof FormattedTextControl) {
                                ((JFormattedTextField)((FormattedTextControl)comp).getBindingComponent()).commitEdit();
                            }
                        }
                        catch (ParseException ex) {
                            // empty catch block
                        }
                        value = comp.getValue();
                        if ((value == null || value.equals("")) && comp.isRequired()) {
                            if (comp.getLinkLabel() != null) {
                                inputControlsNotValid.add(comp.getLinkLabel().getText());
                            } else {
                                inputControlsNotValid.add(comp.getAttributeName());
                            }
                        }
                        if (comp instanceof CodLookupControl) {
                            if (((CodLookupControl)comp).getCodBox().hasFocus()) {
                                ((CodLookupControl)comp).getCodBox().forceValidate();
                            }
                            if (((CodLookupControl)comp).getLookupController() != null && !((CodLookupControl)comp).getLookupController().isCodeValid()) {
                                inputControlsNotValid.add(comp.getAttributeName());
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return inputControlsNotValid;
    }

    public final InsertButton getInsertButton() {
        return this.insertButton;
    }

    public final int getMode() {
        return this.mode;
    }

    public final Border getNotFocusedBorder() {
        return this.notFocusedBorder;
    }

    private final Grid getParentGrid() {
        Container c = this;
        while (c != null && !(c instanceof ExpandablePanel)) {
            c = c.getParent();
        }
        if (c != null && c instanceof ExpandablePanel) {
            while (c != null && !(c instanceof Grid)) {
                c = c.getParent();
            }
            if (c != null) {
                return (Grid)c;
            }
        }
        return null;
    }

    private JFrame getParentJFrame(Form comp) {
        Container parentFrame = comp.getParent();
        while (parentFrame != null) {
            if (parentFrame instanceof JFrame) {
                return (JFrame)parentFrame;
            }
            parentFrame = parentFrame.getParent();
        }
        return null;
    }

    private JInternalFrame getParentJInternalFrame(Form comp) {
        Container parentFrame = comp.getParent();
        while (parentFrame != null) {
            if (parentFrame instanceof JInternalFrame) {
                return (JInternalFrame)parentFrame;
            }
            parentFrame = parentFrame.getParent();
        }
        return null;
    }

    public final ReloadButton getReloadButton() {
        return this.reloadButton;
    }

    public final int getRowIndexInGrid() {
        this.maybeCreateVOModel();
        if (this.grid != null && this.pkAttributes != null) {
            ValueObject gridVO = null;
            Iterator it = null;
            String pkAttrName = null;
            int i = 0;
            while (i < this.grid.getVOListTableModel().getRowCount()) {
                gridVO = this.grid.getVOListTableModel().getObjectForRow(i);
                it = this.pkAttributes.iterator();
                boolean rowFound = true;
                while (it.hasNext()) {
                    pkAttrName = it.next().toString();
                    int colIndex = this.grid.getVOListTableModel().findColumn(pkAttrName);
                    if (colIndex == -1) {
                        rowFound = false;
                        break;
                    }
                    Object o1 = this.grid.getVOListTableModel().getValueAt(i, colIndex);
                    Object o2 = this.model.getValue(pkAttrName, this.previousVO);
                    if (!(o1 == null && o2 != null || o1 != null && o2 == null) && (o1 == null || o2 == null || o1.equals(o2))) continue;
                    rowFound = false;
                    break;
                }
                if (rowFound) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public final SaveButton getSaveButton() {
        return this.saveButton;
    }

    public final String getVOClassName() {
        try {
            if (Beans.isDesignTime()) {
                AttributeNameEditor.setDesignVOClass(Class.forName(this.voClassName));
            }
        }
        catch (Throwable ex) {}
        return this.voClassName;
    }

    public final VOModel getVOModel() {
        this.maybeCreateVOModel();
        return this.model;
    }

    public final void importData() {
    }

    public final void insert() {
        if (this.getMode() == 0) {
            if (!this.formController.beforeInsertData(this)) {
                return;
            }
            this.setMode(1);
        } else {
            Logger.error(this.getClass().getName(), "insert", "The form is not in READONLY mode: operation not allowed.", null);
        }
    }

    public final boolean isButtonDisabled(GenericButton button) {
        ArrayList list = (ArrayList)this.buttonsToDisable.get(button);
        if (list != null) {
            GenericButtonController buttonController = null;
            int i = 0;
            while (i < list.size()) {
                buttonController = (GenericButtonController)list.get(i);
                if (buttonController.isButtonDisabled(button)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public final boolean isChanged() {
        Enumeration en = this.bindings.keys();
        String attrName = null;
        ArrayList list = null;
        while (en.hasMoreElements()) {
            attrName = en.nextElement().toString();
            list = (ArrayList)this.bindings.get(attrName);
            int i = 0;
            while (i < list.size()) {
                if (((InputControl)list.get(i)).isChanged()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public final boolean isCreateInnerVO() {
        return this.createInnerVO;
    }

    public final boolean isCurrentFormHasFocus() {
        return this.currentFormHasFocus;
    }

    private boolean isInputControlEnabled(boolean enabled, InputControl control) {
        if (!enabled) {
            return enabled;
        }
        if (control.getAttributeName() == null) {
            return enabled;
        }
        this.maybeCreateVOModel();
        ArrayList list = (ArrayList)this.inputControlsToDisable.get(control.getAttributeName());
        AttributeCouple ac = null;
        Object stateValue = null;
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ac = (AttributeCouple)list.get(i);
                stateValue = this.model.getValue(ac.getAttributeName());
                if (stateValue != null && ac.getAttributeValue() != null && stateValue.equals(ac.getAttributeValue()) || stateValue == null && ac.getAttributeValue() == null) {
                    return false;
                }
                ++i;
            }
        }
        return enabled;
    }

    public final void linkGrid(GridControl grid, HashSet pkAttributes, boolean reloadModelWhenSelectingOnGrid, boolean reloadModelWhenClickingWithMouse, boolean reloadModelWhenPressingKey, NavigatorBar navBar) {
        this.grid = grid;
        this.pkAttributes = pkAttributes;
        this.navBar = navBar;
        this.reloadModelWhenClickingWithMouse = reloadModelWhenClickingWithMouse;
        this.reloadModelWhenPressingKey = reloadModelWhenPressingKey;
        if (Beans.isDesignTime()) {
            return;
        }
        if (grid != null && pkAttributes != null && grid.getNavBar() != null && reloadModelWhenSelectingOnGrid) {
            grid.getNavBar().addAfterActionListener(this);
            this.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                }

                public void ancestorMoved(AncestorEvent event) {
                }

                public void ancestorRemoved(AncestorEvent event) {
                    if (Form.this.grid != null && Form.this.grid.getNavBar() != null) {
                        Form.this.grid.getNavBar().removeAfterActionListener(Form.this);
                    }
                }
            });
        }
    }

    public final void linkGrid(GridControl grid, HashSet pkAttributes, boolean reloadModelWhenSelectingOnGrid, NavigatorBar navBar) {
        this.linkGrid(grid, pkAttributes, reloadModelWhenSelectingOnGrid, reloadModelWhenSelectingOnGrid, reloadModelWhenSelectingOnGrid, navBar);
    }

    public final void linkGrid(GridControl grid, HashSet pkAttributes, boolean reloadModelWhenSelectingOnGrid) {
        this.linkGrid(grid, pkAttributes, reloadModelWhenSelectingOnGrid, reloadModelWhenSelectingOnGrid, reloadModelWhenSelectingOnGrid, null);
    }

    private void linkInputControlsAndButtons(Component[] c, boolean evalLinkedForm) {
        this.maybeCreateVOModel();
        int i = 0;
        while (i < c.length) {
            block18: {
                if (c[i] instanceof InputControl) {
                    try {
                        if (((InputControl)((Object)c[i])).getAttributeName() == null) break block18;
                        try {
                            this.bind((InputControl)((Object)c[i]));
                        }
                        catch (Exception ex) {
                            Logger.error(this.getClass().getName(), "linkInputControls", "Error while linking the input control having attribute name '" + ((InputControl)((Object)c[i])).getAttributeName() + "'", ex);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (c[i] instanceof GenericButton && ((GenericButton)c[i]).getAttributeName() != null && !((GenericButton)c[i]).getAttributeName().equals("")) {
                    ArrayList<Component> list = (ArrayList<Component>)this.bindedGenericButtons.get(((GenericButton)c[i]).getAttributeName());
                    if (list == null) {
                        list = new ArrayList<Component>();
                    }
                    list.add(c[i]);
                    this.bindedGenericButtons.put(((GenericButton)c[i]).getAttributeName(), list);
                    final ArrayList<Component> auxList = list;
                    final String attributeName = ((GenericButton)c[i]).getAttributeName();
                    this.model.addValueChangeListener(new ValueChangeListener(){

                        public void valueChanged(ValueChangeEvent e) {
                            if (e.getAttributeName().equals(attributeName)) {
                                int j = 0;
                                while (j < auxList.size()) {
                                    if (e.getNewValue() != null) {
                                        ((GenericButton)auxList.get(j)).setText(e.getNewValue().toString());
                                    } else {
                                        ((GenericButton)auxList.get(j)).setText("");
                                    }
                                    ++j;
                                }
                            }
                        }
                    });
                } else if (c[i] instanceof LinkButton && (((LinkButton)c[i]).getLabelAttributeName() != null && !((LinkButton)c[i]).getLabelAttributeName().equals("") || ((LinkButton)c[i]).getTooltipAttributeName() != null && !((LinkButton)c[i]).getTooltipAttributeName().equals("") || ((LinkButton)c[i]).getUriAttributeName() != null && !((LinkButton)c[i]).getUriAttributeName().equals(""))) {
                    ArrayList<Component> list;
                    final String labelAttributeName = ((LinkButton)c[i]).getLabelAttributeName();
                    final String tooltipAttributeName = ((LinkButton)c[i]).getTooltipAttributeName();
                    final String uriAttributeName = ((LinkButton)c[i]).getUriAttributeName();
                    String attrName = labelAttributeName;
                    if (attrName == null || attrName.equals("")) {
                        attrName = tooltipAttributeName;
                    }
                    if (attrName == null || attrName.equals("")) {
                        attrName = uriAttributeName;
                    }
                    if ((list = (ArrayList<Component>)this.bindedLinkButtons.get(attrName)) == null) {
                        list = new ArrayList<Component>();
                    }
                    list.add(c[i]);
                    this.bindedLinkButtons.put(attrName, list);
                    final ArrayList<Component> auxList = list;
                    this.model.addValueChangeListener(new ValueChangeListener(){

                        public void valueChanged(ValueChangeEvent e) {
                            block10: {
                                block11: {
                                    block9: {
                                        if (!e.getAttributeName().equals(labelAttributeName)) break block9;
                                        int j = 0;
                                        while (j < auxList.size()) {
                                            if (e.getNewValue() != null) {
                                                ((LinkButton)auxList.get(j)).setLabel(e.getNewValue().toString());
                                            } else {
                                                ((LinkButton)auxList.get(j)).setLabel("");
                                            }
                                            ++j;
                                        }
                                        break block10;
                                    }
                                    if (!e.getAttributeName().equals(tooltipAttributeName)) break block11;
                                    int j = 0;
                                    while (j < auxList.size()) {
                                        if (e.getNewValue() != null) {
                                            ((LinkButton)auxList.get(j)).setToolTipText(e.getNewValue().toString());
                                        } else {
                                            ((LinkButton)auxList.get(j)).setToolTipText("");
                                        }
                                        ++j;
                                    }
                                    break block10;
                                }
                                if (!e.getAttributeName().equals(uriAttributeName)) break block10;
                                int j = 0;
                                while (j < auxList.size()) {
                                    if (e.getNewValue() != null) {
                                        ((LinkButton)auxList.get(j)).setUri(e.getNewValue().toString());
                                    } else {
                                        ((LinkButton)auxList.get(j)).setUri("");
                                    }
                                    ++j;
                                }
                            }
                        }
                    });
                } else if (c[i] instanceof Container) {
                    this.linkInputControlsAndButtons(((Container)c[i]).getComponents(), false);
                }
            }
            ++i;
        }
        if (evalLinkedForm) {
            Container container = null;
            int i2 = 0;
            while (i2 < this.linkedPanels.size()) {
                container = (Container)this.linkedPanels.get(i2);
                this.linkInputControlsAndButtons(container.getComponents(), false);
                ++i2;
            }
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadData() {
        block23: {
            this.maybeCreateVOModel();
            ClientUtils.fireBusyEvent(true);
            try {
                ClientUtils.getParentFrame(this).setCursor(new Cursor(3));
                ClientUtils.getParentFrame(this).getToolkit().sync();
            }
            catch (Exception ex1) {
                // empty catch block
            }
            Response answer = null;
            try {
                answer = this.formController.loadData(this.model.getValueObjectType());
            }
            finally {
                try {
                    ClientUtils.getParentFrame(this).setCursor(new Cursor(0));
                    ClientUtils.getParentFrame(this).getToolkit().sync();
                }
                catch (Exception ex2) {}
                ClientUtils.fireBusyEvent(false);
            }
            if (!answer.isError()) {
                this.model.setValueObject((ValueObject)((VOResponse)answer).getVo());
                this.previousVO = this.getVOModel().getValueObject();
            } else {
                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while loading data:") + "\n" + ClientSettings.getInstance().getResources().getResource(answer.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error on Loading"), 2);
            }
            if (this.insertButton != null) {
                this.insertButton.setEnabled(true);
            }
            if (this.copyButton != null) {
                this.copyButton.setEnabled(true);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(true);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(true);
            }
            int i = 0;
            while (i < this.genericButtons.size()) {
                ((GenericButton)this.genericButtons.get(i)).setEnabled(true);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.linkButtons.size()) {
                ((LinkButton)this.linkButtons.get(i2)).setEnabled(true);
                ++i2;
            }
            this.pull();
            if (answer.isError()) break block23;
            this.formController.loadDataCompleted(false);
            this.resetButtonsState();
            boolean bl = true;
            Object var6_11 = null;
            return bl;
        }
        try {
            this.formController.loadDataCompleted(true);
            this.resetButtonsState();
            boolean bl = false;
            Object var6_12 = null;
            return bl;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                Object var6_13 = null;
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                throw throwable;
            }
        }
        return false;
    }

    private void maybeCreateVOModel() {
        try {
            if (this.model == null && this.voClassName != null && !this.voClassName.equals("")) {
                this.model = new VOModel(Class.forName(this.voClassName), this.createInnerVO, this);
            }
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "maybeCreateVOModel", "Error on setting Form data model:\n" + ex.toString(), null);
        }
    }

    public final boolean pull(String attributeName) {
        int i;
        JComponent btn;
        this.maybeCreateVOModel();
        boolean result = true;
        ArrayList list = null;
        String attrName = null;
        InputControl comp = null;
        Class clazz = this.model.getAttributeType(attributeName);
        if (clazz != null && (class$org$openswing$swing$message$receive$java$ValueObject == null ? (class$org$openswing$swing$message$receive$java$ValueObject = Form.class$("org.openswing.swing.message.receive.java.ValueObject")) : class$org$openswing$swing$message$receive$java$ValueObject).isAssignableFrom(clazz)) {
            Enumeration en = this.bindings.keys();
            while (en.hasMoreElements()) {
                attrName = en.nextElement().toString();
                if (attrName.indexOf(attributeName + '.') == -1) continue;
                this.pull(attrName);
            }
        }
        if ((list = (ArrayList)this.bindedGenericButtons.get(attributeName)) != null) {
            btn = null;
            i = 0;
            while (i < list.size()) {
                btn = (GenericButton)list.get(i);
                try {
                    if (this.model.getValue(attributeName) != null) {
                        ((GenericButton)btn).setText(this.model.getValue(attributeName).toString());
                    } else {
                        ((GenericButton)btn).setText("");
                    }
                }
                catch (Exception ex) {
                }
                ++i;
            }
        }
        if ((list = (ArrayList)this.bindedLinkButtons.get(attributeName)) != null) {
            btn = null;
            i = 0;
            while (i < list.size()) {
                btn = (LinkButton)list.get(i);
                try {
                    if (((LinkButton)btn).getLabelAttributeName() != null && !((LinkButton)btn).getLabelAttributeName().equals("")) {
                        if (this.model.getValue(((LinkButton)btn).getLabelAttributeName()) != null) {
                            ((LinkButton)btn).setLabel(this.model.getValue(((LinkButton)btn).getLabelAttributeName()).toString());
                        } else {
                            ((LinkButton)btn).setLabel("");
                        }
                    }
                    if (((LinkButton)btn).getTooltipAttributeName() != null && !((LinkButton)btn).getTooltipAttributeName().equals("")) {
                        if (this.model.getValue(((LinkButton)btn).getTooltipAttributeName()) != null) {
                            ((LinkButton)btn).setToolTipText(this.model.getValue(((LinkButton)btn).getTooltipAttributeName()).toString());
                        } else {
                            ((LinkButton)btn).setToolTipText("");
                        }
                    }
                    if (((LinkButton)btn).getUriAttributeName() != null && !((LinkButton)btn).getUriAttributeName().equals("")) {
                        if (this.model.getValue(((LinkButton)btn).getUriAttributeName()) != null) {
                            ((LinkButton)btn).setUri(this.model.getValue(((LinkButton)btn).getUriAttributeName()).toString());
                        } else {
                            ((LinkButton)btn).setUri("");
                        }
                    }
                }
                catch (Exception ex) {
                }
                ++i;
            }
        }
        if ((list = (ArrayList)this.bindings.get(attributeName)) != null) {
            int i2 = 0;
            while (i2 < list.size()) {
                comp = (InputControl)list.get(i2);
                try {
                    comp.setValue(this.model.getValue(comp.getAttributeName()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error on setting value to the input control having the attribute name") + " '" + comp.getAttributeName() + "'\n" + ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Saving Error"), 2);
                    result = false;
                }
                ++i2;
            }
            return result;
        }
        return false;
    }

    public final boolean pull() {
        boolean result = true;
        String attrName = null;
        Enumeration en = this.bindings.keys();
        while (en.hasMoreElements()) {
            attrName = en.nextElement().toString();
            result = result && this.pull(attrName);
        }
        return result;
    }

    public final boolean push() {
        this.maybeCreateVOModel();
        ArrayList inputControlsNotValid = this.getInputControlsNotValid();
        if (inputControlsNotValid.size() > 0) {
            String list = "";
            int i = 0;
            while (i < inputControlsNotValid.size()) {
                list = list + inputControlsNotValid.get(i) + ", ";
                ++i;
            }
            list = list.substring(0, list.length() - 2);
            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while validating data:") + "\n" + list, ClientSettings.getInstance().getResources().getResource("Validation Error"), 2);
            return false;
        }
        boolean result = true;
        ArrayList list = null;
        String attrName = null;
        InputControl comp = null;
        Enumeration en = this.bindings.keys();
        ArrayList models = new ArrayList();
        while (en.hasMoreElements()) {
            attrName = en.nextElement().toString();
            list = (ArrayList)this.bindings.get(attrName);
            if (list == null) continue;
            int i = 0;
            while (i < list.size()) {
                comp = (InputControl)list.get(i);
                if (!(comp instanceof ProgressBarControl)) {
                    if (comp instanceof BaseInputControl && ((BaseInputControl)comp).getBindingComponent().hasFocus()) {
                        ((BaseInputControl)comp).getBindingComponent().transferFocus();
                        try {
                            comp.getClass().getMethod("focusLost", class$java$awt$event$FocusEvent == null ? Form.class$("java.awt.event.FocusEvent") : class$java$awt$event$FocusEvent).invoke((Object)comp, new Object[]{null});
                        }
                        catch (Exception ex) {
                        }
                    }
                    try {
                        this.model.setValue(comp.getAttributeName(), comp.getValue());
                    }
                    catch (Exception ex) {
                        OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while validating data:") + "\n" + comp.getAttributeName(), ClientSettings.getInstance().getResources().getResource("Validation Error"), 2);
                        result = false;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public final void reload() {
        if (this.getReloadButton() != null) {
            this.getReloadButton().requestFocus();
        }
        if (this.getMode() != 0) {
            boolean canReload = true;
            if (this.isChanged()) {
                boolean bl = canReload = OptionPane.showConfirmDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Cancel changes and reload data?"), ClientSettings.getInstance().getResources().getResource("Attention"), 0) == 0;
            }
            if (canReload) {
                if (!ClientSettings.RELOAD_LAST_VO_ON_FORM && this.getMode() == 1) {
                    this.setMode(1);
                } else {
                    this.executeReload();
                }
            }
        } else if (this.getMode() == 0) {
            this.reloadData();
        }
    }

    private void reloadData() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean errorOnLoad = true;
                if (Form.this.reloadButton != null) {
                    Form.this.reloadButton.setEnabled(false);
                }
                if (Form.this.insertButton != null) {
                    Form.this.insertButton.setEnabled(false);
                }
                if (Form.this.copyButton != null) {
                    Form.this.copyButton.setEnabled(false);
                }
                if (Form.this.editButton != null) {
                    Form.this.editButton.setEnabled(false);
                }
                if (Form.this.deleteButton != null) {
                    Form.this.deleteButton.setEnabled(false);
                }
                if (Form.this.saveButton != null) {
                    Form.this.saveButton.setEnabled(false);
                }
                boolean[] oldGenericButtonValues = new boolean[Form.this.genericButtons.size()];
                int i = 0;
                while (i < Form.this.genericButtons.size()) {
                    oldGenericButtonValues[i] = ((GenericButton)Form.this.genericButtons.get(i)).isEnabled();
                    ((GenericButton)Form.this.genericButtons.get(i)).setEnabled(false);
                    ++i;
                }
                int i2 = 0;
                while (i2 < Form.this.linkButtons.size()) {
                    ((LinkButton)Form.this.linkButtons.get(i2)).setEnabled(false);
                    ++i2;
                }
                boolean bl = errorOnLoad = !Form.this.loadData();
                if (errorOnLoad) {
                    if (Form.this.reloadButton != null) {
                        Form.this.reloadButton.setEnabled(true);
                    }
                    if (Form.this.saveButton != null) {
                        Form.this.saveButton.setEnabled(true);
                    }
                } else {
                    if (Form.this.reloadButton != null) {
                        Form.this.reloadButton.setEnabled(true);
                    }
                    if (Form.this.saveButton != null) {
                        Form.this.saveButton.setEnabled(false);
                    }
                    int i3 = 0;
                    while (i3 < Form.this.genericButtons.size()) {
                        ((GenericButton)Form.this.genericButtons.get(i3)).setEnabled(oldGenericButtonValues[i3]);
                        ++i3;
                    }
                    int i4 = 0;
                    while (i4 < Form.this.linkButtons.size()) {
                        ((LinkButton)Form.this.linkButtons.get(i4)).setEnabled(((LinkButton)Form.this.linkButtons.get(i4)).getOldValue());
                        ++i4;
                    }
                    Form.this.formController.afterReloadData();
                    Form.this.resetButtonsState();
                }
            }
        });
    }

    public final void removeGenericButton(GenericButton b) {
        this.genericButtons.remove(b);
    }

    public final void removeLinkButton(LinkButton b) {
        this.linkButtons.remove(b);
    }

    public final void removeLinkedPanel(Container c) {
        this.linkedPanels.remove(c);
        Enumeration en = this.bindings.keys();
        String attrName = null;
        ArrayList list = null;
        while (en.hasMoreElements()) {
            attrName = en.nextElement().toString();
            list = (ArrayList)this.bindings.get(attrName);
            if (list == null) continue;
            int i = 0;
            while (i < list.size()) {
                try {
                    this.unbind((InputControl)list.get(i));
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "removeLinkedPanel", "Error while unbinding the input control having attribute name '" + ((InputControl)list.get(i)).getAttributeName() + "'", ex);
                }
                ++i;
            }
        }
        this.linkInputControlsAndButtons(this.getComponents(), true);
    }

    public final void requestFocus() {
        super.requestFocus();
        this.setFocusOnForm();
    }

    public final void resetButtonsState() {
        if (this.insertButton != null && this.isButtonDisabled(this.insertButton)) {
            this.insertButton.setEnabled(false);
        }
        if (this.copyButton != null && this.isButtonDisabled(this.copyButton)) {
            this.copyButton.setEnabled(false);
        }
        if (this.editButton != null && this.isButtonDisabled(this.editButton)) {
            this.editButton.setEnabled(false);
        }
        if (this.reloadButton != null && this.isButtonDisabled(this.reloadButton)) {
            this.reloadButton.setEnabled(false);
        }
        if (this.saveButton != null && this.isButtonDisabled(this.saveButton)) {
            this.saveButton.setEnabled(false);
        }
        if (this.deleteButton != null && this.isButtonDisabled(this.deleteButton)) {
            this.deleteButton.setEnabled(false);
        }
    }

    public final boolean save() {
        if (this.getSaveButton() != null) {
            this.getSaveButton().requestFocus();
        }
        if (this.getMode() != 0) {
            try {
                if (!this.push()) {
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                this.maybeCreateVOModel();
                int previousMode = this.getMode();
                Response response = null;
                if (this.getMode() == 1) {
                    response = this.formController.insertRecord(this.model.getValueObject());
                } else if (this.getMode() == 2) {
                    response = this.formController.updateRecord(this.previousVO, this.model.getValueObject());
                }
                if (!response.isError()) {
                    this.model.setValueObject((ValueObject)((VOResponse)response).getVo());
                    if (this.getMode() == 1) {
                        this.previousVO = this.getVOModel().getValueObject();
                    }
                    this.pull();
                    this.setMode(0);
                    if (this.saveButton != null) {
                        this.saveButton.setEnabled(false);
                    }
                    if (this.editButton != null) {
                        this.editButton.setEnabled(true);
                    }
                    if (this.deleteButton != null) {
                        this.deleteButton.setEnabled(true);
                    }
                    if (this.insertButton != null) {
                        this.insertButton.setEnabled(true);
                    }
                    if (this.copyButton != null) {
                        this.copyButton.setEnabled(true);
                    }
                    int i = 0;
                    while (i < this.genericButtons.size()) {
                        ((GenericButton)this.genericButtons.get(i)).setEnabled(true);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < this.linkButtons.size()) {
                        ((LinkButton)this.linkButtons.get(i2)).setEnabled(true);
                        ++i2;
                    }
                    switch (previousMode) {
                        case 1: {
                            this.formController.afterInsertData();
                            break;
                        }
                        case 2: {
                            this.formController.afterEditData();
                        }
                    }
                    Enumeration en = this.bindings.keys();
                    String attrName = null;
                    ArrayList list = null;
                    while (en.hasMoreElements()) {
                        attrName = en.nextElement().toString();
                        list = (ArrayList)this.bindings.get(attrName);
                        int i3 = 0;
                        while (i3 < list.size()) {
                            ((InputControl)list.get(i3)).setChanged(false);
                            ++i3;
                        }
                    }
                    this.resetButtonsState();
                    if (this.grid != null && this.pkAttributes != null) {
                        HashMap<String, FilterWhereClause[]> filters = new HashMap<String, FilterWhereClause[]>();
                        String pkAttrName = null;
                        Iterator it = this.pkAttributes.iterator();
                        FilterWhereClause[] filter = null;
                        while (it.hasNext()) {
                            pkAttrName = it.next().toString();
                            filter = new FilterWhereClause[2];
                            filter[0] = new FilterWhereClause(pkAttrName, "=", this.model.getValue(pkAttrName));
                            filters.put(pkAttrName, filter);
                        }
                        Response res = this.grid.getGridDataLocator().loadData(1, 0, filters, new ArrayList(), new ArrayList(), Class.forName(this.grid.getValueObjectClassName()), this.grid.getOtherGridParams());
                        if (res.isError()) {
                            Logger.error(this.getClass().getName(), "save", "Error while loading new row for grid:\n" + res.getErrorMessage(), null);
                        } else {
                            Grid grid;
                            List rows = ((VOListResponse)res).getRows();
                            if (rows.size() == 1) {
                                final int gridRowIndex = this.getRowIndexInGrid();
                                if (gridRowIndex == -1) {
                                    this.grid.getVOListTableModel().addObject((ValueObject)rows.get(0));
                                    this.grid.repaint();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            Form.this.grid.setRowSelectionInterval(Form.this.grid.getVOListTableModel().getRowCount() - 1, Form.this.grid.getVOListTableModel().getRowCount() - 1);
                                        }
                                    });
                                } else {
                                    this.grid.getVOListTableModel().updateObjectAt((ValueObject)rows.get(0), gridRowIndex);
                                    this.grid.repaint();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            Form.this.grid.setRowSelectionInterval(gridRowIndex, gridRowIndex);
                                        }
                                    });
                                }
                            }
                            if ((grid = this.getParentGrid()) != null) {
                                grid.refreshExpandableRenderer();
                            }
                        }
                    }
                    this.previousVO = this.getVOModel().getValueObject();
                    return true;
                }
                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while saving: incorrect data.") + "\n" + ClientSettings.getInstance().getResources().getResource(response.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Saving Error"), 2);
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        Logger.error(this.getClass().getName(), "save", "The form is in READONLY mode: operation not allowed.", null);
        return false;
    }

    public final void setCopyButton(CopyButton copyButton) {
        if (this.copyButton != null) {
            this.copyButton.removeDataController(this);
        }
        this.copyButton = copyButton;
        if (copyButton != null) {
            copyButton.addDataController(this);
            copyButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Copy record (CTRL+C)"));
            this.bindedButtons.add(copyButton);
        }
    }

    public final void setCreateInnerVO(boolean createInnerVO) {
        this.createInnerVO = createInnerVO;
        this.maybeCreateVOModel();
        if (this.model != null) {
            this.model.setCreateInnerVO(createInnerVO);
        }
    }

    public final void setCurrentValue(GenericButton button, boolean currentValue) {
        this.currentValueButtons.put(button, new Boolean(currentValue));
    }

    public final void setDeleteButton(DeleteButton deleteButton) {
        if (this.deleteButton != null) {
            this.deleteButton.removeDataController(this);
        }
        this.deleteButton = deleteButton;
        if (deleteButton != null) {
            deleteButton.addDataController(this);
            deleteButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Delete record (CTRL+D)"));
            this.bindedButtons.add(deleteButton);
        }
    }

    public final void setEditButton(EditButton editButton) {
        if (this.editButton != null) {
            this.editButton.removeDataController(this);
        }
        this.editButton = editButton;
        if (editButton != null) {
            editButton.addDataController(this);
            editButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Edit record (CTRL+E)"));
            this.bindedButtons.add(editButton);
        }
    }

    private void setEnabled(Component[] c, boolean enabled) {
        int i = 0;
        while (i < c.length) {
            if (c[i] instanceof JScrollPane) {
                this.setEnabled(((JScrollPane)c[i]).getViewport().getComponents(), enabled);
            } else if (c[i] instanceof JTabbedPane) {
                this.setEnabled(((Container)c[i]).getComponents(), enabled);
            } else {
                if (c[i] instanceof Container && !(c[i] instanceof InputControl)) {
                    this.setEnabled(((Container)c[i]).getComponents(), enabled);
                }
                if (!(c[i] instanceof JLabel) && !(c[i] instanceof JScrollPane)) {
                    if (c[i] instanceof InputControl && enabled) {
                        if (((InputControl)((Object)c[i])).isEnabledOnInsert() && this.getMode() == 1) {
                            boolean canEdit = this.isInputControlEnabled(enabled, (InputControl)((Object)c[i]));
                            c[i].setEnabled(canEdit);
                            if (canEdit && c[i] instanceof ComboBoxControl && !((ComboBoxControl)c[i]).isNullAsDefaultValue() && ((ComboBoxControl)c[i]).getComboBox().getSelectedIndex() == -1 && ((ComboBoxControl)c[i]).getComboBox().getItemCount() > 0) {
                                ((ComboBoxControl)c[i]).getComboBox().setSelectedIndex(0);
                            }
                        } else if (((InputControl)((Object)c[i])).isEnabledOnEdit() && this.getMode() == 2) {
                            c[i].setEnabled(this.isInputControlEnabled(enabled, (InputControl)((Object)c[i])));
                        } else if (enabled && (this.getMode() == 1 || this.getMode() == 2)) {
                            c[i].setEnabled(false);
                        }
                    } else {
                        c[i].setEnabled(enabled);
                    }
                }
            }
            ++i;
        }
    }

    public final void setFocusOnForm() {
        if (Beans.isDesignTime()) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        try {
            KeyListener[] ll = ApplicationEventQueue.getInstance().getKeyListeners();
            int i = 0;
            while (i < ll.length) {
                if (ll[i] instanceof FormShortcutsListener) {
                    ((FormShortcutsListener)ll[i]).getForm().dropFocusFromForm();
                }
                ++i;
            }
        }
        catch (Exception ex1) {
            // empty catch block
        }
        ApplicationEventQueue.getInstance().addKeyListener(this.shortcutsListener);
        this.currentFormHasFocus = true;
        if (ClientSettings.SHOW_FOCUS_BORDER_ON_FORM) {
            this.setBorder(BorderFactory.createCompoundBorder(this.getNotFocusedBorder(), BorderFactory.createLineBorder(ClientSettings.FORM_FOCUS_BORDER, 1)));
        }
    }

    public final void setFormController(FormController formController) {
        this.formController = formController;
    }

    public final void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public final void setInsertButton(InsertButton insertButton) {
        if (this.insertButton != null) {
            this.insertButton.removeDataController(this);
        }
        this.insertButton = insertButton;
        if (insertButton != null) {
            insertButton.addDataController(this);
            insertButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("New record (CTRL+I)"));
            this.bindedButtons.add(insertButton);
        }
    }

    public final void setMode(int mode) {
        int i;
        int i2;
        if (Beans.isDesignTime()) {
            return;
        }
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new UnsupportedOperationException("Mode not supported");
        }
        this.mode = mode;
        this.maybeCreateVOModel();
        if (mode == 1) {
            try {
                if (!this.formController.beforeInsertData(this)) {
                    return;
                }
                ValueObject vo = (ValueObject)this.model.getValueObjectType().newInstance();
                this.model.setValueObject(vo);
                this.formController.createPersistentObject(vo);
                this.pull();
                Component[] c = this.getComponents();
                this.setEnabled(c, true);
                Container container = null;
                i2 = 0;
                while (i2 < this.linkedPanels.size()) {
                    container = (Container)this.linkedPanels.get(i2);
                    this.setEnabled(container.getComponents(), true);
                    ++i2;
                }
                i = 0;
                while (i < c.length && !c[i].isEnabled()) {
                    ++i;
                }
                if (i < c.length) {
                    c[i].requestFocus();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
            this.formController.afterInsertData(this);
            if (this.insertButton != null) {
                this.insertButton.setEnabled(false);
            }
            if (this.copyButton != null) {
                this.copyButton.setEnabled(false);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(false);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(false);
            }
            int i3 = 0;
            while (i3 < this.genericButtons.size()) {
                ((GenericButton)this.genericButtons.get(i3)).setEnabled(false);
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.linkButtons.size()) {
                ((LinkButton)this.linkButtons.get(i4)).setEnabled(false);
                ++i4;
            }
            if (this.reloadButton != null) {
                this.reloadButton.setEnabled(true);
            }
            if (this.saveButton != null) {
                this.saveButton.setEnabled(true);
            }
            this.resetButtonsState();
        } else if (mode == 0) {
            Component[] c = this.getComponents();
            this.setEnabled(c, false);
            Container container = null;
            int i5 = 0;
            while (i5 < this.linkedPanels.size()) {
                container = (Container)this.linkedPanels.get(i5);
                this.setEnabled(container.getComponents(), false);
                ++i5;
            }
            if (this.insertButton != null) {
                this.insertButton.setEnabled(true);
            }
            if (this.copyButton != null) {
                this.copyButton.setEnabled(true);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(true);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(true);
            }
            i2 = 0;
            while (i2 < this.genericButtons.size()) {
                ((GenericButton)this.genericButtons.get(i2)).setEnabled(true);
                ++i2;
            }
            i = 0;
            while (i < this.linkButtons.size()) {
                ((LinkButton)this.linkButtons.get(i)).setEnabled(((LinkButton)this.linkButtons.get(i)).getOldValue());
                ++i;
            }
            if (this.reloadButton != null) {
                this.reloadButton.setEnabled(true);
            }
            if (this.saveButton != null) {
                this.saveButton.setEnabled(false);
            }
            this.resetButtonsState();
        } else if (mode == 2) {
            if (!this.formController.beforeEditData(this)) {
                return;
            }
            Component[] c = this.getComponents();
            this.setEnabled(c, true);
            Container container = null;
            int i6 = 0;
            while (i6 < this.linkedPanels.size()) {
                container = (Container)this.linkedPanels.get(i6);
                this.setEnabled(container.getComponents(), true);
                ++i6;
            }
            try {
                this.previousVO = (ValueObject)this.model.getValueObject().clone();
            }
            catch (CloneNotSupportedException ex1) {
                Logger.error(this.getClass().getName(), "setMode", "Error while duplicating the value object", ex1);
            }
            i2 = 0;
            while (i2 < c.length && !c[i2].isEnabled()) {
                ++i2;
            }
            if (i2 < c.length) {
                c[i2].requestFocus();
            }
            this.formController.afterEditData(this);
            if (this.insertButton != null) {
                this.insertButton.setEnabled(false);
            }
            if (this.copyButton != null) {
                this.copyButton.setEnabled(false);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(false);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(false);
            }
            i2 = 0;
            while (i2 < this.genericButtons.size()) {
                ((GenericButton)this.genericButtons.get(i2)).setEnabled(false);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.linkButtons.size()) {
                ((LinkButton)this.linkButtons.get(i2)).setEnabled(false);
                ++i2;
            }
            if (this.reloadButton != null) {
                this.reloadButton.setEnabled(true);
            }
            if (this.saveButton != null) {
                this.saveButton.setEnabled(true);
            }
            this.resetButtonsState();
        }
        Enumeration en = this.bindings.keys();
        String attrName = null;
        ArrayList list = null;
        while (en.hasMoreElements()) {
            attrName = en.nextElement().toString();
            list = (ArrayList)this.bindings.get(attrName);
            i2 = 0;
            while (i2 < list.size()) {
                ((InputControl)list.get(i2)).setChanged(false);
                ++i2;
            }
        }
        if (this.formController != null) {
            this.formController.modeChanged(mode);
        }
    }

    public final void setReloadButton(ReloadButton reloadButton) {
        if (this.reloadButton != null) {
            this.reloadButton.removeDataController(this);
        }
        this.reloadButton = reloadButton;
        if (reloadButton != null) {
            reloadButton.addDataController(this);
            reloadButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Reload record/Cancel current operation (CTRL+Z)"));
            this.bindedButtons.add(reloadButton);
        }
    }

    public final void setSaveButton(SaveButton saveButton) {
        if (this.saveButton != null) {
            this.saveButton.removeDataController(this);
        }
        this.saveButton = saveButton;
        if (saveButton != null) {
            saveButton.addDataController(this);
            saveButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("Save record (CTRL+S)"));
            this.bindedButtons.add(saveButton);
        }
    }

    public final void setVOClassName(String voClassName) {
        this.voClassName = voClassName;
        try {
            if (Beans.isDesignTime()) {
                AttributeNameEditor.setDesignVOClass(Class.forName(voClassName));
            } else if (this.model != null) {
                this.model.setValueObject(Class.forName(voClassName));
            }
        }
        catch (Throwable ex) {
        }
    }

    public final void unbind(InputControl comp) throws Exception {
        if (comp.getAttributeName() == null) {
            throw new Exception("No attribute name defined for the specified input control");
        }
        ArrayList list = (ArrayList)this.bindings.get(comp.getAttributeName());
        if (list == null) {
            return;
        }
        list.remove(comp);
        comp.removeValueChangedListener(this);
        comp.removeFocusListener(this.formFocusListener);
    }

    public final void valueChanged(ValueChangeEvent e) {
        if (Beans.isDesignTime()) {
            return;
        }
        this.maybeCreateVOModel();
        this.model.setValue(e.getAttributeName(), e.getNewValue());
        ArrayList list = (ArrayList)this.bindings.get(e.getAttributeName());
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ((InputControl)list.get(i)).setChanged(true);
                ++i;
            }
        }
    }

    class FormFocusListener
    extends FocusAdapter {
        FormFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (!Form.this.currentFormHasFocus) {
                Form.this.setFocusOnForm();
            }
        }

        public void focusLost(FocusEvent e) {
            if (Form.this.currentFormHasFocus) {
                Form.this.dropFocusFromForm();
            }
        }
    }
}

