/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.gantt.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.gantt.client.AppointmentChangeEvent;
import org.openswing.swing.gantt.client.AppointmentChangeListener;
import org.openswing.swing.gantt.client.GanttDataLocator;
import org.openswing.swing.gantt.java.Appointment;
import org.openswing.swing.gantt.java.GanttRowVO;
import org.openswing.swing.gantt.java.GanttWorkingHours;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class GanttControl
extends JPanel {
    private ArrayList appointmentChangeListeners;
    private boolean autoLoadData = true;
    BorderLayout borderLayout1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$ArrayList;
    private int columnWidth = 120;
    private boolean enableDelete = true;
    private boolean enableEdit = true;
    private boolean enableInsert = true;
    private Date endDate;
    private boolean firstTime = true;
    private GanttDataLocator ganttDataLocator = null;
    private Map ganttParameters;
    private ArrayList ganttRows;
    Table1Model model1;
    Table2Model model2;
    private Hashtable preferredSize;
    JScrollPane scrollPane1;
    JScrollPane scrollPane2;
    private boolean showDescription = true;
    private boolean showTime = true;
    JSplitPane splitPane;
    private Date startDate = new Date();
    JTable table1;
    JTable table2;
    private ArrayList visibility;

    public GanttControl() {
        this.endDate = new Date();
        this.ganttRows = new ArrayList();
        this.splitPane = new JSplitPane();
        this.borderLayout1 = new BorderLayout();
        this.scrollPane1 = new JScrollPane();
        this.scrollPane2 = new JScrollPane();
        this.model1 = new Table1Model();
        this.model2 = new Table2Model();
        this.table1 = new JTable();
        this.table2 = new JTable();
        this.ganttParameters = new HashMap();
        this.appointmentChangeListeners = new ArrayList();
        this.preferredSize = new Hashtable();
        this.visibility = new ArrayList();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.startDate = cal.getTime();
        cal.set(2, cal.get(2) + 1);
        this.endDate = cal.getTime();
        try {
            this.jbInit();
            this.setRowHeight(35);
            this.table1.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
            this.table2.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
            this.table1.getTableHeader().setReorderingAllowed(false);
            this.table1.setSelectionBackground(ClientSettings.GRID_SELECTION_BACKGROUND);
            this.table1.setSelectionForeground(ClientSettings.GRID_SELECTION_FOREGROUND);
            this.table1.setSelectionMode(0);
            this.table2.setShowVerticalLines(false);
            this.table2.setDefaultRenderer(class$java$util$ArrayList == null ? (class$java$util$ArrayList = GanttControl.class$("java.util.ArrayList")) : class$java$util$ArrayList, new GanttColumnRenderer());
            this.table2.setDefaultEditor(class$java$util$ArrayList == null ? (class$java$util$ArrayList = GanttControl.class$("java.util.ArrayList")) : class$java$util$ArrayList, new GanttColumnEditor());
            this.table2.getTableHeader().setResizingAllowed(false);
            this.table2.getTableHeader().setReorderingAllowed(false);
            this.table2.getColumnModel().setColumnMargin(0);
            this.table2.addMouseListener(new MouseAdapter(){

                static /* synthetic */ GanttControl access$100(1 x0) {
                    return x0.GanttControl.this;
                }

                public void mouseClicked(MouseEvent e) {
                    if (!GanttControl.this.model2.isCellEditable(0, 0)) {
                        return;
                    }
                    if (GanttControl.this.model2 != null && GanttControl.this.model2.getRowCount() > 0) {
                        GanttControl.this.table2.setRowSelectionInterval(GanttControl.this.table2.rowAtPoint(e.getPoint()), GanttControl.this.table2.rowAtPoint(e.getPoint()));
                        GanttControl.this.table2.setColumnSelectionInterval(GanttControl.this.table2.columnAtPoint(e.getPoint()), GanttControl.this.table2.columnAtPoint(e.getPoint()));
                        GanttControl.this.table2.editCellAt(GanttControl.this.table2.rowAtPoint(e.getPoint()), GanttControl.this.table2.columnAtPoint(e.getPoint()));
                    }
                    if (GanttControl.this.model2 != null && GanttControl.this.model2.getRowCount() > 0 && GanttControl.this.table2.getSelectedRow() != -1 && GanttControl.this.table2.getSelectedColumn() != -1 && SwingUtilities.isRightMouseButton(e)) {
                        JPopupMenu p = new JPopupMenu();
                        if (GanttControl.this.enableInsert) {
                            JMenuItem sel = new JMenuItem(ClientSettings.getInstance().getResources().getResource("fill in the whole day"));
                            p.add(sel);
                            sel.addActionListener(new ActionListener(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void actionPerformed(ActionEvent e) {
                                    Appointment a;
                                    GanttRowVO ganttRow = (GanttRowVO)GanttControl.access$200(1.access$100(this.this$1)).get(1.access$100(this.this$1).table2.getSelectedRow());
                                    ArrayList value = (ArrayList)1.access$100(this.this$1).model2.getValueAt(1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn());
                                    if (value != null) {
                                        long t1 = GanttControl.access$300(1.access$100(this.this$1)).getTime() + 86400000L * (long)1.access$100(this.this$1).table2.getSelectedColumn();
                                        long t2 = t1 + 86400000L;
                                        int i = 0;
                                        while (i < value.size()) {
                                            a = (Appointment)value.get(i);
                                            Appointment olda = (Appointment)a.clone();
                                            if (a.getStartDate().getTime() < t1 && a.getEndDate().getTime() <= t2 && GanttControl.access$400(1.access$100(this.this$1)) && a.isEnableEdit()) {
                                                a.setEndDate(new Timestamp(t1));
                                                a.setDuration(new BigDecimal((double)GanttControl.access$500(1.access$100(this.this$1), a, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn())));
                                                1.access$100(this.this$1).fireAppointmentChangedEvent(1.access$100(this.this$1).table2.getSelectedRow(), olda, a);
                                            } else if (a.getEndDate().getTime() > t2 && a.getStartDate().getTime() >= t1 && GanttControl.access$400(1.access$100(this.this$1)) && a.isEnableEdit()) {
                                                a.setStartDate(new Timestamp(t2));
                                                a.setDuration(new BigDecimal((double)GanttControl.access$500(1.access$100(this.this$1), a, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn())));
                                                1.access$100(this.this$1).fireAppointmentChangedEvent(1.access$100(this.this$1).table2.getSelectedRow(), olda, a);
                                            } else if (a.getEndDate().getTime() <= t2 && a.getStartDate().getTime() >= t1 && GanttControl.access$600(1.access$100(this.this$1)) && a.isEnableDelete()) {
                                                ganttRow.getAppointments().remove(a);
                                                1.access$100(this.this$1).fireAppointmentDeletedEvent(1.access$100(this.this$1).table2.getSelectedRow(), a);
                                            }
                                            ++i;
                                        }
                                    }
                                    try {
                                        a = (Appointment)ganttRow.getAppointmentClass().newInstance();
                                        a.setDescription("");
                                        Calendar cal = Calendar.getInstance();
                                        GanttWorkingHours whVO = GanttControl.access$700(1.access$100(this.this$1), 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn());
                                        if (whVO == null || whVO.getMorningStartHour() == null || whVO.getAfternoonStartHour() == null) {
                                            OptionPane.showMessageDialog(ClientUtils.getParentFrame(1.access$100(this.this$1)), ClientSettings.getInstance().getResources().getResource("no working hours defined for this day"), ClientSettings.getInstance().getResources().getResource("Attention"), 0);
                                            return;
                                        }
                                        1.access$100(this.this$1).table2.getCellEditor().stopCellEditing();
                                        cal.setTimeInMillis(whVO.getMorningStartHour().getTime());
                                        int h = cal.get(11);
                                        int m = cal.get(12);
                                        cal.setTimeInMillis(GanttControl.access$300(1.access$100(this.this$1)).getTime() + 86400000L * (long)1.access$100(this.this$1).table2.getSelectedColumn());
                                        cal.set(11, h);
                                        cal.set(12, m);
                                        cal.set(13, 0);
                                        cal.set(14, 0);
                                        a.setStartDate(new Timestamp(cal.getTimeInMillis()));
                                        cal.setTimeInMillis(whVO.getMorningEndHour().getTime());
                                        h = cal.get(11);
                                        m = cal.get(12);
                                        cal.setTimeInMillis(GanttControl.access$300(1.access$100(this.this$1)).getTime() + 86400000L * (long)1.access$100(this.this$1).table2.getSelectedColumn());
                                        cal.set(11, h);
                                        cal.set(12, m);
                                        cal.set(13, 0);
                                        cal.set(14, 0);
                                        a.setEndDate(new Timestamp(cal.getTimeInMillis()));
                                        a.setDuration(new BigDecimal((double)GanttControl.access$500(1.access$100(this.this$1), a, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn())));
                                        ganttRow.getAppointments().add(a);
                                        1.access$100(this.this$1).fireNewAppointmentEvent(1.access$100(this.this$1).table2.getSelectedRow(), a);
                                        a = (Appointment)ganttRow.getAppointmentClass().newInstance();
                                        a.setDescription("");
                                        cal.setTimeInMillis(whVO.getAfternoonStartHour().getTime());
                                        h = cal.get(11);
                                        m = cal.get(12);
                                        cal.setTimeInMillis(GanttControl.access$300(1.access$100(this.this$1)).getTime() + 86400000L * (long)1.access$100(this.this$1).table2.getSelectedColumn());
                                        cal.set(11, h);
                                        cal.set(12, m);
                                        cal.set(13, 0);
                                        cal.set(14, 0);
                                        a.setStartDate(new Timestamp(cal.getTimeInMillis()));
                                        cal.setTimeInMillis(whVO.getAfternoonEndHour().getTime());
                                        h = cal.get(11);
                                        m = cal.get(12);
                                        cal.setTimeInMillis(GanttControl.access$300(1.access$100(this.this$1)).getTime() + 86400000L * (long)1.access$100(this.this$1).table2.getSelectedColumn());
                                        cal.set(11, h);
                                        cal.set(12, m);
                                        cal.set(13, 0);
                                        cal.set(14, 0);
                                        a.setEndDate(new Timestamp(cal.getTimeInMillis()));
                                        ganttRow.getAppointments().add(a);
                                        a.setDuration(new BigDecimal((double)GanttControl.access$500(1.access$100(this.this$1), a, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn())));
                                        1.access$100(this.this$1).fireNewAppointmentEvent(1.access$100(this.this$1).table2.getSelectedRow(), a);
                                        1.access$100(this.this$1).table2.tableChanged(new TableModelEvent(1.access$100(this.this$1).model2, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn()));
                                    }
                                    catch (Throwable ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                        }
                        if (GanttControl.this.enableDelete) {
                            JMenuItem desel = new JMenuItem(ClientSettings.getInstance().getResources().getResource("remove all day appointments"));
                            p.add(desel);
                            desel.addActionListener(new ActionListener(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void actionPerformed(ActionEvent e) {
                                    ArrayList value = (ArrayList)1.access$100(this.this$1).model2.getValueAt(1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn());
                                    GanttRowVO ganttRow = (GanttRowVO)GanttControl.access$200(1.access$100(this.this$1)).get(1.access$100(this.this$1).table2.getSelectedRow());
                                    1.access$100(this.this$1).table2.getCellEditor().stopCellEditing();
                                    if (value != null) {
                                        long t1 = GanttControl.access$300(1.access$100(this.this$1)).getTime() + 86400000L * (long)1.access$100(this.this$1).table2.getSelectedColumn();
                                        long t2 = t1 + 86400000L;
                                        int i = 0;
                                        while (i < value.size()) {
                                            Appointment a = (Appointment)value.get(i);
                                            Appointment olda = (Appointment)a.clone();
                                            if (a.getStartDate().getTime() < t1 && a.getEndDate().getTime() <= t2 && GanttControl.access$400(1.access$100(this.this$1)) && a.isEnableEdit()) {
                                                a.setEndDate(new Timestamp(t1));
                                                a.setDuration(new BigDecimal((double)GanttControl.access$500(1.access$100(this.this$1), a, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn())));
                                                1.access$100(this.this$1).fireAppointmentChangedEvent(1.access$100(this.this$1).table2.getSelectedRow(), olda, a);
                                            } else if (a.getEndDate().getTime() > t2 && a.getStartDate().getTime() >= t1 && GanttControl.access$400(1.access$100(this.this$1)) && a.isEnableEdit()) {
                                                a.setStartDate(new Timestamp(t2));
                                                a.setDuration(new BigDecimal((double)GanttControl.access$500(1.access$100(this.this$1), a, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn())));
                                                1.access$100(this.this$1).fireAppointmentChangedEvent(1.access$100(this.this$1).table2.getSelectedRow(), olda, a);
                                            } else if (a.getEndDate().getTime() <= t2 && a.getStartDate().getTime() >= t1 && GanttControl.access$600(1.access$100(this.this$1)) && a.isEnableDelete()) {
                                                ganttRow.getAppointments().remove(a);
                                                1.access$100(this.this$1).fireAppointmentDeletedEvent(1.access$100(this.this$1).table2.getSelectedRow(), a);
                                            }
                                            ++i;
                                        }
                                    }
                                    1.access$100(this.this$1).table2.tableChanged(new TableModelEvent(1.access$100(this.this$1).model2, 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedRow(), 1.access$100(this.this$1).table2.getSelectedColumn()));
                                }
                            });
                        }
                        p.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.init();
            this.scrollPane2.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    GanttControl.this.table2.repaint();
                }
            });
            this.scrollPane1.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (GanttControl.this.scrollPane2.getVerticalScrollBar().getValue() != GanttControl.this.scrollPane1.getVerticalScrollBar().getValue()) {
                        GanttControl.this.scrollPane2.getVerticalScrollBar().setValue(GanttControl.this.scrollPane1.getVerticalScrollBar().getValue());
                    }
                }
            });
            this.scrollPane2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (GanttControl.this.scrollPane1.getVerticalScrollBar().getValue() != GanttControl.this.scrollPane2.getVerticalScrollBar().getValue()) {
                        GanttControl.this.scrollPane1.getVerticalScrollBar().setValue(GanttControl.this.scrollPane2.getVerticalScrollBar().getValue());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ boolean access$400(GanttControl x0) {
        return x0.enableEdit;
    }

    public final void addAppointmentChangeListener(AppointmentChangeListener listener) {
        this.appointmentChangeListeners.add(listener);
    }

    public final void addNotify() {
        super.addNotify();
        if (!Beans.isDesignTime() && this.isVisible() && this.firstTime) {
            this.firstTime = false;
            if (this.autoLoadData) {
                this.reloadData();
            }
        }
    }

    public final void addRow(GanttRowVO ganttRow) {
        this.ganttRows.add(ganttRow);
        this.table1.revalidate();
        this.table2.revalidate();
        this.table1.repaint();
        this.table2.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void fireAppointmentChangedEvent(int rowNum, Appointment oldapp, Appointment newapp) {
        int i = 0;
        while (i < this.appointmentChangeListeners.size()) {
            ((AppointmentChangeListener)this.appointmentChangeListeners.get(i)).appointmentChange(new AppointmentChangeEvent(1, rowNum, oldapp, newapp, this));
            ++i;
        }
    }

    protected void fireAppointmentDeletedEvent(int rowNum, Appointment app) {
        int i = 0;
        while (i < this.appointmentChangeListeners.size()) {
            ((AppointmentChangeListener)this.appointmentChangeListeners.get(i)).appointmentChange(new AppointmentChangeEvent(2, rowNum, app, this));
            ++i;
        }
    }

    protected void fireNewAppointmentEvent(int rowNum, Appointment app) {
        int i = 0;
        while (i < this.appointmentChangeListeners.size()) {
            ((AppointmentChangeListener)this.appointmentChangeListeners.get(i)).appointmentChange(new AppointmentChangeEvent(0, rowNum, app, this));
            ++i;
        }
    }

    public final HashSet getAppointments(int row) {
        GanttRowVO vo = (GanttRowVO)this.ganttRows.get(row);
        return vo.getAppointments();
    }

    public final int getColumnWidth() {
        return this.columnWidth;
    }

    public final int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public final Date getEndDate() {
        return this.endDate;
    }

    public final GanttDataLocator getGanttDataLocator() {
        return this.ganttDataLocator;
    }

    public final Map getGanttParameters() {
        return this.ganttParameters;
    }

    public final int getRowCount() {
        return this.ganttRows.size();
    }

    public final int getRowHeight() {
        return this.table1.getRowHeight();
    }

    public final Date getStartDate() {
        return this.startDate;
    }

    private long getTime(Appointment a, int row, int column) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(this.startDate.getTime() + (long)column * 86400000L));
        GanttWorkingHours whVO = null;
        if (cal.get(7) == 1) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getSundayWorkingHours();
        } else if (cal.get(7) == 2) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getMondayWorkingHours();
        } else if (cal.get(7) == 3) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getTuesdayWorkingHours();
        } else if (cal.get(7) == 4) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getWednesdayWorkingHours();
        } else if (cal.get(7) == 5) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getThursdayWorkingHours();
        } else if (cal.get(7) == 6) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getFridayWorkingHours();
        } else if (cal.get(7) == 7) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getSaturdayWorkingHours();
        }
        long m1 = this.startDate.getTime() + (long)column * 86400000L;
        long m2 = this.startDate.getTime() + (long)column * 86400000L;
        long a1 = this.startDate.getTime() + (long)column * 86400000L + 86400000L;
        long a2 = this.startDate.getTime() + (long)column * 86400000L + 86400000L;
        if (whVO != null) {
            if (whVO.getMorningStartHour() != null) {
                cal.setTime(whVO.getMorningStartHour());
                m1 = this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)cal.get(11) * 3600000L + (long)(cal.get(12) * 60000) : 0L);
            }
            if (whVO.getMorningEndHour() != null) {
                cal.setTime(whVO.getMorningEndHour());
                m2 = this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)cal.get(11) * 3600000L + (long)(cal.get(12) * 60000) : 0L);
            }
            if (whVO.getAfternoonStartHour() != null) {
                cal.setTime(whVO.getAfternoonStartHour());
                a1 = this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)cal.get(11) * 3600000L + (long)(cal.get(12) * 60000) : 86400000L);
            }
            if (whVO.getAfternoonEndHour() != null) {
                cal.setTime(whVO.getAfternoonEndHour());
                a2 = this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)cal.get(11) * 3600000L + (long)(cal.get(12) * 60000) : 86400000L);
            }
        }
        long d1 = 0L;
        long d2 = 0L;
        long d3 = 0L;
        long d4 = 0L;
        long delta = 0L;
        if (a.getStartDate().getTime() <= m1) {
            d1 = m1;
            if (a.getEndDate().getTime() <= m2) {
                d2 = a.getEndDate().getTime();
            } else {
                d2 = m2;
                if (a.getEndDate().getTime() >= a1) {
                    d3 = a1;
                    if (a.getEndDate().getTime() <= a2) {
                        d4 = a.getEndDate().getTime();
                    } else {
                        d4 = a2;
                        delta = this.getTime(a, row, column + 1);
                        if (delta < 0L) {
                            delta = 0L;
                        }
                    }
                }
            }
        } else if (a.getStartDate().getTime() > m2) {
            if (a.getStartDate().getTime() > a1) {
                d3 = a.getStartDate().getTime();
                if (a.getEndDate().getTime() < a2) {
                    d4 = a.getEndDate().getTime();
                } else {
                    d4 = a2;
                    delta = this.getTime(a, row, column + 1);
                    if (delta < 0L) {
                        delta = 0L;
                    }
                }
            } else {
                d3 = a1 == a2 ? a.getStartDate().getTime() : a1;
                if (a.getEndDate().getTime() < a2) {
                    d4 = a.getEndDate().getTime();
                } else {
                    d4 = a2;
                    delta = this.getTime(a, row, column + 1);
                    if (delta < 0L) {
                        delta = 0L;
                    }
                }
            }
        } else {
            d1 = a.getStartDate().getTime();
            if (a.getEndDate().getTime() <= m2) {
                d2 = a.getEndDate().getTime();
            } else if (a.getEndDate().getTime() < a1) {
                d2 = m2;
            } else {
                d2 = m2;
                d3 = a1;
                if (a.getEndDate().getTime() <= a2) {
                    d4 = a.getEndDate().getTime();
                } else {
                    d4 = a2;
                    delta = this.getTime(a, row, column + 1);
                    if (delta < 0L) {
                        delta = 0L;
                    }
                }
            }
        }
        return delta + (d2 - d1 + d4 - d3) / 60000L;
    }

    public final Object getValueAt(int rowNumber, int colIndex) {
        return this.model1.getValueAt(rowNumber, colIndex);
    }

    private GanttWorkingHours getWhVO(int row, int column) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(this.startDate.getTime() + (long)column * 86400000L));
        GanttWorkingHours whVO = null;
        if (cal.get(7) == 1) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getSundayWorkingHours();
        } else if (cal.get(7) == 2) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getMondayWorkingHours();
        } else if (cal.get(7) == 3) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getTuesdayWorkingHours();
        } else if (cal.get(7) == 4) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getWednesdayWorkingHours();
        } else if (cal.get(7) == 5) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getThursdayWorkingHours();
        } else if (cal.get(7) == 6) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getFridayWorkingHours();
        } else if (cal.get(7) == 7) {
            whVO = ((GanttRowVO)this.ganttRows.get(row)).getSaturdayWorkingHours();
        }
        return whVO;
    }

    public void init(String[] columnNames) {
        this.ganttRows.clear();
        boolean lastEnabled = this.model1.isEnabled();
        this.model1 = new Table1Model();
        this.model1.resetModel(columnNames);
        this.model1.setEnabled(lastEnabled);
        lastEnabled = this.model2.isEnabled();
        this.model2 = new Table2Model();
        this.model2.resetModel();
        this.model2.setEnabled(lastEnabled);
        int i = 0;
        while (i < this.table2.getColumnModel().getColumnCount()) {
            this.table2.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidth);
            ++i;
        }
        this.table1.repaint();
        this.table2.repaint();
        if (columnNames.length == 0) {
            this.splitPane.setDividerLocation(0);
        } else if (this.splitPane.getDividerLocation() == 0) {
            this.splitPane.setDividerLocation(200);
        }
    }

    private void init() {
        this.init(new String[0]);
    }

    public final boolean isAutoLoadData() {
        return this.autoLoadData;
    }

    public final boolean isEnableDelete() {
        return this.enableDelete;
    }

    public final boolean isEnableEdit() {
        return this.enableEdit;
    }

    public final boolean isEnableInsert() {
        return this.enableInsert;
    }

    public final boolean isGanttEnabled() {
        return this.model2.isEnabled();
    }

    public final boolean isGridEnabled() {
        return this.model1.isEnabled();
    }

    public final boolean isShowDescription() {
        return this.showDescription;
    }

    public final boolean isShowTime() {
        return this.showTime;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.splitPane.setOrientation(1);
        this.splitPane.setDividerSize(1);
        this.table2.setAutoResizeMode(0);
        this.scrollPane1.setHorizontalScrollBarPolicy(32);
        this.scrollPane2.setHorizontalScrollBarPolicy(32);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.scrollPane1, "top");
        this.splitPane.add((Component)this.scrollPane2, "bottom");
        this.scrollPane2.getViewport().add((Component)this.table2, null);
        this.scrollPane1.getViewport().add((Component)this.table1, null);
        this.splitPane.setDividerLocation(150);
    }

    public void reloadData() {
        this.ganttRows.clear();
        this.table1.repaint();
        this.table2.repaint();
        Response res = this.ganttDataLocator.loadData(this.ganttParameters);
        if (res.isError()) {
            OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Error while loading data") + ":\n" + ClientSettings.getInstance().getResources().getResource(res.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
        } else {
            List rows = ((VOListResponse)res).getRows();
            GanttRowVO vo = null;
            int i = 0;
            while (i < rows.size()) {
                vo = (GanttRowVO)rows.get(i);
                this.addRow(vo);
                ++i;
            }
        }
    }

    public final void removeAppointmentChangeListener(AppointmentChangeListener listener) {
        this.appointmentChangeListeners.remove(listener);
    }

    public final void setAutoLoadData(boolean autoLoadData) {
        this.autoLoadData = autoLoadData;
    }

    public final void setColumnWidth(int width) {
        this.columnWidth = this.columnWidth;
        int i = 0;
        while (i < this.table2.getColumnModel().getColumnCount()) {
            this.table2.getColumnModel().getColumn(i).setPreferredWidth(this.columnWidth);
            ++i;
        }
        this.table2.repaint();
    }

    public final void setDividerLocation(int location) {
        this.splitPane.setDividerLocation(location);
    }

    public final void setEnableDelete(boolean enableDelete) {
        this.enableDelete = enableDelete;
    }

    public final void setEnableEdit(boolean enableEdit) {
        this.enableEdit = enableEdit;
    }

    public final void setEnableInsert(boolean enableInsert) {
        this.enableInsert = enableInsert;
    }

    public final void setEndDate(Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.endDate = cal.getTime();
        this.init(this.model1.getColumnNames());
    }

    public final void setGanttDataLocator(GanttDataLocator ganttDataLocator) {
        this.ganttDataLocator = ganttDataLocator;
    }

    public final void setGanttEnabled(boolean enabled) {
        this.model2.setEnabled(enabled);
        this.table2.repaint();
    }

    public final void setGanttParameters(Map ganttParameters) {
        this.ganttParameters = ganttParameters;
    }

    public final void setGridColumnVisible(int columnIndex, boolean visible) {
        if (!visible) {
            this.table1.getColumnModel().removeColumn(this.table1.getColumnModel().getColumn(columnIndex));
            this.visibility.add(new Integer(columnIndex));
        }
    }

    public final void setGridColumnWidth(int columnIndex, int width) {
        this.table1.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
        this.preferredSize.put(new Integer(columnIndex), new Integer(width));
    }

    public final void setGridEnabled(boolean enabled) {
        this.model1.setEnabled(enabled);
        if (enabled) {
            this.table1.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
        } else {
            this.table1.setBackground(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
        }
        this.table1.repaint();
    }

    public final void setRowHeight(int height) {
        this.table1.setRowHeight(height);
        this.table2.setRowHeight(height);
    }

    public final void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    public final void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public final void setStartDate(Date startDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.startDate = cal.getTime();
        this.init(this.model1.getColumnNames());
    }

    public class GanttColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    OldAppointmentCallback {
        private Appointment appointment;
        private Calendar cal;
        private boolean isLeftMouseButtonPressed;
        private boolean isSelected;
        private GanttCell label;
        private int lastCellIndex;
        private String lastDescr;
        private int lastRow;
        private long lastX;
        private JTable table;
        private ArrayList value;

        public GanttColumnEditor() {
            this.label = new GanttCell();
            this.table = null;
            this.value = null;
            this.isLeftMouseButtonPressed = false;
            this.lastX = -1L;
            this.lastCellIndex = -1;
            this.isSelected = false;
            this.cal = Calendar.getInstance();
            this.lastDescr = null;
            this.lastRow = -1;
            this.appointment = null;
            this.label.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ GanttColumnEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent e) {
                    if (!GanttColumnEditor.access$1300(this.this$1).getModel().isCellEditable(0, 0)) {
                        return;
                    }
                    GanttColumnEditor.access$1402(this.this$1, SwingUtilities.isLeftMouseButton(e));
                    GanttColumnEditor.access$1502(this.this$1, e.getX());
                }

                public void mouseReleased(MouseEvent e) {
                    if (!GanttColumnEditor.access$1300(this.this$1).getModel().isCellEditable(0, 0)) {
                        return;
                    }
                    if (GanttColumnEditor.access$1400(this.this$1)) {
                        long width1 = 86400000L;
                        long m1 = 0L;
                        GanttWorkingHours whVO1 = GanttControl.access$700(GanttColumnEditor.access$1800(this.this$1), GanttColumnEditor.access$1600(this.this$1), GanttColumnEditor.access$1700(this.this$1));
                        if (whVO1 != null) {
                            width1 = (whVO1.getMorningEndHour() != null ? whVO1.getMorningEndHour().getTime() - whVO1.getMorningStartHour().getTime() : 0L) + (whVO1.getAfternoonEndHour() != null ? whVO1.getAfternoonEndHour().getTime() - whVO1.getAfternoonStartHour().getTime() : 0L);
                            GanttColumnEditor.access$1900(this.this$1).setTime(whVO1.getMorningStartHour());
                            Calendar calendar = GanttColumnEditor.access$1900(this.this$1);
                            GanttColumnEditor.access$1900(this.this$1);
                            m1 = calendar.get(11) * 3600000;
                        }
                        int currentColIndex = (int)((long)e.getX() + (long)GanttColumnEditor.access$1700(this.this$1) * (long)GanttColumnEditor.access$2000(this.this$1).getWidth()) / GanttColumnEditor.access$2000(this.this$1).getWidth();
                        long width2 = 86400000L;
                        long m2 = 0L;
                        GanttWorkingHours whVO2 = GanttControl.access$700(GanttColumnEditor.access$1800(this.this$1), GanttColumnEditor.access$1600(this.this$1), currentColIndex);
                        if (whVO2 != null) {
                            width2 = (whVO2.getMorningEndHour() != null ? whVO2.getMorningEndHour().getTime() - whVO2.getMorningStartHour().getTime() : 0L) + (whVO2.getAfternoonEndHour() != null ? whVO2.getAfternoonEndHour().getTime() - whVO2.getAfternoonStartHour().getTime() : 0L);
                            GanttColumnEditor.access$1900(this.this$1).setTime(whVO2.getMorningStartHour());
                            Calendar calendar = GanttColumnEditor.access$1900(this.this$1);
                            GanttColumnEditor.access$1900(this.this$1);
                            m2 = calendar.get(11) * 3600000;
                        }
                        long x = 0L;
                        x = e.getX() > 0 ? (long)(e.getX() % GanttColumnEditor.access$2000(this.this$1).getWidth()) : (long)(GanttColumnEditor.access$2000(this.this$1).getWidth() - -e.getX() % GanttColumnEditor.access$2000(this.this$1).getWidth());
                        if (GanttColumnEditor.access$2100(this.this$1) != null && GanttColumnEditor.access$1500(this.this$1) != (long)e.getX()) {
                            if (GanttColumnEditor.access$1500(this.this$1) < (long)e.getX()) {
                                Appointment a;
                                boolean exists = false;
                                long t1 = GanttControl.access$300(GanttColumnEditor.access$1800(this.this$1)).getTime() + 86400000L * (long)GanttColumnEditor.access$1700(this.this$1) + m1 + width1 * GanttColumnEditor.access$1500(this.this$1) / (long)GanttColumnEditor.access$2000(this.this$1).getWidth();
                                long t2 = GanttControl.access$300(GanttColumnEditor.access$1800(this.this$1)).getTime() + 86400000L * (long)currentColIndex + m2 + width2 * x / (long)GanttColumnEditor.access$2000(this.this$1).getWidth();
                                int i = 0;
                                while (i < GanttColumnEditor.access$2100(this.this$1).size()) {
                                    a = (Appointment)GanttColumnEditor.access$2100(this.this$1).get(i);
                                    Appointment olda = (Appointment)a.clone();
                                    if (a.getStartDate().getTime() <= t1 && t1 <= a.getEndDate().getTime()) {
                                        if (GanttControl.access$400(GanttColumnEditor.access$1800(this.this$1)) && a.isEnableEdit()) {
                                            a.setEndDate(new Timestamp(t2));
                                            a.setDuration(new BigDecimal((double)GanttControl.access$500(GanttColumnEditor.access$1800(this.this$1), a, GanttColumnEditor.access$1600(this.this$1), GanttColumnEditor.access$1700(this.this$1))));
                                            GanttColumnEditor.access$1800(this.this$1).fireAppointmentChangedEvent(GanttColumnEditor.access$1800((GanttColumnEditor)this.this$1).table2.getSelectedRow(), olda, a);
                                        }
                                        exists = true;
                                        break;
                                    }
                                    ++i;
                                }
                                if (!exists && GanttControl.access$000(GanttColumnEditor.access$1800(this.this$1))) {
                                    try {
                                        GanttRowVO ganttRow = (GanttRowVO)GanttControl.access$200(GanttColumnEditor.access$1800(this.this$1)).get(GanttColumnEditor.access$1600(this.this$1));
                                        a = (Appointment)ganttRow.getAppointmentClass().newInstance();
                                        a.setDescription("");
                                        a.setStartDate(new Timestamp(t1));
                                        a.setEndDate(new Timestamp(t2));
                                        a.setDuration(new BigDecimal((double)GanttControl.access$500(GanttColumnEditor.access$1800(this.this$1), a, GanttColumnEditor.access$1600(this.this$1), GanttColumnEditor.access$1700(this.this$1))));
                                        GanttColumnEditor.access$1800(this.this$1).fireNewAppointmentEvent(GanttColumnEditor.access$1800((GanttColumnEditor)this.this$1).table2.getSelectedRow(), a);
                                        GanttColumnEditor.access$2100(this.this$1).add(a);
                                    }
                                    catch (Throwable ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            } else {
                                long t2 = GanttControl.access$300(GanttColumnEditor.access$1800(this.this$1)).getTime() + 86400000L * (long)currentColIndex + m2 + width2 * x / (long)GanttColumnEditor.access$2000(this.this$1).getWidth();
                                int i = 0;
                                while (i < GanttColumnEditor.access$2100(this.this$1).size()) {
                                    Appointment a = (Appointment)GanttColumnEditor.access$2100(this.this$1).get(i);
                                    Appointment olda = (Appointment)a.clone();
                                    if (a.getStartDate().getTime() <= t2 && t2 <= a.getEndDate().getTime()) {
                                        if (!GanttControl.access$400(GanttColumnEditor.access$1800(this.this$1)) || !a.isEnableEdit()) break;
                                        a.setEndDate(new Timestamp(t2));
                                        if (a.getStartDate().getTime() >= a.getEndDate().getTime() && GanttControl.access$600(GanttColumnEditor.access$1800(this.this$1)) && a.isEnableDelete()) {
                                            GanttRowVO ganttRow = (GanttRowVO)GanttControl.access$200(GanttColumnEditor.access$1800(this.this$1)).get(GanttColumnEditor.access$1600(this.this$1));
                                            ganttRow.getAppointments().remove(a);
                                            GanttColumnEditor.access$1800(this.this$1).fireAppointmentDeletedEvent(GanttColumnEditor.access$1800((GanttColumnEditor)this.this$1).table2.getSelectedRow(), a);
                                            break;
                                        }
                                        GanttColumnEditor.access$1800(this.this$1).fireAppointmentChangedEvent(GanttColumnEditor.access$1800((GanttColumnEditor)this.this$1).table2.getSelectedRow(), olda, a);
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (GanttColumnEditor.access$1300(this.this$1) != null) {
                                GanttColumnEditor.access$1300(this.this$1).editingStopped(null);
                            }
                            GanttColumnEditor.access$1800((GanttColumnEditor)this.this$1).table2.repaint();
                        }
                    }
                    GanttColumnEditor.access$1402(this.this$1, false);
                }
            });
        }

        static /* synthetic */ JTable access$1300(GanttColumnEditor x0) {
            return x0.table;
        }

        static /* synthetic */ boolean access$1400(GanttColumnEditor x0) {
            return x0.isLeftMouseButtonPressed;
        }

        static /* synthetic */ boolean access$1402(GanttColumnEditor x0, boolean x1) {
            x0.isLeftMouseButtonPressed = x1;
            return x0.isLeftMouseButtonPressed;
        }

        static /* synthetic */ long access$1500(GanttColumnEditor x0) {
            return x0.lastX;
        }

        static /* synthetic */ long access$1502(GanttColumnEditor x0, long x1) {
            x0.lastX = x1;
            return x0.lastX;
        }

        static /* synthetic */ int access$1600(GanttColumnEditor x0) {
            return x0.lastRow;
        }

        static /* synthetic */ int access$1700(GanttColumnEditor x0) {
            return x0.lastCellIndex;
        }

        static /* synthetic */ GanttControl access$1800(GanttColumnEditor x0) {
            return x0.GanttControl.this;
        }

        static /* synthetic */ Calendar access$1900(GanttColumnEditor x0) {
            return x0.cal;
        }

        static /* synthetic */ GanttCell access$2000(GanttColumnEditor x0) {
            return x0.label;
        }

        static /* synthetic */ ArrayList access$2100(GanttColumnEditor x0) {
            return x0.value;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public Appointment getLastAppointment() {
            return this.appointment;
        }

        public String getLastDescr() {
            return this.lastDescr;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.table = table;
            if (row != this.lastRow) {
                this.lastDescr = null;
                this.lastRow = row;
            }
            long width = 86400000L;
            this.cal.setTime(new Date(GanttControl.this.startDate.getTime() + (long)column * 86400000L));
            GanttWorkingHours whVO = GanttControl.this.getWhVO(row, column);
            if (whVO != null) {
                width = (whVO.getMorningEndHour() != null ? whVO.getMorningEndHour().getTime() - whVO.getMorningStartHour().getTime() : 0L) + (whVO.getAfternoonEndHour() != null ? whVO.getAfternoonEndHour().getTime() - whVO.getAfternoonStartHour().getTime() : 0L);
            }
            this.value = (ArrayList)value;
            this.isSelected = isSelected;
            this.lastCellIndex = table.convertColumnIndexToModel(column);
            long m1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L;
            long m2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L;
            long a1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + 86400000L;
            long a2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + 86400000L;
            if (whVO != null) {
                if (whVO.getMorningStartHour() != null) {
                    this.cal.setTime(whVO.getMorningStartHour());
                    m1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 0L);
                }
                if (whVO.getMorningEndHour() != null) {
                    this.cal.setTime(whVO.getMorningEndHour());
                    m2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 0L);
                }
                if (whVO.getAfternoonStartHour() != null) {
                    this.cal.setTime(whVO.getAfternoonStartHour());
                    a1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 86400000L);
                }
                if (whVO.getAfternoonEndHour() != null) {
                    this.cal.setTime(whVO.getAfternoonEndHour());
                    a2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 86400000L);
                }
            }
            this.label.setAppointments((ArrayList)value, GanttControl.this.startDate.getTime() + (long)column * 86400000L, GanttControl.this.startDate.getTime() + ((long)column + 1L) * 86400000L, width, m1, m2, a1, a2, row, this, column);
            this.label.repaint();
            return this.label;
        }

        public void setLastAppointment(Appointment appointment) {
            this.appointment = appointment;
        }

        public void setLastDescr(String lastDescr) {
            this.lastDescr = lastDescr;
        }
    }

    class GanttCell
    extends JPanel {
        private long a1;
        private long a2;
        private ArrayList appointments = new ArrayList();
        private OldAppointmentCallback callback;
        private int column;
        private long m1;
        private long m2;
        private int row;
        private long t1;
        private long t2;
        private long w;

        GanttCell() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Appointment a = null;
            String time = null;
            if (GanttControl.this.model2.isEnabled()) {
                g.setColor(ClientSettings.GRID_CELL_BACKGROUND);
            } else {
                g.setColor(ClientSettings.GRID_NOT_EDITABLE_CELL_BACKGROUND);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int i = 0;
            while (i < this.appointments.size()) {
                long minutes;
                a = (Appointment)this.appointments.get(i);
                int x = a.getStartDate().getTime() < this.m1 ? 0 : (a.getStartDate().getTime() > this.m2 ? (int)((long)this.getWidth() * (this.m2 - this.m1 + a.getStartDate().getTime() - this.a1) / this.w) : (int)((long)this.getWidth() * (a.getStartDate().getTime() - this.m1) / this.w));
                int len = a.getEndDate().getTime() > this.a2 ? this.getWidth() - x : (a.getEndDate().getTime() <= this.a1 ? (int)((long)this.getWidth() * (a.getEndDate().getTime() - this.m1) / this.w) : (int)((long)this.getWidth() * (this.m2 - this.m1 + a.getEndDate().getTime() - this.a1) / this.w));
                if (a.getBackgroundColor() != null) {
                    g.setColor(a.getBackgroundColor());
                    g.fillRect(x, 0, len, this.getHeight());
                }
                g.setColor(a.getForegroundColor() == null ? Color.black : a.getForegroundColor());
                g.fillRect(x, 20, len, 10);
                int delta = 0;
                if (GanttControl.this.showDescription && a.getDescription() != null && len > 0) {
                    g.setColor(Color.black);
                    if (!a.getDescription().equals(this.callback.getLastDescr())) {
                        this.callback.setLastDescr(a.getDescription());
                        g.drawString(this.callback.getLastDescr().length() > 15 ? this.callback.getLastDescr().substring(0, 15) : this.callback.getLastDescr(), x + 2, 12);
                        delta = g.getFontMetrics().stringWidth(this.callback.getLastDescr().length() > 15 ? this.callback.getLastDescr().substring(0, 15) : this.callback.getLastDescr()) + 2;
                    }
                    if (GanttControl.this.showTime) {
                        g.setColor(Color.black);
                        minutes = GanttControl.this.getTime(a, this.row, this.column);
                        time = minutes / 60L + ":" + minutes % 60L;
                        if (!a.equals(this.callback.getLastAppointment())) {
                            this.callback.setLastAppointment(a);
                            g.drawString("[" + time + "]", x + 2 + delta, 12);
                        }
                    }
                }
                if (!GanttControl.this.showDescription && GanttControl.this.showTime) {
                    g.setColor(Color.black);
                    minutes = GanttControl.this.getTime(a, this.row, this.column);
                    time = minutes / 60L + ":" + minutes % 60L;
                    if (!a.equals(this.callback.getLastAppointment())) {
                        this.callback.setLastAppointment(a);
                        g.drawString("[" + time + "]", x + 2 + delta, 12);
                    }
                }
                ++i;
            }
        }

        public void setAppointments(ArrayList appointments, long t1, long t2, long w, long m1, long m2, long a1, long a2, int row, OldAppointmentCallback callback, int column) {
            this.appointments = appointments;
            this.t1 = t1;
            this.t2 = t2;
            this.w = w;
            this.m1 = m1;
            this.m2 = m2;
            this.a1 = a1;
            this.a2 = a2;
            this.row = row;
            this.callback = callback;
            this.column = column;
        }
    }

    class GanttColumnRenderer
    extends DefaultTableCellRenderer
    implements OldAppointmentCallback {
        private Appointment appointment;
        private Calendar cal;
        private GanttCell canvas;
        private String lastDescr;
        private int lastRow;

        GanttColumnRenderer() {
            this.canvas = new GanttCell();
            this.cal = Calendar.getInstance();
            this.lastDescr = null;
            this.lastRow = -1;
            this.appointment = null;
        }

        public Appointment getLastAppointment() {
            return this.appointment;
        }

        public String getLastDescr() {
            return this.lastDescr;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row != this.lastRow) {
                this.lastDescr = null;
                this.lastRow = row;
            }
            long width = 86400000L;
            this.cal.setTime(new Date(GanttControl.this.startDate.getTime() + (long)column * 86400000L));
            GanttWorkingHours whVO = null;
            if (this.cal.get(7) == 1) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getSundayWorkingHours();
            } else if (this.cal.get(7) == 2) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getMondayWorkingHours();
            } else if (this.cal.get(7) == 3) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getTuesdayWorkingHours();
            } else if (this.cal.get(7) == 4) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getWednesdayWorkingHours();
            } else if (this.cal.get(7) == 5) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getThursdayWorkingHours();
            } else if (this.cal.get(7) == 6) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getFridayWorkingHours();
            } else if (this.cal.get(7) == 7) {
                whVO = ((GanttRowVO)GanttControl.this.ganttRows.get(row)).getSaturdayWorkingHours();
            }
            if (whVO != null) {
                width = (whVO.getMorningEndHour() != null ? whVO.getMorningEndHour().getTime() - whVO.getMorningStartHour().getTime() : 0L) + (whVO.getAfternoonEndHour() != null ? whVO.getAfternoonEndHour().getTime() - whVO.getAfternoonStartHour().getTime() : 0L);
            }
            long m1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L;
            long m2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L;
            long a1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + 86400000L;
            long a2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + 86400000L;
            if (whVO != null) {
                if (whVO.getMorningStartHour() != null) {
                    this.cal.setTime(whVO.getMorningStartHour());
                    m1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 0L);
                }
                if (whVO.getMorningEndHour() != null) {
                    this.cal.setTime(whVO.getMorningEndHour());
                    m2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 0L);
                }
                if (whVO.getAfternoonStartHour() != null) {
                    this.cal.setTime(whVO.getAfternoonStartHour());
                    a1 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 86400000L);
                }
                if (whVO.getAfternoonEndHour() != null) {
                    this.cal.setTime(whVO.getAfternoonEndHour());
                    a2 = GanttControl.this.startDate.getTime() + (long)column * 86400000L + (whVO != null ? (long)this.cal.get(11) * 3600000L + (long)(this.cal.get(12) * 60000) : 86400000L);
                }
            }
            this.canvas.setAppointments((ArrayList)value, GanttControl.this.startDate.getTime() + (long)column * 86400000L, GanttControl.this.startDate.getTime() + ((long)column + 1L) * 86400000L, width, m1, m2, a1, a2, row, this, column);
            return this.canvas;
        }

        public void setLastAppointment(Appointment appointment) {
            this.appointment = appointment;
        }

        public void setLastDescr(String lastDescr) {
            this.lastDescr = lastDescr;
        }
    }

    static interface OldAppointmentCallback {
        public Appointment getLastAppointment();

        public String getLastDescr();

        public void setLastAppointment(Appointment var1);

        public void setLastDescr(String var1);
    }

    class Table2Model
    extends AbstractTableModel {
        private ArrayList dates = new ArrayList();
        private boolean gridEnabled = true;

        public Class getColumnClass(int columnIndex) {
            return GanttControl.this.ganttRows.size() > 0 && this.getValueAt(0, columnIndex) != null ? this.getValueAt(0, columnIndex).getClass() : (class$java$lang$Object == null ? (class$java$lang$Object = GanttControl.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public int getColumnCount() {
            return this.dates.size();
        }

        public String getColumnName(int columnIndex) {
            return (String)this.dates.get(columnIndex);
        }

        public int getRowCount() {
            return GanttControl.this.ganttRows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            long t1 = GanttControl.this.startDate.getTime() + 86400000L * (long)columnIndex;
            long t2 = t1 + 86400000L;
            ArrayList<Appointment> list = new ArrayList<Appointment>();
            HashSet alist = ((GanttRowVO)GanttControl.this.ganttRows.get(rowIndex)).getAppointments();
            Appointment a = null;
            Iterator it = alist.iterator();
            while (it.hasNext()) {
                a = (Appointment)it.next();
                if (!(a.getEndDate().getTime() >= t1 && a.getEndDate().getTime() <= t2 || a.getStartDate().getTime() >= t1 && a.getStartDate().getTime() <= t2) && (a.getStartDate().getTime() > t1 || a.getEndDate().getTime() < t2)) continue;
                list.add(a);
            }
            return list;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.gridEnabled;
        }

        public final boolean isEnabled() {
            return this.gridEnabled;
        }

        public final void resetModel() {
            SimpleDateFormat sdf = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(1));
            Calendar cal = Calendar.getInstance();
            cal.setTime(GanttControl.this.startDate);
            while (cal.getTimeInMillis() <= GanttControl.this.endDate.getTime()) {
                this.dates.add(sdf.format(cal.getTime()));
                cal.set(5, cal.get(5) + 1);
            }
            GanttControl.this.table2.setModel(this);
        }

        public final void setEnabled(boolean enabled) {
            this.gridEnabled = enabled;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            long t1 = GanttControl.this.startDate.getTime() + 86400000L * (long)columnIndex;
            long t2 = t1 + 86400000L;
            ArrayList list = (ArrayList)aValue;
            HashSet alist = ((GanttRowVO)GanttControl.this.ganttRows.get(rowIndex)).getAppointments();
            Appointment a = null;
            Iterator it = alist.iterator();
            HashSet<Appointment> toRemove = new HashSet<Appointment>();
            while (it.hasNext()) {
                a = (Appointment)it.next();
                if (!(a.getEndDate().getTime() >= t1 && a.getEndDate().getTime() <= t2 || a.getStartDate().getTime() >= t1 && a.getStartDate().getTime() <= t2) && (a.getStartDate().getTime() > t1 || a.getEndDate().getTime() < t2)) continue;
                toRemove.add(a);
            }
            alist.removeAll(toRemove);
            alist.addAll(list);
        }
    }

    class Table1Model
    extends AbstractTableModel {
        private String[] cols = new String[0];
        private boolean enabled = true;

        public Class getColumnClass(int columnIndex) {
            return GanttControl.this.ganttRows.size() > 0 && this.getValueAt(0, columnIndex) != null ? this.getValueAt(0, columnIndex).getClass() : (class$java$lang$Object == null ? (class$java$lang$Object = GanttControl.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int columnIndex) {
            return this.cols[columnIndex];
        }

        public final String[] getColumnNames() {
            return this.cols;
        }

        public int getRowCount() {
            return GanttControl.this.ganttRows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((GanttRowVO)GanttControl.this.ganttRows.get(rowIndex)).getLegend()[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.enabled;
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void resetModel(String[] cols) {
            this.cols = cols;
            GanttControl.this.table1.setModel(this);
            Enumeration keys = GanttControl.this.preferredSize.keys();
            Integer colIndex = null;
            while (keys.hasMoreElements()) {
                colIndex = (Integer)keys.nextElement();
                GanttControl.this.table1.getColumnModel().getColumn(colIndex).setPreferredWidth((Integer)GanttControl.this.preferredSize.get(colIndex));
            }
            int i = 0;
            while (i < GanttControl.this.visibility.size()) {
                GanttControl.this.table1.getColumnModel().removeColumn(GanttControl.this.table1.getColumnModel().getColumn((Integer)GanttControl.this.visibility.get(i)));
                ++i;
            }
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ((GanttRowVO)((GanttControl)GanttControl.this).ganttRows.get((int)rowIndex)).getLegend()[columnIndex] = aValue;
        }
    }
}

