/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.importdata.java;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class ImportFromCSV {
    private String format = null;
    SimpleDateFormat sdfdate = null;
    SimpleDateFormat sdfdatetime = null;
    SimpleDateFormat sdftime = null;

    public ImportFromCSV(String format, SimpleDateFormat sdfdate, SimpleDateFormat sdftime, SimpleDateFormat sdfdatetime) {
        this.format = format;
        this.sdfdate = sdfdate;
        this.sdftime = sdftime;
        this.sdfdatetime = sdfdatetime;
    }

    private Object[] decodeRow(ArrayList row, int[] colTypes, ArrayList importAttrColumns) throws Throwable {
        Object[] rowobj = new Object[importAttrColumns.size()];
        int j = 0;
        while (j < importAttrColumns.size()) {
            Object object = rowobj[j] = row.size() > j ? row.get(j).toString() : null;
            if (rowobj[j] != null) {
                if (rowobj[j].equals("")) {
                    rowobj[j] = null;
                } else {
                    if (colTypes[j] == 0) {
                        rowobj[j] = rowobj[j].toString();
                    }
                    if (colTypes[j] == 1) {
                        rowobj[j] = this.sdfdate.parse(rowobj[j].toString());
                    } else if (colTypes[j] == 2) {
                        rowobj[j] = this.sdfdatetime.parse(rowobj[j].toString());
                    } else if (colTypes[j] == 3) {
                        rowobj[j] = this.sdftime.parse(rowobj[j].toString());
                    } else if (colTypes[j] == 4) {
                        rowobj[j] = new Long(rowobj[j].toString());
                    } else if (colTypes[j] == 5) {
                        rowobj[j] = new Double(rowobj[j].toString());
                    } else if (colTypes[j] == 6) {
                        rowobj[j] = rowobj[j];
                    } else if (colTypes[j] == 7) {
                        rowobj[j] = rowobj[j];
                    } else if (colTypes[j] == 8) {
                        rowobj[j] = rowobj[j];
                    } else if (colTypes[j] == 9) {
                        rowobj[j] = new Double(rowobj[j].toString());
                    } else if (colTypes[j] == 10) {
                        rowobj[j] = new Double(rowobj[j].toString());
                    } else if (colTypes[j] == 13) {
                        rowobj[j] = rowobj[j].toString();
                    } else if (colTypes[j] == 14) {
                        rowobj[j] = rowobj[j].toString();
                    } else if (colTypes[j] == 16) {
                        rowobj[j] = new Double(rowobj[j].toString());
                    } else if (colTypes[j] == 17) {
                        rowobj[j] = rowobj[j];
                    }
                }
            }
            ++j;
        }
        return rowobj;
    }

    public ArrayList importData(int[] colTypes, ArrayList importAttrColumns, InputStream in) throws Throwable {
        BufferedInputStream bis = new BufferedInputStream(in);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        char lastchar = '\uffff';
        char dq = '\"';
        char nl = '\n';
        char cr = '\r';
        char delim = ',';
        if (this.format.equals("CSV (;)")) {
            delim = ';';
        }
        StringBuffer sb = new StringBuffer();
        boolean isnewline = false;
        boolean escape = false;
        ArrayList<StringBuffer> row = new ArrayList<StringBuffer>();
        int ichar = -1;
        while ((ichar = bis.read()) != -1) {
            char c = (char)ichar;
            if (c == dq) {
                if (!escape) {
                    escape = true;
                } else if (sb.length() <= 0 || sb.charAt(sb.length() - 1) != dq) {
                    sb.append(dq);
                }
            } else if (c == delim) {
                if (!escape) {
                    row.add(sb);
                    sb = new StringBuffer();
                } else if (sb.length() > 0 && sb.charAt(sb.length() - 1) == dq) {
                    sb = sb.delete(sb.length() - 1, sb.length() - 1);
                    escape = false;
                } else {
                    sb.append(delim);
                }
            } else if (c == nl || c == cr) {
                if (escape) {
                    sb.append(c);
                } else if (lastchar != nl && lastchar != cr) {
                    row.add(sb);
                    sb = new StringBuffer();
                    escape = false;
                    isnewline = true;
                }
            } else {
                sb.append(c);
            }
            if (isnewline) {
                isnewline = false;
                rows.add(this.decodeRow(row, colTypes, importAttrColumns));
                row.clear();
            }
            lastchar = c;
        }
        if (row.size() > 0) {
            rows.add(this.decodeRow(row, colTypes, importAttrColumns));
        }
        return rows;
    }
}

