/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.logger.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.openswing.swing.logger.client.LoggerMethods;

public class ConsoleLogger
implements LoggerMethods {
    public final void debug(String className, String methodName, String debugMessage) {
        System.out.println("\n------------------------\n" + new Date() + " [DEBUG]\n" + "in " + className + "." + methodName + "():\n" + debugMessage + "\n" + "------------------------");
    }

    public final void error(String className, String methodName, String errorMessage, Throwable exception) {
        StackTraceCollector stack = new StackTraceCollector();
        if (exception != null) {
            exception.printStackTrace(new PrintStream(stack));
        }
        System.err.println("\n------------------------\n" + new Date() + " [ERROR]\n" + "in " + className + "." + methodName + "():\n" + errorMessage + "\n" + stack + "\n" + "------------------------");
    }

    public final void info(String className, String methodName, String infoMessage) {
        System.out.println("\n------------------------\n" + new Date() + " [INFO]\n" + "in " + className + "." + methodName + "():\n" + infoMessage + "\n" + "------------------------");
    }

    public final void warn(String className, String methodName, String warnMessage) {
        System.out.println("\n------------------------\n" + new Date() + " [WARN]\n" + "in " + className + "." + methodName + "():\n" + warnMessage + "\n" + "------------------------");
    }

    class StackTraceCollector
    extends OutputStream {
        private StringBuffer stack = new StringBuffer();

        StackTraceCollector() {
        }

        public String toString() {
            return this.stack.toString();
        }

        public void write(int b) throws IOException {
            this.stack.append((char)b);
        }
    }
}

