/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.lookup.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openswing.swing.client.CopyButton;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.FilterButton;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.lookup.client.CustomFilterPanel;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupGridController;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupMapper;
import org.openswing.swing.lookup.client.LookupParent;
import org.openswing.swing.lookup.client.RestoreFocusOnInvalidCodeException;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridStatusPanel;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.client.ListFilterController;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.DateColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.FormattedTextColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.filter.client.FilterPanel;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.tree.client.TreePanel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class LookupController {
    public static final int GRID_AND_FILTER_FRAME = 3;
    public static final int GRID_AND_PANEL_FRAME = 5;
    public static final int GRID_FRAME = 0;
    public static final int ON_INVALID_CODE_CLEAR_CODE = 0;
    public static final int ON_INVALID_CODE_RESTORE_FOCUS = 2;
    public static final int ON_INVALID_CODE_RESTORE_LAST_VALID_CODE = 1;
    public static final int TREE_FRAME = 1;
    public static final int TREE_GRID_AND_FILTER_FRAME = 4;
    public static final int TREE_GRID_AND_PANEL_FRAME = 6;
    public static final int TREE_GRID_FRAME = 2;
    private int allColumnPreferredWidth = 100;
    private boolean allColumnVisible = false;
    private Boolean allColumnsSelectable = null;
    private boolean allowTreeLeafSelectionOnly = true;
    private boolean anchorLastColumn = false;
    public boolean autoFitColumns;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$openswing$swing$message$receive$java$ValueObject;
    private int codeSelectionWindow;
    private boolean codeValid = true;
    private Column[] colProperties;
    private Boolean[] columnsSelectable = null;
    private HashMap comboFilters;
    private CustomFilterPanel customPanel = null;
    private boolean disableFrameClosing = false;
    private Form form = null;
    private Dimension framePreferredSize;
    private String frameTitle = "Code Selection";
    private boolean gridCopyButton = false;
    private boolean gridDeleteButton = false;
    private boolean gridEditButton = false;
    private boolean gridExportButton = false;
    private boolean gridFilterButton = false;
    private boolean gridInsertButton = false;
    private String lastInvalidCode = "";
    private String lastValidCode = null;
    private ArrayList listeners;
    private LookupDataLocator lookupDataLocator = null;
    private LookupFrame lookupFrame = null;
    private LookupGridController lookupGridController;
    private LookupMapper lookupMapper = new LookupMapper();
    private ValueObject lookupVO = null;
    private String lookupValueObjectClassName = null;
    private int maxSortedColumns = 1;
    private int onInvalidCode;
    private int selectedRow = -1;
    private boolean showNavigatorBar;
    private boolean visibleStatusPanel;

    public LookupController() {
        this.framePreferredSize = new Dimension(300, 400);
        this.listeners = new ArrayList();
        this.colProperties = new Column[0];
        this.codeSelectionWindow = ClientSettings.LOOKUP_FRAME_CONTENT;
        this.onInvalidCode = ClientSettings.ON_INVALID_CODE;
        this.lookupGridController = new LookupGridController();
        this.comboFilters = new HashMap();
        this.autoFitColumns = ClientSettings.AUTO_FIT_COLUMNS;
        this.showNavigatorBar = ClientSettings.SHOW_NAVIGATOR_BAR_IN_LOOKUP;
        this.visibleStatusPanel = ClientSettings.VISIBLE_STATUS_PANEL;
    }

    public final void addComboFilter(String attributeName, ListFilterController filter) {
        this.comboFilters.put(attributeName, filter);
    }

    public final void addLookup2ParentLink(String parentAttributeName) {
        this.lookupMapper.addLookup2ParentLink("", parentAttributeName);
    }

    public final void addLookup2ParentLink(String lookupAttributeName, String parentAttributeName) {
        this.lookupMapper.addLookup2ParentLink(lookupAttributeName, parentAttributeName);
    }

    public final void addLookupListener(LookupListener listener) {
        this.listeners.add(listener);
    }

    private void analyzeVO(String prefix, Hashtable vosAlreadyProcessed, ArrayList attributes, ArrayList getterMethods, Class clazz) throws Throwable {
        Integer num = (Integer)vosAlreadyProcessed.get(clazz);
        if (num == null) {
            num = new Integer(0);
        }
        if ((num = new Integer(num + 1)) > ClientSettings.MAX_NR_OF_LOOPS_IN_ANALYZE_VO) {
            return;
        }
        vosAlreadyProcessed.put(clazz, num);
        String attributeName = null;
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            if ((methods[i].getName().startsWith("get") || methods[i].getName().startsWith("is")) && methods[i].getParameterTypes().length == 0 && (methods[i].getReturnType().equals(class$java$lang$String == null ? LookupController.class$("java.lang.String") : class$java$lang$String) || methods[i].getReturnType().equals(class$java$math$BigDecimal == null ? LookupController.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || methods[i].getReturnType().equals(class$java$util$Date == null ? LookupController.class$("java.util.Date") : class$java$util$Date) || methods[i].getReturnType().equals(class$java$sql$Date == null ? LookupController.class$("java.sql.Date") : class$java$sql$Date) || methods[i].getReturnType().equals(class$java$sql$Timestamp == null ? LookupController.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || methods[i].getReturnType().equals(class$java$lang$Integer == null ? LookupController.class$("java.lang.Integer") : class$java$lang$Integer) || methods[i].getReturnType().equals(class$java$lang$Long == null ? LookupController.class$("java.lang.Long") : class$java$lang$Long) || methods[i].getReturnType().equals(class$java$lang$Double == null ? LookupController.class$("java.lang.Double") : class$java$lang$Double) || methods[i].getReturnType().equals(class$java$lang$Float == null ? LookupController.class$("java.lang.Float") : class$java$lang$Float) || methods[i].getReturnType().equals(class$java$lang$Short == null ? LookupController.class$("java.lang.Short") : class$java$lang$Short) || methods[i].getReturnType().equals(Integer.TYPE) || methods[i].getReturnType().equals(Long.TYPE) || methods[i].getReturnType().equals(Double.TYPE) || methods[i].getReturnType().equals(Float.TYPE) || methods[i].getReturnType().equals(Short.TYPE) || methods[i].getReturnType().equals(class$java$lang$Boolean == null ? LookupController.class$("java.lang.Boolean") : class$java$lang$Boolean))) {
                attributeName = methods[i].getName().startsWith("get") ? methods[i].getName().substring(3) : methods[i].getName().substring(2);
                if (attributeName.length() > 1) {
                    attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
                }
                attributes.add(prefix + attributeName);
                getterMethods.add(methods[i]);
            } else if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes().length == 0 && (class$org$openswing$swing$message$receive$java$ValueObject == null ? LookupController.class$("org.openswing.swing.message.receive.java.ValueObject") : class$org$openswing$swing$message$receive$java$ValueObject).isAssignableFrom(methods[i].getReturnType())) {
                attributeName = methods[i].getName().substring(3);
                if (attributeName.length() > 1) {
                    attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
                }
                this.analyzeVO(prefix + attributeName + ".", vosAlreadyProcessed, attributes, getterMethods, methods[i].getReturnType());
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private boolean createLookupGrid(JFrame parentFrame, LookupParent lookupParent, GridDataLocator dataLocator) {
        this.fireLookupActionEvent(lookupParent.getValueObject());
        this.selectedRow = -1;
        if (this.lookupValueObjectClassName == null) {
            Logger.error(this.getClass().getName(), "createLookupGrid", "You must set 'lookupValueObjectClassName' property", null);
            return false;
        }
        try {
            if (this.lookupFrame != null) {
                this.lookupFrame.setVisible(false);
                this.lookupFrame.dispose();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            GridStatusPanel statusPanel = new GridStatusPanel();
            Grids table = new Grids(null, 0, true, this.lookupValueObjectClassName, this.colProperties, this.lookupGridController, statusPanel, dataLocator, new HashMap(), true, new ArrayList(), this.anchorLastColumn, 0, false, false, null, this.comboFilters, ClientSettings.HEADER_HEIGHT, false, false, 0);
            this.lookupGridController.init(this, lookupParent, table.getVOListTableModel(), table);
            table.setMaxSortedColumns(this.maxSortedColumns);
            this.lookupFrame = new LookupGridFrame(parentFrame, this.frameTitle, table, statusPanel);
            this.lookupFrame.setSize(this.framePreferredSize);
            table.reload();
            ClientUtils.centerDialog(parentFrame, this.lookupFrame);
            this.lookupFrame.setVisible(true);
            return true;
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "createLookupGrid", "Error while creating lookup grid frame.", ex);
            return false;
        }
    }

    private boolean createLookupGrid(JFrame parentFrame, LookupParent lookupParent) {
        return this.createLookupGrid(parentFrame, lookupParent, new GridDataLocator(){

            public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                return LookupController.this.lookupDataLocator.loadData(action, startIndex, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType);
            }
        });
    }

    private boolean createLookupTree(JFrame parentFrame, final LookupParent lookupParent) {
        this.fireLookupActionEvent(lookupParent.getValueObject());
        if (this.lookupValueObjectClassName == null) {
            Logger.error(this.getClass().getName(), "createLookupTree", "You must set 'lookupValueObjectClassName' property", null);
            return false;
        }
        try {
            if (this.lookupFrame != null) {
                this.lookupFrame.setVisible(false);
                this.lookupFrame.dispose();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            TreeController container = new TreeController(){

                public void doubleClick(DefaultMutableTreeNode node) {
                    if (LookupController.this.allowTreeLeafSelectionOnly && !node.isLeaf()) {
                        return;
                    }
                    LookupController.this.lookupVO = (ValueObject)node.getUserObject();
                    LookupController.this.updateParentModel(lookupParent);
                    if (!LookupController.this.disableFrameClosing) {
                        LookupController.this.lookupFrame.setVisible(false);
                        LookupController.this.lookupFrame.dispose();
                    }
                }

                public void leftClick(DefaultMutableTreeNode node) {
                }

                public boolean rightClick(DefaultMutableTreeNode node) {
                    return false;
                }
            };
            TreePanel treePanel = new TreePanel();
            treePanel.setTreeController(container);
            treePanel.setTreeDataLocator(this.lookupDataLocator);
            this.lookupFrame = new LookupTreeFrame(parentFrame, this.frameTitle, treePanel);
            this.lookupFrame.setSize(this.framePreferredSize);
            ClientUtils.centerDialog(parentFrame, this.lookupFrame);
            this.lookupFrame.setVisible(true);
            return true;
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "createLookupTree", "Error while creating lookup tree frame.", ex);
            return false;
        }
    }

    private boolean createLookupTreeGrid(JFrame parentFrame, LookupParent lookupParent) {
        this.fireLookupActionEvent(lookupParent.getValueObject());
        this.selectedRow = -1;
        if (this.lookupValueObjectClassName == null) {
            Logger.error(this.getClass().getName(), "createLookupTreeGrid", "You must set 'lookupValueObjectClassName' property", null);
            return false;
        }
        try {
            if (this.lookupFrame != null) {
                this.lookupFrame.setVisible(false);
                this.lookupFrame.dispose();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            GridStatusPanel statusPanel = new GridStatusPanel();
            final Grids table = new Grids(null, 0, true, this.lookupValueObjectClassName, this.colProperties, this.lookupGridController, statusPanel, new GridDataLocator(){

                public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                    return LookupController.this.lookupDataLocator.loadData(action, startIndex, filteredColumns, currentSortedColumns, currentSortedVersusColumns, valueObjectType);
                }
            }, new HashMap(), true, new ArrayList(), this.anchorLastColumn, 0, false, false, null, this.comboFilters, ClientSettings.HEADER_HEIGHT, false, false, 0);
            this.lookupGridController.init(this, lookupParent, table.getVOListTableModel(), table);
            TreeController treeContainer = new TreeController(){

                public void doubleClick(DefaultMutableTreeNode node) {
                }

                public void leftClick(DefaultMutableTreeNode node) {
                    Map map = LookupController.this.lookupDataLocator.getLookupFrameParams();
                    map.put("TREE_FILTER", node.getUserObject());
                    table.reload();
                }

                public boolean rightClick(DefaultMutableTreeNode node) {
                    return false;
                }
            };
            TreePanel treePanel = new TreePanel();
            treePanel.setTreeController(treeContainer);
            treePanel.setTreeDataLocator(this.lookupDataLocator);
            this.lookupFrame = new LookupTreeGridFrame(parentFrame, this.frameTitle, treePanel, table, statusPanel);
            this.lookupFrame.setSize(this.framePreferredSize);
            ClientUtils.centerDialog(parentFrame, this.lookupFrame);
            this.lookupFrame.setVisible(true);
            return true;
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "createLookupTreeGrid", "Error while creating lookup tree grid frame.", ex);
            return false;
        }
    }

    private void createVoidLookupVO() {
        try {
            Enumeration lookupAttributes = this.lookupMapper.getLookupChangedAttributes();
            int mappingCount = 0;
            boolean setToNull = false;
            while (lookupAttributes.hasMoreElements()) {
                String lookupAttributeName = (String)lookupAttributes.nextElement();
                ++mappingCount;
                if (lookupAttributeName.length() != 0) continue;
                setToNull = true;
            }
            boolean bl = setToNull = setToNull && mappingCount == 1;
            if (setToNull) {
                this.lookupVO = null;
            } else if (this.lookupValueObjectClassName == null) {
                Logger.error(this.getClass().getName(), "createVoidLookupVO", "Error while creating lookup value object: 'lookupValueObjectClassName' property is null.", null);
            } else {
                this.lookupVO = (ValueObject)Class.forName(this.lookupValueObjectClassName).newInstance();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.lookupVO = null;
        }
        catch (Error er) {
            er.printStackTrace();
            this.lookupVO = null;
        }
    }

    public final void doubleClick(int rowNumber, LookupParent lookupParent) {
        this.selectedRow = rowNumber;
        this.lookupVO = this.lookupFrame.getTable().getVOListTableModel().getObjectForRow(this.selectedRow);
        this.updateParentModel(lookupParent);
        if (!this.disableFrameClosing) {
            this.lookupFrame.setVisible(false);
            this.lookupFrame.dispose();
        }
        this.codeValid = true;
    }

    private final void fireCodeChangedEvent(ValueObject parentVO) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((LookupListener)this.listeners.get(i)).codeChanged(parentVO, this.lookupMapper.getParentChangedAttributes());
            ++i;
        }
    }

    private final void fireCodeValidatedEvent(boolean validated) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((LookupListener)this.listeners.get(i)).codeValidated(validated);
            ++i;
        }
    }

    private void fireForceValidateEvent() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((LookupListener)this.listeners.get(i)).forceValidate();
            ++i;
        }
    }

    private final void fireLookupActionEvent(ValueObject parentVO) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((LookupListener)this.listeners.get(i)).beforeLookupAction(parentVO);
            ++i;
        }
    }

    public final void forceValidate() {
        this.fireForceValidateEvent();
    }

    public final int getAllColumnPreferredWidth() {
        return this.allColumnPreferredWidth;
    }

    public final int getCodeSelectionWindow() {
        return this.codeSelectionWindow;
    }

    public final CustomFilterPanel getCustomPanel() {
        return this.customPanel;
    }

    public final Form getForm() {
        return this.form;
    }

    public final Dimension getFramePreferedSize() {
        return this.framePreferredSize;
    }

    public final String getFrameTitle() {
        return this.frameTitle;
    }

    public final String getLookupAttributeName(String parentAttributeName) {
        String lookupAttribute = this.lookupMapper.getLookupAttributeName(parentAttributeName);
        if (lookupAttribute == null && parentAttributeName.indexOf(".") != -1) {
            lookupAttribute = parentAttributeName.substring(parentAttributeName.indexOf("."));
        }
        return lookupAttribute;
    }

    public final LookupDataLocator getLookupDataLocator() {
        return this.lookupDataLocator;
    }

    public final LookupGridController getLookupGridController() {
        return this.lookupGridController;
    }

    public final LookupListener[] getLookupListeners() {
        return this.listeners.toArray(new LookupListener[this.listeners.size()]);
    }

    public final ValueObject getLookupVO() {
        return this.lookupVO;
    }

    public final String getLookupValueObjectClassName() {
        return this.lookupValueObjectClassName;
    }

    public final int getMaxSortedColumns() {
        return this.maxSortedColumns;
    }

    public final int getOnInvalidCode() {
        return this.onInvalidCode;
    }

    private void initLookupVO(String lookupValueObjectClassName) {
        try {
            ArrayList attributes = new ArrayList();
            ArrayList getterMethods = new ArrayList();
            this.analyzeVO("", new Hashtable(), attributes, getterMethods, Class.forName(lookupValueObjectClassName));
            String attributeName = null;
            this.colProperties = new Column[getterMethods.size()];
            this.columnsSelectable = new Boolean[this.colProperties.length];
            Class<?> colType = null;
            Method getter = null;
            int i = 0;
            while (i < getterMethods.size()) {
                getter = (Method)getterMethods.get(i);
                attributeName = attributes.get(i).toString();
                colType = getter.getReturnType();
                if (colType.equals(class$java$lang$String == null ? LookupController.class$("java.lang.String") : class$java$lang$String)) {
                    this.colProperties[i] = new TextColumn();
                } else if (colType.equals(class$java$lang$Integer == null ? LookupController.class$("java.lang.Integer") : class$java$lang$Integer) || colType.equals(class$java$lang$Long == null ? LookupController.class$("java.lang.Long") : class$java$lang$Long) || colType.equals(class$java$lang$Short == null ? LookupController.class$("java.lang.Short") : class$java$lang$Short) || colType.equals(Short.TYPE) || colType.equals(Integer.TYPE) || colType.equals(Long.TYPE)) {
                    this.colProperties[i] = new IntegerColumn();
                } else if (colType.equals(class$java$math$BigDecimal == null ? LookupController.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || colType.equals(class$java$lang$Double == null ? LookupController.class$("java.lang.Double") : class$java$lang$Double) || colType.equals(class$java$lang$Float == null ? LookupController.class$("java.lang.Float") : class$java$lang$Float) || colType.equals(Double.TYPE) || colType.equals(Float.TYPE)) {
                    this.colProperties[i] = new DecimalColumn();
                } else if (colType.equals(class$java$lang$Boolean == null ? LookupController.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    this.colProperties[i] = new CheckBoxColumn();
                } else if (colType.equals(class$java$util$Date == null ? LookupController.class$("java.util.Date") : class$java$util$Date)) {
                    this.colProperties[i] = new DateColumn();
                } else if (colType.equals(class$java$sql$Date == null ? LookupController.class$("java.sql.Date") : class$java$sql$Date)) {
                    this.colProperties[i] = new DateColumn();
                } else if (colType.equals(class$java$sql$Timestamp == null ? LookupController.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                    this.colProperties[i] = new DateColumn();
                }
                this.colProperties[i].setColumnName(attributeName);
                if (this.colProperties[i].getHeaderColumnName().equals("columnname")) {
                    this.colProperties[i].setHeaderColumnName(String.valueOf(attributeName.charAt(0)).toUpperCase() + attributeName.substring(1));
                }
                this.colProperties[i].setColumnVisible(this.allColumnVisible);
                if (this.allColumnsSelectable != null && this.columnsSelectable[i] == null) {
                    this.colProperties[i].setColumnSelectable(this.allColumnsSelectable);
                }
                this.colProperties[i].setPreferredWidth(this.allColumnPreferredWidth);
                this.colProperties[i].setAutoFitColumn(this.autoFitColumns);
                ++i;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.lookupVO = null;
        }
    }

    public final boolean isAllColumnVisible() {
        return this.allColumnVisible;
    }

    public final Boolean isAllColumnsSelectable() {
        return this.allColumnsSelectable;
    }

    public final boolean isAllowTreeLeafSelectionOnly() {
        return this.allowTreeLeafSelectionOnly;
    }

    public boolean isAnchorLastColumn() {
        return this.anchorLastColumn;
    }

    public final boolean isAutoFitColumns() {
        return this.autoFitColumns;
    }

    public final boolean isCodeValid() {
        return this.codeValid;
    }

    public final boolean isDisableFrameClosing() {
        return this.disableFrameClosing;
    }

    public final boolean isGridCopyButton() {
        return this.gridCopyButton;
    }

    public final boolean isGridDeleteButton() {
        return this.gridDeleteButton;
    }

    public final boolean isGridEditButton() {
        return this.gridEditButton;
    }

    public final boolean isGridExportButton() {
        return this.gridExportButton;
    }

    public final boolean isGridFilterButton() {
        return this.gridFilterButton;
    }

    public final boolean isGridInsertButton() {
        return this.gridInsertButton;
    }

    public final boolean isShowNavigatorBar() {
        return this.showNavigatorBar;
    }

    public final boolean isVisibleStatusPanel() {
        return this.visibleStatusPanel;
    }

    public final void openLookupFrame(JFrame parentFrame, LookupParent lookupParent) {
        if (this.codeSelectionWindow == 0 || this.codeSelectionWindow == 3 || this.codeSelectionWindow == 5) {
            this.createLookupGrid(parentFrame, lookupParent);
        } else if (this.codeSelectionWindow == 1) {
            this.createLookupTree(parentFrame, lookupParent);
        } else if (this.codeSelectionWindow == 2 || this.codeSelectionWindow == 4 || this.codeSelectionWindow == 6) {
            this.createLookupTreeGrid(parentFrame, lookupParent);
        }
    }

    public final void openLookupFrame(JComponent source, LookupParent lookupParent) {
        this.openLookupFrame(ClientUtils.getParentFrame(source), lookupParent);
    }

    public final void removeComboFilter(String attributeName) {
        this.comboFilters.remove(attributeName);
    }

    public final void removeLookupListener(LookupListener listener) {
        this.listeners.remove(listener);
    }

    public final void setAllColumnPreferredWidth(int preferredWidth) {
        this.allColumnPreferredWidth = preferredWidth;
        int i = 0;
        while (i < this.colProperties.length) {
            this.colProperties[i].setPreferredWidth(preferredWidth);
            ++i;
        }
    }

    public final void setAllColumnVisible(boolean visible) {
        this.allColumnVisible = visible;
        int i = 0;
        while (i < this.colProperties.length) {
            this.colProperties[i].setColumnVisible(visible);
            if (this.allColumnsSelectable == null && this.columnsSelectable[i] == null) {
                this.colProperties[i].setColumnSelectable(visible);
            }
            ++i;
        }
    }

    public final void setAllColumnsSelectable(Boolean allColumnsSelectable) {
        this.allColumnsSelectable = allColumnsSelectable;
        if (allColumnsSelectable != null) {
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.columnsSelectable[i] == null) {
                    this.colProperties[i].setColumnSelectable(allColumnsSelectable);
                }
                ++i;
            }
        }
    }

    public final void setAllowTreeLeafSelectionOnly(boolean allowTreeLeafSelectionOnly) {
        this.allowTreeLeafSelectionOnly = allowTreeLeafSelectionOnly;
    }

    public void setAnchorLastColumn(boolean anchorLastColumn) {
        this.anchorLastColumn = anchorLastColumn;
    }

    public final void setAutoFitColumns(boolean autoFitColumns) {
        this.autoFitColumns = autoFitColumns;
    }

    public final void setCodeSelectionWindow(int codeSelectionWindow) {
        this.codeSelectionWindow = codeSelectionWindow;
    }

    public final void setColumnEditableOnEdit(String lookupAttributeName, boolean editable) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setEditableOnEdit(editable);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setColumnEditableOnEdit", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setColumnEditableOnInsert(String lookupAttributeName, boolean editable) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setEditableOnInsert(editable);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setColumnEditableOnInsert", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setColumnRequired(String lookupAttributeName, boolean required) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setColumnRequired(required);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setColumnRequired", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setColumnTextAlignment(String lookupAttributeName, int alignement) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setTextAlignment(alignement);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setColumnTextAlignment", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setCustomPanel(CustomFilterPanel customPanel) {
        this.customPanel = customPanel;
    }

    public final void setDisableFrameClosing(boolean disableFrameClosing) {
        this.disableFrameClosing = disableFrameClosing;
    }

    public final void setDomainColumn(String lookupAttributeName, String domainId) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                Column oldCol = this.colProperties[i];
                this.colProperties[i] = new ComboColumn();
                ((ComboColumn)this.colProperties[i]).setColumnName(lookupAttributeName);
                ((ComboColumn)this.colProperties[i]).setPreferredWidth(oldCol.getPreferredWidth());
                ((ComboColumn)this.colProperties[i]).setColumnVisible(oldCol.isColumnVisible());
                ((ComboColumn)this.colProperties[i]).setColumnSelectable(oldCol.isColumnVisible());
                ((ComboColumn)this.colProperties[i]).setSortingOrder(oldCol.getSortingOrder());
                ((ComboColumn)this.colProperties[i]).setSortVersus(oldCol.getSortVersus());
                ((ComboColumn)this.colProperties[i]).setHeaderColumnName(oldCol.getHeaderColumnName());
                ((ComboColumn)this.colProperties[i]).setDomainId(domainId);
                ((ComboColumn)this.colProperties[i]).setColumnFilterable(oldCol.isColumnFilterable());
                ((ComboColumn)this.colProperties[i]).setColumnSortable(oldCol.isColumnSortable());
                ((ComboColumn)this.colProperties[i]).setTextAlignment(oldCol.getTextAlignment());
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setDomainColumn", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setFilterableColumn(String lookupAttributeName, boolean filterable) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setColumnFilterable(filterable);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setFilterableColumn", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setForm(Form form) {
        if (this.form == null) {
            this.form = form;
        }
    }

    public final void setFormattedTextColumn(String lookupAttributeName, JFormattedTextField.AbstractFormatter formatter) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                Column oldCol = this.colProperties[i];
                this.colProperties[i] = new FormattedTextColumn();
                ((FormattedTextColumn)this.colProperties[i]).setColumnName(lookupAttributeName);
                ((FormattedTextColumn)this.colProperties[i]).setPreferredWidth(oldCol.getPreferredWidth());
                ((FormattedTextColumn)this.colProperties[i]).setColumnVisible(oldCol.isColumnVisible());
                ((FormattedTextColumn)this.colProperties[i]).setColumnSelectable(oldCol.isColumnVisible());
                ((FormattedTextColumn)this.colProperties[i]).setSortingOrder(oldCol.getSortingOrder());
                ((FormattedTextColumn)this.colProperties[i]).setSortVersus(oldCol.getSortVersus());
                ((FormattedTextColumn)this.colProperties[i]).setHeaderColumnName(oldCol.getHeaderColumnName());
                ((FormattedTextColumn)this.colProperties[i]).setFormatter(formatter);
                ((FormattedTextColumn)this.colProperties[i]).setColumnFilterable(oldCol.isColumnFilterable());
                ((FormattedTextColumn)this.colProperties[i]).setColumnSortable(oldCol.isColumnSortable());
                ((FormattedTextColumn)this.colProperties[i]).setTextAlignment(oldCol.getTextAlignment());
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setFormattedTextColumn", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setFramePreferedSize(Dimension framePreferredSize) {
        this.framePreferredSize = framePreferredSize;
    }

    public final void setFrameTitle(String frameTitle) {
        this.frameTitle = frameTitle;
    }

    public final void setGridCopyButton(boolean gridCopyButton) {
        this.gridCopyButton = gridCopyButton;
    }

    public final void setGridDeleteButton(boolean gridDeleteButton) {
        this.gridDeleteButton = gridDeleteButton;
    }

    public final void setGridEditButton(boolean gridEditButton) {
        this.gridEditButton = gridEditButton;
    }

    public final void setGridExportButton(boolean gridExportButton) {
        this.gridExportButton = gridExportButton;
    }

    public final void setGridFilterButton(boolean gridFilterButton) {
        this.gridFilterButton = gridFilterButton;
    }

    public final void setGridInsertButton(boolean gridInsertButton) {
        this.gridInsertButton = gridInsertButton;
    }

    public final void setGroupingEnabledColumn(String lookupAttributeName, boolean groupEnabled) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName) && this.colProperties[i] instanceof DecimalColumn) {
                ((DecimalColumn)this.colProperties[i]).setGrouping(groupEnabled);
                return;
            }
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName) && this.colProperties[i] instanceof IntegerColumn) {
                ((IntegerColumn)this.colProperties[i]).setGrouping(groupEnabled);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setGroupingEnabledColumn", "There no exists a numeric column having the attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "'", null);
    }

    public final void setHeaderColumnName(String lookupAttributeName, String name) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setHeaderColumnName(name);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setHeaderColumnName", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setLookupDataLocator(LookupDataLocator lookupDataLocator) {
        this.lookupDataLocator = lookupDataLocator;
    }

    public final void setLookupGridController(LookupGridController lookupGridController) {
        this.lookupGridController = lookupGridController;
    }

    public final void setLookupValueObjectClassName(String lookupValueObjectClassName) {
        this.lookupValueObjectClassName = lookupValueObjectClassName;
        this.initLookupVO(lookupValueObjectClassName);
    }

    public final void setMaxSortedColumns(int maxSortedColumns) {
        this.maxSortedColumns = maxSortedColumns;
    }

    public final void setOnInvalidCode(int onInvalidCode) {
        this.onInvalidCode = onInvalidCode;
    }

    public final void setPreferredWidthColumn(String lookupAttributeName, int preferredWidth) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setPreferredWidth(preferredWidth);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setPreferredWidthColumn", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setSelectableColumn(String lookupAttributeName, boolean selectable) {
        try {
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                    this.colProperties[i].setColumnSelectable(selectable);
                    this.columnsSelectable[i] = new Boolean(selectable);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setShowNavigatorBar(boolean showNavigatorBar) {
        this.showNavigatorBar = showNavigatorBar;
    }

    public final void setSortableColumn(String lookupAttributeName, boolean sortable) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setColumnSortable(sortable);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setSortableColumn", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setSortedColumn(String lookupAttributeName, String sortVersus) {
        int i = 0;
        while (i < this.colProperties.length) {
            if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                this.colProperties[i].setSortVersus(sortVersus);
                return;
            }
            ++i;
        }
        Logger.error(this.getClass().getName(), "setSortedColumn", "The attribute '" + (lookupAttributeName == null ? "null" : "'" + lookupAttributeName + "'") + "' does not exist.", null);
    }

    public final void setVisibleColumn(String lookupAttributeName, boolean visible) {
        try {
            int visibleIndex = -1;
            int index = -1;
            int i = 0;
            while (i < this.colProperties.length) {
                if (this.colProperties[i].isVisible()) {
                    visibleIndex = i;
                }
                if (this.colProperties[i].getColumnName().equals(lookupAttributeName)) {
                    this.colProperties[i].setColumnVisible(visible);
                    if (this.columnsSelectable[i] == null) {
                        this.colProperties[i].setColumnSelectable(visible);
                    }
                    index = i;
                    break;
                }
                ++i;
            }
            if (visible) {
                if (visibleIndex == -1) {
                    visibleIndex = 0;
                } else if (visibleIndex - 1 < this.colProperties.length) {
                    ++visibleIndex;
                }
                if (index > -1 && index != visibleIndex) {
                    Column infoTemp = this.colProperties[index];
                    this.colProperties[index] = this.colProperties[visibleIndex];
                    this.colProperties[visibleIndex] = infoTemp;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setVisibleStatusPanel(boolean visibleStatusPanel) {
        this.visibleStatusPanel = visibleStatusPanel;
    }

    private void updateParentModel(LookupParent lookupParent) {
        if (this.lookupValueObjectClassName != null && this.lookupMapper != null) {
            try {
                Enumeration lookupAttributes = this.lookupMapper.getLookupChangedAttributes();
                String attrName = null;
                while (lookupAttributes.hasMoreElements()) {
                    String lookupAttributeName = (String)lookupAttributes.nextElement();
                    if (lookupAttributeName.length() == 0) {
                        if (!this.lookupMapper.setParentAttribute(lookupParent, lookupAttributeName, Class.forName(this.lookupValueObjectClassName), this.lookupVO)) {
                            Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting lookup container value object.", null);
                            continue;
                        }
                        if (this.form == null || (attrName = this.lookupMapper.getParentAttributeName(lookupAttributeName)) == null || this.form == null) continue;
                        this.form.pull(attrName);
                        continue;
                    }
                    if (this.lookupVO != null) {
                        String aName = lookupAttributeName;
                        Method getter = null;
                        Class<?> clazz = this.lookupVO.getClass();
                        Object obj = this.lookupVO;
                        while (aName.indexOf(".") != -1) {
                            try {
                                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                            }
                            catch (NoSuchMethodException ex2) {
                                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1, aName.indexOf(".")), new Class[0]);
                            }
                            obj = getter.invoke(obj, new Object[0]);
                            if (obj == null) break;
                            aName = aName.substring(aName.indexOf(".") + 1);
                            clazz = getter.getReturnType();
                        }
                        if (obj != null) {
                            try {
                                getter = clazz.getMethod("get" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
                            }
                            catch (NoSuchMethodException ex2) {
                                getter = clazz.getMethod("is" + aName.substring(0, 1).toUpperCase() + aName.substring(1), new Class[0]);
                            }
                            obj = getter.invoke(obj, new Object[0]);
                        }
                        if (!this.lookupMapper.setParentAttribute(lookupParent, lookupAttributeName, getter.getReturnType(), obj)) {
                            Logger.error(this.getClass().getName(), "updateParentModel", "Error while setting lookup container value object.", null);
                            continue;
                        }
                        if (this.form == null || (attrName = this.lookupMapper.getParentAttributeName(lookupAttributeName)) == null || this.form == null) continue;
                        this.form.pull(attrName);
                        continue;
                    }
                    Logger.error(this.getClass().getName(), "updateParentModel", "Error: lookup value object is null.", null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
            this.fireCodeChangedEvent(lookupParent.getValueObject());
        } else {
            Logger.error(this.getClass().getName(), "updateParentModel", "You must set 'lookupValueObjectClassName' property", null);
        }
    }

    public final void validateCode(JComponent parentComponent, String code, LookupParent lookupParent) throws RestoreFocusOnInvalidCodeException {
        try {
            if (this.lastValidCode == null) {
                this.lastValidCode = lookupParent.getLookupCodeParentValue().toString();
            }
        }
        catch (Exception ex1) {
            this.lastValidCode = "";
        }
        this.fireLookupActionEvent(lookupParent.getValueObject());
        if (code == null || code.trim().length() == 0) {
            this.codeValid = true;
            this.createVoidLookupVO();
            this.updateParentModel(lookupParent);
            this.fireCodeChangedEvent(lookupParent.getValueObject());
            this.fireCodeValidatedEvent(true);
        } else {
            try {
                final Response r = this.lookupDataLocator.validateCode(code);
                if (r == null || !(r instanceof VOListResponse) && !(r instanceof ErrorResponse)) {
                    Logger.error(this.getClass().getName(), "validateCode", "Error while validating lookup code: lookup data locator must always returns an instanceof VOListResponse.", null);
                    return;
                }
                if (!r.isError() && ((VOListResponse)r).getRows().size() == 1) {
                    this.codeValid = true;
                    this.lastValidCode = code;
                    this.lookupVO = (ValueObject)((VOListResponse)r).getRows().get(0);
                    this.updateParentModel(lookupParent);
                    this.fireCodeValidatedEvent(true);
                } else if (!r.isError() && ((VOListResponse)r).getRows().size() > 1) {
                    if (!this.createLookupGrid(ClientUtils.getParentFrame(parentComponent), lookupParent, new GridDataLocator(){

                        public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
                            return r;
                        }
                    })) {
                        this.fireCodeValidatedEvent(false);
                    }
                } else if (this.onInvalidCode == 0) {
                    this.codeValid = true;
                    this.createVoidLookupVO();
                    this.updateParentModel(lookupParent);
                    this.fireCodeChangedEvent(lookupParent.getValueObject());
                    this.fireCodeValidatedEvent(false);
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(parentComponent), ClientSettings.getInstance().getResources().getResource("Code is not correct."), ClientSettings.getInstance().getResources().getResource("Code Validation"), 0);
                } else if (this.onInvalidCode == 1) {
                    OptionPane.showMessageDialog(ClientUtils.getParentFrame(parentComponent), ClientSettings.getInstance().getResources().getResource("Code is not correct."), ClientSettings.getInstance().getResources().getResource("Code Validation"), 0);
                    if (!this.lastValidCode.equals(code)) {
                        this.validateCode(parentComponent, this.lastValidCode, lookupParent);
                    } else {
                        this.validateCode(parentComponent, "", lookupParent);
                    }
                } else {
                    if (this.onInvalidCode == 2) {
                        if (!this.lastInvalidCode.equals(code)) {
                            this.lastInvalidCode = code;
                            OptionPane.showMessageDialog(ClientUtils.getParentFrame(parentComponent), ClientSettings.getInstance().getResources().getResource("Code is not correct."), ClientSettings.getInstance().getResources().getResource("Code Validation"), 0);
                        }
                        this.codeValid = false;
                        throw new RestoreFocusOnInvalidCodeException();
                    }
                    Logger.error(this.getClass().getName(), "validateCode", "Error while validating lookup code: invalid 'onInvalidCode' property value: " + this.onInvalidCode, null);
                }
            }
            catch (RestoreFocusOnInvalidCodeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.createVoidLookupVO();
                this.updateParentModel(lookupParent);
                this.fireCodeChangedEvent(lookupParent.getValueObject());
                this.fireCodeValidatedEvent(false);
                Logger.error(this.getClass().getName(), "validateCode", "Error while validating lookup code.", ex);
            }
        }
    }

    class LookupTreeGridFrame
    extends LookupFrame {
        private TreePanel treePanel;

        public LookupTreeGridFrame(JFrame parentFrame, String title, TreePanel treePanel, Grids table, GridStatusPanel labelPanel) {
            JComponent b;
            super(parentFrame, ClientSettings.getInstance().getResources().getResource(title), true);
            this.treePanel = null;
            this.treePanel = treePanel;
            this.table = table;
            this.getContentPane().setLayout(new BorderLayout());
            JSplitPane split = new JSplitPane(1);
            this.getContentPane().add((Component)split, "Center");
            split.add((Component)new JScrollPane(treePanel), "left");
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            split.add((Component)p, "right");
            split.setDividerLocation(200);
            JSplitPane split2 = new JSplitPane(0);
            split2.setDividerSize(0);
            JPanel gridStatusPanel = new JPanel();
            gridStatusPanel.setLayout(new BorderLayout());
            if (labelPanel != null) {
                labelPanel.setPreferredSize(new Dimension(((LookupController)LookupController.this).framePreferredSize.width, 22));
                if (LookupController.this.visibleStatusPanel) {
                    gridStatusPanel.add((Component)labelPanel, "South");
                }
            }
            gridStatusPanel.add((Component)table, "Center");
            split2.add((Component)gridStatusPanel, "bottom");
            split2.setDividerLocation(0);
            p.add((Component)split2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            treePanel.getTree().addKeyListener(new KeyAdapter(this, p){
                private final /* synthetic */ LookupTreeGridFrame this$1;
                private final /* synthetic */ JPanel val$p;
                {
                    this.this$1 = this$1;
                    this.val$p = val$p;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        this.val$p.getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
                        this.val$p.getActionMap().remove("exitAction");
                        this.this$1.setVisible(false);
                    }
                }
            });
            table.getGrid().addKeyListener(new KeyAdapter(this, p){
                private final /* synthetic */ LookupTreeGridFrame this$1;
                private final /* synthetic */ JPanel val$p;
                {
                    this.this$1 = this$1;
                    this.val$p = val$p;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27 && !this.this$1.table.getGrid().isSearchWindowVisible()) {
                        this.val$p.getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
                        this.val$p.getActionMap().remove("exitAction");
                        this.this$1.setVisible(false);
                    }
                }
            });
            AbstractAction exitAction = new AbstractAction(this, p){
                private final /* synthetic */ LookupTreeGridFrame this$1;
                private final /* synthetic */ JPanel val$p;
                {
                    this.this$1 = this$1;
                    this.val$p = val$p;
                }

                public void actionPerformed(ActionEvent e) {
                    if (!this.this$1.table.getGrid().isSearchWindowVisible()) {
                        this.val$p.getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
                        this.val$p.getActionMap().remove("exitAction");
                        this.this$1.setVisible(false);
                    }
                }
            };
            p.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "exitAction");
            p.getActionMap().put("exitAction", exitAction);
            JPanel topPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            topPanel.setLayout(borderLayout);
            split2.add((Component)topPanel, "top");
            int h = 0;
            if (LookupController.this.codeSelectionWindow == 4) {
                FilterPanel f = new FilterPanel(LookupController.this.colProperties, table, 0);
                f.init();
                topPanel.add((Component)f, "Center");
                h = f.getPreferredSize().height;
            }
            if (LookupController.this.codeSelectionWindow == 6 && LookupController.this.customPanel != null) {
                LookupController.this.customPanel.setLookupGrid(table);
                LookupController.this.customPanel.init();
                topPanel.add((Component)LookupController.this.customPanel, "Center");
                h = ((LookupController)LookupController.this).customPanel.getPreferredSize().height;
            }
            JPanel toolbarPanel = new JPanel();
            FlowLayout flowLayout1 = new FlowLayout(0, 5, 5);
            toolbarPanel.setLayout(flowLayout1);
            if (LookupController.this.gridInsertButton) {
                b = new InsertButton();
                toolbarPanel.add((Component)b, null);
                table.setInsertButton((InsertButton)b);
            }
            if (LookupController.this.gridEditButton) {
                b = new EditButton();
                toolbarPanel.add((Component)b, null);
                table.setEditButton((EditButton)b);
            }
            if (LookupController.this.gridCopyButton) {
                b = new CopyButton();
                toolbarPanel.add((Component)b, null);
                table.setCopyButton((CopyButton)b);
            }
            if (LookupController.this.gridInsertButton || LookupController.this.gridEditButton || LookupController.this.gridCopyButton) {
                SaveButton sb = new SaveButton();
                toolbarPanel.add((Component)sb, null);
                table.setSaveButton(sb);
                ReloadButton rb = new ReloadButton();
                toolbarPanel.add((Component)rb, null);
                table.setReloadButton(rb);
            }
            if (LookupController.this.gridDeleteButton) {
                b = new DeleteButton();
                toolbarPanel.add((Component)b, null);
                table.setDeleteButton((DeleteButton)b);
            }
            if (LookupController.this.gridFilterButton) {
                b = new FilterButton();
                toolbarPanel.add((Component)b, null);
                table.setFilterButton((FilterButton)b);
            }
            if (LookupController.this.gridExportButton) {
                b = new ExportButton();
                toolbarPanel.add((Component)b, null);
                table.setExportButton((ExportButton)b);
            }
            if (LookupController.this.showNavigatorBar) {
                b = new NavigatorBar();
                toolbarPanel.add((Component)b, null);
                table.setNavBar((NavigatorBar)b);
            }
            if (toolbarPanel.getComponentCount() > 0) {
                topPanel.add((Component)toolbarPanel, "South");
                h += toolbarPanel.getPreferredSize().height;
            }
            split2.setDividerLocation(h);
        }
    }

    class LookupTreeFrame
    extends LookupFrame {
        private TreePanel treePanel;

        public LookupTreeFrame(JFrame parentFrame, String title, TreePanel treePanel) {
            super(parentFrame, ClientSettings.getInstance().getResources().getResource(title), true);
            this.treePanel = null;
            this.treePanel = treePanel;
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(treePanel), "Center");
            treePanel.getTree().addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ LookupTreeFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        this.this$1.setVisible(false);
                    }
                }
            });
        }
    }

    class LookupGridFrame
    extends LookupFrame {
        public LookupGridFrame(JFrame parentFrame, String title, Grids table, GridStatusPanel labelPanel) {
            JComponent b;
            super(parentFrame, ClientSettings.getInstance().getResources().getResource(title), true);
            this.setDefaultCloseOperation(2);
            this.table = table;
            this.getContentPane().setLayout(new BorderLayout());
            JPanel p = new JPanel();
            this.getContentPane().add((Component)p, "Center");
            p.setLayout(new GridBagLayout());
            p.setBorder(BorderFactory.createLineBorder(ClientSettings.GRID_FOCUS_BORDER, 2));
            JSplitPane split2 = new JSplitPane(0);
            split2.setDividerSize(0);
            JPanel gridStatusPanel = new JPanel();
            gridStatusPanel.setLayout(new BorderLayout());
            if (labelPanel != null) {
                labelPanel.setPreferredSize(new Dimension(((LookupController)LookupController.this).framePreferredSize.width, 22));
                if (LookupController.this.visibleStatusPanel) {
                    gridStatusPanel.add((Component)labelPanel, "South");
                }
            }
            gridStatusPanel.add((Component)table, "Center");
            split2.add((Component)gridStatusPanel, "bottom");
            split2.setDividerLocation(0);
            p.add((Component)split2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            AbstractAction exitAction = new AbstractAction(this, p){
                private final /* synthetic */ LookupGridFrame this$1;
                private final /* synthetic */ JPanel val$p;
                {
                    this.this$1 = this$1;
                    this.val$p = val$p;
                }

                public void actionPerformed(ActionEvent e) {
                    if (!this.this$1.table.getGrid().isSearchWindowVisible()) {
                        this.val$p.getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
                        this.val$p.getActionMap().remove("exitAction");
                        this.this$1.setVisible(false);
                    }
                }
            };
            p.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "exitAction");
            p.getActionMap().put("exitAction", exitAction);
            table.getGrid().addKeyListener(new KeyAdapter(this, p){
                private final /* synthetic */ LookupGridFrame this$1;
                private final /* synthetic */ JPanel val$p;
                {
                    this.this$1 = this$1;
                    this.val$p = val$p;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27 && !this.this$1.table.getGrid().isSearchWindowVisible()) {
                        this.val$p.getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
                        this.val$p.getActionMap().remove("exitAction");
                        this.this$1.setVisible(false);
                    }
                }
            });
            JPanel topPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            topPanel.setLayout(borderLayout);
            split2.add((Component)topPanel, "top");
            int h = 0;
            if (LookupController.this.codeSelectionWindow == 3) {
                FilterPanel f = new FilterPanel(LookupController.this.colProperties, table, 0);
                f.init();
                topPanel.add((Component)f, "Center");
                h = f.getPreferredSize().height;
            }
            if (LookupController.this.codeSelectionWindow == 5 && LookupController.this.customPanel != null) {
                topPanel.add((Component)LookupController.this.customPanel, "Center");
                LookupController.this.customPanel.setLookupGrid(table);
                LookupController.this.customPanel.init();
                h = ((LookupController)LookupController.this).customPanel.getPreferredSize().height;
            }
            JPanel toolbarPanel = new JPanel();
            FlowLayout flowLayout1 = new FlowLayout(0, 5, 5);
            toolbarPanel.setLayout(flowLayout1);
            if (LookupController.this.gridInsertButton) {
                b = new InsertButton();
                toolbarPanel.add((Component)b, null);
                table.setInsertButton((InsertButton)b);
            }
            if (LookupController.this.gridEditButton) {
                b = new EditButton();
                toolbarPanel.add((Component)b, null);
                table.setEditButton((EditButton)b);
            }
            if (LookupController.this.gridCopyButton) {
                b = new CopyButton();
                toolbarPanel.add((Component)b, null);
                table.setCopyButton((CopyButton)b);
            }
            if (LookupController.this.gridInsertButton || LookupController.this.gridEditButton || LookupController.this.gridCopyButton) {
                SaveButton sb = new SaveButton();
                toolbarPanel.add((Component)sb, null);
                table.setSaveButton(sb);
                ReloadButton rb = new ReloadButton();
                toolbarPanel.add((Component)rb, null);
                table.setReloadButton(rb);
            }
            if (LookupController.this.gridDeleteButton) {
                b = new DeleteButton();
                toolbarPanel.add((Component)b, null);
                table.setDeleteButton((DeleteButton)b);
            }
            if (LookupController.this.gridFilterButton) {
                b = new FilterButton();
                toolbarPanel.add((Component)b, null);
                table.setFilterButton((FilterButton)b);
            }
            if (LookupController.this.gridExportButton) {
                b = new ExportButton();
                toolbarPanel.add((Component)b, null);
                table.setExportButton((ExportButton)b);
            }
            if (LookupController.this.showNavigatorBar) {
                b = new NavigatorBar();
                toolbarPanel.add((Component)b, null);
                table.setNavBar((NavigatorBar)b);
            }
            if (toolbarPanel.getComponentCount() > 0) {
                topPanel.add((Component)toolbarPanel, "South");
                h += toolbarPanel.getPreferredSize().height;
            }
            split2.setDividerLocation(h);
        }
    }

    class LookupFrame
    extends JDialog {
        protected Grids table;

        public LookupFrame(JFrame parent, String title, boolean modal) {
            super(parent, title, modal);
            this.table = null;
        }

        public final Grids getTable() {
            return this.table;
        }
    }
}

