/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.mdi.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.mdi.client.SwitchDialog;
import org.openswing.swing.mdi.client.WindowsList;
import org.openswing.swing.util.client.ClientSettings;

public class WindowMenu
extends JMenu {
    private WindowsList internalFrames;
    private JMenuItem menuWindowCascade;
    private JMenuItem menuWindowCloseAll = new JMenuItem();
    private JMenuItem menuWindowMinimize;
    private JMenuItem menuWindowMinimizeAll;
    private JMenuItem menuWindowSwitch;
    private JMenuItem menuWindowTileH;
    private JMenuItem menuWindowTileV;

    static {
        try {
            UIManager.setLookAndFeel(ClientSettings.LOOK_AND_FEEL_CLASS_NAME);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public WindowMenu() {
        this.internalFrames = new WindowsList();
        this.menuWindowSwitch = new JMenuItem();
        this.menuWindowTileH = new JMenuItem();
        this.menuWindowTileV = new JMenuItem();
        this.menuWindowCascade = new JMenuItem();
        this.menuWindowMinimize = new JMenuItem();
        this.menuWindowMinimizeAll = new JMenuItem();
    }

    public final void addWindow(final JInternalFrame frame) {
        int i = this.updateMnemonics();
        JMenuItem window = new JMenuItem();
        window.setText(i + " " + frame.getTitle());
        if (i < 10) {
            window.setMnemonic(window.getText().charAt(0));
            this.add((Component)window, i);
        }
        this.menuWindowCloseAll.setEnabled(true);
        this.menuWindowSwitch.setEnabled(true);
        this.menuWindowMinimize.setEnabled(true);
        this.menuWindowMinimizeAll.setEnabled(true);
        this.internalFrames.put(frame, window);
        this.menuWindowTileH.setEnabled(this.internalFrames.size() > 1);
        this.menuWindowTileV.setEnabled(this.internalFrames.size() > 1);
        this.menuWindowCascade.setEnabled(this.internalFrames.size() > 1);
        window.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (frame.isIcon()) {
                        frame.setIcon(false);
                    }
                    frame.toFront();
                    frame.setSelected(true);
                }
                catch (Exception ex) {
                    Logger.error(this.getClass().getName(), "addWindow", "Error while setting the internal frame to front", ex);
                }
            }
        });
    }

    public void init() {
        this.removeAll();
        this.setText(ClientSettings.getInstance().getResources().getResource("Window"));
        this.setMnemonic(ClientSettings.getInstance().getResources().getResource("windowmnemonic").charAt(0));
        this.menuWindowCloseAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowCloseAll_actionPerformed(e);
            }
        });
        this.menuWindowCloseAll.setText(ClientSettings.getInstance().getResources().getResource("Close All"));
        this.menuWindowCloseAll.setMnemonic(ClientSettings.getInstance().getResources().getResource("closeallmnemonic").charAt(0));
        this.menuWindowSwitch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowSwitch_actionPerformed(e);
            }
        });
        this.menuWindowSwitch.setText(ClientSettings.getInstance().getResources().getResource("switch") + "...");
        this.menuWindowSwitch.setMnemonic(ClientSettings.getInstance().getResources().getResource("switchmnemonic").charAt(0));
        this.menuWindowTileH.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowTileH_actionPerformed(e);
            }
        });
        this.menuWindowTileH.setText(ClientSettings.getInstance().getResources().getResource("tile horizontally"));
        this.menuWindowTileH.setMnemonic(ClientSettings.getInstance().getResources().getResource("tilehorizontallymnemonic").charAt(0));
        this.menuWindowTileV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowTileV_actionPerformed(e);
            }
        });
        this.menuWindowTileV.setText(ClientSettings.getInstance().getResources().getResource("tile vertically"));
        this.menuWindowTileV.setMnemonic(ClientSettings.getInstance().getResources().getResource("tileverticallymnemonic").charAt(0));
        this.menuWindowCascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowCascade_actionPerformed(e);
            }
        });
        this.menuWindowCascade.setText(ClientSettings.getInstance().getResources().getResource("cascade"));
        this.menuWindowCascade.setMnemonic(ClientSettings.getInstance().getResources().getResource("cascademnemonic").charAt(0));
        this.menuWindowMinimize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowMinimize_actionPerformed(e);
            }
        });
        this.menuWindowMinimize.setText(ClientSettings.getInstance().getResources().getResource("minimize"));
        this.menuWindowMinimize.setMnemonic(ClientSettings.getInstance().getResources().getResource("minimizemnemonic").charAt(0));
        this.menuWindowMinimizeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMenu.this.menuWindowMinimizeAll_actionPerformed(e);
            }
        });
        this.menuWindowMinimizeAll.setText(ClientSettings.getInstance().getResources().getResource("minimize all"));
        this.menuWindowMinimizeAll.setMnemonic(ClientSettings.getInstance().getResources().getResource("minimizeallmnemonic").charAt(0));
        this.add(this.menuWindowSwitch);
        this.add(new JSeparator());
        this.add(this.menuWindowTileH);
        this.add(this.menuWindowTileV);
        this.add(this.menuWindowCascade);
        this.add(this.menuWindowMinimize);
        this.add(this.menuWindowMinimizeAll);
        this.add(this.menuWindowCloseAll);
        this.menuWindowCloseAll.setEnabled(false);
        this.menuWindowSwitch.setEnabled(false);
        this.menuWindowTileH.setEnabled(false);
        this.menuWindowTileV.setEnabled(false);
        this.menuWindowCascade.setEnabled(false);
        this.menuWindowMinimize.setEnabled(false);
        this.menuWindowMinimizeAll.setEnabled(false);
    }

    public void menuWindowCascade_actionPerformed(ActionEvent e) {
        InternalFrame frame = null;
        Enumeration en = this.internalFrames.keys();
        MDIFrame.getInstance();
        int nWindows = MDIFrame.getDesktopDimension().width / 20;
        int max = Math.min(nWindows, this.internalFrames.size());
        int x = 0;
        MDIFrame.getInstance();
        int w = MDIFrame.getDesktopDimension().width - 20 * max;
        MDIFrame.getInstance();
        int h = MDIFrame.getDesktopDimension().height - 20 * max;
        int i = 0;
        while (i < max) {
            frame = (InternalFrame)en.nextElement();
            frame.setSize(new Dimension(w, h));
            frame.setLocation(x, x);
            x += 20;
            frame.toFront();
            ++i;
        }
    }

    public void menuWindowCloseAll_actionPerformed(ActionEvent e) {
        boolean i = false;
        while (this.getMenuComponentCount() > 8) {
            this.remove(0);
        }
        InternalFrame frame = null;
        Enumeration en = this.internalFrames.keys();
        while (en.hasMoreElements()) {
            frame = (InternalFrame)en.nextElement();
            try {
                frame.closeFrame();
            }
            catch (PropertyVetoException ex) {
            }
        }
        this.menuWindowCloseAll.setEnabled(false);
        this.menuWindowSwitch.setEnabled(false);
        this.menuWindowTileH.setEnabled(false);
        this.menuWindowTileV.setEnabled(false);
        this.menuWindowCascade.setEnabled(false);
        this.menuWindowMinimize.setEnabled(false);
        this.menuWindowMinimizeAll.setEnabled(false);
        this.revalidate();
    }

    public void menuWindowMinimizeAll_actionPerformed(ActionEvent e) {
        try {
            InternalFrame frame = null;
            Enumeration en = this.internalFrames.keys();
            while (en.hasMoreElements()) {
                frame = (InternalFrame)en.nextElement();
                frame.setIcon(true);
            }
        }
        catch (Exception ex) {
        }
    }

    public void menuWindowMinimize_actionPerformed(ActionEvent e) {
        try {
            if (MDIFrame.getSelectedFrame() != null && !MDIFrame.getSelectedFrame().isIcon()) {
                MDIFrame.getSelectedFrame().setIcon(true);
            }
        }
        catch (Exception ex) {
        }
    }

    public void menuWindowSwitch_actionPerformed(ActionEvent e) {
        new SwitchDialog(this.internalFrames);
    }

    public void menuWindowTileH_actionPerformed(ActionEvent e) {
        InternalFrame frame = null;
        Enumeration en = this.internalFrames.keys();
        MDIFrame.getInstance();
        int nWindows = MDIFrame.getDesktopDimension().height / 200;
        int max = Math.min(nWindows, this.internalFrames.size());
        MDIFrame.getInstance();
        int w = MDIFrame.getDesktopDimension().width;
        int h = 0;
        int i = 0;
        while (i < max) {
            frame = (InternalFrame)en.nextElement();
            MDIFrame.getInstance();
            frame.setSize(new Dimension(w, MDIFrame.getDesktopDimension().height / max));
            frame.setLocation(0, h);
            MDIFrame.getInstance();
            h += MDIFrame.getDesktopDimension().height / max;
            frame.toFront();
            ++i;
        }
    }

    public void menuWindowTileV_actionPerformed(ActionEvent e) {
        InternalFrame frame = null;
        Enumeration en = this.internalFrames.keys();
        MDIFrame.getInstance();
        int nWindows = MDIFrame.getDesktopDimension().width / 200;
        int max = Math.min(nWindows, this.internalFrames.size());
        int w = 0;
        MDIFrame.getInstance();
        int h = MDIFrame.getDesktopDimension().height;
        int i = 0;
        while (i < max) {
            frame = (InternalFrame)en.nextElement();
            MDIFrame.getInstance();
            frame.setSize(new Dimension(MDIFrame.getDesktopDimension().width / max, h));
            frame.setLocation(w, 0);
            MDIFrame.getInstance();
            w += MDIFrame.getDesktopDimension().width / max;
            frame.toFront();
            ++i;
        }
    }

    public final void removeWindow(JInternalFrame frame) {
        JMenuItem window = (JMenuItem)this.internalFrames.remove(frame);
        if (window != null) {
            this.remove(window);
            this.updateMnemonics();
            this.revalidate();
        }
        this.menuWindowCloseAll.setEnabled(this.getMenuComponentCount() > 8);
        this.menuWindowSwitch.setEnabled(this.getMenuComponentCount() > 8);
        this.menuWindowTileH.setEnabled(this.internalFrames.size() > 1);
        this.menuWindowTileV.setEnabled(this.internalFrames.size() > 1);
        this.menuWindowCascade.setEnabled(this.internalFrames.size() > 1);
        this.menuWindowMinimize.setEnabled(this.internalFrames.size() > 0);
        this.menuWindowMinimizeAll.setEnabled(this.internalFrames.size() > 0);
        MDIFrame.getInstance().windowClosed(frame);
        System.gc();
    }

    private int updateMnemonics() {
        int i = 0;
        JMenuItem item = null;
        String text = null;
        while (i < this.getMenuComponentCount() - 8 && !(this.getMenuComponent(i) instanceof JSeparator)) {
            item = (JMenuItem)this.getMenuComponent(i);
            text = item.getText();
            text = i + text.substring(text.indexOf(32));
            item.setText(text);
            item.setMnemonic(text.charAt(0));
            ++i;
        }
        return i;
    }
}

