/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.client.MultiLineLabelControl;
import org.openswing.swing.miscellaneous.client.IconifableWindow;

public class AlertWindow
extends IconifableWindow {
    private MultiLineLabelControl body = new MultiLineLabelControl();
    private JPanel defaultComponentsPanel = new JPanel();
    private long fadeInTime = 1000L;
    private long fadeOutTime = 1000L;
    private String imageName;
    private ImagePanel imagePanel = new ImagePanel();
    private boolean reduceToIconOnTimeout = false;
    private long timeout = 0L;

    public AlertWindow() {
        this.setAllowsCloseWindow(true);
        this.body.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !AlertWindow.this.isShowCloseButton() && AlertWindow.this.isAllowsCloseWindow()) {
                    AlertWindow.this.hideWindow();
                }
            }
        });
        this.defaultComponentsPanel.setLayout(new GridBagLayout());
        this.imagePanel.setOpaque(false);
        this.imagePanel.setBorder(BorderFactory.createEmptyBorder());
        this.imagePanel.setScrollBarsPolicy(21);
        this.defaultComponentsPanel.setOpaque(false);
        this.defaultComponentsPanel.add((Component)this.body, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public final long getFadeInTime() {
        return this.fadeInTime;
    }

    public final long getFadeOutTime() {
        return this.fadeOutTime;
    }

    public final String getImageName() {
        return this.imageName;
    }

    public final String getMainText() {
        return this.body.getLabel();
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final boolean isReduceToIconOnTimeout() {
        return this.reduceToIconOnTimeout;
    }

    public final void setFadeInTime(long fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    public final void setFadeOutTime(long fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    public final void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public final void setMainText(String body) {
        this.body.setLabel(body);
    }

    public final void setReduceToIconOnTimeout(boolean reduceToIconOnTimeout) {
        this.reduceToIconOnTimeout = reduceToIconOnTimeout;
    }

    public final void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected final void showWindowInternally() {
        if (this.getComponents().length == 0) {
            this.imagePanel.setBackground(this.getBackground());
            if (this.imageName != null && !this.imageName.equals("")) {
                this.defaultComponentsPanel.remove(this.imagePanel);
                this.imagePanel.setImageName(this.imageName);
                this.imagePanel.setMinimumSize(this.imagePanel.getPreferredSize());
                this.defaultComponentsPanel.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            }
            this.body.setPreferredSize(new Dimension(this.getWindow().getWidth() - (this.imageName != null && !this.imageName.equals("") ? this.imagePanel.getPreferredSize().width + 8 : 0), this.getWindow().getHeight()));
            this.body.setSize(this.body.getPreferredSize());
            this.body.setMaximumSize(new Dimension(this.getWindow().getWidth() - (this.imageName != null && !this.imageName.equals("") ? this.imagePanel.getPreferredSize().width + 8 : 0), this.getWindow().getHeight()));
            this.getWindow().getContentPane().remove(this);
            this.getWindow().getContentPane().add((Component)this.defaultComponentsPanel, "Center");
        }
        if (this.fadeInTime > 50L) {
            final double delta = (long)this.getWindow().getHeight() / (this.fadeInTime / 50L);
            final double h = this.getWindow().getHeight();
            final int finalYLocation = this.getWindow().getLocation().y;
            this.getWindow().setSize(this.getWindow().getWidth(), 0);
            this.getWindow().setLocation(this.getWindow().getLocation().x, this.getWindow().getLocation().y);
            final int startingYLocation = this.getWindow().getLocation().y + (int)h;
            new Thread(){

                public void run() {
                    double i = 0.0;
                    while (i < h) {
                        AlertWindow.this.getWindow().setVisible(false);
                        if (AlertWindow.this.constraint == 0) {
                            AlertWindow.this.getWindow().setLocation(AlertWindow.this.getWindow().getLocation().x, startingYLocation - (int)i);
                        }
                        AlertWindow.this.getWindow().setSize(AlertWindow.this.getWindow().getWidth(), (int)i);
                        AlertWindow.this.getWindow().setVisible(true);
                        try {
                            Thread.sleep(AlertWindow.this.fadeInTime / 50L);
                        }
                        catch (InterruptedException ex1) {
                        }
                        i += delta;
                    }
                    AlertWindow.this.getWindow().setSize(AlertWindow.this.getWindow().getWidth(), (int)h);
                    if (AlertWindow.this.constraint == 0) {
                        AlertWindow.this.getWindow().setLocation(AlertWindow.this.getWindow().getLocation().x, finalYLocation);
                    }
                    AlertWindow.this.getWindow().setVisible(true);
                    AlertWindow.this.fireWindowEvent(1);
                }
            }.start();
        } else {
            super.showWindowInternally();
        }
        if (this.timeout > 0L) {
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(AlertWindow.this.timeout);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    int h = AlertWindow.this.getWindow().getHeight();
                    int i = 0;
                    while (i < h - (AlertWindow.this.reduceToIconOnTimeout ? AlertWindow.this.getIconHeight() : 0)) {
                        AlertWindow.this.getWindow().setSize(AlertWindow.this.getWindow().getWidth(), h - i);
                        if (AlertWindow.this.constraint == 0) {
                            AlertWindow.this.getWindow().setLocation(AlertWindow.this.getWindow().getLocation().x, AlertWindow.this.getWindow().getLocation().y + 1);
                        }
                        try {
                            Thread.sleep(Math.max(AlertWindow.this.fadeOutTime / (long)h - 5L, 5L));
                        }
                        catch (InterruptedException ex1) {
                        }
                        ++i;
                    }
                    if (AlertWindow.this.reduceToIconOnTimeout) {
                        AlertWindow.this.setupTopPanel(true);
                    } else {
                        AlertWindow.this.hideWindow();
                    }
                }
            }.start();
        }
    }
}

