/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.client;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openswing.swing.client.ImagePanel;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.miscellaneous.client.IconifableWindowListener;
import org.openswing.swing.util.client.ClientUtils;

public class IconifableWindow
extends JPanel {
    public static final int BOTTOM = 1;
    public static final int INSIDE_BOTTOM = 2;
    public static final int INSIDE_TOP = 3;
    public static final int TOP = 0;
    private boolean allowsCloseWindow = false;
    private JComponent anchorComponent;
    private ImagePanel closeButton;
    protected int constraint;
    private int iconHeight = 21;
    private ArrayList iconifableWindowListeners;
    private Dimension lastWindowDimension = null;
    private ImagePanel reduceToIconButton;
    private ImagePanel restoreButton;
    private boolean showCloseButton;
    private boolean showReduceToIconButton;
    private LabelControl title = new LabelControl();
    private ImagePanel titleImage;
    private String titleImageName;
    private JPanel topPanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            if (IconifableWindow.this.showCloseButton || IconifableWindow.this.showReduceToIconButton || IconifableWindow.this.title.getLabel() != null && !IconifableWindow.this.title.getLabel().equals("") || IconifableWindow.this.titleImageName != null && !IconifableWindow.this.titleImageName.equals("")) {
                g.setColor(Color.lightGray);
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
        }
    };
    private JWindow window;

    public IconifableWindow() {
        this.closeButton = new ImagePanel();
        this.reduceToIconButton = new ImagePanel();
        this.restoreButton = new ImagePanel();
        this.iconifableWindowListeners = new ArrayList();
        this.titleImage = new ImagePanel();
        this.setBackground(new Color(240, 240, 240));
        this.title.setFont(new Font(this.title.getFont().getName(), 1, this.title.getFont().getSize()));
        this.titleImage.setOpaque(false);
        this.titleImage.setScrollBarsPolicy(21);
        this.titleImage.setBorder(BorderFactory.createEmptyBorder());
        this.topPanel.setOpaque(false);
        this.topPanel.setLayout(new GridBagLayout());
        this.closeButton.setImageName("closealert.gif");
        this.closeButton.setOpaque(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.closeButton.setScrollBarsPolicy(21);
        this.closeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                IconifableWindow.this.hideWindow();
            }
        });
        this.restoreButton.setImageName("maximizealert.gif");
        this.restoreButton.setOpaque(false);
        this.restoreButton.setBorder(BorderFactory.createEmptyBorder());
        this.restoreButton.setScrollBarsPolicy(21);
        this.restoreButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                IconifableWindow.this.restoreWindow();
            }
        });
        this.reduceToIconButton.setImageName("reducealert.gif");
        this.reduceToIconButton.setOpaque(false);
        this.reduceToIconButton.setBorder(BorderFactory.createEmptyBorder());
        this.reduceToIconButton.setScrollBarsPolicy(21);
        this.reduceToIconButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                IconifableWindow.this.reduceToIcon();
            }
        });
        this.lastWindowDimension = new Dimension(300, 150);
        super.setSize(this.lastWindowDimension);
        super.setFocusable(false);
        this.setBackground(UIManager.getColor("Label.background"));
        super.setPreferredSize(new Dimension(300, 150));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !IconifableWindow.this.showCloseButton && IconifableWindow.this.allowsCloseWindow) {
                    IconifableWindow.this.hideWindow();
                }
            }
        });
        this.title.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && !IconifableWindow.this.showReduceToIconButton) {
                    if (((IconifableWindow)IconifableWindow.this).window.getSize().height != IconifableWindow.this.iconHeight) {
                        IconifableWindow.this.reduceToIcon();
                    } else {
                        IconifableWindow.this.restoreWindow();
                    }
                }
            }
        });
        this.topPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && !IconifableWindow.this.showReduceToIconButton) {
                    if (((IconifableWindow)IconifableWindow.this).window.getSize().height != IconifableWindow.this.iconHeight) {
                        IconifableWindow.this.reduceToIcon();
                    } else {
                        IconifableWindow.this.restoreWindow();
                    }
                }
            }
        });
    }

    public final void addIconifableWindowListener(IconifableWindowListener listener) {
        this.iconifableWindowListeners.add(listener);
    }

    public final void anchorWindow(JComponent anchorComponent, int constraint) {
        this.anchorComponent = anchorComponent;
        this.constraint = constraint;
    }

    protected final void fireWindowEvent(int event) {
        int i = 0;
        while (i < this.iconifableWindowListeners.size()) {
            ((IconifableWindowListener)this.iconifableWindowListeners.get(i)).windowEvent(this, event);
            ++i;
        }
    }

    public final int getConstraint() {
        return this.constraint;
    }

    public final int getIconHeight() {
        return this.iconHeight;
    }

    public final String getTitle() {
        return this.title.getLabel();
    }

    public final String getTitleImageName() {
        return this.titleImageName;
    }

    private final Component getTopLevelAncestor(Component component) {
        if (component == null) {
            return null;
        }
        Component p = component;
        while (p != null) {
            if (p instanceof Window || p instanceof Applet) {
                return p;
            }
            p = p.getParent();
        }
        return null;
    }

    public final Color getTopPanelBackground() {
        return this.topPanel.getBackground();
    }

    public final JWindow getWindow() {
        return this.window;
    }

    public final Dimension getWindowMaximumSize() {
        return this.lastWindowDimension;
    }

    public final void hideWindow() {
        if (this.window != null) {
            this.window.getContentPane().removeAll();
            this.window.setVisible(false);
            this.window.dispose();
            this.fireWindowEvent(2);
        }
    }

    public final boolean isAllowsCloseWindow() {
        return this.allowsCloseWindow;
    }

    public final boolean isShowCloseButton() {
        return this.showCloseButton;
    }

    public final boolean isShowReduceToIconButton() {
        return this.showReduceToIconButton;
    }

    private void locateWindow() {
        Component topLevelAncestor = this.getTopLevelAncestor(this.anchorComponent);
        Point location = null;
        if (topLevelAncestor != null && topLevelAncestor instanceof JWindow) {
            location = topLevelAncestor.getLocationOnScreen();
        } else if (topLevelAncestor != null && topLevelAncestor instanceof MDIFrame) {
            int x = topLevelAncestor.getLocation().x;
            int y = topLevelAncestor.getLocation().y;
            Container c = this.anchorComponent;
            while (!c.equals(topLevelAncestor)) {
                x += c.getLocation().x;
                y += c.getLocation().y;
                c = c.getParent();
            }
            location = new Point(x, y);
        } else {
            location = this.anchorComponent.getLocationOnScreen();
        }
        if (this.constraint == 0) {
            location.y -= this.window.getHeight();
        } else if (this.constraint == 1) {
            location.y = location.y + this.anchorComponent.getSize().height + 1;
        } else if (this.constraint == 2) {
            location.y = location.y + this.anchorComponent.getSize().height - this.window.getHeight();
        } else if (this.constraint == 3) {
            ++location.y;
        }
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        this.window.setLocation(location);
    }

    public final void reduceToIcon() {
        if (this.window != null && this.window.getSize().height != this.iconHeight) {
            this.window.setSize(this.lastWindowDimension.width, this.iconHeight);
            this.setupTopPanel(true);
            this.locateWindow();
            this.revalidate();
            ((JComponent)this.window.getContentPane()).revalidate();
            this.fireWindowEvent(3);
        }
    }

    public final void removeIconifableWindowListener(IconifableWindowListener listener) {
        this.iconifableWindowListeners.remove(listener);
    }

    public final void restoreWindow() {
        if (this.window != null && this.lastWindowDimension != null && this.lastWindowDimension.height != this.iconHeight) {
            this.window.setSize(this.lastWindowDimension);
            this.setupTopPanel(false);
            this.locateWindow();
            this.revalidate();
            ((JComponent)this.window.getContentPane()).revalidate();
            this.fireWindowEvent(4);
        }
    }

    public final void setAllowsCloseWindow(boolean allowsCloseWindow) {
        this.allowsCloseWindow = allowsCloseWindow;
    }

    public final void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    public final void setShowCloseButton(boolean showCloseButton) {
        this.showCloseButton = showCloseButton;
    }

    public final void setShowReduceToIconButton(boolean showReduceToIconButton) {
        this.showReduceToIconButton = showReduceToIconButton;
    }

    public final void setTitle(String title) {
        this.title.setLabel(title);
    }

    public final void setTitleImageName(String titleImageName) {
        this.titleImageName = titleImageName;
        if (!Beans.isDesignTime()) {
            this.titleImage.setImageName(titleImageName);
        }
    }

    public final void setTopPanelBackground(Color color) {
        this.topPanel.setBackground(color);
        this.topPanel.setOpaque(color != null);
    }

    public final void setWindowMaximumSize(Dimension lastWindowDimension) {
        this.lastWindowDimension = lastWindowDimension;
    }

    protected final void setupTopPanel(boolean windowIconified) {
        this.topPanel.removeAll();
        if (this.titleImageName != null && !this.titleImageName.equals("")) {
            this.topPanel.add((Component)this.titleImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        if (this.title.getLabel() != null && !this.title.getLabel().equals("")) {
            this.topPanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        }
        if (windowIconified) {
            if (this.showReduceToIconButton) {
                this.topPanel.add((Component)this.restoreButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            }
            if (this.showCloseButton) {
                this.topPanel.add((Component)this.closeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            }
        } else {
            if (this.showReduceToIconButton) {
                this.topPanel.add((Component)this.reduceToIconButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            }
            if (this.showCloseButton) {
                this.topPanel.add((Component)this.closeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            }
        }
        this.topPanel.setSize(this.window.getSize().width, this.topPanel.getHeight());
        this.topPanel.revalidate();
        this.topPanel.repaint();
    }

    public final void showWindow() {
        this.closeButton.setBackground(this.getBackground());
        this.reduceToIconButton.setBackground(this.getBackground());
        this.restoreButton.setBackground(this.getBackground());
        if (this.window != null) {
            this.hideWindow();
        }
        Component topLevelAncestor = null;
        topLevelAncestor = this.anchorComponent != null ? this.getTopLevelAncestor(this.anchorComponent) : this.getTopLevelAncestor(this.getParent());
        if (topLevelAncestor != null) {
            if (topLevelAncestor instanceof Frame) {
                this.window = new JWindow((Frame)topLevelAncestor);
            } else if (topLevelAncestor instanceof Window) {
                this.window = new JWindow((Window)topLevelAncestor);
            } else {
                JFrame frame = ClientUtils.getParentFrame((JComponent)topLevelAncestor);
                this.window = new JWindow(frame);
            }
            topLevelAncestor.addComponentListener(new ComponentAdapter(){

                /*
                 * Handled impossible loop by adding 'first' condition
                 * Enabled aggressive block sorting
                 */
                public void componentMoved(ComponentEvent e) {
                    if (IconifableWindow.this.lastWindowDimension != null) {
                        IconifableWindow.this.lastWindowDimension = new Dimension(((IconifableWindow)IconifableWindow.this).anchorComponent.getSize().width, ((IconifableWindow)IconifableWindow.this).lastWindowDimension.height);
                    }
                    if (IconifableWindow.this.window != null) {
                        Container c = IconifableWindow.this.window.getContentPane();
                        boolean bl = true;
                        do {
                            if (!bl || (bl = false) || !true) {
                                c.setSize(IconifableWindow.this.window.getWidth(), c.getHeight());
                                c = c.getParent();
                            }
                            if (c == null) break;
                        } while (!c.equals(IconifableWindow.this.window));
                    }
                    int j = 0;
                    while (j < IconifableWindow.this.window.getContentPane().getComponentCount()) {
                        IconifableWindow.this.window.getContentPane().getComponents()[j].setSize(new Dimension(IconifableWindow.this.window.getWidth(), IconifableWindow.this.window.getContentPane().getComponents()[j].getHeight()));
                        ((JComponent)IconifableWindow.this.window.getContentPane().getComponents()[j]).revalidate();
                        ++j;
                    }
                    IconifableWindow.this.locateWindow();
                }

                /*
                 * Handled impossible loop by adding 'first' condition
                 * Enabled aggressive block sorting
                 */
                public void componentResized(ComponentEvent e) {
                    if (IconifableWindow.this.lastWindowDimension != null) {
                        IconifableWindow.this.lastWindowDimension = new Dimension(((IconifableWindow)IconifableWindow.this).anchorComponent.getSize().width, ((IconifableWindow)IconifableWindow.this).lastWindowDimension.height);
                    }
                    if (IconifableWindow.this.window != null) {
                        Container c = IconifableWindow.this.window.getContentPane();
                        boolean bl = true;
                        do {
                            if (!bl || (bl = false) || !true) {
                                c.setSize(IconifableWindow.this.window.getWidth(), c.getHeight());
                                c = c.getParent();
                            }
                            if (c == null) break;
                        } while (!c.equals(IconifableWindow.this.window));
                    }
                    int j = 0;
                    while (j < IconifableWindow.this.window.getContentPane().getComponentCount()) {
                        IconifableWindow.this.window.getContentPane().getComponents()[j].setSize(new Dimension(IconifableWindow.this.window.getWidth(), IconifableWindow.this.window.getContentPane().getComponents()[j].getHeight()));
                        ((JComponent)IconifableWindow.this.window.getContentPane().getComponents()[j]).revalidate();
                        ++j;
                    }
                    IconifableWindow.this.locateWindow();
                }
            });
        } else {
            this.window = new JWindow();
        }
        this.window.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !IconifableWindow.this.showCloseButton && IconifableWindow.this.allowsCloseWindow) {
                    IconifableWindow.this.hideWindow();
                }
            }
        });
        if (this.lastWindowDimension != null) {
            this.window.setSize(this.lastWindowDimension);
        }
        if (this.anchorComponent != null && (this.constraint == 0 || this.constraint == 1 || this.constraint == 3 || this.constraint == 2)) {
            this.locateWindow();
            this.anchorComponent.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent e) {
                    IconifableWindow.this.locateWindow();
                }

                /*
                 * Handled impossible loop by adding 'first' condition
                 * Enabled aggressive block sorting
                 */
                public void componentResized(ComponentEvent e) {
                    if (IconifableWindow.this.lastWindowDimension != null) {
                        IconifableWindow.this.lastWindowDimension = new Dimension(((IconifableWindow)IconifableWindow.this).anchorComponent.getSize().width, ((IconifableWindow)IconifableWindow.this).lastWindowDimension.height);
                    }
                    if (IconifableWindow.this.window != null) {
                        Container c = IconifableWindow.this.window.getContentPane();
                        boolean bl = true;
                        do {
                            if (!bl || (bl = false) || !true) {
                                c.setSize(IconifableWindow.this.window.getWidth(), c.getHeight());
                                c = c.getParent();
                            }
                            if (c == null) break;
                        } while (!c.equals(IconifableWindow.this.window));
                    }
                    int j = 0;
                    while (j < IconifableWindow.this.window.getContentPane().getComponentCount()) {
                        IconifableWindow.this.window.getContentPane().getComponents()[j].setSize(new Dimension(IconifableWindow.this.window.getWidth(), IconifableWindow.this.window.getContentPane().getComponents()[j].getHeight()));
                        ((JComponent)IconifableWindow.this.window.getContentPane().getComponents()[j]).revalidate();
                        ++j;
                    }
                    IconifableWindow.this.locateWindow();
                }
            });
        }
        ((JComponent)this.window.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().setBackground(this.getBackground());
        this.window.getContentPane().add((Component)this, "Center");
        this.setupTopPanel(false);
        this.window.getContentPane().add((Component)this.topPanel, "North");
        this.fireWindowEvent(0);
        this.showWindowInternally();
        this.window.toFront();
    }

    protected void showWindowInternally() {
        this.window.setVisible(true);
        this.fireWindowEvent(1);
    }
}

