/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.openswing.swing.util.client.ClientSettings;

public class ProgressBar
extends JPanel {
    private ArrayList coloredBands;
    private Color currentColor = ClientSettings.GRID_SELECTION_BACKGROUND;
    private double currentValue = 0.0;
    private double maxValue = 100.0;
    private double minValue = 0.0;
    private boolean showAllBands = true;

    public ProgressBar() {
        this.coloredBands = new ArrayList();
        this.setPreferredSize(new Dimension(300, 20));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setOpaque(false);
    }

    public final boolean addColoredBand(double minValue, double maxValue, Color color) {
        if (minValue < this.minValue) {
            minValue = this.minValue;
        }
        if (maxValue > this.maxValue) {
            maxValue = this.maxValue;
        }
        if (minValue >= maxValue) {
            return false;
        }
        ColoredBand interv = null;
        int pos = 0;
        int i = 0;
        while (i < this.coloredBands.size()) {
            interv = (ColoredBand)this.coloredBands.get(i);
            if (minValue > interv.getMinValue() && minValue < interv.getMaxValue()) {
                return false;
            }
            if (maxValue > interv.getMinValue() && maxValue < interv.getMaxValue()) {
                return false;
            }
            if (minValue >= interv.getMaxValue()) {
                pos = i + 1;
            }
            ++i;
        }
        this.coloredBands.add(pos, new ColoredBand(minValue, maxValue, color));
        return true;
    }

    public final Color getColor() {
        return this.currentColor;
    }

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final double getValue() {
        return this.currentValue;
    }

    public final boolean isShowAllBands() {
        return this.showAllBands;
    }

    public final void paint(Graphics g) {
        if (this.coloredBands.size() > 0) {
            if (this.showAllBands) {
                ColoredBand band = null;
                int i = 0;
                while (i < this.coloredBands.size()) {
                    band = (ColoredBand)this.coloredBands.get(i);
                    if (band.getMaxValue() <= this.currentValue) {
                        double val = Math.min(band.getMaxValue(), this.currentValue);
                        g.setColor(band.getColor());
                        g.fillRect(1 + (int)((double)this.getWidth() * band.getMinValue() / (this.maxValue - this.minValue)), 1, (int)((double)this.getWidth() * val / (this.maxValue - this.minValue)), this.getHeight() - 2);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                ColoredBand band = null;
                int i = this.coloredBands.size() - 1;
                while (i >= 0) {
                    band = (ColoredBand)this.coloredBands.get(i);
                    if (band.getMaxValue() >= this.currentValue && band.getMinValue() <= this.currentValue) {
                        g.setColor(band.getColor());
                        g.fillRect(1, 1, (int)((double)this.getWidth() * this.currentValue / (this.maxValue - this.minValue)), this.getHeight() - 2);
                        break;
                    }
                    --i;
                }
            }
        } else {
            g.setColor(this.currentColor);
            g.fillRect(1, 1, (int)((double)this.getWidth() * this.currentValue / (this.maxValue - this.minValue)), this.getHeight() - 2);
        }
        super.paint(g);
    }

    public final void setColor(Color currentColor) {
        this.currentColor = currentColor;
        this.repaint();
    }

    public final void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.repaint();
    }

    public final void setMinValue(double minValue) {
        this.minValue = minValue;
        this.repaint();
    }

    public final void setShowAllBands(boolean showAllBands) {
        this.showAllBands = showAllBands;
    }

    public final synchronized void setValue(double currentValue) {
        if (currentValue > this.maxValue) {
            currentValue = this.maxValue;
        }
        if (currentValue < this.minValue) {
            currentValue = this.minValue;
        }
        this.currentValue = currentValue;
        this.repaint();
    }

    class ColoredBand {
        private Color color;
        private double maxValue;
        private double minValue;

        public ColoredBand(double minValue, double maxValue, Color color) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public double getMinValue() {
            return this.minValue;
        }
    }
}

