/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.miscellaneous.client.ProgressDialog_buttonCancel_actionAdapter;
import org.openswing.swing.miscellaneous.client.ProgressEvent;
import org.openswing.swing.miscellaneous.client.ProgressPanel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ProgressDialog
extends JDialog {
    BorderLayout borderLayout1 = new BorderLayout();
    ProgressPanel progressPanel = null;

    public ProgressDialog(JFrame parentFrame, String title, String mainTitle, String mainMessage, String[] messageLabels, double minValue, double maxValue, boolean modal, boolean showCancelButton) {
        super(parentFrame, ClientSettings.getInstance().getResources().getResource(title), modal);
        try {
            this.progressPanel = new ProgressPanel(mainTitle, mainMessage, messageLabels, minValue, maxValue, showCancelButton);
            this.progressPanel.addCancelButtonListener(new ProgressDialog_buttonCancel_actionAdapter(this));
            this.jbInit();
            this.setSize(500, 80 + (int)this.progressPanel.getPreferredSize().getHeight());
            ClientUtils.centerDialog(parentFrame, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ProgressDialog(String title, String mainTitle, String mainMessage, String[] messageLabels, double minValue, double maxValue, boolean modal, boolean showCancelButton) {
        this(MDIFrame.getInstance(), title, mainTitle, mainMessage, messageLabels, minValue, maxValue, modal, showCancelButton);
    }

    public final void addCancelButtonListener(ActionListener listener) {
        this.progressPanel.addCancelButtonListener(listener);
    }

    public final boolean addColoredBand(double minValue, double maxValue, Color color) {
        return this.progressPanel.addColoredBand(minValue, maxValue, color);
    }

    void buttonCancel_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public final String getImageName() {
        return this.progressPanel.getImageName();
    }

    public final double getMaximumValue() {
        return this.progressPanel.getMaximumValue();
    }

    public final double getMinimumValue() {
        return this.progressPanel.getMinimumValue();
    }

    public final Color getProgressBarColor() {
        return this.progressPanel.getProgressBarColor();
    }

    public final boolean isShowAllBands() {
        return this.progressPanel.isShowAllBands();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.progressPanel, "Center");
    }

    public final void processProgressEvent(ProgressEvent event) {
        this.progressPanel.processProgressEvent(event);
        if (event.getProgressValue() >= this.progressPanel.getMaximumValue()) {
            this.buttonCancel_actionPerformed(null);
        }
    }

    public final void removeCancelButtonListener(ActionListener listener) {
        this.progressPanel.removeCancelButtonListener(listener);
    }

    public final void setImageName(String imageName) {
        this.progressPanel.setImageName(imageName);
    }

    public final void setMaximumValue(double maxValue) {
        this.progressPanel.setMaximumValue(maxValue);
    }

    public final void setMinimumValue(double minValue) {
        this.progressPanel.setMinimumValue(minValue);
    }

    public final void setProgressBarColor(Color color) {
        this.progressPanel.setProgressBarColor(color);
    }

    public final void setShowAllBands(boolean showAllBands) {
        this.progressPanel.setShowAllBands(showAllBands);
    }
}

