/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.miscellaneous.util.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.miscellaneous.client.TipPanelContent;
import org.openswing.swing.miscellaneous.util.client.TipSelectDialog_cancelButton_actionAdapter;
import org.openswing.swing.miscellaneous.util.client.TipSelectDialog_list_mouseAdapter;
import org.openswing.swing.miscellaneous.util.client.TipSelectDialog_okButton_actionAdapter;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

class TipSelectDialog
extends JDialog {
    JPanel buttonsPane;
    JButton cancelButton;
    TextControl controlFilter;
    JPanel filterPanel = new JPanel();
    FlowLayout flowLayout1;
    GridBagLayout gridBagLayout1;
    LabelControl labelFilter;
    LabelControl labelTitle;
    JList list;
    JButton okButton;
    JScrollPane scrollPane;
    private int tipIndex = -1;
    private final TipPanelContent tipPanelContent;

    public TipSelectDialog(TipPanelContent tipPanelContent) {
        super(MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource("select tip"), true);
        this.buttonsPane = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelFilter = new LabelControl();
        this.controlFilter = new TextControl();
        this.labelTitle = new LabelControl();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tipPanelContent = tipPanelContent;
        try {
            this.jbInit();
            this.init();
            this.setSize(300, 300);
            this.setDefaultCloseOperation(2);
            ClientUtils.centerDialog(MDIFrame.getInstance(), this);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.tipIndex = -1;
        this.setVisible(false);
    }

    public int getTipIndex() {
        return this.tipIndex;
    }

    private void init() {
        this.list.setSelectionForeground((Color)UIManager.get("TextField.foreground"));
        this.list.setBackground((Color)UIManager.get("TextField.background"));
        this.list.setSelectionBackground(ClientSettings.BACKGROUND_SEL_COLOR);
        DefaultListModel<String> model = new DefaultListModel<String>();
        int i = 0;
        while (i < this.tipPanelContent.getTitles().length) {
            model.addElement(ClientSettings.getInstance().getResources().getResource(this.tipPanelContent.getTitles()[i]));
            ++i;
        }
        this.list.setModel(model);
        final long t = System.currentTimeMillis();
        this.controlFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (TipSelectDialog.this.controlFilter.getText().length() > 0) {
                    int i = 0;
                    while (i < TipSelectDialog.this.list.getModel().getSize()) {
                        if (TipSelectDialog.this.list.getModel().getElementAt(i).toString().toLowerCase().startsWith(TipSelectDialog.this.controlFilter.getText().toLowerCase())) {
                            TipSelectDialog.this.list.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                if (e.getKeyCode() == 27) {
                    TipSelectDialog.this.tipIndex = -1;
                    TipSelectDialog.this.setVisible(false);
                }
                if (e.getKeyCode() == 10 && System.currentTimeMillis() > t + 1000L) {
                    TipSelectDialog.this.tipIndex = TipSelectDialog.this.list.getSelectedIndex();
                    TipSelectDialog.this.setVisible(false);
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.filterPanel.setLayout(this.gridBagLayout1);
        this.buttonsPane.setLayout(this.flowLayout1);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new TipSelectDialog_list_mouseAdapter(this));
        this.labelFilter.setLabel("tip name");
        this.labelTitle.setLabel("tips list");
        this.labelTitle.setTextAlignment(2);
        this.okButton.setText(ClientSettings.getInstance().getResources().getResource("ok"));
        this.okButton.setMnemonic(this.okButton.getText().charAt(0));
        this.okButton.addActionListener(new TipSelectDialog_okButton_actionAdapter(this));
        this.cancelButton.setText(ClientSettings.getInstance().getResources().getResource("cancel"));
        this.cancelButton.setMnemonic(this.cancelButton.getText().charAt(0));
        this.cancelButton.addActionListener(new TipSelectDialog_cancelButton_actionAdapter(this));
        this.getContentPane().add((Component)this.filterPanel, "North");
        this.getContentPane().add((Component)this.buttonsPane, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.list, null);
        this.filterPanel.add((Component)this.labelFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.filterPanel.add((Component)this.controlFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.labelTitle, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.buttonsPane.add((Component)this.okButton, null);
        this.buttonsPane.add((Component)this.cancelButton, null);
    }

    void list_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.tipIndex = this.list.getSelectedIndex();
            this.setVisible(false);
        }
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.tipIndex = this.list.getSelectedIndex();
        if (this.list.getSelectedIndex() == -1) {
            return;
        }
        this.setVisible(false);
    }
}

