/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.permissions.java;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class CryptUtils {
    private static CryptUtils cryptUtils = null;
    private Cipher decodeCipher = null;
    private Cipher encodeCipher = null;

    private CryptUtils(String passwd) {
        try {
            char[] chars = new char[passwd.length()];
            int i = 0;
            while (i < chars.length) {
                chars[i] = passwd.charAt(i);
                ++i;
            }
            PBEKeySpec pbeKeySpec = new PBEKeySpec(chars);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            this.encodeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
            int count = 20;
            PBEParameterSpec encodePbeParamSpec = new PBEParameterSpec(salt, count);
            this.encodeCipher.init(1, (Key)pbeKey, encodePbeParamSpec);
            this.decodeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            PBEParameterSpec decodePbeParamSpec = new PBEParameterSpec(salt, count);
            this.decodeCipher.init(2, (Key)pbeKey, decodePbeParamSpec);
        }
        catch (NoSuchPaddingException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final byte[] decodeBytes(byte[] encodedBytes) throws Throwable {
        return this.decodeCipher.doFinal(encodedBytes);
    }

    public final String decodeText(byte[] encodedBytes) throws Throwable {
        return new String(this.decodeCipher.doFinal(encodedBytes));
    }

    public final byte[] encodeBytes(byte[] clearBytes) throws Throwable {
        return this.encodeCipher.doFinal(clearBytes);
    }

    public final byte[] encodeText(String clearText) throws Throwable {
        return this.encodeCipher.doFinal(clearText.getBytes());
    }

    public static CryptUtils getInstance(String passwd) {
        if (cryptUtils == null) {
            cryptUtils = new CryptUtils(passwd);
        }
        return cryptUtils;
    }

    public static CryptUtils getInstance() {
        if (cryptUtils == null) {
            cryptUtils = new CryptUtils("openswing");
        }
        return cryptUtils;
    }
}

