/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.cellspantable.client;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openswing.swing.pivottable.cellspantable.client.CellSpanTableUI;

public class CellSpanTable
extends JTable {
    public static final int COLUMN = 1;
    public static final int ROW = 0;
    protected int columnSize;
    protected int rowSize;
    protected int[][][] span;

    public CellSpanTable() {
        this.setShowGrid(false);
        this.getColumnModel().setColumnMargin(0);
        this.setRowMargin(0);
    }

    public void addColumn() {
        int[][][] oldSpan = this.span;
        int numRows = oldSpan.length;
        int numColumns = oldSpan[0].length == 0 ? 0 : oldSpan[0].length;
        this.span = new int[numRows][numColumns + 1][2];
        int i = 0;
        while (i < numRows) {
            this.span[i] = new int[numColumns + 1][2];
            System.arraycopy(oldSpan[i], 0, this.span[i], 0, oldSpan[i].length);
            this.span[i][numColumns][1] = 1;
            this.span[i][numColumns][0] = 1;
            ++i;
        }
        ++this.columnSize;
    }

    public void addRow() {
        int[][][] oldSpan = this.span;
        int numRows = oldSpan.length;
        int numColumns = oldSpan.length == 0 ? this.getModel().getColumnCount() : oldSpan[0].length;
        this.span = new int[numRows + 1][numColumns][2];
        System.arraycopy(oldSpan, 0, this.span, 0, numRows);
        int i = 0;
        while (i < numColumns) {
            this.span[numRows][i][1] = 1;
            this.span[numRows][i][0] = 1;
            ++i;
        }
        ++this.rowSize;
    }

    public int columnAtPoint(Point point) {
        return this.rowColumnAtPoint(point)[1];
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        this.repaint();
    }

    public void combine(int[] rows, int[] columns) {
        if (this.isOutOfBounds(rows, columns)) {
            return;
        }
        int rowSpan = rows.length;
        int columnSpan = columns.length;
        int startRow = rows.length == 0 ? 0 : rows[0];
        int startColumn = columns.length == 0 ? 0 : columns[0];
        int i = 0;
        while (i < rowSpan) {
            int j = 0;
            while (j < columnSpan) {
                if (this.span[startRow + i][startColumn + j][1] != 1 || this.span[startRow + i][startColumn + j][0] != 1) {
                    return;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        int ii = 0;
        while (i2 < rowSpan) {
            int j = 0;
            int jj = 0;
            while (j < columnSpan) {
                this.span[startRow + i2][startColumn + j][1] = jj--;
                this.span[startRow + i2][startColumn + j][0] = ii;
                ++j;
            }
            ++i2;
            --ii;
        }
        this.span[startRow][startColumn][1] = columnSpan;
        this.span[startRow][startColumn][0] = rowSpan;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle sRect = super.getCellRect(row, column, includeSpacing);
        if (row < 0 || column < 0 || this.getRowCount() <= row || this.getColumnCount() <= column) {
            return sRect;
        }
        if (!this.isGridVisible(row, column)) {
            int temp_row = row;
            int temp_column = column;
            row += this.getSpan(temp_row, temp_column)[0];
            column += this.getSpan(temp_row, temp_column)[1];
        }
        int[] n = this.getSpan(row, column);
        int index = 0;
        int columnMargin = this.getColumnModel().getColumnMargin();
        Rectangle cellFrame = new Rectangle();
        int aCellHeight = this.rowHeight + this.rowMargin;
        cellFrame.y = row * aCellHeight;
        cellFrame.height = n[0] * aCellHeight;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width = aColumn.getWidth() + columnMargin;
            if (index == column) break;
            cellFrame.x += cellFrame.width;
            ++index;
        }
        try {
            int i = 0;
            while (i < n[1] - 1) {
                TableColumn aColumn = enumeration.nextElement();
                cellFrame.width += aColumn.getWidth() + columnMargin;
                ++i;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!includeSpacing) {
            Dimension spacing = this.getIntercellSpacing();
            cellFrame.setBounds(cellFrame.x + spacing.width / 2, cellFrame.y + spacing.height / 2, cellFrame.width - spacing.width, cellFrame.height - spacing.height);
        }
        return cellFrame;
    }

    public int[] getSpan(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            int[] ret_code = new int[]{1, 1};
            return ret_code;
        }
        return this.span[row][column];
    }

    protected void initValue() {
        int i = 0;
        while (i < this.span.length) {
            int j = 0;
            while (j < this.span[i].length) {
                this.span[i][j][1] = 1;
                this.span[i][j][0] = 1;
                ++j;
            }
            ++i;
        }
    }

    public void insertRow(int row) {
        int[][][] oldSpan = this.span;
        int numRows = oldSpan.length;
        int numColumns = oldSpan.length == 0 ? this.getModel().getColumnCount() : oldSpan[0].length;
        this.span = new int[numRows + 1][numColumns][2];
        if (0 < row) {
            System.arraycopy(oldSpan, 0, this.span, 0, row - 1);
        }
        System.arraycopy(oldSpan, 0, this.span, row, numRows - row);
        int i = 0;
        while (i < numColumns) {
            this.span[row][i][1] = 1;
            this.span[row][i][0] = 1;
            ++i;
        }
        ++this.rowSize;
    }

    public boolean isGridVisible(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return false;
        }
        return this.span[row][column][1] >= 1 && this.span[row][column][0] >= 1;
    }

    public final boolean isOutOfBounds(int[] rows, int[] columns) {
        int i = 0;
        while (i < rows.length) {
            if (rows[i] < 0 || this.rowSize <= rows[i]) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < columns.length) {
            if (columns[i2] < 0 || this.columnSize <= columns[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public final boolean isOutOfBounds(int row, int column) {
        return row < 0 || this.rowSize <= row || column < 0 || this.columnSize <= column;
    }

    public int rowAtPoint(Point point) {
        return this.rowColumnAtPoint(point)[0];
    }

    private int[] rowColumnAtPoint(Point point) {
        int[] retValue = new int[]{-1, -1};
        int row = point.y / (this.rowHeight + this.rowMargin);
        if (row < 0 || this.getRowCount() <= row) {
            return retValue;
        }
        int column = this.getColumnModel().getColumnIndexAtX(point.x);
        if (this.isGridVisible(row, column)) {
            retValue[1] = column;
            retValue[0] = row;
            return retValue;
        }
        retValue[1] = column + this.getSpan(row, column)[1];
        retValue[0] = row + this.getSpan(row, column)[0];
        return retValue;
    }

    public void setGridSize(Dimension size) {
        this.columnSize = size.width;
        this.rowSize = size.height;
        this.span = new int[this.rowSize][this.columnSize][2];
        this.initValue();
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.setUI(new CellSpanTableUI());
    }

    public void setSpan(int[] span, int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return;
        }
        this.span[row][column] = span;
    }

    public final void setValues(Object[][] target, Object value, int[] rows, int[] columns) {
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            int j = 0;
            while (j < columns.length) {
                int column = columns[j];
                target[row][column] = value;
                ++j;
            }
            ++i;
        }
    }

    public void split(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return;
        }
        int columnSpan = this.span[row][column][1];
        int rowSpan = this.span[row][column][0];
        int i = 0;
        while (i < rowSpan) {
            int j = 0;
            while (j < columnSpan) {
                this.span[row + i][column + j][1] = 1;
                this.span[row + i][column + j][0] = 1;
                ++j;
            }
            ++i;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        if (firstIndex == -1 && lastIndex == -1) {
            this.repaint();
        }
        Rectangle dirtyRegion = this.getCellRect(firstIndex, 0, false);
        int numCoumns = this.getColumnCount();
        int index = firstIndex;
        int i = 0;
        while (i < numCoumns) {
            dirtyRegion.add(this.getCellRect(index, i, false));
            ++i;
        }
        index = lastIndex;
        int i2 = 0;
        while (i2 < numCoumns) {
            dirtyRegion.add(this.getCellRect(index, i2, false));
            ++i2;
        }
        this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
    }
}

