/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.pivottable.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.openswing.swing.client.DataController;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.FilterButton;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.export.java.ComponentExportOptions;
import org.openswing.swing.export.java.ExportOptions;
import org.openswing.swing.export.java.ExportToExcel;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.pivottable.cellspantable.client.CellSpanTable;
import org.openswing.swing.pivottable.client.DataFieldRenderer;
import org.openswing.swing.pivottable.client.DraggableButton;
import org.openswing.swing.pivottable.client.DraggableButtonEvent;
import org.openswing.swing.pivottable.client.DraggableButtonListener;
import org.openswing.swing.pivottable.client.FilterDialog;
import org.openswing.swing.pivottable.client.PivotTableController;
import org.openswing.swing.pivottable.java.ColGenericNode;
import org.openswing.swing.pivottable.java.ColumnField;
import org.openswing.swing.pivottable.java.DataField;
import org.openswing.swing.pivottable.java.GenericNodeKey;
import org.openswing.swing.pivottable.java.GlobalColGenericNode;
import org.openswing.swing.pivottable.java.InputFilter;
import org.openswing.swing.pivottable.java.PivotTableModel;
import org.openswing.swing.pivottable.java.PivotTableParameters;
import org.openswing.swing.pivottable.java.RowField;
import org.openswing.swing.pivottable.java.RowGenericNode;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public final class PivotTable
extends JPanel
implements DataController,
DraggableButtonListener {
    public static final String COLUMNS_PANEL = "COLUMNS_PANEL";
    public static final String DATA_PANEL = "DATA_PANEL";
    public static final String ROWS_PANEL = "ROWS_PANEL";
    private ArrayList allColumnFields;
    private ArrayList allDataFields;
    private ArrayList allRowFields;
    private boolean autoCompile = true;
    private Color backPanel;
    private HashSet bindedButtons;
    JScrollPane colsScrollPane;
    CellSpanTable colsTable;
    JPanel columnsPanel;
    private PivotTableController controller = null;
    private HashMap currentExpandableColFields;
    private HashMap currentExpandableRowFields;
    private HashMap currentValueButtons;
    private DataFieldRenderer dataFieldRenderer = null;
    JPanel dataPanel;
    JScrollPane dataScrollPane;
    JTable dataTable;
    private ExportButton exportButton = null;
    private FilterButton filterButton = null;
    private boolean firstTime = true;
    FlowLayout flowLayout1;
    FlowLayout flowLayout3;
    private String functionId = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private PivotTableParameters pars;
    private boolean pivotTableChanged = false;
    private PivotTableModel pivotTableModel = null;
    private ReloadButton reloadButton = null;
    JPanel rowsPanel;
    JScrollPane rowsScrollPane;
    CellSpanTable rowsTable;
    private SimpleDateFormat sdf = null;

    public PivotTable() {
        this.dataPanel = new JPanel();
        this.rowsPanel = new JPanel();
        this.columnsPanel = new JPanel();
        this.dataTable = new JTable();
        this.rowsTable = new CellSpanTable();
        this.colsTable = new CellSpanTable();
        this.dataScrollPane = new JScrollPane();
        this.rowsScrollPane = new JScrollPane();
        this.colsScrollPane = new JScrollPane();
        this.flowLayout1 = new FlowLayout();
        this.flowLayout3 = new FlowLayout();
        this.currentExpandableRowFields = new HashMap();
        this.currentExpandableColFields = new HashMap();
        this.pars = new PivotTableParameters();
        this.backPanel = new JPanel().getBackground();
        this.bindedButtons = new HashSet();
        this.currentValueButtons = new HashMap();
        this.allDataFields = new ArrayList();
        this.allRowFields = new ArrayList();
        this.allColumnFields = new ArrayList();
        try {
            this.jbInit();
            this.sdf = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ DataFieldRenderer access$1800(PivotTable x0) {
        return x0.dataFieldRenderer;
    }

    static /* synthetic */ void access$400(PivotTable x0) {
        x0.expandAll();
    }

    static /* synthetic */ void access$500(PivotTable x0) {
        x0.collapseAll();
    }

    public final void addColumnField(int index, ColumnField columnField) {
        this.pars.getColumnFields().add(index, columnField);
        this.setPivotTableChanged(true);
    }

    public final void addColumnField(ColumnField columnField) {
        this.pars.getColumnFields().add(columnField);
        this.setPivotTableChanged(true);
    }

    public final void addDataField(int index, DataField dataField) {
        this.pars.getDataFields().add(index, dataField);
        this.setPivotTableChanged(true);
    }

    public final void addDataField(DataField dataField) {
        this.pars.getDataFields().add(dataField);
        this.setPivotTableChanged(true);
    }

    public final void addNotify() {
        super.addNotify();
        if (!Beans.isDesignTime() && this.firstTime) {
            this.firstTime = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PivotTable.this.prepareContent();
                }
            });
        }
    }

    public final void addRowField(int index, RowField rowField) {
        this.pars.getRowFields().add(index, rowField);
        this.setPivotTableChanged(true);
    }

    public final void addRowField(RowField rowField) {
        this.pars.getRowFields().add(rowField);
        this.setPivotTableChanged(true);
    }

    private void buildPivotTable() {
        this.currentExpandableRowFields.clear();
        this.currentExpandableColFields.clear();
        new RowFieldsTableModel();
        new ColumnFieldsTableModel();
        this.dataTable.setModel(new DataFieldsTableModel());
        this.rowsTable.setShowGrid(false);
        this.colsTable.setShowGrid(false);
        int rowsNum = this.pars.getColumnFields().size() + 1;
        this.colsTable.setSize(new Dimension(this.dataTable.getWidth(), rowsNum * ClientSettings.HEADER_HEIGHT + 1));
        this.colsTable.setMinimumSize(new Dimension(this.dataTable.getWidth(), rowsNum * ClientSettings.HEADER_HEIGHT + 1));
        this.colsScrollPane.setSize(new Dimension(this.dataTable.getWidth(), rowsNum * ClientSettings.HEADER_HEIGHT + 1));
        this.colsScrollPane.setMinimumSize(new Dimension(this.dataTable.getWidth(), rowsNum * ClientSettings.HEADER_HEIGHT + 1));
        JTableHeader th = this.rowsTable.getTableHeader();
        th.setPreferredSize(new Dimension(th.getPreferredSize().width, 0));
        th.setReorderingAllowed(false);
        th.setResizingAllowed(false);
        th = this.colsTable.getTableHeader();
        th.setPreferredSize(new Dimension(th.getPreferredSize().width, 0));
        th.setReorderingAllowed(false);
        th.setResizingAllowed(false);
        th = this.dataTable.getTableHeader();
        th.setPreferredSize(new Dimension(th.getPreferredSize().width, 0));
        th.setReorderingAllowed(false);
        th.setResizingAllowed(false);
        int i = 0;
        while (i < this.pars.getRowFields().size()) {
            this.rowsTable.getColumnModel().getColumn(i).setPreferredWidth(((RowField)this.pars.getRowFields().get(i)).getWidth());
            this.rowsTable.getColumnModel().getColumn(i).setCellRenderer(new RowsHeaderRenderer());
            ++i;
        }
        int k = 0;
        int i2 = 0;
        while (i2 < this.colsTable.getColumnModel().getColumnCount()) {
            this.colsTable.getColumnModel().getColumn(i2).setPreferredWidth(((DataField)this.pars.getDataFields().get(k)).getWidth());
            this.colsTable.getColumnModel().getColumn(i2).setCellRenderer(new ColsHeaderRenderer());
            if (++k == this.pars.getDataFields().size()) {
                k = 0;
            }
            ++i2;
        }
        k = 0;
        DataFieldsRenderer dr = new DataFieldsRenderer();
        int i3 = 0;
        while (i3 < this.dataTable.getColumnModel().getColumnCount()) {
            this.dataTable.getColumnModel().getColumn(i3).setPreferredWidth(((DataField)this.pars.getDataFields().get(k)).getWidth());
            this.dataTable.getColumnModel().getColumn(i3).setCellRenderer(dr);
            if (++k == this.pars.getDataFields().size()) {
                k = 0;
            }
            ++i3;
        }
        this.rowsTable.revalidate();
        this.rowsTable.repaint();
        this.colsTable.revalidate();
        this.colsTable.repaint();
        this.dataTable.revalidate();
        this.dataTable.repaint();
        this.revalidate();
        this.repaint();
        if (this.dataTable.getRowCount() > 0) {
            this.dataTable.setRowSelectionInterval(0, 0);
            this.dataTable.setColumnSelectionInterval(0, 0);
        }
    }

    private void collapseAll() {
        this.currentExpandableColFields.clear();
        this.currentExpandableRowFields.clear();
        int i = 0;
        while (i < this.pivotTableModel.getHRoot().getChildrenCount()) {
            this.setExpansionStateNode(this.pivotTableModel.getHRoot().getChildren(i), false, -1);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.pivotTableModel.getVRoot().getChildrenCount()) {
            this.setExpansionStateNode(this.pivotTableModel.getVRoot().getChildren(i2), false, -1);
            ++i2;
        }
        this.buildPivotTable();
    }

    public final void collapseColumn(int column) {
        int c = 0;
        if (column > 0) {
            int oldc = 0;
            int w = 0;
            int i = 0;
            while (i < column) {
                if (this.colsTable.columnAtPoint(new Point(w, 5)) != oldc) {
                    oldc = this.colsTable.columnAtPoint(new Point(w, 5));
                    ++c;
                }
                w += this.dataTable.getColumnModel().getColumn(i).getWidth();
                ++i;
            }
            if (c >= this.pivotTableModel.getVRoot().getChildrenCount()) {
                c = this.pivotTableModel.getVRoot().getChildrenCount() - 1;
            }
        }
        this.setExpansionStateNode(this.pivotTableModel.getVRoot().getChildren(c), false, c);
        this.buildPivotTable();
    }

    public final void collapseRow(int row) {
        int r = 0;
        if (row > 0) {
            int oldr = 0;
            int i = 0;
            while (i < row) {
                if (this.rowsTable.rowAtPoint(new Point(5, i * this.dataTable.getRowHeight())) != oldr) {
                    oldr = this.rowsTable.rowAtPoint(new Point(5, i * this.dataTable.getRowHeight()));
                    ++r;
                }
                ++i;
            }
        }
        this.setExpansionStateNode(this.pivotTableModel.getHRoot().getChildren(r), false, r);
        this.buildPivotTable();
    }

    private void columnFieldClicked(ColumnField columnField, int index, int clickCount) {
        if (clickCount == 2 && this.pars.getColumnFields().size() > 1) {
            this.pars.getColumnFields().remove(columnField);
            this.compileDataInThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compileData() {
        if (this.firstTime) {
            Logger.error(this.getClass().getName(), "compileData", "compileData method cannot be invoked before showing grid: Pivot Table cannot be created.", null);
            return;
        }
        if (this.controller == null) {
            Logger.error(this.getClass().getName(), "compileData", "setController method has not been invoked: Pivot Table cannot be created.", null);
            return;
        }
        ClientUtils.fireBusyEvent(true);
        Response res = null;
        try {
            try {
                res = this.controller.getPivotTableModel(this.pars);
            }
            catch (Throwable ex) {
                Logger.error(this.getClass().getName(), "compileData", res.getErrorMessage(), null);
                Object var4_3 = null;
                ClientUtils.fireBusyEvent(false);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ClientUtils.fireBusyEvent(false);
            throw throwable;
        }
        ClientUtils.fireBusyEvent(false);
        if (res.isError()) {
            Logger.error(this.getClass().getName(), "compileData", res.getErrorMessage(), null);
            return;
        }
        this.currentExpandableRowFields.clear();
        this.currentExpandableColFields.clear();
        this.pivotTableModel = (PivotTableModel)((VOResponse)res).getVo();
        DraggableButton button = null;
        this.removeAllButtons(this.dataPanel);
        this.dataPanel.setLayout(new FlowLayout(0, 0, 0));
        int i = 0;
        while (i < this.pars.getDataFields().size()) {
            final DataField dataField = (DataField)this.pars.getDataFields().get(i);
            button = new DraggableButton(DATA_PANEL, i);
            button.setBackground(this.backPanel);
            button.add(new JLabel(ClientSettings.getInstance().getResources().getResource(dataField.getDescription())));
            button.addDraggableButtonListener(this);
            button.setBorder(BorderFactory.createRaisedBevelBorder());
            button.setSize(new Dimension(button.getPreferredSize().width, ClientSettings.CELL_HEIGHT));
            final int index = i++;
            button.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    PivotTable.this.dataFieldClicked(dataField, index, e.getClickCount());
                }
            });
            this.dataPanel.add((Component)button, null);
        }
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
        this.removeAllButtons(this.rowsPanel);
        int w = 1;
        int i2 = 0;
        while (i2 < this.pars.getRowFields().size()) {
            final RowField rowField = (RowField)this.pars.getRowFields().get(i2);
            button = new DraggableButton(ROWS_PANEL, i2);
            button.setBackground(this.backPanel);
            button.setLayout(new GridBagLayout());
            button.add((Component)new JLabel(ClientSettings.getInstance().getResources().getResource(rowField.getDescription())), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 10, new Insets(0, 0, 0, 0), 0, 0));
            button.addDraggableButtonListener(this);
            button.setBorder(BorderFactory.createRaisedBevelBorder());
            final int index = i2;
            button.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    PivotTable.this.rowFieldClicked(rowField, index, e.getClickCount());
                }
            });
            button.setBounds(new Rectangle(w - 1, 1, rowField.getWidth() - 2 + (i2 == this.pars.getRowFields().size() - 1 ? 1 : 0), ClientSettings.HEADER_HEIGHT - 1));
            w += rowField.getWidth() - 1;
            this.rowsPanel.add((Component)button, null);
            ++i2;
        }
        this.rowsPanel.setSize(new Dimension(w, ClientSettings.HEADER_HEIGHT));
        this.rowsPanel.setPreferredSize(new Dimension(w, ClientSettings.HEADER_HEIGHT));
        this.rowsPanel.setMinimumSize(new Dimension(w, ClientSettings.HEADER_HEIGHT));
        this.rowsPanel.revalidate();
        this.rowsPanel.repaint();
        this.removeAllButtons(this.columnsPanel);
        this.columnsPanel.setSize(new Dimension(this.rowsPanel.getPreferredSize().width, ClientSettings.HEADER_HEIGHT * this.pars.getColumnFields().size() + 1));
        this.columnsPanel.setPreferredSize(new Dimension(this.rowsPanel.getPreferredSize().width, ClientSettings.HEADER_HEIGHT * this.pars.getColumnFields().size() + 1));
        this.columnsPanel.setMinimumSize(new Dimension(this.rowsPanel.getPreferredSize().width, ClientSettings.HEADER_HEIGHT * this.pars.getColumnFields().size() + 1));
        int i3 = 0;
        while (i3 < this.pars.getColumnFields().size()) {
            final ColumnField columnField = (ColumnField)this.pars.getColumnFields().get(i3);
            button = new DraggableButton(COLUMNS_PANEL, i3);
            button.setBackground(this.backPanel);
            button.setSize(button.getWidth(), ClientSettings.HEADER_HEIGHT);
            button.setLayout(new GridBagLayout());
            button.add((Component)new JLabel(ClientSettings.getInstance().getResources().getResource(columnField.getDescription())), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 10, new Insets(0, 0, 0, 0), 0, 0));
            button.addDraggableButtonListener(this);
            button.setBorder(BorderFactory.createRaisedBevelBorder());
            final int index = i3;
            button.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    PivotTable.this.columnFieldClicked(columnField, index, e.getClickCount());
                }
            });
            button.setBounds(new Rectangle(this.columnsPanel.getPreferredSize().width - button.getPreferredSize().width - 10 - 1, i3 * ClientSettings.HEADER_HEIGHT, button.getPreferredSize().width + 10, ClientSettings.HEADER_HEIGHT + (i3 == this.pars.getColumnFields().size() - 1 ? 1 : 0)));
            this.columnsPanel.add((Component)button, null);
            ++i3;
        }
        this.columnsPanel.revalidate();
        this.columnsPanel.repaint();
        this.buildPivotTable();
        this.setPivotTableChanged(false);
    }

    public final void compileDataInThread() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PivotTable.this.setCursor(Cursor.getPredefinedCursor(3));
                    Toolkit.getDefaultToolkit().sync();
                    PivotTable.this.compileData();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    PivotTable.this.setCursor(Cursor.getDefaultCursor());
                    Toolkit.getDefaultToolkit().sync();
                    throw throwable;
                }
            }
        });
    }

    public final void copy() {
    }

    private void dataFieldClicked(DataField dataField, int index, int clickCount) {
        if (clickCount == 2 && this.pars.getDataFields().size() > 1) {
            this.pars.getDataFields().remove(dataField);
            this.compileDataInThread();
        }
    }

    public final void delete() {
    }

    public final void dragEventFired(DraggableButtonEvent e) {
        ArrayList list = null;
        if (e.getPanelId().equals(ROWS_PANEL)) {
            list = this.pars.getRowFields();
        } else if (e.getPanelId().equals(COLUMNS_PANEL)) {
            list = this.pars.getColumnFields();
        } else if (e.getPanelId().equals(DATA_PANEL)) {
            list = this.pars.getDataFields();
        }
        if (e.getTarget() < e.getSource()) {
            Object obj = list.remove(e.getSource());
            list.add(e.getTarget(), obj);
        } else {
            Object obj = list.get(e.getSource());
            if (e.getTarget() == list.size() - 1) {
                list.add(obj);
            } else {
                list.add(e.getTarget() + 1, obj);
            }
            list.remove(e.getSource());
        }
        this.compileDataInThread();
    }

    public final void edit() {
    }

    private void expandAll() {
        int i;
        int level = 1;
        boolean containsChildren = true;
        while (containsChildren) {
            containsChildren = false;
            i = 0;
            while (i < this.pivotTableModel.getHRoot().getChildrenCount()) {
                containsChildren = containsChildren || this.setExpansionStateNode(this.pivotTableModel.getHRoot().getChildren(i), true, level);
                ++i;
            }
            ++level;
            this.buildPivotTable();
        }
        level = 0;
        containsChildren = true;
        while (containsChildren) {
            containsChildren = false;
            i = 0;
            while (i < this.pivotTableModel.getVRoot().getChildrenCount()) {
                containsChildren = containsChildren || this.setExpansionStateNode(this.pivotTableModel.getVRoot().getChildren(i), true, level);
                this.buildPivotTable();
                ++i;
            }
            ++level;
        }
    }

    public final void expandColumn(int column) {
        int c = 0;
        if (column > 0) {
            int oldc = 0;
            int w = 0;
            int i = 0;
            while (i < column) {
                if (this.colsTable.columnAtPoint(new Point(w, 5)) != oldc) {
                    oldc = this.colsTable.columnAtPoint(new Point(w, 5));
                    ++c;
                }
                w += this.dataTable.getColumnModel().getColumn(i).getWidth();
                ++i;
            }
            if (c >= this.pivotTableModel.getVRoot().getChildrenCount()) {
                c = this.pivotTableModel.getVRoot().getChildrenCount() - 1;
            }
        }
        this.setExpansionStateNode(this.pivotTableModel.getVRoot().getChildren(c), true, c);
        this.buildPivotTable();
    }

    public final void expandRow(int row) {
        int r = 0;
        if (row > 0) {
            int oldr = 0;
            int i = 0;
            while (i < row) {
                if (this.rowsTable.rowAtPoint(new Point(5, i * this.dataTable.getRowHeight())) != oldr) {
                    oldr = this.rowsTable.rowAtPoint(new Point(5, i * this.dataTable.getRowHeight()));
                    ++r;
                }
                ++i;
            }
        }
        this.setExpansionStateNode(this.pivotTableModel.getHRoot().getChildren(r), true, r);
        this.buildPivotTable();
    }

    public final void export() {
        try {
            ExportOptions opt = new ExportOptions(null, ClientSettings.getInstance().getResources().getDateMask(1), ClientSettings.getInstance().getResources().getDateMask(3), ClientSettings.getInstance().getResources().getDateMask(2), "XLS", ClientSettings.EXPORT_TO_PDF_ADAPTER, ClientSettings.EXPORT_TO_RTF_ADAPTER);
            ArrayList comps = opt.getComponentsExportOptions();
            comps.remove(0);
            Object[][] cells = new Object[this.colsTable.getRowCount() + this.rowsTable.getRowCount()][this.rowsTable.getColumnCount() + this.colsTable.getColumnCount()];
            int i = 0;
            while (i < this.pars.getColumnFields().size()) {
                cells[i][this.rowsTable.getColumnCount() - 1] = ClientSettings.getInstance().getResources().getResource(((ColumnField)this.pars.getColumnFields().get(i)).getDescription());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.colsTable.getRowCount()) {
                int j = 0;
                while (j < this.colsTable.getColumnCount()) {
                    cells[i2][this.rowsTable.getColumnCount() + j] = this.colsTable.getValueAt(i2, j);
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.dataTable.getRowCount()) {
                int j = 0;
                while (j < this.dataTable.getColumnCount()) {
                    cells[this.colsTable.getRowCount() + i3][this.rowsTable.getColumnCount() + j] = this.dataTable.getValueAt(i3, j);
                    ++j;
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.rowsTable.getRowCount()) {
                int j = 0;
                while (j < this.rowsTable.getColumnCount()) {
                    cells[this.colsTable.getRowCount() + i4][j] = this.rowsTable.getValueAt(i4, j);
                    ++j;
                }
                ++i4;
            }
            int i5 = 0;
            while (i5 < this.pars.getRowFields().size()) {
                cells[this.colsTable.getRowCount() - 1][i5] = ClientSettings.getInstance().getResources().getResource(((RowField)this.pars.getRowFields().get(i5)).getDescription());
                ++i5;
            }
            ComponentExportOptions comp = new ComponentExportOptions();
            comp.setCellsContent(cells);
            opt.addComponentExportOptions(comp);
            String fileName = System.getProperty("java.io.tmpdir").replace('\\', '/');
            if (!fileName.endsWith("/")) {
                fileName = fileName + "/";
            }
            byte[] doc = null;
            doc = new ExportToExcel().getDocument(opt);
            fileName = fileName + "doc" + System.currentTimeMillis() + ".xls";
            FileOutputStream out = new FileOutputStream(fileName);
            out.write(doc);
            out.close();
            ClientUtils.displayURL("file://" + fileName);
        }
        catch (Throwable t) {
            Logger.error(this.getClass().getName(), "export", "Error on exporting data from Pivot table:\n" + t.toString(), t);
        }
    }

    public final void filterSort() {
        new FilterDialog(this, this.pars);
    }

    private Object formatValue(Object obj) {
        if (obj != null) {
            if (obj instanceof Date) {
                return this.sdf.format((Date)obj);
            }
            if (obj instanceof Number) {
                Number num = (Number)obj;
                if ((double)num.longValue() == num.doubleValue()) {
                    return new Long(num.longValue());
                }
                return num;
            }
            return obj;
        }
        return obj;
    }

    public final ArrayList getAllColumnFields() {
        return this.allColumnFields;
    }

    public final ArrayList getAllDataFields() {
        return this.allDataFields;
    }

    public final ArrayList getAllRowFields() {
        return this.allRowFields;
    }

    public final HashSet getBindedButtons() {
        return this.bindedButtons;
    }

    public final boolean getCurrentValue(GenericButton button) {
        Boolean currentValue = (Boolean)this.currentValueButtons.get(button);
        if (currentValue == null) {
            return true;
        }
        return currentValue;
    }

    public final DataFieldRenderer getDataFieldRenderer() {
        return this.dataFieldRenderer;
    }

    public ExportButton getExportButton() {
        return this.exportButton;
    }

    public FilterButton getFilterButton() {
        return this.filterButton;
    }

    public final String getFunctionId() {
        return this.functionId;
    }

    public final PivotTableParameters getPivotTableParameters() {
        return this.pars;
    }

    public ReloadButton getReloadButton() {
        return this.reloadButton;
    }

    public final int getSelectedColumn() {
        return this.dataTable.getSelectedColumn();
    }

    public final int getSelectedRow() {
        return this.dataTable.getSelectedRow();
    }

    public final void importData() {
    }

    public final void insert() {
    }

    public final boolean isAutoCompile() {
        return this.autoCompile;
    }

    public final boolean isButtonDisabled(GenericButton button) {
        return false;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.rowsPanel.setLayout(null);
        this.columnsPanel.setLayout(null);
        this.flowLayout1.setAlignment(0);
        this.rowsTable.setAutoResizeMode(4);
        this.colsTable.setAutoResizeMode(0);
        this.dataTable.setAutoResizeMode(0);
        this.dataTable.setShowGrid(true);
        this.dataPanel.setLayout(this.flowLayout3);
        this.flowLayout3.setAlignment(0);
        this.rowsScrollPane.setHorizontalScrollBarPolicy(31);
        this.rowsScrollPane.setVerticalScrollBarPolicy(21);
        this.dataScrollPane.setHorizontalScrollBarPolicy(32);
        this.dataScrollPane.setVerticalScrollBarPolicy(22);
        this.colsScrollPane.setHorizontalScrollBarPolicy(31);
        this.colsScrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)this.rowsPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.dataScrollPane, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.columnsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rowsScrollPane, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, this.dataScrollPane.getHorizontalScrollBar().getPreferredSize().height, 0), 0, 0));
        this.add((Component)this.colsScrollPane, new GridBagConstraints(1, 2, 1, 2, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, this.dataScrollPane.getVerticalScrollBar().getPreferredSize().width), 0, 0));
        this.add((Component)this.dataPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dataScrollPane.getViewport().add((Component)this.dataTable, null);
        this.rowsScrollPane.getViewport().add((Component)this.rowsTable, null);
        this.colsScrollPane.getViewport().add((Component)this.colsTable, null);
        this.dataScrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                PivotTable.this.colsScrollPane.getHorizontalScrollBar().setValue(e.getValue());
            }
        });
        this.dataScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                PivotTable.this.rowsScrollPane.getVerticalScrollBar().setValue(e.getValue());
            }
        });
    }

    private void prepareContent() {
        try {
            this.backPanel = new Color(this.backPanel.getRed() + 10, this.backPanel.getGreen() + 10, this.backPanel.getBlue() + 10);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.rowsTable.setRowHeight(ClientSettings.CELL_HEIGHT);
        this.rowsTable.setSelectionMode(0);
        this.rowsTable.setSurrendersFocusOnKeystroke(true);
        this.rowsTable.setForeground(ClientSettings.GRID_CELL_FOREGROUND);
        this.rowsTable.setRowSelectionAllowed(false);
        this.rowsTable.setColumnSelectionAllowed(false);
        this.rowsTable.setBackground(new JButton().getBackground());
        this.rowsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.colsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.dataScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.colsTable.setRowHeight(ClientSettings.HEADER_HEIGHT);
        this.colsTable.setRowSelectionAllowed(false);
        this.colsTable.setColumnSelectionAllowed(false);
        this.colsTable.setBackground(new JButton().getBackground());
        this.dataTable.setRowHeight(ClientSettings.CELL_HEIGHT);
        this.dataTable.setSelectionMode(0);
        this.dataTable.setSurrendersFocusOnKeystroke(true);
        this.dataTable.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
        this.dataTable.setForeground(ClientSettings.GRID_CELL_FOREGROUND);
        this.dataTable.setSelectionBackground(ClientSettings.GRID_SELECTION_BACKGROUND);
        this.dataTable.setSelectionForeground(ClientSettings.GRID_SELECTION_FOREGROUND);
        this.dataTable.setShowGrid(true);
        this.dataTable.setRowSelectionAllowed(false);
        this.dataTable.setColumnSelectionAllowed(false);
        this.rowsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PivotTable.this.processRowClick(PivotTable.this.rowsTable.getSelectedRow(), PivotTable.this.rowsTable.getSelectedColumn());
            }
        });
        this.colsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PivotTable.this.processColClick(PivotTable.this.colsTable.getSelectedRow(), PivotTable.this.colsTable.getSelectedColumn());
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            static /* synthetic */ PivotTable access$300(6 x0) {
                return x0.PivotTable.this;
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem expAllMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("expand all"), ClientSettings.getInstance().getResources().getResource("expand all").charAt(0));
                    expAllMenu.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent e) {
                            PivotTable.access$400(6.access$300(this.this$1));
                        }
                    });
                    menu.add(expAllMenu);
                    JMenuItem collapseAllMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("collapse all"), ClientSettings.getInstance().getResources().getResource("collapse all").charAt(0));
                    collapseAllMenu.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent e) {
                            PivotTable.access$500(6.access$300(this.this$1));
                        }
                    });
                    menu.add(collapseAllMenu);
                    menu.show(PivotTable.this.dataTable, e.getX(), e.getY());
                }
            }
        });
        if (this.autoCompile) {
            this.compileDataInThread();
        }
    }

    private void processColClick(int row, int col) {
        if (row == this.pars.getColumnFields().size()) {
            return;
        }
        if (this.currentExpandableColFields.get(new Integer(col)) != null) {
            GlobalColGenericNode n;
            n.setNodeExpanded(!(n = (GlobalColGenericNode)this.currentExpandableColFields.remove(new Integer(col))).isNodeExpanded());
            this.buildPivotTable();
        }
    }

    private void processRowClick(int row, int col) {
        if (col == this.pars.getRowFields().size() - 1) {
            return;
        }
        if (this.currentExpandableRowFields.get(new Integer(row)) != null) {
            RowGenericNode n;
            n.setNodeExpanded(!(n = (RowGenericNode)this.currentExpandableRowFields.remove(new Integer(row))).isNodeExpanded());
            this.buildPivotTable();
        }
    }

    public final void reload() {
        this.compileDataInThread();
    }

    private void removeAllButtons(JPanel panel) {
        DraggableButton b = null;
        while (panel.getComponentCount() > 0) {
            b = (DraggableButton)panel.getComponent(0);
            b.removeDraggableButtonListener(this);
            panel.remove(0);
        }
    }

    public final void removeColumnField(ColumnField columnField) {
        this.pars.getColumnFields().remove(columnField);
        this.setPivotTableChanged(true);
    }

    public final void removeDataField(DataField dataField) {
        int index = this.pars.getDataFields().indexOf(dataField);
        this.pars.getDataFields().remove(index);
        if (index != -1) {
            this.setPivotTableChanged(true);
        }
    }

    public final void removeRowField(RowField rowField) {
        int index = this.pars.getRowFields().indexOf(rowField);
        this.pars.getRowFields().remove(index);
        if (index != -1) {
            this.setPivotTableChanged(true);
        }
    }

    private void rowFieldClicked(RowField rowField, int index, int clickCount) {
        if (clickCount == 2 && this.pars.getRowFields().size() > 1) {
            this.pars.getRowFields().remove(rowField);
            this.compileDataInThread();
        }
    }

    public final boolean save() {
        return false;
    }

    public final void setAutoCompile(boolean autoCompile) {
        this.autoCompile = autoCompile;
    }

    public final void setController(PivotTableController controller) {
        this.controller = controller;
    }

    public final void setCurrentValue(GenericButton button, boolean currentValue) {
        this.currentValueButtons.put(button, new Boolean(currentValue));
    }

    public final void setDataFieldRenderer(DataFieldRenderer dataFieldRenderer) {
        this.dataFieldRenderer = dataFieldRenderer;
    }

    private boolean setExpansionStateNode(GlobalColGenericNode node, boolean expanded, int level) {
        node.setNodeExpanded(expanded);
        boolean containsChildren = false;
        if (node.getLevel() <= level || level == -1) {
            int i = 0;
            while (i < node.getChildrenCount()) {
                containsChildren = containsChildren || this.setExpansionStateNode(node.getChildren(i), expanded, level);
                ++i;
            }
        }
        return containsChildren;
    }

    private boolean setExpansionStateNode(RowGenericNode node, boolean expanded, int level) {
        node.setNodeExpanded(expanded);
        boolean containsChildren = false;
        if (node.getLevel() <= level || level == -1) {
            int i = 0;
            while (i < node.getChildrenCount()) {
                containsChildren = containsChildren || this.setExpansionStateNode(node.getChildren(i), expanded, level);
                ++i;
            }
        }
        return containsChildren;
    }

    public void setExportButton(ExportButton exportButton) {
        this.exportButton = exportButton;
        exportButton.addDataController(this);
    }

    public void setFilterButton(FilterButton filterButton) {
        this.filterButton = filterButton;
        filterButton.addDataController(this);
    }

    public final void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public final void setInputFilter(InputFilter rowFilter) {
        this.pars.setInputFilter(rowFilter);
    }

    private void setPivotTableChanged(boolean pivotTableChanged) {
        this.pivotTableChanged = pivotTableChanged;
    }

    public void setReloadButton(ReloadButton reloadButton) {
        this.reloadButton = reloadButton;
        reloadButton.addDataController(this);
    }

    class DataFieldsRenderer
    extends DefaultTableCellRenderer {
        private Font defaultFont;
        private boolean hasFocus = false;
        private JLabel l = new JLabel();
        private JPanel p;

        private DataFieldsRenderer() {
            this.defaultFont = this.l.getFont();
            this.p = new JPanel(this){
                private final /* synthetic */ DataFieldsRenderer this$1;
                {
                    this.this$1 = this$1;
                }

                public final void paint(Graphics g) {
                    super.paint(g);
                    if (DataFieldsRenderer.access$1700(this.this$1)) {
                        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    }
                }
            };
            this.l.setHorizontalAlignment(4);
            this.p.setLayout(new FlowLayout(2, 0, 0));
            this.p.add((Component)this.l, null);
            this.p.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
            this.l.setForeground(ClientSettings.GRID_CELL_FOREGROUND);
        }

        static /* synthetic */ boolean access$1700(DataFieldsRenderer x0) {
            return x0.hasFocus;
        }

        /*
         * Unable to fully structure code
         */
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            block14: {
                block13: {
                    this.hasFocus = hasFocus;
                    if (value != null) break block13;
                    this.l.setText("");
                    break block14;
                }
                df = (DataField)PivotTable.access$1000(PivotTable.this).getDataFields().get(column % PivotTable.access$1000(PivotTable.this).getDataFields().size());
                if (df.getFormatter() == null) {
                    this.l.setText(value.toString());
                } else {
                    this.l.setText(df.getFormatter().format(((Number)value).doubleValue()));
                }
                if (PivotTable.access$1800(PivotTable.this) == null) break block14;
                rowPath = new GenericNodeKey();
                colPath = new GenericNodeKey();
                kk = PivotTable.this.rowsTable.getColumnCount() - 1;
                while (kk >= 0 && PivotTable.this.rowsTable.getValueAt(row, kk) == null) {
                    --kk;
                }
                if (kk >= 0) {
                    rowPath = rowPath.appendKey(PivotTable.this.rowsTable.getValueAt(row, kk));
                }
                k = row;
                i = kk - 1;
                ** GOTO lbl32
                {
                    --k;
                    do {
                        if (k >= 0 && PivotTable.this.rowsTable.getValueAt(k, i) == null) continue block1;
                        if (k >= 0) {
                            rowPath = rowPath.appendKey(PivotTable.this.rowsTable.getValueAt(k, i));
                        } else {
                            k = 0;
                        }
                        --i;
lbl32:
                        // 2 sources

                    } while (i >= 0);
                }
                colPath = colPath.appendKey(PivotTable.this.colsTable.getValueAt(PivotTable.this.colsTable.getRowCount() - 1, column));
                kk = column;
                while (kk % PivotTable.access$1000(PivotTable.this).getDataFields().size() > 0 && PivotTable.this.colsTable.getValueAt(PivotTable.this.colsTable.getRowCount() - 2, kk) == null) {
                    --kk;
                }
                if (PivotTable.this.colsTable.getValueAt(PivotTable.this.colsTable.getRowCount() - 2, kk) != null) {
                    colPath = colPath.appendKey(PivotTable.this.colsTable.getValueAt(PivotTable.this.colsTable.getRowCount() - 2, kk));
                }
                k = PivotTable.this.colsTable.getRowCount() - 3;
                ** GOTO lbl49
                {
                    --kk;
                    do {
                        if (kk >= 0 && PivotTable.this.colsTable.getValueAt(k, kk) == null) continue block4;
                        if (kk >= 0) {
                            colPath = colPath.appendKey(PivotTable.this.colsTable.getValueAt(k, kk));
                        }
                        --k;
lbl49:
                        // 2 sources

                    } while (k >= 0);
                }
                this.p.setBackground(PivotTable.access$1800(PivotTable.this).getBackgroundColor(ClientSettings.GRID_CELL_BACKGROUND, rowPath, colPath, value, row, column));
                this.p.setForeground(PivotTable.access$1800(PivotTable.this).getForegroundColor(ClientSettings.GRID_CELL_FOREGROUND, rowPath, colPath, value, row, column));
                this.l.setFont(PivotTable.access$1800(PivotTable.this).getFont(this.defaultFont, rowPath, colPath, value, row, column));
            }
            return this.p;
        }
    }

    class RowsHeaderRenderer
    extends DefaultTableCellRenderer {
        JPanel b = new JPanel(this){
            private final /* synthetic */ RowsHeaderRenderer this$1;
            {
                this.this$1 = this$1;
            }

            public void paint(Graphics g) {
                RowGenericNode n;
                super.paint(g);
                if (this.this$1.t != null && this.this$1.col != -1 && this.this$1.row != -1 && (n = (RowGenericNode)PivotTable.access$1300(RowsHeaderRenderer.access$1600(this.this$1)).get(new Integer(this.this$1.row))) != null && this.this$1.col == n.getLevel() - 1 && this.this$1.col < PivotTable.access$1000(RowsHeaderRenderer.access$1600(this.this$1)).getRowFields().size() - 1) {
                    if (!n.isNodeExpanded()) {
                        g.drawLine(7, 9, 11, 9);
                        g.drawLine(9, 7, 9, 11);
                    } else {
                        g.drawLine(7, 9, 11, 9);
                    }
                    g.setColor(Color.lightGray);
                    g.drawRect(5, 5, 8, 8);
                }
            }
        };
        int col = -1;
        JLabel l = new JLabel();
        int row = -1;
        JTable t = null;

        public RowsHeaderRenderer() {
            this.b.setBackground(new JButton().getBackground());
            this.b.setBorder(BorderFactory.createRaisedBevelBorder());
            this.b.setSize(this.b.getWidth(), ClientSettings.HEADER_HEIGHT);
            this.b.setLayout(new GridBagLayout());
            this.b.add((Component)this.l, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 16, 0, 0), 0, 0));
        }

        static /* synthetic */ PivotTable access$1600(RowsHeaderRenderer x0) {
            return x0.PivotTable.this;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.t = table;
            this.col = column;
            this.row = row;
            this.l.setText(value == null ? "" : value.toString());
            return this.b;
        }
    }

    class ColsHeaderRenderer
    extends DefaultTableCellRenderer {
        JPanel b = new JPanel(this){
            private final /* synthetic */ ColsHeaderRenderer this$1;
            {
                this.this$1 = this$1;
            }

            public void paint(Graphics g) {
                GlobalColGenericNode n;
                super.paint(g);
                if (this.this$1.t != null && this.this$1.col != -1 && this.this$1.row != -1 && (n = (GlobalColGenericNode)PivotTable.access$1400(ColsHeaderRenderer.access$1500(this.this$1)).get(new Integer(this.this$1.col))) != null && this.this$1.row == n.getLevel() - 1 && this.this$1.row < PivotTable.access$1000(ColsHeaderRenderer.access$1500(this.this$1)).getColumnFields().size() - 1) {
                    if (!n.isNodeExpanded()) {
                        g.drawLine(7, 11, 11, 11);
                        g.drawLine(9, 9, 9, 13);
                    } else {
                        g.drawLine(7, 11, 11, 11);
                    }
                    g.setColor(Color.lightGray);
                    g.drawRect(5, 7, 8, 8);
                }
            }
        };
        int col = -1;
        JLabel l = new JLabel();
        int row = -1;
        JTable t = null;

        public ColsHeaderRenderer() {
            this.b.setBackground(new JButton().getBackground());
            this.b.setBorder(BorderFactory.createRaisedBevelBorder());
            this.b.setSize(this.b.getWidth(), ClientSettings.HEADER_HEIGHT);
            this.b.setLayout(new GridBagLayout());
            this.b.add((Component)this.l, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 10, new Insets(2, 16, 0, 0), 0, 0));
        }

        static /* synthetic */ PivotTable access$1500(ColsHeaderRenderer x0) {
            return x0.PivotTable.this;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.t = table;
            this.col = column;
            this.row = row;
            this.l.setText(value == null ? "" : value.toString());
            return this.b;
        }
    }

    class DataFieldsTableModel
    extends AbstractTableModel {
        int colIndex;
        ArrayList rows = new ArrayList();

        public DataFieldsTableModel() {
            this.processHNode(this.rows, PivotTable.this.pivotTableModel.getHRoot(), 0);
            PivotTable.this.dataTable.setModel(this);
        }

        public int getColumnCount() {
            if (this.rows.size() > 0) {
                return ((Object[])this.rows.get(0)).length;
            }
            return 0;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((Object[])this.rows.get(rowIndex))[columnIndex];
        }

        private void processHNode(ArrayList rows, RowGenericNode parentNode, int pos) {
            Object[] row = null;
            RowGenericNode n = null;
            int oldIndex = -1;
            int i = 0;
            while (i < parentNode.getChildrenCount()) {
                n = parentNode.getChildren(i);
                row = new Object[PivotTable.this.colsTable.getColumnCount()];
                this.colIndex = 0;
                this.processVNode(row, n.getVtreeNodes(), PivotTable.this.pivotTableModel.getVRoot(), new GenericNodeKey());
                rows.add(row);
                oldIndex = rows.size() - 1;
                if (n.isNodeExpanded()) {
                    n.setNodeExpanded(true);
                    this.processHNode(rows, n, pos + 1);
                }
                ++i;
            }
        }

        private void processVNode(Object[] row, HashMap dataValues, GlobalColGenericNode n, GenericNodeKey key) {
            GlobalColGenericNode vn = null;
            ColGenericNode obj = null;
            Double num = null;
            GenericNodeKey currentKey = null;
            int i = 0;
            while (i < n.getChildrenCount()) {
                vn = n.getChildren(i);
                currentKey = key.appendKey(vn.getValue());
                obj = (ColGenericNode)dataValues.get(currentKey);
                this.colIndex = 0;
                int x = 0;
                while (x < currentKey.getPath().length) {
                    int y = this.colIndex;
                    while (y < PivotTable.this.colsTable.getModel().getColumnCount()) {
                        Object obj1 = currentKey.getPath()[x];
                        Object obj2 = PivotTable.this.colsTable.getModel().getValueAt(x, y);
                        if (obj1 != null && obj2 != null && (obj1 instanceof Number && obj2 instanceof Number && ((Number)obj1).doubleValue() == ((Number)obj2).doubleValue() || obj1.equals(obj2))) {
                            this.colIndex = y;
                            break;
                        }
                        ++y;
                    }
                    ++x;
                }
                if (obj != null) {
                    int k = 0;
                    while (k < PivotTable.this.pars.getDataFields().size()) {
                        num = obj.getGenericFunctions()[k].getValue();
                        row[this.colIndex++] = num == null ? (Number)num : (Number)((double)((Number)num).longValue() == num ? (Number)new Long(((Number)num).longValue()) : (Number)num);
                        ++k;
                    }
                }
                if (vn.isNodeExpanded()) {
                    vn.setNodeExpanded(true);
                    this.processVNode(row, dataValues, vn, key.appendKey(vn.getValue()));
                }
                ++i;
            }
        }
    }

    class ColumnFieldsTableModel
    extends AbstractTableModel {
        ArrayList cols = new ArrayList();

        public ColumnFieldsTableModel() {
            PivotTable.this.colsTable.setGridSize(new Dimension(0, PivotTable.this.pars.getColumnFields().size() + 1));
            this.processNode(this.cols, PivotTable.this.pivotTableModel.getVRoot(), 0);
            PivotTable.this.colsTable.setModel(this);
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public int getRowCount() {
            return PivotTable.this.pars.getColumnFields().size() + 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((Object[])this.cols.get(columnIndex))[rowIndex];
        }

        private void processNode(ArrayList cols, GlobalColGenericNode parentNode, int pos) {
            Object[] col = null;
            GlobalColGenericNode n = null;
            int oldIndex = -1;
            int[] rowCellsSpan = null;
            int[] colCellsSpan = null;
            int i = 0;
            while (i < parentNode.getChildrenCount()) {
                int j;
                col = new Object[PivotTable.this.pars.getColumnFields().size() + 1];
                n = parentNode.getChildren(i);
                col[pos] = PivotTable.this.formatValue(n.getValue());
                col[((PivotTable)PivotTable.this).pars.getColumnFields().size()] = ClientSettings.getInstance().getResources().getResource(((DataField)PivotTable.this.pars.getDataFields().get(0)).getDescription());
                cols.add(col);
                oldIndex = cols.size() - 1;
                PivotTable.this.colsTable.addColumn();
                PivotTable.this.currentExpandableColFields.put(new Integer(oldIndex), n);
                int k = 1;
                while (k < PivotTable.this.pars.getDataFields().size()) {
                    col = new Object[PivotTable.this.pars.getColumnFields().size() + 1];
                    col[((PivotTable)PivotTable.this).pars.getColumnFields().size()] = ClientSettings.getInstance().getResources().getResource(((DataField)PivotTable.this.pars.getDataFields().get(k)).getDescription());
                    cols.add(col);
                    PivotTable.this.colsTable.addColumn();
                    ++k;
                }
                if (n.isNodeExpanded()) {
                    n.setNodeExpanded(true);
                    this.processNode(cols, n, pos + 1);
                    rowCellsSpan = new int[PivotTable.this.pars.getColumnFields().size() - pos - 1];
                    j = 0;
                    while (j < rowCellsSpan.length) {
                        rowCellsSpan[j] = pos + 1 + j;
                        ++j;
                    }
                    colCellsSpan = new int[PivotTable.this.pars.getDataFields().size()];
                    int j2 = 0;
                    while (j2 < colCellsSpan.length) {
                        colCellsSpan[j2] = oldIndex + j2;
                        ++j2;
                    }
                    PivotTable.this.colsTable.combine(rowCellsSpan, colCellsSpan);
                    rowCellsSpan = new int[]{pos};
                } else {
                    rowCellsSpan = new int[PivotTable.this.pars.getColumnFields().size() - pos];
                    j = 0;
                    while (j < rowCellsSpan.length) {
                        rowCellsSpan[j] = pos + j;
                        ++j;
                    }
                }
                colCellsSpan = new int[cols.size() - oldIndex];
                j = 0;
                while (j < colCellsSpan.length) {
                    colCellsSpan[j] = oldIndex + j;
                    ++j;
                }
                PivotTable.this.colsTable.combine(rowCellsSpan, colCellsSpan);
                ++i;
            }
        }
    }

    class RowFieldsTableModel
    extends AbstractTableModel {
        ArrayList rows = new ArrayList();

        public RowFieldsTableModel() {
            PivotTable.this.rowsTable.setModel(this);
            PivotTable.this.rowsTable.setGridSize(new Dimension(PivotTable.this.pars.getRowFields().size(), 0));
            this.processNode(this.rows, PivotTable.this.pivotTableModel.getHRoot(), 0);
        }

        public int getColumnCount() {
            return PivotTable.this.pars.getRowFields().size();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((Object[])this.rows.get(rowIndex))[columnIndex];
        }

        private void processNode(ArrayList rows, RowGenericNode parentNode, int pos) {
            Object[] row = null;
            RowGenericNode n = null;
            int oldIndex = -1;
            int[] rowCellsSpan = null;
            int[] colCellsSpan = null;
            int i = 0;
            while (i < parentNode.getChildrenCount()) {
                int j;
                row = new Object[PivotTable.this.pars.getRowFields().size()];
                n = parentNode.getChildren(i);
                row[pos] = PivotTable.this.formatValue(n.getValue());
                rows.add(row);
                oldIndex = rows.size() - 1;
                PivotTable.this.rowsTable.addRow();
                PivotTable.this.currentExpandableRowFields.put(new Integer(oldIndex), n);
                if (n.isNodeExpanded()) {
                    n.setNodeExpanded(true);
                    this.processNode(rows, n, pos + 1);
                    colCellsSpan = new int[PivotTable.this.pars.getRowFields().size() - pos - 1];
                    j = 0;
                    while (j < colCellsSpan.length) {
                        colCellsSpan[j] = pos + 1 + j;
                        ++j;
                    }
                    PivotTable.this.rowsTable.combine(new int[]{oldIndex}, colCellsSpan);
                    colCellsSpan = new int[]{pos};
                } else {
                    colCellsSpan = new int[PivotTable.this.pars.getRowFields().size() - pos];
                    j = 0;
                    while (j < colCellsSpan.length) {
                        colCellsSpan[j] = pos + j;
                        ++j;
                    }
                }
                rowCellsSpan = new int[rows.size() - oldIndex];
                j = 0;
                while (j < rowCellsSpan.length) {
                    rowCellsSpan[j] = oldIndex + j;
                    ++j;
                }
                PivotTable.this.rowsTable.combine(rowCellsSpan, colCellsSpan);
                ++i;
            }
        }
    }
}

