/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.properties.client;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.table.DefaultTableModel;
import org.openswing.swing.client.InputControl;
import org.openswing.swing.util.client.ClientSettings;

public class PropertyGridModel
extends DefaultTableModel {
    private HashSet changedRows;
    private Hashtable changedValues = new Hashtable();
    private int mode = 0;

    public PropertyGridModel() {
        super(new String[]{ClientSettings.getInstance().getResources().getResource("property name"), ClientSettings.getInstance().getResources().getResource("property value"), "", ""}, 0);
        this.changedRows = new HashSet();
    }

    public final int findRow(String attributeName) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (attributeName.equals(this.getInputControl(i).getAttributeName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final String getAttributeName(int rowIndex) {
        return this.getInputControl(rowIndex).getAttributeName();
    }

    public final int[] getChangedRowNumbers() {
        int[] rows = new int[this.changedRows.size()];
        Iterator it = this.changedRows.iterator();
        int i = 0;
        while (it.hasNext()) {
            rows[i++] = (Integer)it.next();
        }
        return rows;
    }

    public final Object getDefaultValue(int rowIndex) {
        return this.getValueAt(rowIndex, 3);
    }

    public final InputControl getInputControl(int rowIndex) {
        return (InputControl)this.getValueAt(rowIndex, 2);
    }

    public final int getMode() {
        return this.mode;
    }

    public final Object getOldPropertyValue(int rowIndex) {
        return this.changedValues.get(new Integer(rowIndex));
    }

    public final Object getPropertyValue(int rowIndex) {
        return this.getValueAt(rowIndex, 1);
    }

    public final Object getUserObject(int rowIndex) {
        return this.getValueAt(rowIndex, 4);
    }

    public final boolean isCellEditable(int row, int column) {
        return column == 1 && (this.mode == 2 || this.mode == 1);
    }

    public final boolean isRequired(int rowIndex) {
        return this.getInputControl(rowIndex).isRequired();
    }

    public final void setMode(int mode) {
        this.mode = mode;
        this.changedRows.clear();
        this.changedValues.clear();
        if (mode == 1) {
            Object defValue = null;
            int i = 0;
            while (i < this.getRowCount()) {
                defValue = this.getDefaultValue(i);
                this.setValueAt(defValue, i, 1);
                ++i;
            }
        }
    }

    public final void setPropertyValue(int rowIndex, Object value) {
        this.setValueAt(value, rowIndex, 1);
    }

    public final void setValueAt(Object aValue, int row, int column) {
        Object oldValue = this.getValueAt(row, column);
        if ((oldValue != null && aValue == null || oldValue == null && aValue != null || oldValue != null && !oldValue.equals(aValue)) && !this.changedRows.contains(new Integer(row))) {
            this.changedRows.add(new Integer(row));
            if (oldValue != null) {
                this.changedValues.put(new Integer(row), oldValue);
            }
        }
        super.setValueAt(aValue, row, column);
    }
}

