/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.openswing.swing.client.DataController;
import org.openswing.swing.client.ExpandableRowController;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.OptionPane;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.send.java.FilterWhereClause;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.GridStatusPanel;
import org.openswing.swing.table.client.GridUI;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.client.ListFilterController;
import org.openswing.swing.table.client.OrderPolicy;
import org.openswing.swing.table.client.PaginationVerticalScrollbar;
import org.openswing.swing.table.columns.client.ButtonColumn;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.editors.client.CheckBoxCellEditor;
import org.openswing.swing.table.filter.client.QuickFilterListener;
import org.openswing.swing.table.filter.client.QuickFilterPanel;
import org.openswing.swing.table.model.client.VOListAdapter;
import org.openswing.swing.table.model.client.VOListTableModel;
import org.openswing.swing.table.profiles.java.GridProfile;
import org.openswing.swing.table.renderers.client.ExpandablePanel;
import org.openswing.swing.table.renderers.client.ExpandableRenderer;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;
import org.openswing.swing.util.client.SearchControl;
import org.openswing.swing.util.client.SearchWindowManager;

public class Grid
extends JTable
implements QuickFilterListener,
DragSourceListener,
DropTargetListener,
SearchControl,
MouseListener {
    public static final int BOTTOM_GRID = 2;
    public static final int MAIN_GRID = 0;
    public static final int TOP_GRID = 1;
    private Color activeCellBackgroundColor = ClientSettings.GRID_ACTIVE_CELL_BACKGROUND;
    private Hashtable additionalHeaderToHeaders;
    private boolean allowColumnsSortingInEdit = false;
    private Icon ascSort = new ImageIcon(ClientUtils.getImage(ClientSettings.SORT_DOWN));
    private Hashtable cellSpans;
    private MouseListener colHeaderMouseListener = null;
    private Column[] colProps = null;
    private boolean colorsInReadOnlyMode = true;
    private static final Border columnHeaderBorder = new BevelBorder(0);
    private HashMap comboFilterControllers;
    private boolean controlDown = false;
    private Component currentEditor = null;
    private Icon descSort = new ImageIcon(ClientUtils.getImage(ClientSettings.SORT_UP));
    private Cursor dragCursor = null;
    private DragSource dragSource;
    private DropTarget dropTarget = null;
    private DropTarget dropTarget2 = null;
    private String expandableColumnAttributeName = null;
    private ExpandableRenderer expandableRenderer = null;
    private ExpandableRowController expandableRowController = null;
    private Icon filterSymbol = new ImageIcon(ClientUtils.getImage(ClientSettings.FILTER_SYMBOL));
    private boolean firstTime = true;
    private int fromColIndex;
    private GridController gridController = null;
    private String gridId = null;
    private KeyListener gridListener;
    private int gridType;
    private Grids grids = null;
    private boolean hasColSpan = false;
    private int headerHeight;
    private Hashtable headerToAdditionalHeader;
    private boolean lockedGrid;
    private VOListTableModel model = null;
    private VOListAdapter modelAdapter = null;
    private OrderPolicy orderPolicy = null;
    private boolean orderWithLoadData = true;
    private boolean overwriteRowWhenExpanding = false;
    private Grid parentGrid = null;
    private boolean parentGridAlreadyCalculated = false;
    private boolean reorderingAllowed = true;
    private boolean resizingAllowed = true;
    private MouseListener rightClickMouseListener;
    private boolean rowHeightFixed = true;
    private JScrollPane scrollPane = null;
    public boolean searchAdditionalRows = false;
    private SearchWindowManager searchWindowManager = null;
    private boolean singleExpandableRow = false;
    private GridStatusPanel statusPanel = null;
    private TableColumn[] tableColumnModel = null;
    private int toColIndex;
    private PaginationVerticalScrollbar vScrollbar;

    public Grid(Grids grids, Column[] colProps, GridStatusPanel statusPanel, int fromColIndex, int toColIndex, boolean colorsInReadOnlyMode, VOListTableModel model, VOListAdapter modelAdapter, GridController gridController, boolean lockedGrid, boolean anchorLastColumn, int expandableColumn, boolean singleExpandableRow, boolean overwriteRowWhenExpanding, ExpandableRowController expandableRowController, HashMap comboFilters, int headerHeight, boolean searchAdditionalRows, boolean allowColumnsSortingInEdit, int gridType) {
        this.dragSource = new DragSource();
        this.headerToAdditionalHeader = new Hashtable();
        this.additionalHeaderToHeaders = new Hashtable();
        this.cellSpans = new Hashtable();
        this.headerHeight = ClientSettings.HEADER_HEIGHT;
        this.gridListener = new GridListener();
        this.comboFilterControllers = new HashMap();
        this.grids = grids;
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.colProps = colProps;
        this.statusPanel = statusPanel;
        this.fromColIndex = fromColIndex;
        this.toColIndex = toColIndex;
        this.colorsInReadOnlyMode = colorsInReadOnlyMode;
        this.gridController = gridController;
        this.lockedGrid = lockedGrid;
        this.singleExpandableRow = singleExpandableRow;
        this.overwriteRowWhenExpanding = overwriteRowWhenExpanding;
        this.expandableRowController = expandableRowController;
        this.comboFilterControllers = comboFilters;
        this.setShowGrid(true);
        if (!anchorLastColumn) {
            this.setAutoResizeMode(0);
        }
        this.setRowHeight(ClientSettings.CELL_HEIGHT);
        this.setSelectionMode(0);
        this.setSurrendersFocusOnKeystroke(true);
        this.setBackground(ClientSettings.GRID_CELL_BACKGROUND);
        this.setForeground(ClientSettings.GRID_CELL_FOREGROUND);
        this.setSelectionBackground(ClientSettings.GRID_SELECTION_BACKGROUND);
        this.setSelectionForeground(ClientSettings.GRID_SELECTION_FOREGROUND);
        this.headerHeight = headerHeight;
        this.searchAdditionalRows = searchAdditionalRows;
        this.allowColumnsSortingInEdit = allowColumnsSortingInEdit;
        this.gridType = gridType;
        if (expandableColumn >= 0) {
            this.expandableColumnAttributeName = colProps[expandableColumn].getColumnName();
        }
        try {
            this.setModel(model);
            this.setUI(new GridUI());
            this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(ClientUtils.getImage("drag.gif"), new Point(15, 10), ClientSettings.getInstance().getResources().getResource("drag"));
            this.prepareJTable();
            this.checkColumnSpans();
            if (expandableRowController != null) {
                this.setResizingAllowed(false);
                this.setReorderingAllowed(false);
            }
            TableColumnModel colsModel = this.getColumnModel();
            this.tableColumnModel = new TableColumn[colsModel.getColumnCount()];
            int i = 0;
            while (i < colsModel.getColumnCount()) {
                this.tableColumnModel[i] = colsModel.getColumn(i);
                ++i;
            }
            this.setVisibleColumns();
            if (gridType == 0) {
                if (this.rightClickMouseListener == null) {
                    this.rightClickMouseListener = this;
                }
                MouseListener[] l = this.getMouseListeners();
                int i2 = 0;
                while (i2 < l.length) {
                    this.removeMouseListener(l[i2]);
                    ++i2;
                }
                this.addMouseListener(new MouseAdapter(){

                    static /* synthetic */ Grid access$900(1 x0) {
                        return x0.Grid.this;
                    }

                    public void mouseClicked(MouseEvent e) {
                        Component c;
                        Pair p = Grid.this.rowColumnAtPoint(e.getPoint());
                        if (Grid.this.grids != null && Grid.this.grids.getMode() == 0 && Grid.this.expandableRowController != null && Grid.this.expandableRowController.isRowExpandable(Grid.this.grids.getVOListTableModel(), p.n1) && p.n2 >= Grid.this.modelAdapter.getFieldIndex(Grid.this.expandableColumnAttributeName) && Grid.this.grids.isRowExpanded(p.n1) && (c = Grid.this.grids.getComponentInCache(p.n1)) != null) {
                            int row = Grid.this.rowAtPoint(e.getPoint());
                            int y = Grid.this.getRowHeight();
                            int i = 0;
                            while (i < row) {
                                y += Grid.this.getRowHeight(i);
                                ++i;
                            }
                            int x = 13;
                            int expandableColIndex = Grid.this.modelAdapter.getFieldIndex(Grid.this.expandableColumnAttributeName);
                            int i2 = 0;
                            while (i2 < expandableColIndex) {
                                x += Grid.this.getColumnModel().getColumn(i2).getWidth();
                                ++i2;
                            }
                            if (c.getParent() == null) {
                                ((JComponent)e.getSource()).remove(c);
                                ((JComponent)e.getSource()).add(c);
                                c.setBounds(x, y, c.getWidth(), c.getHeight());
                            }
                            x = e.getX() - x;
                            y = e.getY() - y;
                            if (x >= 0 && y >= 0) {
                                Component c2 = SwingUtilities.getDeepestComponentAt(c, x, y);
                                if (c2 != null && c2 instanceof JViewport && c2.getMouseListeners().length == 0 && c2.getParent().getComponentCount() > 0 && c2.getParent().getComponent(0) instanceof JViewport && ((JViewport)c2.getParent().getComponent(0)).getComponentCount() == 1 && ((JViewport)c2.getParent().getComponent(0)).getComponent(0) instanceof Grid) {
                                    c2 = ((Grid)((JViewport)c2.getParent().getComponent(0)).getComponent(0)).getTableHeader();
                                }
                                if (c2 != null) {
                                    Point pp = SwingUtilities.convertPoint(c, x, y, c2);
                                    c2.dispatchEvent(new MouseEvent(c2, e.getID(), e.getWhen(), e.getModifiers(), pp.x, pp.y, e.getClickCount(), e.isPopupTrigger()));
                                    Component c3 = SwingUtilities.getDeepestComponentAt(c, x, y);
                                    Grid.this.grids.setCurrentNestedComponent(Grid.this.getSelectedRow(), c3);
                                    c2.repaint();
                                    ((Component)e.getSource()).repaint();
                                    Grid.this.repaint();
                                    return;
                                }
                            }
                        }
                        Grid.this.grids.setCurrentNestedComponent(-1, null);
                        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && Grid.this.gridController != null && Grid.this.getSelectedRow() != -1 && Grid.this.model.getMode() == 0) {
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    Grid.access$700(1.access$900(this.this$1)).doubleClick(1.access$900(this.this$1).getSelectedRow(), Grid.access$800(1.access$900(this.this$1)).getObjectForRow(1.access$900(this.this$1).getSelectedRow()));
                                }
                            });
                        } else if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && Grid.this.gridController != null && Grid.this.model.getMode() == 0 && Grid.this.grids.getNavBar() != null) {
                            Grid.this.grids.getNavBar().fireButtonPressedEvent("LEFT_MOUSE_BUTTON");
                        }
                    }

                    public void mousePressed(MouseEvent e) {
                        Component c;
                        Pair p = Grid.this.rowColumnAtPoint(e.getPoint());
                        if (Grid.this.grids != null && Grid.this.grids.getMode() == 0 && Grid.this.expandableRowController != null && Grid.this.expandableRowController.isRowExpandable(Grid.this.grids.getVOListTableModel(), p.n1) && p.n2 >= Grid.this.modelAdapter.getFieldIndex(Grid.this.expandableColumnAttributeName) && Grid.this.grids.isRowExpanded(p.n1) && (c = Grid.this.grids.getComponentInCache(p.n1)) != null) {
                            Component c2;
                            int row = Grid.this.rowAtPoint(e.getPoint());
                            int y = Grid.this.getRowHeight();
                            int i = 0;
                            while (i < row) {
                                y += Grid.this.getRowHeight(i);
                                ++i;
                            }
                            int x = 13;
                            int expandableColIndex = Grid.this.modelAdapter.getFieldIndex(Grid.this.expandableColumnAttributeName);
                            int i2 = 0;
                            while (i2 < expandableColIndex) {
                                x += Grid.this.getColumnModel().getColumn(i2).getWidth();
                                ++i2;
                            }
                            if (c.getParent() == null) {
                                ((JComponent)e.getSource()).remove(c);
                                ((JComponent)e.getSource()).add(c);
                                c.setBounds(x, y, c.getWidth(), c.getHeight());
                            }
                            x = e.getX() - x;
                            y = e.getY() - y;
                            if (x >= 0 && y >= 0 && (c2 = SwingUtilities.getDeepestComponentAt(c, x, y)) != null) {
                                Point pp = SwingUtilities.convertPoint(c, x, y, c2);
                                Grid.this.grids.setCurrentNestedComponent(Grid.this.getSelectedRow(), c2);
                                c2.dispatchEvent(new MouseEvent(c2, e.getID(), e.getWhen(), e.getModifiers(), pp.x, pp.y, e.getClickCount(), e.isPopupTrigger()));
                                Component c3 = SwingUtilities.getDeepestComponentAt(c, x, y);
                                Grid.this.grids.setCurrentNestedComponent(Grid.this.getSelectedRow(), c3);
                                c2.repaint();
                                Grid.this.repaint();
                                return;
                            }
                        }
                        Grid.this.grids.setCurrentNestedComponent(-1, null);
                    }

                    public void mouseReleased(MouseEvent e) {
                        Component c;
                        Pair p = Grid.this.rowColumnAtPoint(e.getPoint());
                        if (Grid.this.grids != null && Grid.this.grids.getMode() == 0 && Grid.this.expandableRowController != null && Grid.this.expandableRowController.isRowExpandable(Grid.this.grids.getVOListTableModel(), p.n1) && p.n2 >= Grid.this.modelAdapter.getFieldIndex(Grid.this.expandableColumnAttributeName) && Grid.this.grids.isRowExpanded(p.n1) && (c = Grid.this.grids.getComponentInCache(p.n1)) != null) {
                            Component c2;
                            int row = Grid.this.rowAtPoint(e.getPoint());
                            int y = Grid.this.getRowHeight();
                            int i = 0;
                            while (i < row) {
                                y += Grid.this.getRowHeight(i);
                                ++i;
                            }
                            int x = 13;
                            int expandableColIndex = Grid.this.modelAdapter.getFieldIndex(Grid.this.expandableColumnAttributeName);
                            int i2 = 0;
                            while (i2 < expandableColIndex) {
                                x += Grid.this.getColumnModel().getColumn(i2).getWidth();
                                ++i2;
                            }
                            if (c.getParent() == null) {
                                ((JComponent)e.getSource()).remove(c);
                                ((JComponent)e.getSource()).add(c);
                                c.setBounds(x, y, c.getWidth(), c.getHeight());
                            }
                            x = e.getX() - x;
                            y = e.getY() - y;
                            if (x >= 0 && y >= 0 && (c2 = SwingUtilities.getDeepestComponentAt(c, x, y)) != null) {
                                Point pp = SwingUtilities.convertPoint(c, x, y, c2);
                                c2.dispatchEvent(new MouseEvent(c2, e.getID(), e.getWhen(), e.getModifiers(), pp.x, pp.y, e.getClickCount(), e.isPopupTrigger()));
                                Component c3 = SwingUtilities.getDeepestComponentAt(c, x, y);
                                Grid.this.grids.setCurrentNestedComponent(Grid.this.getSelectedRow(), c3);
                                c2.repaint();
                                ((Component)e.getSource()).repaint();
                                Grid.this.repaint();
                                Grid.this.getParentGrid().getParent().repaint();
                                return;
                            }
                        }
                        Grid.this.grids.setCurrentNestedComponent(-1, null);
                        Grid.this.repaint();
                    }
                });
                int i3 = 0;
                while (i3 < l.length) {
                    this.addMouseListener(l[i3]);
                    ++i3;
                }
                this.addMouseListener(this.rightClickMouseListener);
                this.addKeyListener(this.gridListener);
            }
            if (gridType == 1) {
                this.setRowSelectionAllowed(false);
                this.setCellSelectionEnabled(true);
                this.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        if (Grid.this.getSelectedRow() != -1) {
                            Grid.this.removeRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                        }
                    }
                });
            }
            if (gridType == 2) {
                this.setRowSelectionAllowed(false);
                this.setCellSelectionEnabled(true);
                this.addFocusListener(new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        if (Grid.this.getSelectedRow() != -1) {
                            Grid.this.removeRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                        }
                    }
                });
            }
            this.prepareHeader();
            if (grids.getGridControl() != null && (gridType != 0 || grids.getGridControl().getLockedRowsOnTop() != 0) && gridType != 1 && this.getTableHeader() != null) {
                this.getTableHeader().setVisible(false);
                this.setTableHeader(null);
            }
        }
        catch (Throwable t) {
            Logger.error(this.getClass().getName(), "Grid", "Error while constructing grid.", t);
        }
    }

    static /* synthetic */ void access$3200(Grid x0, KeyEvent x1) {
        x0.tabPressed(x1);
    }

    static /* synthetic */ ExpandableRenderer access$3500(Grid x0) {
        return x0.expandableRenderer;
    }

    static /* synthetic */ int access$3600(Grid x0, int x1) {
        return x0.calcHeightToRow(x1);
    }

    static /* synthetic */ void access$3700(Grid x0, int x1, int x2) {
        x0.showPopupMenu(x1, x2);
    }

    static /* synthetic */ void access$3800(Grid x0, KeyEvent x1) {
        x0.shiftTabPressed(x1);
    }

    static /* synthetic */ Grid access$3900(Grid x0) {
        return x0.parentGrid;
    }

    static /* synthetic */ Component access$4000(Grid x0) {
        return x0.currentEditor;
    }

    public final void addNotify() {
        block4: {
            block3: {
                super.addNotify();
                if (!this.firstTime || this.gridType != 0) break block3;
                this.firstTime = false;
                this.dropTarget = new DropTarget(this.scrollPane, this);
                this.dropTarget2 = new DropTarget(this, this);
                if (this.grids != null && this.grids.getGridControl() != null && this.grids.getGridControl().getLockedRowsOnTop() != 0) break block4;
                int i = 0;
                while (i < this.tableColumnModel.length) {
                    this.tableColumnModel[i].setHeaderValue(ClientSettings.getInstance().getResources().getResource(this.colProps[i].getHeaderColumnName()));
                    ++i;
                }
                break block4;
            }
            if (this.grids != null && this.grids.getGridControl() != null && this.gridType == 1 && this.grids.getGridControl().getLockedRowsOnTop() > 0) {
                int i = 0;
                while (i < this.tableColumnModel.length) {
                    this.tableColumnModel[i].setHeaderValue(ClientSettings.getInstance().getResources().getResource(this.colProps[i].getHeaderColumnName()));
                    ++i;
                }
            }
        }
    }

    public final void addPopupCommand(JMenuItem item) {
        this.grids.getPopupCommands().add(item);
    }

    private int calcHeightToRow(int row) {
        int y = 0;
        int i = 0;
        while (i < row) {
            y += this.getRowHeight(i);
            ++i;
        }
        return y;
    }

    private void checkColumnSpans() {
        int rest = 0;
        boolean disableAdditionalHeaders = false;
        this.hasColSpan = false;
        int i = 0;
        while (i < this.colProps.length) {
            if (this.colProps[i].getAdditionalHeaderColumnSpan() > 0 && rest > 0) {
                disableAdditionalHeaders = true;
                this.hasColSpan = false;
                Logger.error(this.getClass().getName(), "checkColumnSpans", "The specified attribute '" + this.colProps[i].getColumnName() + "' has an additional column header with col span >0 and incompatibile with previous col spans.", null);
                break;
            }
            if (this.colProps[i].getAdditionalHeaderColumnSpan() > 0 && rest == 0) {
                rest = this.colProps[i].getAdditionalHeaderColumnSpan() - 1;
                this.hasColSpan = true;
            } else if (rest > 0) {
                --rest;
            }
            ++i;
        }
        if (disableAdditionalHeaders) {
            int i2 = 0;
            while (i2 < this.colProps.length) {
                this.colProps[i2].setAdditionalHeaderColumnSpan(0);
                ++i2;
            }
        }
    }

    public final void collapseRow(int row) {
        if (this.expandableRenderer != null) {
            this.expandableRenderer.collapseRow(row);
        }
    }

    public final int columnAtPoint(Point point) {
        return this.rowColumnAtPoint(point).getN2();
    }

    public final void columnMarginChanged(ChangeEvent e) {
        int index;
        TableColumn resizingColumn;
        try {
            resizingColumn = this.getTableHeader().getResizingColumn();
            if (resizingColumn != null) {
                index = resizingColumn.getModelIndex();
                this.colProps[index].setPreferredWidth(resizingColumn.getWidth());
                this.repaintAdditionalColumnHeaders(index, resizingColumn.getWidth());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            resizingColumn = this.getTableHeader().getResizingColumn();
            if (resizingColumn != null) {
                index = resizingColumn.getModelIndex();
                this.colProps[index].setPreferredWidth(resizingColumn.getWidth());
                JPanel hp = (JPanel)this.headerToAdditionalHeader.get(new Integer(index));
                if (hp != null) {
                    ArrayList list = (ArrayList)this.additionalHeaderToHeaders.get(hp);
                    int w = 0;
                    int i = 0;
                    while (i < list.size()) {
                        w += this.colProps[(Integer)list.get(i)].getPreferredWidth();
                        ++i;
                    }
                    hp.setPreferredSize(new Dimension(w, hp.getSize().height));
                    hp.revalidate();
                    hp.getParent().validate();
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        super.columnMarginChanged(e);
        try {
            if (this.gridType == 1 && this.grids.getGridControl() != null && this.grids.getGridControl().getTopTable() != null && (resizingColumn = this.getTableHeader().getResizingColumn()) != null) {
                index = resizingColumn.getModelIndex();
                this.colProps[index].setPreferredWidth(resizingColumn.getWidth());
                index = this.convertColumnIndexToView(index);
                if (this.lockedGrid) {
                    this.grids.getGridControl().getTable().getLockedGrid().getColumnModel().getColumn(index).setPreferredWidth(resizingColumn.getPreferredWidth());
                } else {
                    this.grids.getGridControl().getTable().getGrid().getColumnModel().getColumn(index).setPreferredWidth(resizingColumn.getPreferredWidth());
                }
                if (this.grids.getGridControl().getBottomTable() != null) {
                    if (this.lockedGrid) {
                        this.grids.getGridControl().getBottomTable().getLockedGrid().getColumnModel().getColumn(index).setPreferredWidth(resizingColumn.getPreferredWidth());
                    } else {
                        this.grids.getGridControl().getBottomTable().getGrid().getColumnModel().getColumn(index).setPreferredWidth(resizingColumn.getPreferredWidth());
                    }
                }
            }
            if (this.grids.getGridControl() != null && this.grids.getGridControl().getLockedRowsOnTop() == 0 && this.grids.getGridControl().getLockedRowsOnBottom() > 0 && this.gridType == 0 && this.grids.getGridControl().getBottomTable() != null) {
                resizingColumn = this.getTableHeader().getResizingColumn();
                index = resizingColumn.getModelIndex();
                index = this.convertColumnIndexToView(index);
                if (this.lockedGrid) {
                    this.grids.getGridControl().getBottomTable().getLockedGrid().getColumnModel().getColumn(index).setPreferredWidth(resizingColumn.getPreferredWidth());
                } else {
                    this.grids.getGridControl().getBottomTable().getGrid().getColumnModel().getColumn(index).setPreferredWidth(resizingColumn.getPreferredWidth());
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            int width = 0;
            int i = 0;
            while (i < this.tableHeader.getColumnModel().getColumnCount()) {
                width += this.tableHeader.getColumnModel().getColumn(i).getWidth();
                ++i;
            }
            this.tableHeader.setPreferredSize(new Dimension(width, this.headerHeight));
        }
        catch (Exception ex) {
        }
    }

    public final void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        if (this.gridType == 1 && this.grids.getGridControl() != null && this.grids.getGridControl().getTopTable() != null) {
            if (this.lockedGrid) {
                this.grids.getGridControl().getTable().getLockedGrid().moveColumn(e.getFromIndex(), e.getToIndex());
            } else {
                this.grids.getGridControl().getTable().getGrid().moveColumn(e.getFromIndex(), e.getToIndex());
            }
            if (this.grids.getGridControl().getBottomTable() != null) {
                if (this.lockedGrid) {
                    this.grids.getGridControl().getBottomTable().getLockedGrid().moveColumn(e.getFromIndex(), e.getToIndex());
                } else {
                    this.grids.getGridControl().getBottomTable().getGrid().moveColumn(e.getFromIndex(), e.getToIndex());
                }
            }
        }
        if (this.grids.getGridControl() != null && this.grids.getGridControl().getLockedRowsOnTop() == 0 && this.grids.getGridControl().getBottomTable() != null && this.gridType == 0) {
            if (this.lockedGrid) {
                this.grids.getGridControl().getBottomTable().getLockedGrid().moveColumn(e.getFromIndex(), e.getToIndex());
            } else {
                this.grids.getGridControl().getBottomTable().getGrid().moveColumn(e.getFromIndex(), e.getToIndex());
            }
        }
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        Rectangle r = this.getVisibleRect();
        int row = this.getSelectedRow();
        try {
            if (this.rowAtPoint(new Point(r.x, r.y)) > row) {
                row = this.rowAtPoint(new Point(r.x, r.y + r.height - 1));
                this.setRowSelectionInterval(row, row);
            } else if (this.rowAtPoint(new Point(r.x, r.y + r.height - 1)) < row) {
                row = this.rowAtPoint(new Point(r.x, r.y));
                this.setRowSelectionInterval(row, row);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.ensureRowIsVisible(row);
        this.revalidate();
        this.repaint();
        if (this.getTableHeader() != null) {
            this.getTableHeader().revalidate();
            this.getTableHeader().repaint();
        }
    }

    private void configQuickFilter(int x, int y) {
        int modelColIndex;
        int n = modelColIndex = this.getSelectedColumn() == -1 ? -1 : this.getColumnModel().getColumn(this.getSelectedColumn()).getModelIndex();
        if (modelColIndex == -1) {
            Point tablexy = this.getLocationOnScreen();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xOverflow = x + (int)tablexy.getX() + this.grids.getPopup().getWidth() - (int)screenSize.getWidth();
            int popupX = xOverflow > 0 ? x - xOverflow - 20 : x;
            modelColIndex = this.getColumnModel().getColumnIndexAtX(popupX + this.scrollPane.getHorizontalScrollBar().getValue());
        }
        if (modelColIndex != -1 && this.colProps[modelColIndex].isColumnFilterable()) {
            Object initialValue;
            this.grids.getFilterPanel();
            int filterType = 0;
            switch (this.colProps[modelColIndex].getColumnType()) {
                case 1: 
                case 2: 
                case 3: {
                    this.grids.getFilterPanel();
                    filterType = 1;
                    break;
                }
                default: {
                    this.grids.getFilterPanel();
                    filterType = 0;
                }
            }
            if (this.grids.getQuickFilterValues().get(this.colProps[modelColIndex].getColumnName()) != null) {
                this.grids.getRemovefilterItem().setVisible(true);
            } else {
                this.grids.getRemovefilterItem().setVisible(false);
            }
            Object object = initialValue = this.getSelectedRow() >= 0 ? this.getModel().getValueAt(this.getSelectedRow(), modelColIndex) : null;
            if (this.gridController != null) {
                initialValue = this.gridController.getInitialQuickFilterValue(this.colProps[modelColIndex].getColumnName(), initialValue);
            }
            QuickFilterPanel quickFilterPanel = new QuickFilterPanel((ListFilterController)this.comboFilterControllers.get(this.colProps[modelColIndex].getColumnName()), this.grids.getDefaultQuickFilterCriteria(), this, filterType, this.colProps[modelColIndex], (FilterWhereClause[])this.grids.getQuickFilterValues().get(this.colProps[modelColIndex].getColumnName()), initialValue);
            quickFilterPanel.setBackground(this.grids.getRemovefilterItem().getBackground());
            this.grids.setFilterPanel(quickFilterPanel);
            this.grids.getFilterPanel().setVisible(this.colProps[modelColIndex].isColumnFilterable());
        } else {
            this.grids.setFilterPanel(null);
        }
    }

    protected void configureEnclosingScrollPane() {
        Container p = this.getParent();
        if (p instanceof JViewport) {
            Container gp = p.getParent();
            if (gp instanceof JScrollPane) {
                this.scrollPane = (JScrollPane)gp;
                if (this.rightClickMouseListener == null) {
                    this.rightClickMouseListener = this;
                }
                try {
                    this.scrollPane.removeMouseListener(this.rightClickMouseListener);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.scrollPane.addMouseListener(this.rightClickMouseListener);
                this.createVerticalScrollBarListener(this.scrollPane);
                JViewport viewport = this.scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                JPanel topPanel = new JPanel();
                topPanel.setLayout(new GridBagLayout());
                JTableHeader th = this.getTableHeader();
                if (th != null) {
                    topPanel.add((Component)th, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                if (this.hasColSpan && (this.gridType == 0 && this.grids.getGridControl() == null || this.gridType == 0 && this.grids.getGridControl() != null && this.grids.getGridControl().getTopTable() == null || this.gridType == 1)) {
                    JPanel additionalColHeaders = new JPanel();
                    additionalColHeaders.setLayout(new FlowLayout(0, 0, 0));
                    int span = 0;
                    int w = 0;
                    int rest = 0;
                    JLabel h = null;
                    JPanel hp = null;
                    Color backcolor = new JButton().getBackground();
                    int i = 0;
                    while (i < this.colProps.length) {
                        ArrayList<Integer> list;
                        if (this.colProps[i].getAdditionalHeaderColumnSpan() > 0) {
                            span = this.colProps[i].getAdditionalHeaderColumnSpan();
                            hp = new JPanel();
                            if (this.colProps[i].getHeaderTextHorizontalAlignment() == 0) {
                                hp.setLayout(new FlowLayout(1, 0, 0));
                            } else if (this.colProps[i].getHeaderTextHorizontalAlignment() == 2) {
                                hp.setLayout(new FlowLayout(0, 0, 0));
                            } else if (this.colProps[i].getHeaderTextHorizontalAlignment() == 4) {
                                hp.setLayout(new FlowLayout(2, 0, 0));
                            }
                            hp.setBorder(BorderFactory.createRaisedBevelBorder());
                            hp.setBackground(backcolor);
                            h = new JLabel();
                            if (this.colProps[i].getHeaderFont() != null) {
                                h.setFont(this.colProps[i].getHeaderFont());
                            }
                            if (this.colProps[i].getHeaderForegroundColor() != null) {
                                h.setForeground(this.colProps[i].getHeaderForegroundColor());
                            }
                            hp.add((Component)h, null);
                            h.setText(ClientSettings.getInstance().getResources().getResource(this.colProps[i].getAdditionalHeaderColumnName()));
                            rest = span - 1;
                            w = this.colProps[i].getPreferredWidth();
                            list = new ArrayList<Integer>();
                            list.add(new Integer(i));
                            this.additionalHeaderToHeaders.put(hp, list);
                            this.headerToAdditionalHeader.put(new Integer(i), hp);
                        } else {
                            w += this.colProps[i].getPreferredWidth();
                            --rest;
                            list = (ArrayList<Integer>)this.additionalHeaderToHeaders.get(hp);
                            if (list != null) {
                                list.add(new Integer(i));
                            }
                            this.headerToAdditionalHeader.put(new Integer(i), hp);
                        }
                        if (rest == 0 && h != null) {
                            hp.setPreferredSize(new Dimension(w, this.headerHeight));
                            if (i >= this.fromColIndex && i < this.toColIndex) {
                                additionalColHeaders.add((Component)hp, null);
                            }
                        }
                        ++i;
                    }
                    topPanel.add((Component)additionalColHeaders, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                this.scrollPane.setColumnHeaderView(topPanel);
                Border border = this.scrollPane.getBorder();
                if (border == null || border instanceof UIResource) {
                    this.scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                }
            }
            if (this.gridType == 0 && this.searchWindowManager == null) {
                this.searchWindowManager = new SearchWindowManager(this);
            }
        }
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel(){

            public void moveColumn(int index, int newIndex) {
                if (Grid.this.hasColSpan && (Grid.this.gridType == 1 || Grid.this.grids.getGridControl() != null && Grid.this.grids.getGridControl().getTopTable() == null && Grid.this.gridType == 0 || Grid.this.grids.getGridControl() == null)) {
                    try {
                        JPanel hp1 = (JPanel)Grid.this.headerToAdditionalHeader.get(new Integer(index));
                        JPanel hp2 = (JPanel)Grid.this.headerToAdditionalHeader.get(new Integer(newIndex));
                        if (hp1 != null && hp2 != null && hp1.equals(hp2)) {
                            super.moveColumn(index, newIndex);
                            return;
                        }
                        return;
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
                super.moveColumn(index, newIndex);
            }
        };
    }

    private void createVerticalScrollBarListener(final JScrollPane scrollPane) {
        this.vScrollbar = new PaginationVerticalScrollbar();
        scrollPane.setVerticalScrollBarPolicy(22);
        this.vScrollbar.setUnitIncrement(this.getRowHeight());
        if (ClientSettings.GRID_SCROLL_BLOCK_INCREMENT == 1) {
            this.vScrollbar.setBlockIncrement(this.getRowHeight());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Grid.this.vScrollbar.setBlockIncrement(((Grid)Grid.this).vScrollbar.getVisibleRect().height - scrollPane.getHorizontalScrollBar().getHeight());
                }
            });
        }
        VerticalScrollBarMouseListener vsListener = new VerticalScrollBarMouseListener();
        this.vScrollbar.getDecrButton().addMouseListener(vsListener);
        this.vScrollbar.getIncrButton().addMouseListener(vsListener);
        this.vScrollbar.getIncrButton().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (Grid.this.grids.getNavBar() != null) {
                    Grid.this.grids.getNavBar().fireButtonPressedEvent("LEFT_MOUSE_BUTTON");
                }
            }
        });
        this.vScrollbar.getDecrButton().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (Grid.this.grids.getNavBar() != null) {
                    Grid.this.grids.getNavBar().fireButtonPressedEvent("LEFT_MOUSE_BUTTON");
                }
            }
        });
        if (this.vScrollbar.getPrevPgButton() != null) {
            this.vScrollbar.getPrevPgButton().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    Grid.this.previousPage(Grid.this.grids.getGridControl() == null ? null : Grid.this.grids.getGridControl().getNavBar());
                }
            });
        }
        if (this.vScrollbar.getNextPgButton() != null) {
            this.vScrollbar.getNextPgButton().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    Grid.this.nextPage(Grid.this.grids.getGridControl() == null ? null : Grid.this.grids.getGridControl().getNavBar());
                }
            });
        }
        this.vScrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Grid.this.repaint();
            }
        });
        if (this.gridType == 0) {
            scrollPane.setVerticalScrollBar(this.vScrollbar);
        }
    }

    public final boolean disableListener() {
        return this.grids.getCurrentNestedComponent() != null;
    }

    public final void dragDropEnd(DragSourceDropEvent event) {
        this.gridController.dragDropEnd();
    }

    public final void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
        this.gridController.dropEnter();
    }

    public final void dragEnter(DragSourceDragEvent event) {
        this.setCursor(Cursor.getDefaultCursor());
        this.gridController.dragEnter();
    }

    public final void dragExit(DropTargetEvent event) {
        try {
            this.gridController.dropExit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void dragExit(DragSourceEvent event) {
        this.setCursor(Cursor.getDefaultCursor());
        this.gridController.dragExit();
    }

    public final void dragOver(DropTargetDragEvent event) {
        int row = this.rowAtPoint(event.getLocation());
        this.gridController.dropOver(row);
    }

    public final void dragOver(DragSourceDragEvent event) {
        this.setCursor(this.dragCursor);
        this.gridController.dragOver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void drop(DropTargetDropEvent event) {
        block12: {
            block11: {
                this.setCursor(Cursor.getDefaultCursor());
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    if (this.gridController.dropEnabled((String)transferable.getTransferData(DataFlavor.stringFlavor))) {
                        event.acceptDrop(2);
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                    break block11;
                }
                event.rejectDrop();
            }
            Object var4_4 = null;
            try {
                MDIFrame.getInstance().setCursor(new Cursor(0));
            }
            catch (Exception ex2) {
            }
            break block12;
            {
                catch (Exception ex) {
                    ex.printStackTrace();
                    event.rejectDrop();
                    Object var4_5 = null;
                    try {
                        MDIFrame.getInstance().setCursor(new Cursor(0));
                    }
                    catch (Exception ex2) {
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    MDIFrame.getInstance().setCursor(new Cursor(0));
                }
                catch (Exception ex2) {
                }
                throw throwable;
            }
        }
    }

    public final void dropActionChanged(DropTargetDragEvent event) {
        this.gridController.dropActionChanged();
    }

    public final void dropActionChanged(DragSourceDragEvent event) {
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.grids == null) {
            return false;
        }
        if (this.grids != null && this.grids.getMode() == 0) {
            int i = 0;
            while (i < this.colProps.length) {
                if (this.colProps[i].getColumnType() == 11 && ((ButtonColumn)this.colProps[i]).isEnableInReadOnlyMode()) {
                    return super.editCellAt(row, column, e);
                }
                if (this.colProps[i].getColumnType() == 19) {
                    return super.editCellAt(row, column, e);
                }
                if (this.colProps[i].getColumnType() == 6 && ((CheckBoxColumn)this.colProps[i]).isEnableInReadOnlyMode()) {
                    return super.editCellAt(row, column, e);
                }
                ++i;
            }
            return false;
        }
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(column, column);
        return super.editCellAt(row, column, e);
    }

    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            boolean ok = this.model.setValue(value, this.editingRow, this.convertColumnIndexToModel(this.editingColumn));
            final int row = this.editingRow;
            final int col = this.editingColumn;
            this.removeEditor();
            if (!ok) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Grid.this.editCellAt(row, col);
                    }
                });
            }
        }
    }

    public final void enableDrag(String gridId) {
        try {
            this.gridId = gridId;
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, new DragGestureAdapter(this));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void ensureRowIsVisible(int selRow) {
        Rectangle r = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn() == -1 ? 0 : this.getSelectedColumn(), true);
        this.scrollRectToVisible(r);
    }

    public void filter(Column colProps, Object value1, Object value2) {
        if (colProps == null) {
            return;
        }
        Class clazz = this.grids.getVOListTableModel().getColumnClass(this.grids.getVOListTableModel().findColumn(colProps.getColumnName()));
        value1 = ClientUtils.convertObject(value1, clazz);
        value2 = ClientUtils.convertObject(value2, clazz);
        if (this.gridController != null) {
            value1 = this.gridController.beforeFilterGrid(colProps.getColumnName(), value1);
            if (value2 != null) {
                value2 = this.gridController.beforeFilterGrid(colProps.getColumnName(), value2);
            }
        }
        FilterWhereClause[] values = null;
        if (value2 != null) {
            values = new FilterWhereClause[]{new FilterWhereClause(colProps.getColumnName(), ">=", value1), new FilterWhereClause(colProps.getColumnName(), value2 instanceof Date ? "<" : "<=", value2)};
            this.grids.getQuickFilterValues().put(colProps.getColumnName(), values);
        } else {
            int colType = colProps.getColumnType();
            if ((colType == 0 || colType == 8) && value1 != null && (value1.toString().endsWith("%") || value1.toString().startsWith("%"))) {
                values = new FilterWhereClause[]{new FilterWhereClause(colProps.getColumnName(), ClientSettings.LIKE, value1), null};
                this.grids.getQuickFilterValues().put(colProps.getColumnName(), values);
            } else {
                values = new FilterWhereClause[]{new FilterWhereClause(colProps.getColumnName(), "=", value1), null};
                this.grids.getQuickFilterValues().put(colProps.getColumnName(), values);
            }
        }
        int gridIndex = -1;
        int i = 0;
        while (i < this.getModel().getColumnCount()) {
            try {
                gridIndex = this.convertColumnIndexToView(i);
                if (gridIndex != -1 && colProps.getColumnName().equals(this.getVOListTableModel().getColumnName(i)) && this.getTableHeader() != null) {
                    if (!ClientSettings.SHOW_FILTER_SYMBOL) {
                        ((TableColumnHeaderRenderer)this.getTableHeader().getColumnModel().getColumn(gridIndex).getHeaderRenderer()).setBorder(BorderFactory.createLoweredBevelBorder());
                    } else {
                        this.repaint();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        this.grids.reloadDataFromStart();
        this.grids.getRemovefilterItem().setVisible(true);
        this.grids.getPopup().setVisible(false);
        this.grids.getPopup().setVisible(true);
        this.grids.getFilterPanel().requestFocus();
    }

    public void finalize() {
        try {
            if (this.searchWindowManager != null) {
                this.searchWindowManager.hideSearchWindow();
            }
            FocusListener[] fl = this.getFocusListeners();
            int i = 0;
            while (i < fl.length) {
                this.removeFocusListener(fl[i]);
                ++i;
            }
            MouseListener[] ml = this.getMouseListeners();
            int i2 = 0;
            while (i2 < ml.length) {
                this.removeMouseListener(ml[i2]);
                ++i2;
            }
            KeyListener[] ll = this.getKeyListeners();
            int i3 = 0;
            while (i3 < ll.length) {
                this.removeKeyListener(ll[i3]);
                ++i3;
            }
            try {
                int i4 = 0;
                while (i4 < this.getColumnModel().getColumnCount()) {
                    try {
                        this.getColumnModel().getColumn(i4).getCellEditor().getClass().getMethod("finalize", new Class[0]).invoke((Object)this.getColumnModel().getColumn(i4).getCellEditor(), new Object[0]);
                    }
                    catch (NoSuchMethodException ex1) {
                        // empty catch block
                    }
                    try {
                        this.getColumnModel().getColumn(i4).getCellRenderer().getClass().getMethod("finalize", new Class[0]).invoke((Object)this.getColumnModel().getColumn(i4).getCellRenderer(), new Object[0]);
                    }
                    catch (NoSuchMethodException ex1) {
                    }
                    ++i4;
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            if (this.modelAdapter != null) {
                this.modelAdapter.finalize();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gridController = null;
        this.modelAdapter = null;
        this.model = null;
        this.colProps = null;
        this.tableColumnModel = null;
        this.grids = null;
        this.dragSource = null;
        this.searchWindowManager = null;
        this.expandableRowController = null;
        this.expandableRenderer = null;
        this.parentGrid = null;
    }

    public final Color getActiveCellBackgroundColor() {
        return this.activeCellBackgroundColor;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle r = new Rectangle();
        boolean valid = true;
        if (row >= 0 && column >= 0 && row < this.model.getRowCount() && column < this.model.getColumnCount() && !this.isVisible(row, column)) {
            int temp_row = row;
            int temp_column = column;
            row += this.getSpan(temp_row, temp_column).getN1();
            column += this.getSpan(temp_row, temp_column).getN2();
        }
        Pair n = this.getSpan(row, column);
        if (row < 0) {
            valid = false;
        } else if (row >= this.getRowCount()) {
            r.y = this.getHeight();
            valid = false;
        } else {
            r.height = n.getN1() * this.getRowHeight(row);
            r.y = this.calcHeightToRow(row);
        }
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else if (column >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else {
            int i;
            TableColumnModel cm = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                i = 0;
                while (i < column) {
                    r.x += cm.getColumn(i).getWidth();
                    ++i;
                }
            } else {
                i = cm.getColumnCount() - 1;
                while (i > column) {
                    r.x += cm.getColumn(i).getWidth();
                    --i;
                }
            }
            r.width = 0;
            i = column;
            while (i < column + n.getN2()) {
                r.width += cm.getColumn(i).getWidth();
                ++i;
            }
        }
        if (valid && !includeSpacing) {
            int rm = this.getRowMargin();
            int cm = this.getColumnModel().getColumnMargin();
            r.setBounds(r.x + cm / 2, r.y + rm / 2, r.width - cm, r.height - rm);
        }
        return r;
    }

    public final TableCellRenderer getCellRenderer(int row, int col) {
        TableCellRenderer rend = super.getCellRenderer(row, col);
        int expandableColumn = this.modelAdapter.getFieldIndex(this.expandableColumnAttributeName);
        if (this.expandableRowController != null && this.expandableColumnAttributeName != null && this.expandableRenderer == null) {
            this.expandableRenderer = new ExpandableRenderer(this, this.grids, expandableColumn, this.modelAdapter);
            this.setRowHeightFixed(false);
        }
        if (this.expandableRenderer != null) {
            this.expandableRenderer.setDefaultCellRenderer(rend);
            return this.expandableRenderer;
        }
        return rend;
    }

    public int getColumnIndex(String columnName) {
        return this.modelAdapter.getFieldIndex(columnName);
    }

    public final JComponent getComponent() {
        return this;
    }

    public final String getExpandableColumnAttributeName() {
        return this.expandableColumnAttributeName;
    }

    private final ExpandablePanel getExpandablePanel(Component c) {
        while (c != null && !(c instanceof ExpandablePanel)) {
            c = c.getParent();
        }
        if (c != null && c instanceof ExpandablePanel) {
            return (ExpandablePanel)c;
        }
        return null;
    }

    public final ExpandableRowController getExpandableRowController() {
        return this.expandableRowController;
    }

    public Grids getGrids() {
        return this.grids;
    }

    public final int getMode() {
        return this.model.getMode();
    }

    public final Grid getParentGrid() {
        if (this.parentGrid != null || this.parentGridAlreadyCalculated) {
            return this.parentGrid;
        }
        this.parentGridAlreadyCalculated = true;
        Container c = this;
        while (c != null && !(c instanceof ExpandablePanel)) {
            c = c.getParent();
        }
        if (c != null && c instanceof ExpandablePanel) {
            while (c != null && !(c instanceof Grid)) {
                c = c.getParent();
            }
            if (c != null) {
                this.parentGrid = (Grid)c;
            }
        }
        return this.parentGrid;
    }

    public final int getRowCount() {
        return this.model == null ? 0 : this.model.getRowCount();
    }

    public final int getSelectedIndex() {
        return this.getSelectedRow();
    }

    public final MouseListener getSortingMouseListener() {
        return this.colHeaderMouseListener;
    }

    public final Pair getSpan(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return new Pair(1, 1);
        }
        Pair p = (Pair)this.cellSpans.get(new Pair(row, column));
        if (p == null) {
            return new Pair(1, 1);
        }
        return p;
    }

    public final VOListTableModel getVOListTableModel() {
        return this.model;
    }

    public final String getValueAt(int index) {
        if (this.getSelectedColumn() == -1 && this.getColumnCount() > 0) {
            this.setColumnSelectionInterval(0, 0);
        }
        try {
            Object obj = this.getValueAt(index, this.getSelectedColumn());
            if (obj != null && obj instanceof Number) {
                return obj.toString();
            }
            JLabel l = (JLabel)this.getCellRenderer(index, this.getSelectedColumn()).getTableCellRendererComponent(this, this.getValueAt(index, this.getSelectedColumn()), false, false, index, this.getSelectedColumn());
            return l.getText();
        }
        catch (Exception ex) {
            return this.getValueAt(index, this.getSelectedColumn()) == null ? "" : this.getValueAt(index, this.getSelectedColumn()).toString();
        }
    }

    public final boolean hasCellSpan() {
        return this.cellSpans.size() > 0;
    }

    public final boolean hasColSpan() {
        return this.hasColSpan;
    }

    public final void internalSorting() {
        Vector list = this.getVOListTableModel().getDataVector();
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Grid.this.orderPolicy.compareRow(Grid.this.modelAdapter, Grid.this.grids, Grid.this.model, (ValueObject)o1, (ValueObject)o2);
            }

            public boolean equals(Object obj) {
                return obj.equals(this);
            }
        });
        this.repaint();
        if (this.grids.getLockedGrid() != null) {
            this.grids.getLockedGrid().repaint();
        }
        this.orderPolicy.afterSorting(this.model);
    }

    public final boolean isColorsInReadOnlyMode() {
        return this.colorsInReadOnlyMode;
    }

    public boolean isDataModified() {
        boolean modified = false;
        if (this.getMode() == 1) {
            modified = true;
        } else if (this.getMode() == 2) {
            modified = this.stopCellEditing() ? true : this.getVOListTableModel().getChangedRows().size() > 0;
        }
        return modified;
    }

    private boolean isOutOfBounds(int[] rows, int[] columns) {
        int i = 0;
        while (i < rows.length) {
            if (rows[i] < 0 || this.model.getRowCount() <= rows[i]) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < columns.length) {
            if (columns[i2] < 0 || this.model.getColumnCount() <= columns[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean isOutOfBounds(int row, int column) {
        return row < 0 || this.model.getRowCount() <= row || column < 0 || this.model.getColumnCount() <= column;
    }

    public final boolean isOverwriteRowWhenExpanding() {
        return this.overwriteRowWhenExpanding;
    }

    public final boolean isReadOnly() {
        return this.getMode() == 0;
    }

    public final boolean isRowHeightFixed() {
        return this.rowHeightFixed;
    }

    public final boolean isSearchWindowVisible() {
        return this.searchWindowManager != null && this.searchWindowManager.isSearchWindowVisible();
    }

    public final boolean isSingleExpandableRow() {
        return this.singleExpandableRow;
    }

    public final boolean isVisible(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return false;
        }
        Pair p = (Pair)this.cellSpans.get(new Pair(row, column));
        if (p == null) {
            return true;
        }
        return p.getN1() >= 1 && p.getN2() >= 1;
    }

    public final boolean mergeCells(int[] rows, int[] columns) {
        int i = 0;
        while (i < rows.length) {
            int j = 0;
            while (j < columns.length) {
                if (this.cellSpans.get(new Pair(rows[0] + i, columns[0] + j)) != null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        int ii = 0;
        while (i2 < rows.length) {
            int j = 0;
            int jj = 0;
            while (j < columns.length) {
                this.cellSpans.put(new Pair(rows[0] + i2, columns[0] + j), new Pair(ii, jj));
                ++j;
                --jj;
            }
            ++i2;
            --ii;
        }
        this.cellSpans.put(new Pair(rows[0], columns[0]), new Pair(rows.length, columns.length));
        return true;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
            if (this.getParentGrid() != null && e.getSource().equals(this)) {
                return;
            }
            if (this.grids.getCurrentNestedComponent() != null) {
                int row = this.rowAtPoint(e.getPoint());
                int y = this.getRowHeight();
                int i = 0;
                while (i < row) {
                    y += this.getRowHeight(i);
                    ++i;
                }
                int x = 13;
                int expandableColIndex = this.modelAdapter.getFieldIndex(this.expandableColumnAttributeName);
                int i2 = 0;
                while (i2 < expandableColIndex) {
                    x += this.getColumnModel().getColumn(i2).getWidth();
                    ++i2;
                }
                x = e.getX() - x;
                y = e.getY() - y;
                if (x >= 0 && y >= 0) {
                    ExpandablePanel c = this.getExpandablePanel(this.grids.getCurrentNestedComponent());
                    Point pp = SwingUtilities.convertPoint(c, x, y, this.grids.getCurrentNestedComponent());
                    this.grids.getCurrentNestedComponent().dispatchEvent(new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), pp.x, pp.y, e.getClickCount(), e.isPopupTrigger()));
                }
                e.consume();
                return;
            }
            if (this.columnAtPoint(e.getPoint()) >= 0) {
                this.setColumnSelectionInterval(this.columnAtPoint(e.getPoint()), this.columnAtPoint(e.getPoint()));
            }
            if (this.model.getRowCount() > 0 && this.rowAtPoint(e.getPoint()) >= 0 && this.getSelectedRows() != null && this.getSelectedRows().length <= 1) {
                this.setRowSelectionInterval(this.rowAtPoint(e.getPoint()), this.rowAtPoint(e.getPoint()));
            }
            this.showPopupMenu(e.getX(), e.getY());
            e.consume();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public final void nextPage(NavigatorBar navBar) {
        if (this.getMode() != 0) {
            return;
        }
        this.vScrollbar.setValue(this.vScrollbar.getMaximum());
        this.scrollMov(this.vScrollbar, "NEXT_PG_BUTTON");
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        }
        if (navBar != null) {
            navBar.fireButtonPressedEvent("NEXT_PG_BUTTON");
        }
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        JComponent jComp;
        boolean isSelected;
        Object value = this.getValueAt(row, column);
        Component comp = editor.getTableCellEditorComponent(this, value, isSelected = this.isCellSelected(row, column), row, column);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent(this);
        }
        this.currentEditor = comp;
        this.currentEditor.addKeyListener(this.gridListener);
        return comp;
    }

    private void prepareHeader() {
        int i = 0;
        while (i < this.tableColumnModel.length) {
            this.tableColumnModel[i].setHeaderRenderer(new TableColumnHeaderRenderer(this.colProps[i].getColumnName(), this.colProps[i].getHeaderTextHorizontalAlignment(), this.colProps[i].getHeaderTextVerticalAlignment(), this.colProps[i].getHeaderFont(), this.colProps[i].getHeaderForegroundColor()));
            ++i;
        }
        JTableHeader th = this.getTableHeader();
        th.setPreferredSize(new Dimension(th.getPreferredSize().width, this.headerHeight));
        th.setPreferredSize(new Dimension(th.getPreferredSize().width, this.headerHeight));
        th.setReorderingAllowed(this.reorderingAllowed);
        th.setResizingAllowed(this.resizingAllowed);
        this.colHeaderMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (Grid.this.model.getMode() != 0 && (Grid.this.model.getMode() != 2 || !Grid.this.allowColumnsSortingInEdit || Grid.this.orderWithLoadData)) {
                    return;
                }
                if (!(Grid.this.isEnabled() || Grid.this.model.getMode() == 2 && Grid.this.allowColumnsSortingInEdit)) {
                    return;
                }
                if (Grid.this.grids.getCurrentNestedComponent() != null) {
                    Grid.this.grids.getCurrentNestedComponent().dispatchEvent(e);
                    Grid.this.repaint();
                    return;
                }
                TableColumnModel columnModel = Grid.this.getColumnModel();
                int viewColumnIndex = columnModel.getColumnIndexAtX(e.getX());
                int modelColumnIndex = Grid.this.convertColumnIndexToModel(viewColumnIndex);
                if (e.getClickCount() == 1 && modelColumnIndex != -1) {
                    boolean ok = Grid.this.refreshIconsAndSort(modelColumnIndex);
                    if (Grid.this.grids.getGridControl() != null && ok && Grid.this.gridType == 1) {
                        if (Grid.this.lockedGrid) {
                            Grid.this.grids.getGridControl().getTable().getLockedGrid().getSortingMouseListener().mouseClicked(e);
                        } else {
                            Grid.this.grids.getGridControl().getTable().getGrid().getSortingMouseListener().mouseClicked(e);
                        }
                    }
                    return;
                }
            }
        };
        th.addMouseListener(this.colHeaderMouseListener);
        this.setOrderList();
    }

    public final void prepareJTable() {
        TableColumnModel cmodel = this.getColumnModel();
        int cols = cmodel.getColumnCount();
        int i = 0;
        while (i < cols) {
            int w;
            TableColumn tc = cmodel.getColumn(i);
            if (i >= this.fromColIndex && i < this.toColIndex) {
                tc.setCellRenderer(this.modelAdapter.getCellRenderer(i));
                tc.setCellEditor(this.modelAdapter.getCellEditor(i));
            }
            if ((w = this.modelAdapter.getFieldPreferredWidth(i)) > 0) {
                tc.setPreferredWidth(w);
            }
            if ((w = this.modelAdapter.getFieldMinWidth(i)) > 0) {
                tc.setMinWidth(w);
            }
            if ((w = this.modelAdapter.getFieldMaxWidth(i)) > 0) {
                tc.setMaxWidth(w);
            }
            ++i;
        }
    }

    public final Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean hasFocus;
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        boolean rowIsAnchor = this.selectionModel.getAnchorSelectionIndex() == row;
        boolean colIsAnchor = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == column;
        boolean bl = hasFocus = rowIsAnchor && colIsAnchor;
        if (hasFocus) {
            try {
                Grid parentGrid = this.getParentGrid();
                hasFocus = parentGrid != null && parentGrid.grids.getCurrentNestedComponent() != null && parentGrid.grids.getCurrentNestedComponent() == this && this.grids.getCurrentNestedComponent() == null ? true : this.isFocusOwner();
            }
            catch (Exception ex) {
                hasFocus = this.isFocusOwner();
            }
        }
        return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
    }

    public final void previousPage(NavigatorBar navBar) {
        if (this.getMode() != 0) {
            return;
        }
        this.vScrollbar.setValue(this.vScrollbar.getMinimum());
        this.scrollMov(this.vScrollbar, "PREV_PG_BUTTON");
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
        if (navBar != null) {
            navBar.fireButtonPressedEvent("PREV_PG_BUTTON");
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.grids.getCurrentNestedComponent() != null) {
            Component source = (Component)e.getSource();
            if (e.getID() == 401 && e.getKeyChar() == '\t' && !e.isShiftDown()) {
                Container c = source.getParent();
                while (c != null && !(c instanceof Grid) && !(c instanceof Form)) {
                    c = c.getParent();
                }
                if (c != null && c instanceof Form) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    e.consume();
                    return true;
                }
            } else if (e.getID() == 401 && e.getKeyChar() == '\t' && e.isShiftDown()) {
                Container c = source.getParent();
                while (c != null && !(c instanceof Grid) && !(c instanceof Form)) {
                    c = c.getParent();
                }
                if (c != null && c instanceof Form) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    e.consume();
                    return true;
                }
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (this.getMode() != 0 && this.getCellEditor() != null && this.getCellEditor() instanceof CheckBoxCellEditor) {
            if (e.getID() == 501 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                ((CheckBoxCellEditor)this.getCellEditor()).changeSelectedValue();
            }
        }
    }

    private void rebindButtons(DataController dataController) {
        if (ClientSettings.MDI_TOOLBAR != null && !ClientSettings.MDI_TOOLBAR.containsDataController(dataController)) {
            ClientSettings.MDI_TOOLBAR.setDataController(dataController);
        }
    }

    public final void refreshExpandableRenderer() {
        if (this.expandableRenderer != null) {
            this.expandableRenderer.refreshExpandableRenderer();
        }
    }

    private boolean refreshIconsAndSort(int modelColumnIndex) {
        try {
            Column colProp = this.colProps[modelColumnIndex];
            if (!colProp.isColumnSortable()) {
                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("This column is not sorteable"), ClientSettings.getInstance().getResources().getResource("Sorting not allowed"), 2);
                return false;
            }
            int maxSortingOrder = -1;
            int currentColSorted = 0;
            int i = 0;
            while (i < this.colProps.length) {
                if (this.colProps[i].isColumnSortable() && !this.colProps[i].getSortVersus().equals("NO_SORT")) {
                    ++currentColSorted;
                    maxSortingOrder = Math.max(maxSortingOrder, this.colProps[i].getSortingOrder());
                }
                ++i;
            }
            String currentSortVersus = colProp.getSortVersus();
            if (currentSortVersus.equals("NO_SORT")) {
                currentSortVersus = "ASC";
            } else if (currentSortVersus.equals("ASC")) {
                currentSortVersus = "DESC";
            } else if (currentSortVersus.equals("DESC")) {
                currentSortVersus = "NO_SORT";
            }
            if (colProp.getSortVersus().equals("NO_SORT") && !currentSortVersus.equals("NO_SORT") && currentColSorted == this.grids.getMaxSortedColumns() && this.grids.getMaxSortedColumns() == 1) {
                int i2 = 0;
                while (i2 < this.colProps.length) {
                    if (this.colProps[i2].isColumnSortable() && !this.colProps[i2].getSortVersus().equals("NO_SORT")) {
                        this.colProps[i2].setSortVersus("NO_SORT");
                        this.colProps[i2].setSortingOrder(0);
                        break;
                    }
                    ++i2;
                }
                maxSortingOrder = 0;
            } else if (colProp.getSortVersus().equals("NO_SORT") && !currentSortVersus.equals("NO_SORT") && currentColSorted >= this.grids.getMaxSortedColumns()) {
                OptionPane.showMessageDialog(ClientUtils.getParentFrame(this), ClientSettings.getInstance().getResources().getResource("Maximum number of sorted columns"), ClientSettings.getInstance().getResources().getResource("Sorting not applicable"), 2);
                return false;
            }
            colProp.setSortVersus(currentSortVersus);
            if (currentSortVersus.equals("NO_SORT")) {
                colProp.setSortingOrder(0);
            } else if (colProp.getSortingOrder() == 0) {
                colProp.setSortingOrder(maxSortingOrder + 1);
            }
            if (maxSortingOrder != -1) {
                Integer[] aux = new Integer[Math.max(maxSortingOrder + 1, this.colProps.length + 1)];
                int i3 = 0;
                while (i3 < this.colProps.length) {
                    if (this.colProps[i3].isColumnSortable() && !this.colProps[i3].getSortVersus().equals("NO_SORT")) {
                        aux[this.colProps[i3].getSortingOrder()] = new Integer(i3);
                    }
                    ++i3;
                }
                int pos = 1;
                int i4 = 0;
                while (i4 < aux.length) {
                    if (aux[i4] != null) {
                        this.colProps[aux[i4]].setSortingOrder(pos);
                        ++pos;
                    }
                    ++i4;
                }
            }
            if (this.getTableHeader() != null) {
                this.getTableHeader().repaint();
            }
            this.setOrderList();
            if (this.orderWithLoadData || this.grids.getLastIndex() - this.grids.getVOListTableModel().getRowCount() > 0 || this.grids.isMoreRows()) {
                this.grids.reload();
            } else {
                this.internalSorting();
            }
            return true;
        }
        catch (Exception ex) {
            Logger.error(this.getClass().getName(), "refreshIconsAndSort", "Error while loading data on sorting", ex);
            return false;
        }
    }

    public void removeEditor() {
        if (this.currentEditor != null) {
            this.currentEditor.removeKeyListener(this.gridListener);
        }
        this.currentEditor = null;
        super.removeEditor();
    }

    public final boolean removeMergedCells(int[] rows, int[] columns) {
        int i = 0;
        while (i < rows.length) {
            int j = 0;
            while (j < columns.length) {
                if (this.cellSpans.get(new Pair(rows[0] + i, columns[0] + j)) == null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        int ii = 0;
        while (i2 < rows.length) {
            int j = 0;
            int jj = 0;
            while (j < columns.length) {
                this.cellSpans.remove(new Pair(rows[0] + i2, columns[0] + j));
                ++j;
                --jj;
            }
            ++i2;
            --ii;
        }
        this.cellSpans.remove(new Pair(rows[0], columns[0]));
        return true;
    }

    public void removeQuickFilter(String attributeName) {
        FilterWhereClause[] values = (FilterWhereClause[])this.grids.getQuickFilterValues().remove(attributeName);
        if (values == null) {
            return;
        }
        int gridIndex = -1;
        int i = 0;
        while (i < this.getModel().getColumnCount()) {
            try {
                gridIndex = this.convertColumnIndexToView(i);
                if (gridIndex != -1 && attributeName.equals(this.getVOListTableModel().getColumnName(i)) && !ClientSettings.SHOW_FILTER_SYMBOL && this.getTableHeader() != null) {
                    ((TableColumnHeaderRenderer)this.getTableHeader().getColumnModel().getColumn(gridIndex).getHeaderRenderer()).setBorder(BorderFactory.createRaisedBevelBorder());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        this.grids.reload();
    }

    private void repaintAdditionalColumnHeaders(int index, int width) {
        try {
            JPanel hp = (JPanel)this.headerToAdditionalHeader.get(new Integer(index));
            if (hp != null) {
                ArrayList list = (ArrayList)this.additionalHeaderToHeaders.get(hp);
                int w = 0;
                int i = 0;
                while (i < list.size()) {
                    w = i != index ? (w += this.colProps[(Integer)list.get(i)].getPreferredWidth()) : (w += width);
                    ++i;
                }
                hp.setPreferredSize(new Dimension(w, hp.getSize().height));
                hp.revalidate();
                hp.getParent().validate();
            }
        }
        catch (Exception ex) {
        }
    }

    public final void requestFocus() {
        if (this.grids.getCurrentNestedComponent() != null) {
            this.grids.getCurrentNestedComponent().requestFocus();
            if (ClientSettings.MDI_TOOLBAR != null) {
                if (this.grids.getCurrentNestedComponent() instanceof DataController) {
                    this.rebindButtons((DataController)((Object)this.grids.getCurrentNestedComponent()));
                } else {
                    this.rebindButtons(this.grids);
                }
            }
        } else if (ClientSettings.MDI_TOOLBAR != null) {
            this.rebindButtons(this.grids);
        }
        super.requestFocus();
    }

    public final void resetColumns(GridProfile profile) {
        String[] attrs = profile.getColumnsAttribute();
        Hashtable<String, Integer> aux = new Hashtable<String, Integer>();
        int i = 0;
        while (i < attrs.length) {
            aux.put(attrs[i], new Integer(i - this.fromColIndex));
            ++i;
        }
        Hashtable map = new Hashtable();
        int i2 = this.fromColIndex;
        while (i2 < this.toColIndex) {
            map.put(aux.get(this.colProps[i2].getColumnName()), new Integer(i2));
            ++i2;
        }
        TableColumnModel colsModel = this.getColumnModel();
        while (colsModel.getColumnCount() > 0) {
            colsModel.removeColumn(colsModel.getColumn(0));
        }
        int i3 = 0;
        while (i3 < map.size()) {
            int index = (Integer)map.get(new Integer(i3));
            if (this.colProps[index].isColumnVisible()) {
                this.addColumn(this.tableColumnModel[index]);
                this.tableColumnModel[index].setPreferredWidth(profile.getColumnsWidth()[index]);
            }
            ++i3;
        }
    }

    public final int rowAtPoint(Point point) {
        return this.rowColumnAtPoint(point).getN1();
    }

    private Pair rowColumnAtPoint(Point point) {
        Pair retValue = new Pair(-1, -1);
        int h = 0;
        int row = 0;
        row = 0;
        while (row < this.getRowCount()) {
            if (h + this.getRowHeight(row) > point.y) break;
            h += this.getRowHeight(row);
            ++row;
        }
        if (row < 0 || this.model.getRowCount() <= row) {
            return retValue;
        }
        int column = this.getColumnModel().getColumnIndexAtX(point.x);
        if (this.isVisible(row, column)) {
            retValue.setN1(row);
            retValue.setN2(column);
            return retValue;
        }
        retValue.setN2(column + this.getSpan(row, column).getN2());
        retValue.setN1(row + this.getSpan(row, column).getN1());
        return retValue;
    }

    private void scrollMov(JScrollBar scrollBar, String pageButton) {
        if (this.getMode() != 0) {
            return;
        }
        if (!this.grids.isListenEvent()) {
            return;
        }
        int scrollableZoneSize = scrollBar.getMaximum() - scrollBar.getVisibleAmount();
        if (scrollBar.getValue() >= scrollableZoneSize / 4 * 3 && this.grids.isMoreRows() && (pageButton == null || "NEXT_PG_BUTTON".equals(pageButton))) {
            this.setRowSelectionInterval(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
            this.grids.nextRow(this.grids.getGridControl() == null ? null : this.grids.getGridControl().getNavBar(), new ActionEvent(this, 1001, "NEXT_PG_BUTTON"));
            this.setRowSelectionInterval(this.model.getRowCount() / 2, this.model.getRowCount() / 2);
            this.ensureRowIsVisible(this.getSelectedRow());
        } else if (scrollBar.getValue() <= scrollableZoneSize / 4 && this.grids.getLastIndex() + 1 > this.model.getRowCount() && (pageButton == null || "PREV_PG_BUTTON".equals(pageButton))) {
            this.setRowSelectionInterval(0, 0);
            this.grids.previousRow(this.grids.getGridControl() == null ? null : this.grids.getGridControl().getNavBar(), new ActionEvent(this, 1001, "PREV_PG_BUTTON"));
            this.setRowSelectionInterval(this.model.getRowCount() / 2, this.model.getRowCount() / 2);
            this.ensureRowIsVisible(this.getSelectedRow());
        }
    }

    public final int search(String textToSearch) {
        if (this.searchAdditionalRows) {
            if (this.getSelectedColumn() == -1 && this.getColumnCount() > 0) {
                this.setColumnSelectionInterval(0, 0);
            }
            String attrName = this.grids.getVOListTableModel().getColumnName(this.convertColumnIndexToModel(this.getSelectedColumn()));
            return this.grids.retrieveAdditionalRows(attrName, textToSearch);
        }
        return -1;
    }

    public final void setActiveCellBackgroundColor(Color activeCellBackgroundColor) {
        this.activeCellBackgroundColor = activeCellBackgroundColor;
    }

    public final void setColorsInReadOnlyMode(boolean colorsInReadOnlyMode) {
        this.colorsInReadOnlyMode = colorsInReadOnlyMode;
    }

    private void setOrderList() {
        Integer[] aux = new Integer[this.colProps.length + 1];
        int i = 0;
        while (i < this.colProps.length) {
            if (!this.colProps[i].getSortVersus().equals("NO_SORT") && this.colProps[i].getSortingOrder() < aux.length) {
                aux[this.colProps[i].getSortingOrder()] = new Integer(i);
            }
            ++i;
        }
        this.grids.getCurrentSortedColumns().clear();
        this.grids.getCurrentSortedVersusColumns().clear();
        int i2 = 0;
        while (i2 < aux.length) {
            if (aux[i2] != null) {
                if (this.colProps[aux[i2]].getSortVersus().equals("ASC")) {
                    this.grids.getCurrentSortedColumns().add(this.colProps[aux[i2]].getColumnName());
                    this.grids.getCurrentSortedVersusColumns().add("ASC");
                } else if (this.colProps[aux[i2]].getSortVersus().equals("DESC")) {
                    this.grids.getCurrentSortedColumns().add(this.colProps[aux[i2]].getColumnName());
                    this.grids.getCurrentSortedVersusColumns().add("DESC");
                }
            }
            ++i2;
        }
    }

    public final void setOrderWithLoadData(boolean orderWithLoadData, OrderPolicy orderPolicy) {
        this.orderWithLoadData = orderWithLoadData;
        this.orderPolicy = orderPolicy;
    }

    public final void setReorderingAllowed(boolean reorderingAllowed) {
        this.reorderingAllowed = reorderingAllowed;
        if (this.getTableHeader() != null) {
            this.getTableHeader().setReorderingAllowed(reorderingAllowed);
        }
    }

    public final void setResizingAllowed(boolean resizingAllowed) {
        this.resizingAllowed = resizingAllowed;
        if (this.getTableHeader() != null) {
            this.getTableHeader().setResizingAllowed(resizingAllowed);
        }
    }

    public final void setRowHeightFixed(boolean rowHeightFixed) {
        this.rowHeightFixed = rowHeightFixed;
    }

    public final void setSelectedIndex(int index) {
        this.setRowSelectionInterval(index, index);
    }

    public final void setVisibleColumn(int columnModelIndex, boolean colVisible) {
        this.colProps[columnModelIndex].setColumnVisible(colVisible);
        TableColumnModel colsModel = this.getColumnModel();
        int columnViewIndex = this.convertColumnIndexToView(columnModelIndex);
        if (!colVisible && columnViewIndex != -1) {
            colsModel.removeColumn(colsModel.getColumn(columnViewIndex));
        } else if (colVisible && columnViewIndex == -1) {
            this.setVisibleColumns();
        }
        if (this.grids.getGridControl() != null && this.grids.getGridControl().getLockedRowsOnTop() > 0 && this.gridType == 0 && this.grids.getGridControl().getTopTable() != null) {
            this.grids.getGridControl().getTopTable().getGrid().setVisibleColumn(columnModelIndex, colVisible);
            if (this.grids.getGridControl().getTopTable().getLockedGrid() != null) {
                this.grids.getGridControl().getTopTable().getLockedGrid().setVisibleColumn(columnModelIndex, colVisible);
            }
        }
        if (this.grids.getGridControl() != null && this.grids.getGridControl().getLockedRowsOnBottom() > 0 && this.gridType == 0 && this.grids.getGridControl().getBottomTable() != null) {
            this.grids.getGridControl().getBottomTable().getGrid().setVisibleColumn(columnModelIndex, colVisible);
            if (this.grids.getGridControl().getBottomTable().getLockedGrid() != null) {
                this.grids.getGridControl().getBottomTable().getLockedGrid().setVisibleColumn(columnModelIndex, colVisible);
            }
        }
        if (this.hasColSpan) {
            this.repaintAdditionalColumnHeaders(columnModelIndex, colVisible ? this.colProps[columnModelIndex].getPreferredWidth() : 0);
        }
    }

    private final void setVisibleColumns() {
        TableColumnModel colsModel = this.getColumnModel();
        while (colsModel.getColumnCount() > 0) {
            colsModel.removeColumn(colsModel.getColumn(0));
        }
        int i = this.fromColIndex;
        while (i < this.toColIndex) {
            if (this.colProps[i].isColumnVisible()) {
                this.addColumn(this.tableColumnModel[i]);
            }
            ++i;
        }
    }

    private void shiftTabPressed(KeyEvent e) {
        int colIndex = this.getSelectedColumn();
        if (colIndex == -1) {
            e.consume();
            return;
        }
        if (colIndex == 0 && this.getSelectedRow() > 0) {
            colIndex = this.getColumnCount() - 1;
            this.setRowSelectionInterval(this.getSelectedRow() - 1, this.getSelectedRow() - 1);
            this.setColumnSelectionInterval(colIndex, colIndex);
        }
        while (colIndex > 0 && !this.isCellEditable(this.getSelectedRow(), colIndex - 1)) {
            --colIndex;
        }
        if (colIndex >= 0) {
            this.setColumnSelectionInterval(colIndex, colIndex);
        } else if (this.getSelectedRow() > 0) {
            this.setRowSelectionInterval(this.getSelectedRow() - 1, this.getSelectedRow() - 1);
            this.setColumnSelectionInterval(colIndex, colIndex);
            this.shiftTabPressed(e);
        } else {
            e.consume();
            return;
        }
    }

    private void showPopupMenu(final int x, int y) {
        try {
            int modelColIndex;
            Point tmpTablexy = null;
            try {
                tmpTablexy = this.getLocationOnScreen();
            }
            catch (Exception ex1) {
                tmpTablexy = this.getLocation();
            }
            final Point tablexy = tmpTablexy;
            final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.grids.getPopup().removeAll();
            if (this.getMode() == 0) {
                this.configQuickFilter(x, y);
                if (this.grids.getFilterPanel() != null) {
                    this.grids.getFilterPanel().setParentPopup(this.grids.getPopup());
                    this.grids.getPopup().add(this.grids.getFilterPanel());
                    this.grids.getRemovefilterItem().setToolTipText(ClientSettings.getInstance().getResources().getResource("Remove Filter"));
                    this.grids.getRemovefilterItem().removeAll();
                    this.grids.getRemovefilterItem().addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            int modelColIndex;
                            int n = modelColIndex = Grid.this.getSelectedColumn() == -1 ? -1 : Grid.this.getColumnModel().getColumn(Grid.this.getSelectedColumn()).getModelIndex();
                            if (modelColIndex == -1) {
                                int xOverflow = x + (int)tablexy.getX() + Grid.this.grids.getPopup().getWidth() - (int)screenSize.getWidth();
                                int popupX = xOverflow > 0 ? x - xOverflow - 20 : x;
                                modelColIndex = Grid.this.getColumnModel().getColumnIndexAtX(popupX);
                            }
                            if (modelColIndex != -1) {
                                Grid.this.removeQuickFilter(Grid.this.modelAdapter.getFieldName(modelColIndex));
                            }
                        }
                    });
                    this.grids.getPopup().add(this.grids.getRemovefilterItem());
                    this.grids.getPopup().add(new JSeparator());
                }
                JMenuItem menuItem = null;
                int i = 0;
                while (i < this.grids.getPopupCommands().size()) {
                    menuItem = (JMenuItem)this.grids.getPopupCommands().get(i);
                    this.grids.getPopup().add(menuItem);
                    ++i;
                }
                if (this.grids.getPopupCommands().size() > 0) {
                    this.grids.getPopup().add(new JSeparator());
                }
            }
            int n = modelColIndex = this.getSelectedColumn() == -1 ? -1 : this.getColumnModel().getColumn(this.getSelectedColumn()).getModelIndex();
            if (modelColIndex == -1) {
                int xOverflow = x + (int)tablexy.getX() + this.grids.getPopup().getWidth() - (int)screenSize.getWidth();
                int popupX = xOverflow > 0 ? x - xOverflow - 20 : x;
                modelColIndex = this.getColumnModel().getColumnIndexAtX(popupX);
            }
            if (modelColIndex != -1 && this.colProps[modelColIndex].getColumnType() == 6 && ((CheckBoxColumn)this.colProps[modelColIndex]).isShowDeSelectAllInPopupMenu() && (this.getMode() != 0 || ((CheckBoxColumn)this.colProps[modelColIndex]).isEnableInReadOnlyMode())) {
                JMenuItem selMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("select all"), ClientSettings.getInstance().getResources().getResource("select all").charAt(0));
                final int index = modelColIndex;
                selMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int i = 0;
                        while (i < Grid.this.model.getRowCount()) {
                            if (((CheckBoxColumn)Grid.this.colProps[index]).isDeSelectAllCells() || Grid.this.model.isCellEditable(i, index)) {
                                Grid.this.model.setValue(((CheckBoxColumn)Grid.this.colProps[index]).getPositiveValue(), i, index);
                            }
                            ++i;
                        }
                    }
                });
                this.grids.getPopup().add(selMenu);
                JMenuItem deselMenu = new JMenuItem(ClientSettings.getInstance().getResources().getResource("deselect all"), ClientSettings.getInstance().getResources().getResource("deselect all").charAt(0));
                deselMenu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int i = 0;
                        while (i < Grid.this.model.getRowCount()) {
                            if (((CheckBoxColumn)Grid.this.colProps[index]).isDeSelectAllCells() || Grid.this.model.isCellEditable(i, index)) {
                                Grid.this.model.setValue(((CheckBoxColumn)Grid.this.colProps[index]).getNegativeValue(), i, index);
                            }
                            ++i;
                        }
                    }
                });
                this.grids.getPopup().add(deselMenu);
                if (this.getMode() == 0) {
                    this.grids.getPopup().add(new JSeparator());
                }
            }
            if (this.getMode() == 0) {
                int expandableColIndex = -1;
                if (this.expandableColumnAttributeName != null) {
                    expandableColIndex = this.modelAdapter.getFieldIndex(this.expandableColumnAttributeName);
                }
                int i = 0;
                while (i < this.colProps.length) {
                    if (this.colProps[i].isColumnSelectable()) {
                        JCheckBoxMenuItem cbMenuItem = this.colProps[i].getHeaderColumnName() != null && this.colProps[i].getHeaderColumnName().length() > 0 ? new JCheckBoxMenuItem(ClientSettings.getInstance().getResources().getResource(this.colProps[i].getHeaderColumnName())) : new JCheckBoxMenuItem(ClientSettings.getInstance().getResources().getResource(this.colProps[i].getColumnName()));
                        if (this.colProps[i].isColumnVisible()) {
                            cbMenuItem.setState(true);
                        }
                        cbMenuItem.setEnabled(expandableColIndex == -1 || expandableColIndex != i);
                        cbMenuItem.addActionListener(new CheckboxMenuItem(i));
                        this.grids.getPopup().add(cbMenuItem);
                    }
                    ++i;
                }
            }
            if (this.grids.getPopup().getComponentCount() > 0) {
                int popupY;
                int xOverflow = x + (int)tablexy.getX() + this.grids.getPopup().getWidth() - (int)screenSize.getWidth();
                int yOverflow = y + (int)tablexy.getY() + this.grids.getPopup().getHeight() - (int)screenSize.getHeight();
                int popupX = xOverflow > 0 ? x - xOverflow - 20 : x;
                int n2 = popupY = yOverflow > 0 ? y - yOverflow - 20 : y;
                if (this.getPeer() == null) {
                    Container c = this;
                    Grid expPanel = null;
                    popupY = 0;
                    while (true) {
                        if (c != null && !(c instanceof ExpandablePanel)) {
                            popupX += c.getLocation().x;
                            popupY += c.getLocation().y;
                            c = c.getParent();
                            continue;
                        }
                        if (c != null) {
                            expPanel = c;
                            c = c.getParent();
                        }
                        if (c == null) break;
                    }
                    if (expPanel != null) {
                        this.grids.getPopup().show(expPanel.getParent(), popupX, popupY);
                    }
                } else {
                    this.grids.getPopup().show(this, popupX, popupY);
                }
            }
        }
        catch (Throwable ex) {
            Logger.error(this.getClass().getName(), "showPopupMenu", "Error while constructing grids.getPopup() menu.", ex);
            ex.printStackTrace();
        }
    }

    public final boolean stopCellEditing() {
        int row = this.getEditingRow();
        int col = this.getEditingColumn();
        if (row >= 0 && col >= 0) {
            return this.getCellEditor(row, col).stopCellEditing();
        }
        return true;
    }

    private void tabPressed(KeyEvent e) {
        int colIndex = this.getSelectedColumn();
        if (colIndex == -1) {
            e.consume();
            return;
        }
        if (colIndex + 1 == this.getColumnCount() && this.getSelectedRow() < this.model.getRowCount() - 1) {
            colIndex = -1;
            this.setRowSelectionInterval(this.getSelectedRow() + 1, this.getSelectedRow() + 1);
            this.ensureRowIsVisible(this.getSelectedRow());
        }
        while (colIndex + 1 < this.getColumnCount() && !this.isCellEditable(this.getSelectedRow(), colIndex + 1)) {
            ++colIndex;
        }
        if (colIndex + 1 < this.getColumnCount()) {
            this.ensureRowIsVisible(this.getSelectedRow());
            this.setColumnSelectionInterval(colIndex, colIndex);
            this.setRowSelectionInterval(this.getSelectedRow(), this.getSelectedRow());
        } else if (this.getSelectedRow() < this.model.getRowCount() - 1) {
            this.setRowSelectionInterval(this.getSelectedRow() + 1, this.getSelectedRow() + 1);
            this.setColumnSelectionInterval(0, 0);
            this.ensureRowIsVisible(this.getSelectedRow());
            if (!this.isCellEditable(this.getSelectedRow(), 0)) {
                this.tabPressed(e);
            } else {
                e.consume();
            }
        } else {
            e.consume();
            return;
        }
    }

    public final void updateColumnHeaderIcons() {
        int gridIndex = -1;
        FilterWhereClause[] where = null;
        int i = 0;
        while (i < this.getModel().getColumnCount()) {
            try {
                gridIndex = this.convertColumnIndexToView(i);
                if (gridIndex != -1 && !ClientSettings.SHOW_FILTER_SYMBOL && this.getTableHeader() != null) {
                    where = (FilterWhereClause[])this.grids.getQuickFilterValues().get(this.getVOListTableModel().getColumnName(i));
                    if (where != null) {
                        ((TableColumnHeaderRenderer)this.getTableHeader().getColumnModel().getColumn(gridIndex).getHeaderRenderer()).setBorder(BorderFactory.createLoweredBevelBorder());
                    } else {
                        ((TableColumnHeaderRenderer)this.getTableHeader().getColumnModel().getColumn(gridIndex).getHeaderRenderer()).setBorder(BorderFactory.createRaisedBevelBorder());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public final void valueChanged(ListSelectionEvent e) {
        if (this.model != null && this.getMode() == 2 && this.grids != null && this.grids.isEditOnSingleRow() && this.getSelectedRow() != -1) {
            this.setRowSelectionInterval(this.grids.getCurrentEditingRow(), this.grids.getCurrentEditingRow());
            return;
        }
        super.valueChanged(e);
        if (this.gridType != 0) {
            return;
        }
        if (this.model != null && this.getMode() == 1) {
            if (this.grids.isInsertRowsOnTop()) {
                if (this.getSelectedRow() >= this.grids.getCurrentNumberOfNewRows()) {
                    this.setRowSelectionInterval(Math.max(0, this.grids.getCurrentNumberOfNewRows() - 1), Math.max(0, this.grids.getCurrentNumberOfNewRows() - 1));
                    this.grids.setRowSelectionInterval(Math.max(0, this.grids.getCurrentNumberOfNewRows() - 1), Math.max(0, this.grids.getCurrentNumberOfNewRows() - 1));
                    return;
                }
            } else if (this.getSelectedRow() <= this.model.getRowCount() - this.grids.getCurrentNumberOfNewRows()) {
                this.setRowSelectionInterval(Math.max(0, this.model.getRowCount() - this.grids.getCurrentNumberOfNewRows()), Math.max(0, this.model.getRowCount() - this.grids.getCurrentNumberOfNewRows()));
                this.grids.setRowSelectionInterval(Math.max(0, this.model.getRowCount() - this.grids.getCurrentNumberOfNewRows()), Math.max(0, this.model.getRowCount() - this.grids.getCurrentNumberOfNewRows()));
                return;
            }
        }
        if (this.grids != null && this.grids.getLockedGrid() != null) {
            if (!this.controlDown || this.getSelectionModel().getSelectionMode() == 0) {
                this.grids.setRowSelectionInterval(this.getSelectedRow(), this.getSelectedRow());
            } else if (this.controlDown && this.getSelectionModel().getSelectionMode() == 1) {
                this.getSelectionModel().addSelectionInterval(this.getSelectedRow(), this.getSelectedRow());
            } else {
                this.addRowSelectionInterval(this.getSelectedRow(), this.getSelectedRow());
            }
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.model != null && this.getMode() == 0) {
            if (this.getSelectedRows().length > 1) {
                if (this.grids.getNavBar() != null) {
                    this.grids.getNavBar().setEnabled(false);
                }
                if (this.grids.getEditButton() != null) {
                    this.grids.getEditButton().setEnabled(false);
                }
                this.grids.setGenericButtonsEnabled(false);
            } else {
                if (this.grids.getEditButton() != null) {
                    this.grids.getEditButton().setEnabled(true);
                }
                this.grids.setGenericButtonsEnabled(true);
            }
        }
        if (this.gridController != null && this.getSelectedRows().length == 1) {
            int columnIndex = this.getSelectedColumn();
            columnIndex = columnIndex != -1 ? this.convertColumnIndexToModel(columnIndex) : 0;
            this.gridController.selectedCell(this.getSelectedRow(), columnIndex, this.model.getColumnName(columnIndex), this.model.getObjectForRow(this.getSelectedRow()));
            if (this.getMode() == 0 && this.grids.getNavBar() != null) {
                if (this.grids.getstartIndex() == 0 && this.getSelectedRow() == 0) {
                    this.grids.getNavBar().setFirstRow(true);
                } else {
                    this.grids.getNavBar().setFirstRow(false);
                }
                if (!this.grids.isMoreRows() && this.getSelectedRow() == this.model.getRowCount() - 1) {
                    this.grids.getNavBar().setLastRow(true);
                } else {
                    this.grids.getNavBar().setLastRow(false);
                }
            }
        }
        if (this.statusPanel != null) {
            if (this.getSelectedRows().length == 0) {
                this.statusPanel.setText("");
            } else if (this.getSelectedRows().length == 1) {
                String msg = ClientSettings.getInstance().getResources().getResource("Selected Row") + ": " + (this.grids.getCurrentNumberOfNewRows() + this.grids.getLastIndex() - this.model.getRowCount() + this.getSelectedRow() + 2);
                if (this.grids.getTotalResultSetLength() > 0) {
                    msg = msg + " " + ClientSettings.getInstance().getResources().getResource("of") + " " + this.grids.getTotalResultSetLength();
                }
                this.statusPanel.setText(msg);
            } else if (this.getSelectedRows().length > 1 && this.getMode() == 0) {
                String rows = "";
                int i = 0;
                while (i < this.getSelectedRows().length) {
                    rows = rows + (this.getSelectedRows()[i] + 2 + this.grids.getCurrentNumberOfNewRows() + this.grids.getLastIndex() - this.model.getRowCount()) + ", ";
                    ++i;
                }
                rows = rows.substring(0, rows.length() - 2);
                String msg = ClientSettings.getInstance().getResources().getResource("Selected Rows") + ": " + rows;
                if (this.grids.getTotalResultSetLength() > 0) {
                    msg = msg + " " + ClientSettings.getInstance().getResources().getResource("of") + " " + this.grids.getTotalResultSetLength();
                }
                this.statusPanel.setText(msg);
            } else {
                this.statusPanel.setText("");
            }
        }
        try {
            this.ensureRowIsVisible(this.getSelectedRow());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.gridController != null && this.getSelectedRow() != -1) {
            this.gridController.rowChanged(this.getSelectedRow());
        }
    }

    class GridListener
    extends KeyAdapter {
        GridListener() {
        }

        static /* synthetic */ Grid access$3400(GridListener x0) {
            return x0.Grid.this;
        }

        /*
         * Unable to fully structure code
         */
        public void keyPressed(KeyEvent e) {
            block173: {
                block212: {
                    block207: {
                        block211: {
                            block209: {
                                block210: {
                                    block208: {
                                        block198: {
                                            block206: {
                                                block205: {
                                                    block204: {
                                                        block203: {
                                                            block202: {
                                                                block201: {
                                                                    block200: {
                                                                        block199: {
                                                                            block195: {
                                                                                block197: {
                                                                                    block196: {
                                                                                        block192: {
                                                                                            block194: {
                                                                                                block193: {
                                                                                                    block189: {
                                                                                                        block191: {
                                                                                                            block190: {
                                                                                                                block186: {
                                                                                                                    block188: {
                                                                                                                        block187: {
                                                                                                                            block183: {
                                                                                                                                block185: {
                                                                                                                                    block184: {
                                                                                                                                        block181: {
                                                                                                                                            block182: {
                                                                                                                                                block179: {
                                                                                                                                                    block180: {
                                                                                                                                                        block177: {
                                                                                                                                                            block178: {
                                                                                                                                                                block175: {
                                                                                                                                                                    block176: {
                                                                                                                                                                        block174: {
                                                                                                                                                                            if (Grid.access$100(Grid.this).getCurrentNestedComponent() == null) break block174;
                                                                                                                                                                            e.setSource(Grid.access$100(Grid.this).getCurrentNestedComponent());
                                                                                                                                                                            if (Grid.access$100(Grid.this).getCurrentNestedComponent() instanceof Grid && e instanceof KeyEvent) {
                                                                                                                                                                                if (e.getKeyCode() == 9 && ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).getEditorComponent() != null) {
                                                                                                                                                                                    if (((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).stopCellEditing()) {
                                                                                                                                                                                        ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).dispatchEvent(e);
                                                                                                                                                                                    }
                                                                                                                                                                                    e.consume();
                                                                                                                                                                                    return;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            if (Grid.access$100(Grid.this).getCurrentNestedComponent() instanceof Grid || !(e instanceof KeyEvent)) ** GOTO lbl-1000
                                                                                                                                                                            if (e.getKeyCode() == 9) {
                                                                                                                                                                                cont = Grid.access$100(Grid.this).getCurrentNestedComponent().getParent();
                                                                                                                                                                                while (cont != null && !(cont instanceof Grid) && !(cont instanceof Form)) {
                                                                                                                                                                                    cont = cont.getParent();
                                                                                                                                                                                }
                                                                                                                                                                                if (cont != null && cont instanceof Grid && ((Grid)cont).getCellEditor() != null) {
                                                                                                                                                                                    ((Grid)cont).stopCellEditing();
                                                                                                                                                                                    e.setSource(cont);
                                                                                                                                                                                    row = ((Grid)cont).getSelectedRow();
                                                                                                                                                                                    col = ((Grid)cont).getSelectedColumn();
                                                                                                                                                                                    Grid.access$3200((Grid)cont, e);
                                                                                                                                                                                    row = ((Grid)cont).getSelectedRow();
                                                                                                                                                                                    col = ((Grid)cont).getSelectedColumn();
                                                                                                                                                                                    if (col < ((Grid)cont).getColumnCount() - 1) {
                                                                                                                                                                                        ++col;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        col = 0;
                                                                                                                                                                                        if (++row >= ((Grid)cont).getRowCount() - 1) {
                                                                                                                                                                                            row = 0;
                                                                                                                                                                                            col = 0;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    ((Grid)cont).setRowSelectionInterval(row, row);
                                                                                                                                                                                    ((Grid)cont).setColumnSelectionInterval(col, col);
                                                                                                                                                                                    if (((Grid)cont).isCellEditable(row, col)) {
                                                                                                                                                                                        ((Grid)cont).editCellAt(((Grid)cont).getSelectedRow(), ((Grid)cont).getSelectedColumn());
                                                                                                                                                                                    }
                                                                                                                                                                                    Grid.access$100(Grid.this).setCurrentNestedComponent(Grid.this.getSelectedRow(), ((Grid)cont).getEditorComponent());
                                                                                                                                                                                    e.consume();
                                                                                                                                                                                    return;
                                                                                                                                                                                }
                                                                                                                                                                                if (cont != null && cont instanceof Form && ((Form)cont).getMode() != 0) {
                                                                                                                                                                                    c = Grid.access$100(Grid.this).getCurrentNestedComponent().getParent().getComponents();
                                                                                                                                                                                    i = 0;
                                                                                                                                                                                    while (i < c.length) {
                                                                                                                                                                                        if (c[i].equals(Grid.access$100(Grid.this).getCurrentNestedComponent())) {
                                                                                                                                                                                            if (i < c.length - 1) {
                                                                                                                                                                                                c[i + 1].requestFocus();
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            c[0].requestFocus();
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        ++i;
                                                                                                                                                                                    }
                                                                                                                                                                                    e.consume();
                                                                                                                                                                                    return;
                                                                                                                                                                                }
                                                                                                                                                                            } else lbl-1000:
                                                                                                                                                                            // 2 sources

                                                                                                                                                                            {
                                                                                                                                                                                Grid.access$100(Grid.this).getCurrentNestedComponent().dispatchEvent(e);
                                                                                                                                                                            }
                                                                                                                                                                            if (Grid.access$100(Grid.this).getCurrentNestedComponent() instanceof Grid && e instanceof KeyEvent) {
                                                                                                                                                                                if (e.getKeyCode() == 113 && ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).getSelectedRow() != -1 && ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).getSelectedColumn() != -1) {
                                                                                                                                                                                    ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).editCellAt(((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).getSelectedRow(), ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).getSelectedColumn());
                                                                                                                                                                                    c2 = ((Grid)Grid.access$100(Grid.this).getCurrentNestedComponent()).getEditorComponent();
                                                                                                                                                                                    if (c2 != null) {
                                                                                                                                                                                        Grid.access$100(Grid.this).setCurrentNestedComponent(Grid.this.getSelectedRow(), c2);
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            Grid.this.repaint();
                                                                                                                                                                            return;
                                                                                                                                                                        }
                                                                                                                                                                        if (!Grid.access$100(Grid.this).isListenEvent()) {
                                                                                                                                                                            e.consume();
                                                                                                                                                                            return;
                                                                                                                                                                        }
                                                                                                                                                                        if (Grid.this.getMode() == 0) {
                                                                                                                                                                            Grid.access$3302(Grid.this, e.isControlDown());
                                                                                                                                                                        } else {
                                                                                                                                                                            Grid.access$3302(Grid.this, false);
                                                                                                                                                                        }
                                                                                                                                                                        if (e.getKeyCode() == 10 && Grid.access$700(Grid.this) != null && Grid.this.getSelectedRow() != -1 && Grid.access$800(Grid.this).getMode() == 0) {
                                                                                                                                                                            SwingUtilities.invokeLater(new Runnable(this){
                                                                                                                                                                                private final /* synthetic */ GridListener this$1;
                                                                                                                                                                                {
                                                                                                                                                                                    this.this$1 = this$1;
                                                                                                                                                                                }

                                                                                                                                                                                public void run() {
                                                                                                                                                                                    Grid.access$700(GridListener.access$3400(this.this$1)).enterButton(GridListener.access$3400(this.this$1).getSelectedRow(), Grid.access$800(GridListener.access$3400(this.this$1)).getObjectForRow(GridListener.access$3400(this.this$1).getSelectedRow()));
                                                                                                                                                                                }
                                                                                                                                                                            });
                                                                                                                                                                        }
                                                                                                                                                                        if (e.getKeyCode() == 10) {
                                                                                                                                                                            e.consume();
                                                                                                                                                                        }
                                                                                                                                                                        if (e.getKeyCode() == ClientSettings.EXPAND_CELL_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.EXPAND_CELL_KEY.getModifiers() && Grid.this.getMode() == 0 && Grid.this.getSelectedRow() != -1 && Grid.this.getExpandableRowController() != null && Grid.this.getExpandableRowController().isRowExpandable(Grid.access$100(Grid.this).getVOListTableModel(), Grid.this.getSelectedRow()) && !Grid.access$100(Grid.this).isRowExpanded(Grid.this.getSelectedRow())) {
                                                                                                                                                                            c = Grid.access$3500(Grid.this).expandRow(Grid.this.getSelectedRow());
                                                                                                                                                                            if (c != null) {
                                                                                                                                                                                Grid.access$100(Grid.this).setCurrentNestedComponent(Grid.this.getSelectedRow(), c);
                                                                                                                                                                            }
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.COLLAPSE_CELL_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.COLLAPSE_CELL_KEY.getModifiers() && Grid.this.getMode() == 0 && Grid.this.getParentGrid() != null && Grid.this.getParentGrid().getGrids().getCurrentNestedComponentRow() != -1) {
                                                                                                                                                                            Grid.access$3500(Grid.this.getParentGrid()).collapseRow(Grid.this.getParentGrid().getGrids().getCurrentNestedComponentRow());
                                                                                                                                                                            Grid.this.getParentGrid().requestFocus();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.RELOAD_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.RELOAD_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getReloadButton() != null && Grid.access$100(Grid.this).getReloadButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).reload();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.FILTER_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.FILTER_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getFilterButton() != null && Grid.access$100(Grid.this).getFilterButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).filterSort();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.SAVE_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.SAVE_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getSaveButton() != null && Grid.access$100(Grid.this).getSaveButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).save();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.INSERT_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.INSERT_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getInsertButton() != null && Grid.access$100(Grid.this).getInsertButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).insert();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.EDIT_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.EDIT_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getEditButton() != null && Grid.access$100(Grid.this).getEditButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).edit();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.DELETE_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.DELETE_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getDeleteButton() != null && Grid.access$100(Grid.this).getDeleteButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).delete();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.COPY_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.COPY_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getCopyButton() != null && Grid.access$100(Grid.this).getCopyButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).copy();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.EXPORT_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.EXPORT_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getExportButton() != null && Grid.access$100(Grid.this).getExportButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).export();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.IMPORT_BUTTON_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.IMPORT_BUTTON_KEY.getModifiers() && Grid.access$100(Grid.this).getImportButton() != null && Grid.access$100(Grid.this).getImportButton().isEnabled()) {
                                                                                                                                                                            Grid.access$100(Grid.this).importData();
                                                                                                                                                                        } else if (e.getKeyCode() == ClientSettings.GRID_POPUP_KEY.getKeyCode() && e.getModifiers() + e.getModifiersEx() == ClientSettings.GRID_POPUP_KEY.getModifiers() && Grid.this.getColumnModel().getColumnCount() > 0) {
                                                                                                                                                                            if (Grid.this.getSelectedColumn() == -1) {
                                                                                                                                                                                Grid.this.setColumnSelectionInterval(0, 0);
                                                                                                                                                                            }
                                                                                                                                                                            if (Grid.this.getSelectedRow() == -1 && Grid.this.getRowCount() > 0) {
                                                                                                                                                                                Grid.this.setRowSelectionInterval(0, 0);
                                                                                                                                                                            }
                                                                                                                                                                            if ((row = Grid.this.getSelectedRow()) == -1) {
                                                                                                                                                                                row = 0;
                                                                                                                                                                            }
                                                                                                                                                                            x = 0;
                                                                                                                                                                            i = 0;
                                                                                                                                                                            while (i < Grid.this.getSelectedColumn()) {
                                                                                                                                                                                x += Grid.this.getColumnModel().getColumn(i).getWidth();
                                                                                                                                                                                ++i;
                                                                                                                                                                            }
                                                                                                                                                                            Grid.access$3700(Grid.this, x + Grid.this.getColumnModel().getColumn(Grid.this.getSelectedColumn()).getWidth() / 2, Grid.access$3600(Grid.this, row) + Grid.this.getRowHeight(row) / 2);
                                                                                                                                                                        }
                                                                                                                                                                        if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() == -1) break block175;
                                                                                                                                                                        if (e.getKeyCode() == 9) break block176;
                                                                                                                                                                        if (e.getKeyCode() != 39) break block175;
                                                                                                                                                                    }
                                                                                                                                                                    if (e.getModifiers() != 1 && Grid.access$1500(Grid.this) && Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() && Grid.this.getSelectedColumn() == Grid.this.getColumnCount() - 1) {
                                                                                                                                                                        e.consume();
                                                                                                                                                                        Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                                                                                                                                                                        Grid.access$100(Grid.this).getGrid().setColumnSelectionInterval(0, 0);
                                                                                                                                                                        Grid.access$100(Grid.this).getGrid().requestFocus();
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() == -1) break block177;
                                                                                                                                                                if (e.getKeyCode() == 9) break block178;
                                                                                                                                                                if (e.getKeyCode() != 39) break block177;
                                                                                                                                                            }
                                                                                                                                                            if (e.getModifiers() == 1 || !Grid.access$1500(Grid.this) || Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || Grid.this.getSelectedColumn() != Grid.this.getColumnCount() - 1) break block177;
                                                                                                                                                            e.consume();
                                                                                                                                                            try {
                                                                                                                                                                Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow() + 1, Grid.this.getSelectedRow() + 1);
                                                                                                                                                            }
                                                                                                                                                            catch (Exception ex) {
                                                                                                                                                                // empty catch block
                                                                                                                                                            }
                                                                                                                                                            Grid.access$100(Grid.this).getGrid().setColumnSelectionInterval(0, 0);
                                                                                                                                                            Grid.access$100(Grid.this).getGrid().requestFocus();
                                                                                                                                                            break block173;
                                                                                                                                                        }
                                                                                                                                                        if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() >= Grid.access$800(Grid.this).getRowCount() - 1) break block179;
                                                                                                                                                        if (e.getKeyCode() == 9) break block180;
                                                                                                                                                        if (e.getKeyCode() != 39) break block179;
                                                                                                                                                    }
                                                                                                                                                    if (e.getModifiers() == 1 || !Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() != Grid.this.getColumnCount() - 1) break block179;
                                                                                                                                                    e.consume();
                                                                                                                                                    try {
                                                                                                                                                        Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow() + 1, Grid.this.getSelectedRow() + 1);
                                                                                                                                                    }
                                                                                                                                                    catch (Exception ex) {
                                                                                                                                                        // empty catch block
                                                                                                                                                    }
                                                                                                                                                    Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(0, 0);
                                                                                                                                                    Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                                                                                                    break block173;
                                                                                                                                                }
                                                                                                                                                if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() >= Grid.access$800(Grid.this).getRowCount() - 1) break block181;
                                                                                                                                                if (e.getKeyCode() == 9) break block182;
                                                                                                                                                if (e.getKeyCode() != 39) break block181;
                                                                                                                                            }
                                                                                                                                            if (e.getModifiers() == 1 || Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() != Grid.this.getColumnCount() - 1) break block181;
                                                                                                                                            e.consume();
                                                                                                                                            try {
                                                                                                                                                Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                                                                                                                                            }
                                                                                                                                            catch (Exception ex) {
                                                                                                                                                // empty catch block
                                                                                                                                            }
                                                                                                                                            Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(0, 0);
                                                                                                                                            Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                                                                                            break block173;
                                                                                                                                        }
                                                                                                                                        if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() <= 0) break block183;
                                                                                                                                        if (e.getModifiers() != 1) break block184;
                                                                                                                                        if (e.getKeyCode() == 9) break block185;
                                                                                                                                    }
                                                                                                                                    if (e.getKeyCode() != 37) break block183;
                                                                                                                                }
                                                                                                                                if (!Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || !Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() != 0) break block183;
                                                                                                                                e.consume();
                                                                                                                                try {
                                                                                                                                    Grid.access$100(Grid.this).getGrid().setColumnSelectionInterval(Grid.access$100(Grid.this).getGrid().getColumnCount() - 1, Grid.access$100(Grid.this).getGrid().getColumnCount() - 1);
                                                                                                                                    Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow() - 1, Grid.this.getSelectedRow() - 1);
                                                                                                                                }
                                                                                                                                catch (Exception ex1) {
                                                                                                                                    // empty catch block
                                                                                                                                }
                                                                                                                                Grid.access$100(Grid.this).getGrid().requestFocus();
                                                                                                                                break block173;
                                                                                                                            }
                                                                                                                            if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() <= 0) break block186;
                                                                                                                            if (e.getModifiers() != 1) break block187;
                                                                                                                            if (e.getKeyCode() == 9) break block188;
                                                                                                                        }
                                                                                                                        if (e.getKeyCode() != 37) break block186;
                                                                                                                    }
                                                                                                                    if (Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || !Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() != 0) break block186;
                                                                                                                    e.consume();
                                                                                                                    try {
                                                                                                                        Grid.access$100(Grid.this).getGrid().setColumnSelectionInterval(Grid.access$100(Grid.this).getGrid().getColumnCount() - 1, Grid.access$100(Grid.this).getGrid().getColumnCount() - 1);
                                                                                                                        Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                                                                                                                    }
                                                                                                                    catch (Exception ex1) {
                                                                                                                        // empty catch block
                                                                                                                    }
                                                                                                                    Grid.access$100(Grid.this).getGrid().requestFocus();
                                                                                                                    break block173;
                                                                                                                }
                                                                                                                if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() < 0) break block189;
                                                                                                                if (e.getModifiers() != 1) break block190;
                                                                                                                if (e.getKeyCode() == 9) break block191;
                                                                                                            }
                                                                                                            if (e.getKeyCode() != 37) break block189;
                                                                                                        }
                                                                                                        if (!Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() != 0) break block189;
                                                                                                        e.consume();
                                                                                                        Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                                                                                                        Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(Grid.access$100(Grid.this).getLockedGrid().getColumnCount() - 1, Grid.access$100(Grid.this).getLockedGrid().getColumnCount() - 1);
                                                                                                        Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                                                        break block173;
                                                                                                    }
                                                                                                    if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() < 0) break block192;
                                                                                                    if (e.getModifiers() != 1) break block193;
                                                                                                    if (e.getKeyCode() == 9) break block194;
                                                                                                }
                                                                                                if (e.getKeyCode() != 37) break block192;
                                                                                            }
                                                                                            if (Grid.access$100(Grid.this).isAnchorLockedColumnsToLeft() || Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() != 0) break block192;
                                                                                            e.consume();
                                                                                            Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow() - 1, Grid.this.getSelectedRow() - 1);
                                                                                            Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(Grid.access$100(Grid.this).getLockedGrid().getColumnCount() - 1, Grid.access$100(Grid.this).getLockedGrid().getColumnCount() - 1);
                                                                                            Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                                            break block173;
                                                                                        }
                                                                                        if (Grid.access$100(Grid.this).getLockedGrid() == null || Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() < 0) break block195;
                                                                                        if (e.getModifiers() != 1) break block196;
                                                                                        if (e.getKeyCode() == 9) break block197;
                                                                                    }
                                                                                    if (e.getKeyCode() != 37) break block195;
                                                                                }
                                                                                if (Grid.access$1500(Grid.this) || Grid.this.getSelectedColumn() <= 0) break block195;
                                                                                Grid.access$100(Grid.this).setRowSelectionInterval(Grid.this.getSelectedRow(), Grid.this.getSelectedRow());
                                                                                break block173;
                                                                            }
                                                                            if (Grid.this.getMode() == 0) break block198;
                                                                            if (Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() == -1) break block199;
                                                                            if (e.getKeyCode() != 9) break block199;
                                                                            if (e.getModifiers() == 1) break block199;
                                                                            Grid.access$3200(Grid.this, e);
                                                                            break block173;
                                                                        }
                                                                        if (Grid.access$800(Grid.this).getRowCount() <= 0 || Grid.this.getSelectedRow() == -1) break block200;
                                                                        if (e.getKeyCode() != 9) break block200;
                                                                        if (e.getModifiers() != 1) break block200;
                                                                        Grid.access$3800(Grid.this, e);
                                                                        break block173;
                                                                    }
                                                                    if (Grid.this.getMode() != 1 || !Grid.access$100(Grid.this).isInsertRowsOnTop() || e.getKeyCode() != ClientSettings.ADD_ROW_IN_GRID.getKeyCode() || e.getModifiers() + e.getModifiersEx() != ClientSettings.ADD_ROW_IN_GRID.getModifiers() || Grid.this.getSelectedRow() == -1 || Grid.this.getSelectedRow() + 1 >= Grid.access$100(Grid.this).getMaxNumberOfRowsOnInsert() || Grid.this.getMode() != 1 || Grid.this.getSelectedRow() + 1 != Grid.access$100(Grid.this).getCurrentNumberOfNewRows()) break block201;
                                                                    Grid.access$100(Grid.this).setCurrentNumberOfNewRows(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() + 1);
                                                                    vo = null;
                                                                    try {
                                                                        vo = (ValueObject)Grid.access$800(Grid.this).getValueObjectType().getConstructor(new Class[0]).newInstance(new Object[0]);
                                                                        Grid.access$800(Grid.this).insertObjectAt(vo, Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                        rIndex = new Integer(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                        if (!Grid.access$800(Grid.this).getChangedRowIndexes().contains(rIndex)) {
                                                                            Grid.access$800(Grid.this).getChangedRowIndexes().add(rIndex);
                                                                        }
                                                                    }
                                                                    catch (Exception ex) {
                                                                        ex.printStackTrace();
                                                                    }
                                                                    catch (Error er) {
                                                                        er.printStackTrace();
                                                                    }
                                                                    try {
                                                                        Grid.access$700(Grid.this).createValueObject(vo);
                                                                        i = 0;
                                                                        while (i < Grid.access$2100(Grid.this).length) {
                                                                            if (Grid.access$2100(Grid.this)[i] instanceof ComboColumn && !((ComboColumn)Grid.access$2100(Grid.this)[i]).isNullAsDefaultValue()) {
                                                                                Grid.access$800(Grid.this).setValueAt(((ComboColumn)Grid.access$2100(Grid.this)[i]).getDomain().getDomainPairList()[0].getCode(), Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, Grid.access$800(Grid.this).findColumn(((ComboColumn)Grid.access$2100(Grid.this)[i]).getColumnName()));
                                                                            }
                                                                            ++i;
                                                                        }
                                                                    }
                                                                    catch (Throwable ex) {
                                                                        Logger.error(this.getClass().getName(), "modeChanged", "Error while constructing value object '" + Grid.access$800(Grid.this).getValueObjectType().getName() + "'", ex);
                                                                    }
                                                                    Grid.this.setRowSelectionInterval(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                    Grid.this.setColumnSelectionInterval(0, 0);
                                                                    Grid.this.ensureRowIsVisible(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                    if (Grid.access$100(Grid.this).getLockedGrid() != null) {
                                                                        Grid.access$100(Grid.this).getLockedGrid().setRowSelectionInterval(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                        Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(0, 0);
                                                                        Grid.access$100(Grid.this).getLockedGrid().ensureRowIsVisible(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                        Grid.access$100(Grid.this).getLockedGrid().editCellAt(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                        Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                    } else {
                                                                        Grid.this.editCellAt(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                        Grid.this.requestFocus();
                                                                    }
                                                                    if (Grid.access$100(Grid.this).getDeleteButton() != null) {
                                                                        Grid.access$100(Grid.this).getDeleteButton().setEnabled(true);
                                                                    }
                                                                    e.consume();
                                                                    break block173;
                                                                }
                                                                if ((Grid.this.getMode() != 2 || !Grid.access$100(Grid.this).isAllowInsertInEdit()) && (Grid.this.getMode() != 1 || Grid.access$100(Grid.this).isInsertRowsOnTop()) || e.getKeyCode() != ClientSettings.ADD_ROW_IN_GRID.getKeyCode() || e.getModifiers() + e.getModifiersEx() != ClientSettings.ADD_ROW_IN_GRID.getModifiers() || Grid.this.getSelectedRow() == -1 || Grid.access$100(Grid.this).getCurrentNumberOfNewRows() >= Grid.access$100(Grid.this).getMaxNumberOfRowsOnInsert() || Grid.this.getSelectedRow() != Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1) break block202;
                                                                Grid.access$100(Grid.this).setCurrentNumberOfNewRows(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() + 1);
                                                                vo = null;
                                                                try {
                                                                    vo = (ValueObject)Grid.access$800(Grid.this).getValueObjectType().getConstructor(new Class[0]).newInstance(new Object[0]);
                                                                    Grid.access$800(Grid.this).insertObjectAt(vo, Grid.access$100(Grid.this).getVOListTableModel().getRowCount());
                                                                    rIndex = new Integer(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1);
                                                                    if (!Grid.access$800(Grid.this).getChangedRowIndexes().contains(rIndex)) {
                                                                        Grid.access$800(Grid.this).getChangedRowIndexes().add(rIndex);
                                                                    }
                                                                }
                                                                catch (Exception ex) {
                                                                    ex.printStackTrace();
                                                                }
                                                                catch (Error er) {
                                                                    er.printStackTrace();
                                                                }
                                                                try {
                                                                    Grid.access$700(Grid.this).createValueObject(vo);
                                                                    i = 0;
                                                                    while (i < Grid.access$2100(Grid.this).length) {
                                                                        if (Grid.access$2100(Grid.this)[i] instanceof ComboColumn && !((ComboColumn)Grid.access$2100(Grid.this)[i]).isNullAsDefaultValue()) {
                                                                            Grid.access$800(Grid.this).setValueAt(((ComboColumn)Grid.access$2100(Grid.this)[i]).getDomain().getDomainPairList()[0].getCode(), Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, Grid.access$800(Grid.this).findColumn(((ComboColumn)Grid.access$2100(Grid.this)[i]).getColumnName()));
                                                                        }
                                                                        ++i;
                                                                    }
                                                                }
                                                                catch (Throwable ex) {
                                                                    Logger.error(this.getClass().getName(), "modeChanged", "Error while constructing value object '" + Grid.access$800(Grid.this).getValueObjectType().getName() + "'", ex);
                                                                }
                                                                Grid.this.setRowSelectionInterval(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                Grid.this.setColumnSelectionInterval(0, 0);
                                                                Grid.this.ensureRowIsVisible(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1);
                                                                if (Grid.access$100(Grid.this).getLockedGrid() != null) {
                                                                    Grid.access$100(Grid.this).getLockedGrid().setRowSelectionInterval(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                    Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(0, 0);
                                                                    Grid.access$100(Grid.this).getLockedGrid().ensureRowIsVisible(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1);
                                                                    Grid.access$100(Grid.this).getLockedGrid().editCellAt(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                    Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                } else {
                                                                    Grid.this.editCellAt(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                    Grid.this.requestFocus();
                                                                }
                                                                if (Grid.access$100(Grid.this).getDeleteButton() != null) {
                                                                    Grid.access$100(Grid.this).getDeleteButton().setEnabled(true);
                                                                }
                                                                e.consume();
                                                                break block173;
                                                            }
                                                            if (Grid.this.getMode() != 1 || !Grid.access$100(Grid.this).isInsertRowsOnTop() || e.getKeyCode() != ClientSettings.REMOVE_ROW_FROM_GRID.getKeyCode() || e.getModifiers() + e.getModifiersEx() != ClientSettings.REMOVE_ROW_FROM_GRID.getModifiers() || Grid.this.getSelectedRow() <= 0 || Grid.this.getSelectedRow() + 1 != Grid.access$100(Grid.this).getCurrentNumberOfNewRows()) break block203;
                                                            try {
                                                                voToRemove = Grid.access$800(Grid.this).getObjectForRow(Grid.this.getSelectedRow());
                                                                clonedVO = (ValueObject)voToRemove.getClass().newInstance();
                                                                Grid.access$700(Grid.this).createValueObject(clonedVO);
                                                                i = 0;
                                                                while (i < Grid.access$2100(Grid.this).length) {
                                                                    if (Grid.access$2100(Grid.this)[i] instanceof ComboColumn && !((ComboColumn)Grid.access$2100(Grid.this)[i]).isNullAsDefaultValue()) {
                                                                        Grid.access$600(Grid.this).setField(clonedVO, Grid.access$800(Grid.this).findColumn(((ComboColumn)Grid.access$2100(Grid.this)[i]).getColumnName()), ((ComboColumn)Grid.access$2100(Grid.this)[i]).getDomain().getDomainPairList()[0].getCode());
                                                                    }
                                                                    ++i;
                                                                }
                                                                notNullValueFound = false;
                                                                value = null;
                                                                clonedValue = null;
                                                                i = 0;
                                                                while (i < Grid.access$800(Grid.this).getColumnCount()) {
                                                                    value = Grid.access$800(Grid.this).getValueAt(Grid.this.getSelectedRow(), i);
                                                                    if (!(value == null || value.equals(clonedValue = Grid.access$600(Grid.this).getField(clonedVO, Grid.access$600(Grid.this).getFieldIndex(Grid.access$800(Grid.this).getColumnName(i)))) || Grid.access$2100(Grid.this)[i] instanceof ComboColumn && !((ComboColumn)Grid.access$2100(Grid.this)[i]).isNullAsDefaultValue() || value.equals("") && clonedValue == null)) {
                                                                        notNullValueFound = true;
                                                                        break;
                                                                    }
                                                                    ++i;
                                                                }
                                                                if (!notNullValueFound) {
                                                                    Grid.this.editingCanceled(null);
                                                                    Grid.access$100(Grid.this).setCurrentNumberOfNewRows(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                    Grid.access$800(Grid.this).removeObjectAt(Grid.access$100(Grid.this).getCurrentNumberOfNewRows());
                                                                    Grid.access$800(Grid.this).getChangedRowIndexes().remove(Grid.access$800(Grid.this).getChangedRowIndexes().size() - 1);
                                                                    Grid.this.setRowSelectionInterval(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                    Grid.this.setColumnSelectionInterval(0, 0);
                                                                    Grid.this.ensureRowIsVisible(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                    if (Grid.access$100(Grid.this).getLockedGrid() != null) {
                                                                        Grid.access$100(Grid.this).getLockedGrid().setRowSelectionInterval(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                        Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(0, 0);
                                                                        Grid.access$100(Grid.this).getLockedGrid().ensureRowIsVisible(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                        Grid.access$100(Grid.this).getLockedGrid().editCellAt(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                        Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                    } else {
                                                                        Grid.this.editCellAt(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1, 0);
                                                                        Grid.this.requestFocus();
                                                                    }
                                                                    if (Grid.access$100(Grid.this).getDeleteButton() != null && Grid.access$100(Grid.this).getMode() == 1 && Grid.access$100(Grid.this).getCurrentNumberOfNewRows() == 1) {
                                                                        Grid.access$100(Grid.this).getDeleteButton().setEnabled(false);
                                                                    } else if (Grid.access$100(Grid.this).getDeleteButton() != null && Grid.access$100(Grid.this).getMode() == 2 && Grid.access$100(Grid.this).getCurrentNumberOfNewRows() == 0) {
                                                                        Grid.access$100(Grid.this).getDeleteButton().setEnabled(false);
                                                                    }
                                                                    e.consume();
                                                                }
                                                                break block173;
                                                            }
                                                            catch (Exception ex2) {
                                                                ex2.printStackTrace();
                                                            }
                                                            break block173;
                                                        }
                                                        if ((Grid.this.getMode() != 2 || !Grid.access$100(Grid.this).isAllowInsertInEdit()) && (Grid.this.getMode() != 1 || Grid.access$100(Grid.this).isInsertRowsOnTop()) || e.getKeyCode() != ClientSettings.REMOVE_ROW_FROM_GRID.getKeyCode() || e.getModifiers() + e.getModifiersEx() != ClientSettings.REMOVE_ROW_FROM_GRID.getModifiers() || Grid.this.getSelectedRow() <= 0 || (Grid.access$100(Grid.this).getCurrentNumberOfNewRows() <= 1 || Grid.this.getMode() != 1) && (Grid.access$100(Grid.this).getCurrentNumberOfNewRows() <= 0 || Grid.this.getMode() != 2) || Grid.this.getSelectedRow() != Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1) break block204;
                                                        try {
                                                            voToRemove = Grid.access$800(Grid.this).getObjectForRow(Grid.this.getSelectedRow());
                                                            clonedVO = (ValueObject)voToRemove.getClass().newInstance();
                                                            Grid.access$700(Grid.this).createValueObject(clonedVO);
                                                            i = 0;
                                                            while (i < Grid.access$2100(Grid.this).length) {
                                                                if (Grid.access$2100(Grid.this)[i] instanceof ComboColumn && !((ComboColumn)Grid.access$2100(Grid.this)[i]).isNullAsDefaultValue()) {
                                                                    Grid.access$600(Grid.this).setField(clonedVO, Grid.access$800(Grid.this).findColumn(((ComboColumn)Grid.access$2100(Grid.this)[i]).getColumnName()), ((ComboColumn)Grid.access$2100(Grid.this)[i]).getDomain().getDomainPairList()[0].getCode());
                                                                }
                                                                ++i;
                                                            }
                                                            notNullValueFound = false;
                                                            value = null;
                                                            clonedValue = null;
                                                            i = 0;
                                                            while (i < Grid.access$800(Grid.this).getColumnCount()) {
                                                                value = Grid.access$800(Grid.this).getValueAt(Grid.this.getSelectedRow(), i);
                                                                if (!(value == null || value.equals(clonedValue = Grid.access$600(Grid.this).getField(clonedVO, Grid.access$600(Grid.this).getFieldIndex(Grid.access$800(Grid.this).getColumnName(i)))) || Grid.access$2100(Grid.this)[i] instanceof ComboColumn && !((ComboColumn)Grid.access$2100(Grid.this)[i]).isNullAsDefaultValue() || value.equals("") && clonedValue == null)) {
                                                                    notNullValueFound = true;
                                                                    break;
                                                                }
                                                                ++i;
                                                            }
                                                            if (!notNullValueFound) {
                                                                Grid.this.editingCanceled(null);
                                                                Grid.access$100(Grid.this).setCurrentNumberOfNewRows(Grid.access$100(Grid.this).getCurrentNumberOfNewRows() - 1);
                                                                Grid.access$800(Grid.this).removeObjectAt(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1);
                                                                Grid.access$800(Grid.this).getChangedRowIndexes().remove(Grid.access$800(Grid.this).getChangedRowIndexes().size() - 1);
                                                                Grid.this.setRowSelectionInterval(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                Grid.this.setColumnSelectionInterval(0, 0);
                                                                Grid.this.ensureRowIsVisible(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1);
                                                                if (Grid.access$100(Grid.this).getLockedGrid() != null) {
                                                                    Grid.access$100(Grid.this).getLockedGrid().setRowSelectionInterval(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                    Grid.access$100(Grid.this).getLockedGrid().setColumnSelectionInterval(0, 0);
                                                                    Grid.access$100(Grid.this).getLockedGrid().ensureRowIsVisible(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1);
                                                                    Grid.access$100(Grid.this).getLockedGrid().editCellAt(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                    Grid.access$100(Grid.this).getLockedGrid().requestFocus();
                                                                } else {
                                                                    Grid.this.requestFocus();
                                                                    Grid.this.editCellAt(Grid.access$100(Grid.this).getVOListTableModel().getRowCount() - 1, 0);
                                                                }
                                                                if (Grid.access$100(Grid.this).getDeleteButton() != null && Grid.access$100(Grid.this).getMode() == 1 && Grid.access$100(Grid.this).getCurrentNumberOfNewRows() == 1) {
                                                                    Grid.access$100(Grid.this).getDeleteButton().setEnabled(false);
                                                                } else if (Grid.access$100(Grid.this).getDeleteButton() != null && Grid.access$100(Grid.this).getMode() == 2 && Grid.access$100(Grid.this).getCurrentNumberOfNewRows() == 0) {
                                                                    Grid.access$100(Grid.this).getDeleteButton().setEnabled(false);
                                                                }
                                                                e.consume();
                                                            }
                                                            break block173;
                                                        }
                                                        catch (Exception ex2) {
                                                            ex2.printStackTrace();
                                                        }
                                                        break block173;
                                                    }
                                                    if (Grid.this.getSelectedRow() >= 0 && Grid.this.getSelectedColumn() >= 0 && Grid.this.getEditorComponent() != null && Grid.access$3900(Grid.this) != null && Grid.access$100(Grid.access$3900(Grid.this)).getCurrentNestedComponent() != null && Grid.access$100(Grid.access$3900(Grid.this)).getCurrentNestedComponent() == Grid.this && Grid.access$100(Grid.this).getCurrentNestedComponent() == null) break block173;
                                                    if (Grid.this.getSelectedRow() < 0 || Grid.this.getSelectedColumn() < 0 || Grid.this.getEditorComponent() != null) break block205;
                                                    if (e.getKeyCode() != 113) break block205;
                                                    ok = Grid.this.editCellAt(Grid.this.getSelectedRow(), Grid.this.getSelectedColumn());
                                                    break block173;
                                                }
                                                if (Grid.this.getMode() != 2 || Grid.access$4000(Grid.this) == null) break block206;
                                                if (e.getKeyCode() != 40 || Grid.this.getSelectedRow() == -1 || Grid.this.getSelectedRow() >= Grid.access$800(Grid.this).getRowCount() - 1 || Grid.this.getSelectedColumn() == -1 || Grid.access$2100(Grid.this)[Grid.this.convertColumnIndexToModel(Grid.this.getSelectedColumn())].getColumnType() == 8) break block206;
                                                Grid.this.setRowSelectionInterval(Grid.this.getSelectedRow() + 1, Grid.this.getSelectedRow() + 1);
                                                Grid.this.editCellAt(Grid.this.getSelectedRow(), Grid.this.getSelectedColumn());
                                                SwingUtilities.invokeLater(new Runnable(this){
                                                    private final /* synthetic */ GridListener this$1;
                                                    {
                                                        this.this$1 = this$1;
                                                    }

                                                    public void run() {
                                                        if (GridListener.access$3400(this.this$1).getEditorComponent() != null) {
                                                            GridListener.access$3400(this.this$1).getEditorComponent().requestFocus();
                                                        }
                                                    }
                                                });
                                                break block173;
                                            }
                                            if (Grid.this.getMode() != 2 || Grid.access$4000(Grid.this) == null) ** GOTO lbl-1000
                                            if (e.getKeyCode() == 38 && Grid.this.getSelectedRow() != -1 && Grid.this.getSelectedRow() > 0) {
                                                Grid.this.setRowSelectionInterval(Grid.this.getSelectedRow() - 1, Grid.this.getSelectedRow() - 1);
                                                Grid.this.editCellAt(Grid.this.getSelectedRow(), Grid.this.getSelectedColumn());
                                                SwingUtilities.invokeLater(new Runnable(this){
                                                    private final /* synthetic */ GridListener this$1;
                                                    {
                                                        this.this$1 = this$1;
                                                    }

                                                    public void run() {
                                                        if (GridListener.access$3400(this.this$1).getEditorComponent() != null) {
                                                            GridListener.access$3400(this.this$1).getEditorComponent().requestFocus();
                                                        }
                                                    }
                                                });
                                            } else if (Grid.this.getMode() != 0 && Grid.access$4000(Grid.this) != null) {
                                                if (e.getKeyCode() == 27 && Grid.this.getSelectedColumn() != -1 && Grid.access$2100(Grid.this)[Grid.this.convertColumnIndexToModel(Grid.this.getSelectedColumn())].getColumnType() != 1 && Grid.access$2100(Grid.this)[Grid.this.convertColumnIndexToModel(Grid.this.getSelectedColumn())].getColumnType() != 2 && Grid.access$2100(Grid.this)[Grid.this.convertColumnIndexToModel(Grid.this.getSelectedColumn())].getColumnType() != 3 && Grid.this.getSelectedRow() != -1 && Grid.this.getSelectedRow() > 0) {
                                                    Grid.this.stopCellEditing();
                                                    SwingUtilities.invokeLater(new Runnable(this){
                                                        private final /* synthetic */ GridListener this$1;
                                                        {
                                                            this.this$1 = this$1;
                                                        }

                                                        public void run() {
                                                            GridListener.access$3400(this.this$1).requestFocus();
                                                        }
                                                    });
                                                }
                                            }
                                            break block173;
                                        }
                                        if (Grid.this.getMode() != 0 || Grid.access$100(Grid.this).getNavBar() == null) break block207;
                                        if (e.getKeyCode() == 38) break block208;
                                        if (e.getKeyCode() == 40) break block208;
                                        if (e.getKeyCode() == 33) break block208;
                                        if (e.getKeyCode() != 34) break block207;
                                    }
                                    selRows = null;
                                    currentSelRow = Grid.this.getSelectionModel().getLeadSelectionIndex();
                                    if (!e.isShiftDown()) break block209;
                                    if (e.getKeyCode() == 38) break block210;
                                    if (e.getKeyCode() != 40) break block209;
                                }
                                selRows = Grid.this.getSelectedRows();
                            }
                            if (e.getKeyCode() == 38 && Grid.this.getSelectedRow() > 0) {
                                Grid.access$100(Grid.this).getNavBar().prevButton_actionPerformed(new ActionEvent(this, 1001, "UP_KEY"));
                            } else if (e.getKeyCode() == 38 && Grid.this.getSelectedRow() == 0 && Grid.access$100(Grid.this).getNavBar().isPrevButtonEnabled()) {
                                Grid.access$100(Grid.this).getNavBar().prevButton_actionPerformed(new ActionEvent(this, 1001, "UP_KEY"));
                            } else if (e.getKeyCode() == 40 && Grid.this.getSelectedRow() < Grid.access$800(Grid.this).getRowCount() - 1) {
                                Grid.access$100(Grid.this).getNavBar().nextButton_actionPerformed(new ActionEvent(this, 1001, "DOWN_KEY"));
                            } else if (e.getKeyCode() == 40 && Grid.this.getSelectedRow() == Grid.access$800(Grid.this).getRowCount() - 1 && Grid.access$100(Grid.this).getNavBar().isNextButtonEnabled()) {
                                Grid.access$100(Grid.this).getNavBar().nextButton_actionPerformed(new ActionEvent(this, 1001, "DOWN_KEY"));
                            } else if (e.getKeyCode() == 33 && Grid.this.getSelectedRow() > 0) {
                                if (Grid.access$100(Grid.this).getstartIndex() == 0) {
                                    if (Grid.this.getSelectedRow() + 1 < Grid.this.getRowCount()) {
                                        Grid.this.setRowSelectionInterval(Grid.this.getSelectedRow() + 2, Grid.this.getSelectedRow() + 2);
                                        Grid.this.ensureRowIsVisible(Grid.this.getSelectedRow());
                                    } else {
                                        SwingUtilities.invokeLater(new Runnable(this){
                                            private final /* synthetic */ GridListener this$1;
                                            {
                                                this.this$1 = this$1;
                                            }

                                            public void run() {
                                                if (GridListener.access$3400(this.this$1).getSelectedRow() + 1 < GridListener.access$3400(this.this$1).getRowCount()) {
                                                    Rectangle r = GridListener.access$3400(this.this$1).getCellRect(GridListener.access$3400(this.this$1).getSelectedRow(), 0, false);
                                                    r = GridListener.access$3400(this.this$1).getCellRect(GridListener.access$3400(this.this$1).getSelectedRow() + (r.y + GridListener.access$3400((GridListener)this.this$1).getVisibleRect().height) / GridListener.access$3400(this.this$1).getRowHeight(), 0, false);
                                                    GridListener.access$3400(this.this$1).scrollRectToVisible(r);
                                                    GridListener.access$3400(this.this$1).setRowSelectionInterval(GridListener.access$3400(this.this$1).getSelectedRow() + 2, GridListener.access$3400(this.this$1).getSelectedRow() + 2);
                                                } else {
                                                    GridListener.access$3400(this.this$1).setRowSelectionInterval(GridListener.access$3400(this.this$1).getSelectedRow() - GridListener.access$3400((GridListener)this.this$1).getVisibleRect().height / GridListener.access$3400(this.this$1).getRowHeight() + 1, GridListener.access$3400(this.this$1).getSelectedRow() - GridListener.access$3400((GridListener)this.this$1).getVisibleRect().height / GridListener.access$3400(this.this$1).getRowHeight() + 1);
                                                    GridListener.access$3400(this.this$1).ensureRowIsVisible(GridListener.access$3400(this.this$1).getSelectedRow());
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    calculatedPos = Grid.this.getSelectedRow() - Grid.this.getVisibleRect().height / Grid.this.getRowHeight() + 1;
                                    newPos = calculatedPos < 0 ? 0 : calculatedPos;
                                    Grid.this.setRowSelectionInterval(newPos, newPos);
                                    Grid.this.ensureRowIsVisible(Grid.this.getSelectedRow());
                                }
                                if (Grid.this.getSelectedRow() < Grid.access$800(Grid.this).getRowCount() - 1 || Grid.access$100(Grid.this).isMoreRows()) {
                                    Grid.access$100(Grid.this).getNavBar().setLastRow(false);
                                }
                                if (Grid.this.getSelectedRow() == 0 && Grid.access$100(Grid.this).getLastIndex() == Grid.access$800(Grid.this).getRowCount() - 1) {
                                    Grid.access$100(Grid.this).getNavBar().setFirstRow(true);
                                }
                            } else if (e.getKeyCode() == 33 && Grid.this.getSelectedRow() == 0 && Grid.access$100(Grid.this).getNavBar().isPrevButtonEnabled()) {
                                if (Grid.access$100(Grid.this).getLastIndex() == Grid.access$800(Grid.this).getRowCount() - 1) {
                                    Grid.access$100(Grid.this).getNavBar().setFirstRow(true);
                                } else {
                                    Grid.access$100(Grid.this).getNavBar().prevButton_actionPerformed(new ActionEvent(this, 1001, "UP_KEY"));
                                }
                            } else if (e.getKeyCode() == 34 && Grid.this.getSelectedRow() < Grid.access$800(Grid.this).getRowCount() - 1 && Grid.access$100(Grid.this).isMoreRows()) {
                                r = Grid.this.getCellRect(Grid.this.getSelectedRow(), 0, false);
                                delta = (r.y + Grid.this.getVisibleRect().height) / Grid.this.getRowHeight() - 1;
                                Grid.this.setRowSelectionInterval(Math.min(Grid.access$800(Grid.this).getRowCount() - 1, delta), Math.min(Grid.access$800(Grid.this).getRowCount() - 1, delta));
                                Grid.this.ensureRowIsVisible(Grid.this.getSelectedRow());
                                if (Grid.this.getSelectedRow() > 0) {
                                    Grid.access$100(Grid.this).getNavBar().setFirstRow(false);
                                }
                                if (Grid.this.getSelectedRow() == Grid.access$800(Grid.this).getRowCount() - 1 && !Grid.access$100(Grid.this).isMoreRows()) {
                                    Grid.access$100(Grid.this).getNavBar().setLastRow(true);
                                }
                            } else if (e.getKeyCode() == 34 && Grid.this.getSelectedRow() == Grid.access$800(Grid.this).getRowCount() - 1 && Grid.access$100(Grid.this).getNavBar().isNextButtonEnabled()) {
                                if (!Grid.access$100(Grid.this).isMoreRows()) {
                                    Grid.access$100(Grid.this).getNavBar().setLastRow(true);
                                } else {
                                    Grid.access$100(Grid.this).getNavBar().nextButton_actionPerformed(null);
                                }
                            }
                            if (e.getKeyCode() != 34 || Grid.access$100(Grid.this).isMoreRows()) {
                                if (e.getKeyCode() != 33 || Grid.access$100(Grid.this).getstartIndex() != 0) {
                                    e.consume();
                                }
                            }
                            if (!e.isShiftDown()) break block173;
                            if (e.getKeyCode() == 38) break block211;
                            if (e.getKeyCode() != 40) break block173;
                        }
                        if (Grid.this.getSelectionModel().getSelectionMode() != 0) {
                            min = 0;
                            max = selRows.length;
                            if (e.getKeyCode() == 38 && currentSelRow == selRows[selRows.length - 1] && selRows.length > 1) {
                                --max;
                            }
                            if (e.getKeyCode() == 40 && currentSelRow == selRows[0] && selRows.length > 1) {
                                ++min;
                            }
                            Grid.this.getSelectionModel().clearSelection();
                            if (selRows != null) {
                                i = min;
                                while (i < max) {
                                    Grid.this.addRowSelectionInterval(selRows[i], selRows[i]);
                                    ++i;
                                }
                            }
                            selRow = -1;
                            if (e.getKeyCode() == 40 && selRows.length > 0 && currentSelRow == selRows[selRows.length - 1] && selRows[selRows.length - 1] + 1 < Grid.this.getRowCount()) {
                                selRow = selRows[selRows.length - 1] + 1;
                                if (selRow != -1) {
                                    Grid.this.addRowSelectionInterval(selRow, selRow);
                                }
                            } else if (e.getKeyCode() == 38 && selRows.length > 0 && currentSelRow == selRows[0] && (selRow = selRows[0] - 1) >= 0) {
                                Grid.this.addRowSelectionInterval(selRow, selRow);
                            }
                        }
                        break block173;
                    }
                    if (!Grid.access$1500(Grid.this) || Grid.this.getMode() != 0 || Grid.access$100(Grid.this).getNavBar() != null) break block173;
                    if (e.getKeyCode() == 33) break block212;
                    if (e.getKeyCode() != 34) break block173;
                }
                if (e.getKeyCode() == 33 && Grid.this.getSelectedRow() > 0) {
                    r = Grid.this.getCellRect(Grid.this.getSelectedRow(), 0, false);
                    delta = (r.y - Grid.this.getVisibleRect().height) / (Grid.this.getRowHeight() + Grid.this.getRowMargin()) + 1;
                    Grid.this.setRowSelectionInterval(Math.max(0, delta), Math.max(0, delta));
                    Grid.this.ensureRowIsVisible(Grid.this.getSelectedRow());
                } else if (e.getKeyCode() == 34 && Grid.this.getSelectedRow() < Grid.access$800(Grid.this).getRowCount() - 1) {
                    r = Grid.this.getCellRect(Grid.this.getSelectedRow(), 0, false);
                    delta = (r.y + Grid.this.getVisibleRect().height) / (Grid.this.getRowHeight() + Grid.this.getRowMargin());
                    Grid.this.setRowSelectionInterval(Math.min(Grid.access$800(Grid.this).getRowCount() - 1, delta), Math.min(Grid.access$800(Grid.this).getRowCount() - 1, delta));
                    Grid.this.ensureRowIsVisible(Grid.this.getSelectedRow());
                }
                e.consume();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (Grid.this.grids.getCurrentNestedComponent() != null) {
                if (Grid.this.grids.getCurrentNestedComponent() instanceof Grid && e instanceof KeyEvent) {
                    if (e.getKeyCode() == 9) {
                        return;
                    }
                }
                Grid.this.grids.getCurrentNestedComponent().dispatchEvent(e);
                Grid.this.repaint();
                return;
            }
            if (Grid.this.getMode() == 0) {
                Grid.this.controlDown = e.isControlDown();
            } else {
                Grid.this.controlDown = false;
            }
        }

        public void keyTyped(KeyEvent e) {
            if (Grid.this.grids.getCurrentNestedComponent() != null) {
                if (Grid.this.grids.getCurrentNestedComponent() instanceof Grid && e instanceof KeyEvent) {
                    if (e.getKeyCode() == 9) {
                        return;
                    }
                }
                Grid.this.grids.getCurrentNestedComponent().dispatchEvent(e);
                Grid.this.repaint();
                return;
            }
        }
    }

    class Pair {
        private int n1;
        private int n2;

        public Pair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Pair && ((Pair)obj).getN1() == this.n1 && ((Pair)obj).getN2() == this.n2;
        }

        public int getN1() {
            return this.n1;
        }

        public int getN2() {
            return this.n2;
        }

        public final int hashCode() {
            return this.n1 * this.n2;
        }

        public void setN1(int n1) {
            this.n1 = n1;
        }

        public void setN2(int n2) {
            this.n2 = n2;
        }
    }

    class DragGestureAdapter
    implements DragGestureListener {
        private DragSourceListener dragListener = null;

        public DragGestureAdapter(DragSourceListener dragListener) {
            this.dragListener = dragListener;
        }

        public final void dragGestureRecognized(DragGestureEvent event) {
            if (Grid.this.gridController.dragEnabled()) {
                Grid.this.setCursor(Grid.this.dragCursor);
                int[] selIndexes = Grid.this.getSelectedRows();
                if (selIndexes.length > 0) {
                    try {
                        MDIFrame.getInstance().setCursor(Cursor.getPredefinedCursor(12));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Grid.this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, new StringSelection(Grid.this.gridId), this.dragListener);
                }
            } else {
                event.getSourceAsDragGestureRecognizer().resetRecognizer();
            }
        }
    }

    class CheckboxMenuItem
    implements ActionListener {
        private int columnIndex = -1;

        public CheckboxMenuItem(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void actionPerformed(ActionEvent e) {
            Grid.this.colProps[this.columnIndex].setColumnVisible(!Grid.this.colProps[this.columnIndex].isColumnVisible());
            if (Grid.this.fromColIndex <= this.columnIndex && this.columnIndex < Grid.this.toColIndex) {
                if (!Grid.this.colProps[this.columnIndex].isColumnVisible() && Grid.this.getColumnCount() == 1) {
                    return;
                }
                Grid.this.setVisibleColumn(this.columnIndex, Grid.this.colProps[this.columnIndex].isColumnVisible());
            } else if (Grid.this.grids != null) {
                if (!Grid.this.lockedGrid) {
                    if (!Grid.this.colProps[this.columnIndex].isColumnVisible() && Grid.this.getColumnCount() == 1) {
                        return;
                    }
                    Grid.this.grids.getLockedGrid().setVisibleColumn(this.columnIndex, Grid.this.colProps[this.columnIndex].isColumnVisible());
                } else {
                    if (!Grid.this.colProps[this.columnIndex].isColumnVisible() && Grid.this.getColumnCount() == 1) {
                        return;
                    }
                    Grid.this.grids.getGrid().setVisibleColumn(this.columnIndex, Grid.this.colProps[this.columnIndex].isColumnVisible());
                }
            }
        }
    }

    class TableColumnHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private Font headerFont;
        private JLabel l_iconFiltering;
        private JLabel l_iconSorting;
        private JLabel l_text;
        private MultiLineHeader l_text2;
        private SimpleAttributeSet simpleattributeset = new SimpleAttributeSet();

        public TableColumnHeaderRenderer(String attributeName, int headerTextHorizontalAlignment, int headerTextVerticalAlignment, Font headerFont, Color headerColor) {
            this.headerFont = headerFont;
            this.setOpaque(false);
            this.setBorder(columnHeaderBorder);
            this.setLayout(new GridBagLayout());
            this.l_text = new JLabel();
            if (Grid.this.headerHeight < this.l_text.getFontMetrics(headerFont != null ? headerFont : this.l_text.getFont()).getHeight() * 2) {
                this.add((Component)this.l_text, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                if (headerFont != null) {
                    this.l_text.setFont(headerFont);
                }
                if (headerColor != null) {
                    this.l_text.setForeground(headerColor);
                }
                this.l_text.setVerticalTextPosition(headerTextVerticalAlignment);
                this.l_text.setHorizontalAlignment(headerTextHorizontalAlignment);
                this.l_text.setOpaque(false);
            } else {
                this.l_text2 = new MultiLineHeader(headerTextHorizontalAlignment, headerTextVerticalAlignment);
                this.add((Component)this.l_text2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                if (headerFont != null) {
                    this.l_text2.setFont(headerFont);
                }
                if (headerColor != null) {
                    this.l_text2.setForeground(headerColor);
                }
                this.l_text2.setOpaque(false);
            }
            this.l_iconSorting = new JLabel("");
            this.l_iconFiltering = new JLabel("");
            if (headerFont != null) {
                this.l_iconSorting.setFont(headerFont);
            }
            if (headerColor != null) {
                this.l_iconSorting.setForeground(headerColor);
            }
            this.l_iconSorting.setOpaque(false);
            this.add((Component)this.l_iconSorting, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setToolTipText(ClientSettings.getInstance().getResources().getResource(Grid.this.gridController.getHeaderTooltip(attributeName)));
            if (ClientSettings.SHOW_FILTER_SYMBOL) {
                this.l_iconFiltering.setOpaque(false);
                this.add((Component)this.l_iconFiltering, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int viewColumnIndex) {
            int columnModelIndex = table.convertColumnIndexToModel(viewColumnIndex);
            this.setIcon(null, 0);
            int i = 0;
            while (i < Grid.this.grids.getCurrentSortedColumns().size()) {
                if (Grid.this.grids.getCurrentSortedColumns().get(i).equals(Grid.this.colProps[columnModelIndex].getColumnName())) {
                    if (Grid.this.grids.getCurrentSortedVersusColumns().get(i).equals("ASC")) {
                        this.setIcon(Grid.this.ascSort, i + 1);
                    } else {
                        this.setIcon(Grid.this.descSort, i + 1);
                    }
                }
                ++i;
            }
            if (ClientSettings.SHOW_FILTER_SYMBOL) {
                if (Grid.this.grids.getQuickFilterValues().containsKey(Grid.this.getVOListTableModel().getColumnName(columnModelIndex))) {
                    this.l_iconFiltering.setIcon(Grid.this.filterSymbol);
                } else {
                    this.l_iconFiltering.setIcon(null);
                }
            }
            if (Grid.this.headerHeight < this.l_text.getFontMetrics(this.headerFont != null ? this.headerFont : this.l_text.getFont()).getHeight() * 2) {
                this.l_text.setText(value.toString());
            } else {
                this.l_text2.setText(value.toString());
            }
            return this;
        }

        public void setIcon(Icon icon, int sortingOrder) {
            if (sortingOrder > 0 && ClientSettings.SHOW_SORTING_ORDER) {
                this.l_iconSorting.setText(String.valueOf(sortingOrder));
            } else {
                this.l_iconSorting.setText("");
            }
            this.l_iconSorting.setIcon(icon);
        }

        class MultiLineHeader
        extends JTextPane {
            private int headerTextVerticalAlignment;

            public MultiLineHeader(int headerTextHorizontalAlignment, int headerTextVerticalAlignment) {
                this.headerTextVerticalAlignment = headerTextVerticalAlignment;
                StyleConstants.setAlignment(TableColumnHeaderRenderer.this.simpleattributeset, 1);
                if (headerTextHorizontalAlignment == 2) {
                    StyleConstants.setAlignment(TableColumnHeaderRenderer.this.simpleattributeset, 0);
                } else if (headerTextHorizontalAlignment == 0) {
                    StyleConstants.setAlignment(TableColumnHeaderRenderer.this.simpleattributeset, 1);
                } else if (headerTextHorizontalAlignment == 4) {
                    StyleConstants.setAlignment(TableColumnHeaderRenderer.this.simpleattributeset, 2);
                }
                StyleConstants.setFontFamily(TableColumnHeaderRenderer.this.simpleattributeset, Grid.this.getFont().getFontName());
                StyleConstants.setFontSize(TableColumnHeaderRenderer.this.simpleattributeset, Grid.this.getFont().getSize());
                this.setParagraphAttributes(TableColumnHeaderRenderer.this.simpleattributeset, true);
            }

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                if (g.getFontMetrics().stringWidth(this.getText()) < w) {
                    if (this.headerTextVerticalAlignment == 1) {
                        g.translate(0, 0);
                    } else if (this.headerTextVerticalAlignment == 0) {
                        g.translate(0, h / 2 - (g.getFontMetrics().getHeight() + g.getFontMetrics().getDescent()) / 2);
                    } else {
                        g.translate(0, h - g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent());
                    }
                } else {
                    g.translate(0, 0);
                }
                super.paint(g);
            }
        }
    }

    class VerticalScrollBarMouseListener
    extends MouseAdapter {
        private int oldValue = -1;

        VerticalScrollBarMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                int row1 = Grid.this.getVisibleRect().y / Grid.this.getRowHeight();
                int row2 = Grid.this.getVisibleRect().height / Grid.this.getRowHeight();
                int row3 = Grid.this.getSelectedRow();
                if (row3 < row1) {
                    row3 = row1;
                } else if (row3 > row1 + row2) {
                    row3 = row1 + row2;
                } else if (e.getSource().equals(Grid.this.vScrollbar.getDecrButton()) && row3 > 0) {
                    --row3;
                } else if (e.getSource().equals(Grid.this.vScrollbar.getIncrButton()) && row3 + 1 < Grid.this.getRowCount()) {
                    ++row3;
                }
                Grid.this.setRowSelectionInterval(row3, row3);
                if (row3 < row1 || row3 > row1 + row2) {
                    Grid.this.ensureRowIsVisible(row3);
                }
            }
        }
    }
}

