/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.client;

import com.sun.java.swing.plaf.mac.MacScrollBarUI;
import com.sun.java.swing.plaf.mac.MacScrollButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import org.openswing.swing.table.client.PaginationVerticalScrollbarUI;

public class MacPaginationVerticalScrollBarUI
extends MacScrollBarUI
implements PaginationVerticalScrollbarUI {
    protected JButton nextPgButton;
    protected JButton prevPgButton;

    protected JButton createPageButton(int orientation) {
        return new PageArrowButton(orientation);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacPaginationVerticalScrollBarUI();
    }

    public JButton getDecrButton() {
        return this.decrButton;
    }

    public JButton getIncrButton() {
        return this.incrButton;
    }

    public JButton getNextPgButton() {
        return this.nextPgButton;
    }

    public JButton getPrevPgButton() {
        return this.prevPgButton;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.nextPgButton = this.createPageButton(5);
        this.prevPgButton = this.createPageButton(1);
        this.scrollbar.add(this.prevPgButton);
        this.scrollbar.add(this.nextPgButton);
    }

    protected void installListeners() {
        super.installListeners();
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int prevPgButtonH = this.prevPgButton.getPreferredSize().height;
        int prevPgButtonY = sbInsets.top;
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = prevPgButtonY + prevPgButtonH;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int nextPgButtonH = this.nextPgButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH + nextPgButtonH);
        int nextPgButtonY = sbSize.height - (sbInsets.bottom + nextPgButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH + prevPgButtonH + nextPgButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.prevPgButton.setBounds(itemX, prevPgButtonY, itemW, prevPgButtonH);
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.nextPgButton.setBounds(itemX, nextPgButtonY, itemW, nextPgButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    class PageArrowButton
    extends MacScrollButton {
        private Color arrowColor;
        private Color background;
        private int buttonWidth;
        private final ColorUIResource gray0;
        private final ColorUIResource gray3;
        private final ColorUIResource gray6;
        private final ColorUIResource gray9;
        private Color highlight;
        private Color pressedBackground;
        private Color pressedHighlight;
        private Color pressedShadow;
        private Color shadow;

        public PageArrowButton(int direction) {
            super(direction, ((MacPaginationVerticalScrollBarUI)MacPaginationVerticalScrollBarUI.this).incrButton.getPreferredSize().width);
            this.background = UIManager.getColor("ScrollBar.arrowBackground");
            this.highlight = UIManager.getColor("ScrollBar.arrowHighlight");
            this.shadow = UIManager.getColor("ScrollBar.arrowShadow");
            this.pressedBackground = UIManager.getColor("ScrollBar.pressedArrowBackground");
            this.pressedHighlight = UIManager.getColor("ScrollBar.pressedArrowHighlight");
            this.pressedShadow = UIManager.getColor("ScrollBar.pressedArrowShadow");
            this.arrowColor = UIManager.getColor("ScrollBar.arrowColor");
            this.gray0 = new ColorUIResource(238, 238, 238);
            this.gray3 = new ColorUIResource(187, 187, 187);
            this.gray6 = new ColorUIResource(136, 136, 136);
            this.gray9 = new ColorUIResource(85, 85, 85);
            this.buttonWidth = ((MacPaginationVerticalScrollBarUI)MacPaginationVerticalScrollBarUI.this).incrButton.getPreferredSize().width;
        }

        public void paint(Graphics g) {
            ButtonModel buttonmodel;
            boolean flag;
            if (this.background == null) {
                this.background = Color.white;
            }
            if (this.highlight == null) {
                this.highlight = new Color(240, 240, 240);
            }
            if (this.shadow == null) {
                this.shadow = new Color(20, 20, 20);
            }
            if (this.pressedHighlight == null) {
                this.pressedHighlight = new Color(200, 200, 200);
            }
            if (this.pressedShadow == null) {
                this.pressedShadow = new Color(10, 10, 10);
            }
            if (this.arrowColor == null) {
                this.arrowColor = new Color(1, 1, 1);
            }
            boolean bl = flag = (buttonmodel = this.getModel()).isArmed() && buttonmodel.isPressed();
            if (this.isEnabled()) {
                g.setColor(flag ? this.pressedBackground : this.background);
            } else {
                g.setColor(this.gray0);
            }
            g.fillRect(0, 0, this.buttonWidth, this.buttonWidth);
            g.setColor(flag ? this.pressedShadow : this.highlight);
            g.drawLine(0, 0, this.buttonWidth - 2, 0);
            g.drawLine(0, 0, 0, this.buttonWidth - 2);
            g.setColor(flag ? this.pressedHighlight : this.shadow);
            g.drawLine(this.buttonWidth - 1, 1, this.buttonWidth - 1, this.buttonWidth - 1);
            g.drawLine(1, this.buttonWidth - 1, this.buttonWidth - 1, this.buttonWidth - 1);
            g.setColor(this.isEnabled() ? this.arrowColor : this.gray6);
            int h = -3;
            switch (this.getDirection()) {
                case 1: {
                    g.drawLine(6, 5 + h, 7, 5 + h);
                    g.drawLine(5, 6 + h, 8, 6 + h);
                    g.drawLine(4, 7 + h, 9, 7 + h);
                    g.drawLine(3, 8 + h, 10, 8 + h);
                    h = this.getHeight() - 14;
                    g.drawLine(6, 5 + h, 7, 5 + h);
                    g.drawLine(5, 6 + h, 8, 6 + h);
                    g.drawLine(4, 7 + h, 9, 7 + h);
                    g.drawLine(3, 8 + h, 10, 8 + h);
                    break;
                }
                case 5: {
                    g.drawLine(3, 5 + h, 10, 5 + h);
                    g.drawLine(4, 6 + h, 9, 6 + h);
                    g.drawLine(5, 7 + h, 8, 7 + h);
                    g.drawLine(6, 8 + h, 7, 8 + h);
                    h = this.getHeight() - 14;
                    g.drawLine(3, 5 + h, 10, 5 + h);
                    g.drawLine(4, 6 + h, 9, 6 + h);
                    g.drawLine(5, 7 + h, 8, 7 + h);
                    g.drawLine(6, 8 + h, 7, 8 + h);
                }
            }
        }
    }
}

