/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.ButtonCellEditor;
import org.openswing.swing.table.renderers.client.ButtonTableCellRenderer;
import org.openswing.swing.util.client.ClientUtils;

public class ButtonColumn
extends Column {
    private ArrayList actionListeners = new ArrayList();
    private boolean enableInReadOnlyMode = false;
    private Icon icon = null;
    private String iconName = null;
    private boolean showAttributeValue = false;
    private String text = "...";

    public ButtonColumn() {
        this.setColumnRequired(false);
        this.setTextAlignment(0);
    }

    public final void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public final ArrayList getActionListeners() {
        return this.actionListeners;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new ButtonCellEditor(this.getText(), this.isShowAttributeValue(), this.getActionListeners(), this.icon);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new ButtonTableCellRenderer(this.getText(), this.isShowAttributeValue(), tableContainer, this.getTextAlignment(), this.isEnableInReadOnlyMode(), this.icon, this.getColumnName());
    }

    public int getColumnType() {
        return 11;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final String getIconName() {
        return this.iconName;
    }

    public final String getText() {
        return this.text;
    }

    public final boolean isEnableInReadOnlyMode() {
        return this.enableInReadOnlyMode;
    }

    public final boolean isShowAttributeValue() {
        return this.showAttributeValue;
    }

    public final void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public final void setEnableInReadOnlyMode(boolean enableInReadOnlyMode) {
        this.enableInReadOnlyMode = enableInReadOnlyMode;
    }

    public final void setIcon(Icon icon) {
        this.icon = icon;
    }

    public final void setIconName(String iconName) {
        this.iconName = iconName;
        if (iconName != null) {
            this.icon = new ImageIcon(ClientUtils.getImage(iconName));
        }
    }

    public final void setShowAttributeValue(boolean showAttributeValue) {
        this.showAttributeValue = showAttributeValue;
    }

    public final void setText(String text) {
        this.text = text;
    }
}

