/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.ComponentOrientation;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.logger.client.Logger;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupParent;
import org.openswing.swing.lookup.client.RestoreFocusOnInvalidCodeException;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.CodLookupCellEditor;
import org.openswing.swing.table.renderers.client.CodLookupCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class CodLookupColumn
extends Column {
    private boolean allowOnlyNumbers = false;
    private long autoCompletitionWaitTime = ClientSettings.LOOKUP_AUTO_COMPLETITION_WAIT_TIME;
    private int bottomMargin = 0;
    private String codAttributeName = null;
    private boolean codePadding = false;
    private String controllerClassName = null;
    private String controllerMethodName = null;
    private boolean enableCodBox = true;
    private boolean hideButton = false;
    private boolean hideCodeBox;
    private int leftMargin = 2;
    private LookupController lookupController = null;
    private int maxCharacters = 255;
    private ComponentOrientation orientation;
    private int rightMargin = 0;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private int topMargin = 0;
    private boolean zeroLengthAsNull = false;

    public CodLookupColumn() {
        this.orientation = ClientSettings.TEXT_ORIENTATION;
    }

    public final void forceValidate(final int rowNumber) {
        try {
            Object codValue = this.getTable().getVOListTableModel().getValueAt(rowNumber, this.getTable().getVOListTableModel().findColumn(this.getColumnName()));
            if (this.lookupController != null && codValue != null) {
                try {
                    this.lookupController.validateCode(this.getTable(), codValue.toString().toUpperCase(), new LookupParent(){

                        public Object getLookupCodeParentValue() {
                            return CodLookupColumn.this.getTable().getVOListTableModel().getValueAt(rowNumber, CodLookupColumn.this.getTable().getVOListTableModel().findColumn(CodLookupColumn.this.getColumnName()));
                        }

                        public ValueObject getValueObject() {
                            return CodLookupColumn.this.getTable().getVOListTableModel().getObjectForRow(rowNumber);
                        }

                        public void setValue(String attributeName, Object value) {
                            CodLookupColumn.this.getTable().getVOListTableModel().setValueAt(value, rowNumber, CodLookupColumn.this.getTable().getVOListTableModel().findColumn(attributeName));
                        }
                    });
                }
                catch (RestoreFocusOnInvalidCodeException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                CodLookupColumn.this.getTable().getGrid().editCellAt(rowNumber, CodLookupColumn.this.getTable().getGrid().convertColumnIndexToView(CodLookupColumn.this.getTable().getVOListTableModel().findColumn(CodLookupColumn.this.getColumnName())));
                            }
                            catch (Exception ex) {
                            }
                        }
                    });
                }
            }
            if (this.getTable() != null) {
                this.getTable().repaint();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void forceValidate() {
        this.forceValidate(this.getTable().getSelectedRow());
    }

    public final long getAutoCompletitionWaitTime() {
        return this.autoCompletitionWaitTime;
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        if (this.getLookupController() == null) {
            Logger.error(this.getClass().getName(), "getCellEditor", "The column '" + this.getColumnName() + "' has not set the 'lookupController' property.", null);
            return null;
        }
        return new CodLookupCellEditor(this.getMaxCharacters(), this.getLookupController(), this.isColumnRequired(), this.isAllowOnlyNumbers(), !this.isHideCodeBox(), this.isEnableCodBox(), !this.isHideButton(), this.getControllerClassName(), this.getControllerMethodName(), this.getAutoCompletitionWaitTime(), this.getColumnName(), this.getTextOrientation(), this.selectDataOnEdit);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new CodLookupCellRenderer(tableContainer, this.isHideCodeBox(), this.getTextAlignment(), this.getLeftMargin(), this.getRightMargin(), this.getTopMargin(), this.getBottomMargin(), this.getTextOrientation(), this.getColumnName());
    }

    public int getColumnType() {
        return 8;
    }

    public final String getControllerClassName() {
        return this.controllerClassName;
    }

    public final String getControllerMethodName() {
        return this.controllerMethodName;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public LookupController getLookupController() {
        return this.lookupController;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final ComponentOrientation getTextOrientation() {
        return this.orientation;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public boolean isAllowOnlyNumbers() {
        return this.allowOnlyNumbers;
    }

    public boolean isCodePadding() {
        return this.codePadding;
    }

    public boolean isEnableCodBox() {
        return this.enableCodBox;
    }

    public boolean isHideButton() {
        return this.hideButton;
    }

    public boolean isHideCodeBox() {
        return this.hideCodeBox;
    }

    public final boolean isSelectDataOnEdit() {
        return this.selectDataOnEdit;
    }

    public boolean isZeroLengthAsNull() {
        return this.zeroLengthAsNull;
    }

    public void setAllowOnlyNumbers(boolean allowOnlyNumbers) {
        this.allowOnlyNumbers = allowOnlyNumbers;
    }

    public final void setAutoCompletitionWaitTime(long autoCompletitionWaitTime) {
        this.autoCompletitionWaitTime = autoCompletitionWaitTime;
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setCodePadding(boolean codePadding) {
        this.codePadding = codePadding;
    }

    public final void setControllerClassName(String controllerClassName) {
        this.controllerClassName = controllerClassName;
    }

    public final void setControllerMethodName(String controllerMethodName) {
        this.controllerMethodName = controllerMethodName;
    }

    public void setEnableCodBox(boolean enableCodBox) {
        this.enableCodBox = enableCodBox;
    }

    public void setHideButton(boolean hideButton) {
        this.hideButton = hideButton;
    }

    public void setHideCodeBox(boolean hideCodeBox) {
        this.hideCodeBox = hideCodeBox;
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setLookupController(LookupController lookupController) {
        this.lookupController = lookupController;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public final void setSelectDataOnEdit(boolean selectDataOnEdit) {
        this.selectDataOnEdit = selectDataOnEdit;
    }

    public final void setTextOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public void setZeroLengthAsNull(boolean zeroLengthAsNull) {
        this.zeroLengthAsNull = zeroLengthAsNull;
    }
}

