/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JFormattedTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import org.openswing.swing.client.FormatterController;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.FormattedTextCellEditor;
import org.openswing.swing.table.renderers.client.FormattedTextTableCellRenderer;

public class FormattedTextColumn
extends Column {
    private int bottomMargin = 0;
    private FormatterController controller;
    private int leftMargin = 2;
    private int rightMargin = 0;
    private FormattedTextBox textBox = new FormattedTextBox();
    private int topMargin = 0;

    public final void commitEdit() throws ParseException {
        try {
            if (this.textBox != null) {
                this.textBox.commitEdit();
            }
        }
        catch (Exception ex) {
        }
    }

    public final Action[] getActions() {
        try {
            if (this.textBox != null) {
                return this.textBox.getActions();
            }
            return new Action[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new FormattedTextCellEditor(this.getTextBox(), this.isColumnRequired());
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new FormattedTextTableCellRenderer(tableContainer, this.getTextBox(), this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.getTextAlignment(), this.getColumnName());
    }

    public int getColumnType() {
        return 13;
    }

    public final FormatterController getController() {
        return this.controller;
    }

    public final int getFocusLostBehavior() {
        try {
            if (this.textBox != null) {
                return this.textBox.getFocusLostBehavior();
            }
            return 1;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public final JFormattedTextField.AbstractFormatter getFormatter() {
        try {
            if (this.textBox != null) {
                return this.textBox.getFormatter();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final JFormattedTextField.AbstractFormatterFactory getFormatterFactory() {
        try {
            if (this.textBox != null) {
                return this.textBox.getFormatterFactory();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final FormattedTextBox getTextBox() {
        return this.textBox;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public final void invalidEdit() {
        try {
            if (this.textBox != null) {
                this.textBox.invalidEdit();
            }
        }
        catch (Exception ex) {
        }
    }

    public final boolean isEditValid() {
        try {
            if (this.textBox != null) {
                return this.textBox.isEditValid();
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public final void setController(FormatterController controller) {
        this.controller = controller;
    }

    public final void setDocument(Document doc) {
        try {
            if (this.textBox != null) {
                this.textBox.setDocument(doc);
            }
        }
        catch (Exception ex) {
        }
    }

    public void setFocusLostBehavior(int behavior) {
        try {
            if (this.textBox != null) {
                this.textBox.setFocusLostBehavior(behavior);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setFormatter(JFormattedTextField.AbstractFormatter format) {
        try {
            if (this.textBox != null) {
                this.textBox.setFormatter(format);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory tf) {
        try {
            if (this.textBox != null) {
                this.textBox.setFormatterFactory(tf);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setInputVerifier(InputVerifier verifier) {
        try {
            if (this.textBox != null) {
                this.textBox.setInputVerifier(verifier);
            }
        }
        catch (Exception ex) {
        }
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    class FormattedTextBox
    extends JFormattedTextField
    implements FormatterController {
        FormattedTextBox() {
        }

        public void invalidEdit() {
            try {
                if (FormattedTextColumn.this.controller == null) {
                    super.invalidEdit();
                } else {
                    FormattedTextColumn.this.controller.invalidEdit();
                }
            }
            catch (Exception ex) {
            }
        }

        public void processKeyEvent(KeyEvent e) {
            try {
                super.processKeyEvent(e);
            }
            catch (Exception ex) {
            }
        }

        public void setFormatter(JFormattedTextField.AbstractFormatter format) {
            try {
                if (FormattedTextColumn.this.controller == null) {
                    if (this.getFormatterFactory() == null) {
                        super.setFormatterFactory(new DefaultFormatterFactory(format));
                    } else {
                        super.setFormatter(format);
                    }
                } else {
                    FormattedTextColumn.this.controller.setFormatter(format);
                }
            }
            catch (Exception ex) {
            }
        }
    }
}

