/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.awt.ComponentOrientation;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.editors.client.TextCellEditor;
import org.openswing.swing.table.renderers.client.TextTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class TextColumn
extends Column {
    private int bottomMargin = 0;
    private boolean encryptText;
    private int leftMargin = 2;
    private int maxCharacters = 255;
    private ComponentOrientation orientation;
    private int rightMargin = 0;
    private boolean rpadding = false;
    private boolean selectDataOnEdit = ClientSettings.SELECT_DATA_IN_EDITABLE_GRID;
    private int topMargin = 0;
    private boolean trimText = false;
    private boolean upperCase = false;

    public TextColumn() {
        this.orientation = ClientSettings.TEXT_ORIENTATION;
    }

    public final int getBottomMargin() {
        return this.bottomMargin;
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        if (this.isEncryptText()) {
            return new TextCellEditor(this.getMaxCharacters(), this.isColumnRequired());
        }
        return new TextCellEditor(this.getMaxCharacters(), this.isColumnRequired(), this.isRpadding(), this.isTrimText(), this.isUpperCase(), this.selectDataOnEdit, this.getTextOrientation());
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new TextTableCellRenderer(tableContainer, this.isEncryptText(), this.getTextAlignment(), this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.getTextOrientation(), this.getColumnName());
    }

    public int getColumnType() {
        return 0;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final ComponentOrientation getTextOrientation() {
        return this.orientation;
    }

    public final int getTopMargin() {
        return this.topMargin;
    }

    public boolean isEncryptText() {
        return this.encryptText;
    }

    public boolean isRpadding() {
        return this.rpadding;
    }

    public final boolean isSelectDataOnEdit() {
        return this.selectDataOnEdit;
    }

    public boolean isTrimText() {
        return this.trimText;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public final void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setEncryptText(boolean encryptText) {
        this.encryptText = encryptText;
    }

    public final void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public final void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public void setRpadding(boolean rpadding) {
        this.rpadding = rpadding;
    }

    public final void setSelectDataOnEdit(boolean selectDataOnEdit) {
        this.selectDataOnEdit = selectDataOnEdit;
    }

    public final void setTextOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public final void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public void setTrimText(boolean trimText) {
        this.trimText = trimText;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

