/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.columns.client;

import java.util.ArrayList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openswing.swing.client.DateChangedListener;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.client.Grids;
import org.openswing.swing.table.columns.client.Column;
import org.openswing.swing.table.columns.client.DateColumnSettings;
import org.openswing.swing.table.editors.client.DateCellEditor;
import org.openswing.swing.table.renderers.client.DateTableCellRenderer;
import org.openswing.swing.util.client.ClientSettings;

public class TimeColumn
extends Column {
    private ArrayList dateListeners = new ArrayList();
    private DateColumnSettings dynamicSettings = null;
    private String timeFormat = null;

    public TimeColumn() {
        this.setTextAlignment(0);
        try {
            this.timeFormat = ClientSettings.getInstance().getResources().getTimeFormat();
        }
        catch (Exception ex) {
        }
    }

    public final void addDateChangedListener(DateChangedListener listener) {
        this.dateListeners.add(listener);
    }

    public final TableCellEditor getCellEditor(GridController tableContainer, Grids grids) {
        return new DateCellEditor(this.isColumnRequired(), 3, 1, this.getDateListeners(), null);
    }

    public final TableCellRenderer getCellRenderer(GridController tableContainer, Grids grids) {
        return new DateTableCellRenderer(3, tableContainer, this.getTextAlignment(), '/', 1, true, this.getTimeFormat(), this.getDynamicSettings(), this.getColumnName());
    }

    public int getColumnType() {
        return 3;
    }

    public final ArrayList getDateListeners() {
        return this.dateListeners;
    }

    public final DateColumnSettings getDynamicSettings() {
        return this.dynamicSettings;
    }

    public final String getTimeFormat() {
        return this.timeFormat;
    }

    public final void removeDateChangedListener(DateChangedListener listener) {
        this.dateListeners.remove(listener);
    }

    public final void setDynamicSettings(DateColumnSettings dynamicSettings) {
        this.dynamicSettings = dynamicSettings;
    }

    public final void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }
}

