/*
 * Decompiled with CFR 0.152.
 */
package org.openswing.swing.table.editors.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openswing.swing.table.editors.client.AbstractCellEditor;
import org.openswing.swing.util.client.ClientSettings;

public class ButtonCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private ArrayList actionListeners = null;
    private JButton field = new JButton();
    private int row = -1;
    private boolean showAttributeValue;
    private JTable table = null;
    private Object value = null;

    public ButtonCellEditor(String text, boolean showAttributeValue, ArrayList actionListeners, Icon icon) {
        this.showAttributeValue = showAttributeValue;
        if (!showAttributeValue) {
            this.field.setText(ClientSettings.getInstance().getResources().getResource(text));
        }
        if (icon != null) {
            this.field.setIcon(icon);
        }
        this.actionListeners = actionListeners;
        this.field.addActionListener(this);
    }

    private final Component _prepareEditor(Object value) {
        this.value = value;
        if (this.showAttributeValue) {
            if (value != null && value instanceof byte[]) {
                this.field.setIcon(new ImageIcon((byte[])value));
            } else if (value != null && value instanceof Icon) {
                this.field.setIcon((Icon)value);
            } else if (value != null) {
                this.field.setText(value.toString());
            } else {
                this.field.setText("");
                this.field.setIcon(null);
            }
        }
        return this.field;
    }

    public final void actionPerformed(ActionEvent e) {
        if (this.row != -1) {
            this.table.setRowSelectionInterval(this.row, this.row);
        }
        if (this.actionListeners != null) {
            int i = 0;
            while (i < this.actionListeners.size()) {
                ((ActionListener)this.actionListeners.get(i)).actionPerformed(e);
                ++i;
            }
        }
    }

    public final void finalize() {
        if (this.field != null) {
            this.field.removeActionListener(this);
        }
        this.table = null;
        this.field = null;
        this.actionListeners.clear();
    }

    public final Object getCellEditorValue() {
        return this.value;
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        return this._prepareEditor(value);
    }

    public final boolean stopCellEditing() {
        return this.validate();
    }

    private final boolean validate() {
        this.fireEditingStopped();
        return true;
    }
}

